/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.lib.util;

import com.sap.core.jpaas.security.auth.lib.util.Base64Util;
import com.sap.core.jpaas.security.auth.lib.util.RequestUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PostParametersUtil {
    private static final Logger LOG = Logger.getLogger(PostParametersUtil.class.getName());
    private static final String POST_PARAMETERS_COOKIE = "saml2pp";
    private static final String POST_MSG = "Please wait ...";
    private static final String POST_MSG_NO_SCRIPT = "Note: Your browser does not support JavaScript or it is turned off. Press the button to proceed.";
    private static final String POST_BUTTON_CONTINUE = "Continue";
    private static final String HTML_BEGINNING = "<html><body onload=\"document.forms[0].submit()\"><p><script language=\"javascript\">document.write(\"";
    private static final String HTML_CONTINUATION = "\");</script></p><noscript><p>";
    private static final String FORM_BEGINNING = "</p></noscript><form method=\"post\" action=\"";
    private static final String SUBMIT_BUTTON = "<noscript><input type=\"submit\" value=\"";
    private static final String FORM_AND_HTML_ENDING = "\"/></noscript></form></body></html>";
    private static final String FORM_BEGINNING_CLOSE = "\">";
    private static final String PARAMETER_TAG = "<input type=\"hidden\" name=\"%s\" value=\"%s\" />";

    public static void restorePostParameters(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String action = RequestUtil.getOriginalUrlFromRequest(request);
        String cookie = RequestUtil.getCookieValue(request, POST_PARAMETERS_COOKIE);
        if (cookie != null && cookie.length() > 0) {
            String[] parameters;
            HashMap<String, String[]> postParameters = new HashMap<String, String[]>();
            String decodedCookie = Base64Util.decodeString(cookie);
            String[] stringArray = parameters = decodedCookie.split("&");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] keyValuePair = parameter.split("=");
                String key = keyValuePair[0];
                String value = URLDecoder.decode(keyValuePair[1], "UTF-8");
                postParameters.put(key, new String[]{value});
                ++n2;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Original POST parameters to restore: " + postParameters);
            }
            response.addHeader("set-cookie", "saml2pp= ; Max-Age=0; Expires=Thu, 01-Jan-1970 00:00:10 GMT");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("POST parameters cookie successfully removed.");
            }
            action = action.replaceAll("\\?saml2post=true", "").replaceAll("&saml2post=true", "");
            String postBody = PostParametersUtil.buildPostRequest(request, postParameters, action);
            if (!response.isCommitted()) {
                response.getWriter().print(postBody);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Original POST request successfully restored.");
                }
            } else {
                LOG.warning("Cannot restore original POST parameters because response is already committed.");
            }
        }
    }

    public static String preservePostParameters(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, MalformedURLException {
        Map parameters = request.getParameterMap();
        String cookieValue = null;
        if (!parameters.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String requestUrl = RequestUtil.getOriginalUrlFromRequest(request);
            int queryStringPosition = requestUrl.indexOf(63);
            String queryString = null;
            if (queryStringPosition != -1) {
                queryString = URLDecoder.decode(requestUrl.substring(queryStringPosition), "UTF-8");
            }
            for (Map.Entry entry : parameters.entrySet()) {
                String key = (String)entry.getKey();
                String[] value = (String[])entry.getValue();
                boolean skipParameter = false;
                if (queryString != null) {
                    Pattern pattern = Pattern.compile("[\\?|&]" + key + "=");
                    Matcher matcher = pattern.matcher(queryString);
                    skipParameter = matcher.find();
                }
                if (value == null || value.length <= 0 || skipParameter) continue;
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(key).append('=').append(URLEncoder.encode(value[0], "UTF-8"));
            }
            String plainCookieValue = sb.toString();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("POST parameters cookie value: " + plainCookieValue);
            }
            cookieValue = Base64Util.encodeString(plainCookieValue);
            response.addHeader("set-cookie", "saml2pp=" + cookieValue);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Post parametes successfully preserved.");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("POST request does not contain any parameters to preserve.");
        }
        return cookieValue;
    }

    private static String buildPostRequest(HttpServletRequest request, Map<String, String[]> postParameters, String action) {
        StringBuilder sb = new StringBuilder(500);
        sb.append(PostParametersUtil.getFormBeginning(action));
        PostParametersUtil.addPostParameters(postParameters, sb);
        sb.append(PostParametersUtil.getFormEnding());
        return sb.toString();
    }

    private static void addPostParameters(Map<String, String[]> postParameters, StringBuilder sb) {
        if (!postParameters.isEmpty()) {
            for (Map.Entry<String, String[]> pair : postParameters.entrySet()) {
                String name = pair.getKey();
                String[] values = pair.getValue();
                PostParametersUtil.addPostParameter(sb, name, values);
            }
        }
    }

    private static void addPostParameter(StringBuilder sb, String name, String[] values) {
        String value = PostParametersUtil.getFirstValue(values);
        String tag = String.format(PARAMETER_TAG, PostParametersUtil.encodeHTML(name), PostParametersUtil.encodeHTML(value));
        sb.append(tag);
    }

    private static String getFirstValue(String[] values) {
        String value = null;
        if (values != null && values.length > 0) {
            value = values[0];
            value = value.replaceAll("[\n\r]", "");
            return value;
        }
        return "";
    }

    private static String getFormBeginning(String destination) {
        StringBuilder builder = new StringBuilder(500);
        builder.append(HTML_BEGINNING);
        builder.append(POST_MSG);
        builder.append(HTML_CONTINUATION);
        builder.append(POST_MSG_NO_SCRIPT);
        builder.append(FORM_BEGINNING);
        builder.append(PostParametersUtil.encodeHTML(destination));
        builder.append(FORM_BEGINNING_CLOSE);
        return builder.toString();
    }

    private static String getFormEnding() {
        StringBuilder builder = new StringBuilder();
        builder.append(SUBMIT_BUTTON);
        builder.append(POST_BUTTON_CONTINUE);
        builder.append(FORM_AND_HTML_ENDING);
        return builder.toString();
    }

    private static String encodeHTML(String orig) {
        if (orig == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[><\"&\n\t ]");
        Matcher matcher = pattern.matcher(orig);
        if (matcher.find()) {
            int length = orig.length();
            StringBuffer result = new StringBuffer(Math.round((float)length * 1.1f));
            int i = 0;
            while (i < length) {
                char c = orig.charAt(i);
                switch (c) {
                    case '<': {
                        result.append("&lt;");
                        break;
                    }
                    case '>': {
                        result.append("&gt;");
                        break;
                    }
                    case '&': {
                        result.append("&amp;");
                        break;
                    }
                    case '\n': {
                        result.append("<BR>");
                        break;
                    }
                    case ' ': {
                        result.append("&#32;");
                        break;
                    }
                    case '\t': {
                        result.append("&nbsp;&nbsp;");
                        break;
                    }
                    case '\"': {
                        result.append("&quot;");
                        break;
                    }
                    default: {
                        result.append(c);
                    }
                }
                ++i;
            }
            return result.toString();
        }
        return orig;
    }
}

