/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.lib.util;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    private static final String FORWARD_QUERY_STRING_REQUEST_ATRIBUTE = "javax.servlet.forward.query_string";
    private static final String FORWARD_URI_REQUEST_ATRIBUTE = "javax.servlet.forward.request_uri";
    public static final String HTTP_REQUEST_METHOD_GET = "GET";
    public static final String HTTP_REQUEST_METHOD_POST = "POST";
    private static final String PROXIED_PROTOCOL_HEADER = "X-Forwarded-Proto";

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie cookie = RequestUtil.getCookie(request, name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = request.getCookies();
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (name.equalsIgnoreCase(cookie.getName())) {
                    return cookie;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getEntryURI(HttpServletRequest request) {
        String entryURI = (String)request.getAttribute(FORWARD_URI_REQUEST_ATRIBUTE);
        if (entryURI != null) {
            return entryURI;
        }
        return request.getRequestURI();
    }

    public static String getOriginalUrlFromRequest(HttpServletRequest request) throws MalformedURLException {
        String currentUrl = request.getRequestURL().toString();
        if (RequestUtil.isProxiedHttpsRequest(request) && currentUrl.startsWith("http:")) {
            currentUrl = currentUrl.replaceFirst("http", "https");
        }
        String queryString = request.getQueryString();
        String parentUrlRelative = (String)request.getAttribute(FORWARD_URI_REQUEST_ATRIBUTE);
        if (parentUrlRelative != null && parentUrlRelative.length() != 0) {
            URL requestUrl = new URL(currentUrl);
            currentUrl = String.valueOf(requestUrl.getProtocol()) + "://" + requestUrl.getHost() + ":" + requestUrl.getPort() + parentUrlRelative;
            queryString = (String)request.getAttribute(FORWARD_QUERY_STRING_REQUEST_ATRIBUTE);
        }
        if (queryString != null) {
            currentUrl = String.valueOf(currentUrl) + "?" + queryString;
        }
        return currentUrl;
    }

    private static boolean isProxiedHttpsRequest(HttpServletRequest request) {
        String originalProtocol = request.getHeader(PROXIED_PROTOCOL_HEADER);
        return "https".equalsIgnoreCase(originalProtocol);
    }
}

