/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.http;

import com.sap.engine.lib.security.http.HttpCallback;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class HttpAbstractCallback
implements HttpCallback {
    private static Map<Byte, String> TYPES = new HashMap<Byte, String>();
    protected byte type;
    protected String name;
    protected Object value;

    static {
        TYPES.put((byte)1, "HEADER");
        TYPES.put((byte)2, "COOKIE");
        TYPES.put((byte)3, "REQUEST_PARAMETER");
        TYPES.put((byte)4, "CERTIFICATE");
        TYPES.put((byte)5, "CLIENT_IP");
        TYPES.put((byte)6, "METHOD_TYPE");
        TYPES.put((byte)7, "IS_SECURE");
        TYPES.put((byte)8, "RESPONSE_CODE");
        TYPES.put((byte)9, "BODY");
        TYPES.put((byte)10, "SESSION_ATTRIBUTE");
        TYPES.put((byte)11, "ALL_SESSION_ATTRIBUTES");
        TYPES.put((byte)12, "REMOVE_SESSION_ATTRIBUTE");
        TYPES.put((byte)13, "REQUEST_ATTRIBUTE");
        TYPES.put((byte)14, "SET_HEADER");
        TYPES.put((byte)15, "REMOVE_HEADER");
        TYPES.put((byte)16, "BODY_READER");
        TYPES.put((byte)17, "REQUEST_URL");
        TYPES.put((byte)18, "POST_PARAMETERS");
        TYPES.put((byte)19, "REDIRECT");
        TYPES.put((byte)20, "RUNTIME_MODEL_DATA");
        TYPES.put((byte)21, "REMOVE_RUNTIME_MODEL_DATA");
        TYPES.put((byte)22, "CHANGE_SCHEMA");
        TYPES.put((byte)23, "ENCRYPT_STRING");
        TYPES.put((byte)24, "DECRYPT_STRING");
        TYPES.put((byte)25, "LOGIN_CONTEXT");
        TYPES.put((byte)26, "CREATE_SESSION");
        TYPES.put((byte)27, "SERVER_NAME");
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setType(byte type) {
        this.type = type;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("type: ").append(this.getTypeAsString(this.type));
        sb.append(", ");
        sb.append("name: ").append(this.name);
        sb.append(", ");
        sb.append("value: ");
        if (this.value instanceof Object[]) {
            sb.append(Arrays.toString((Object[])this.value));
        } else {
            sb.append(this.value);
        }
        sb.append("]");
        return sb.toString();
    }

    public String getTypeAsString(byte type) {
        String s = TYPES.get(type);
        if (s != null) {
            return s;
        }
        return "UNKNOWN (" + type + ")";
    }
}

