/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.login;

import java.security.Principal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class SubjectWrapper {
    private static final Logger LOG = Logger.getLogger(SubjectWrapper.class.getName());
    private boolean isAnonymous = false;
    private Subject subject = null;
    private Principal principal = null;

    public SubjectWrapper() {
        this.subject = new Subject();
        this.isAnonymous = true;
    }

    public SubjectWrapper(Principal principal) {
        this.principal = principal;
        this.subject = new Subject();
        this.subject.getPrincipals().add(this.principal);
        this.isAnonymous = false;
    }

    public SubjectWrapper(Subject subject) {
        this.subject = subject;
        this.isAnonymous = false;
    }

    public SubjectWrapper(Subject subject, Principal principal) {
        this.subject = subject;
        this.principal = principal;
        this.isAnonymous = false;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Principal getPrincipal() {
        if (this.principal != null) {
            return this.principal;
        }
        if (this.subject != null) {
            Subject inner = this.getSubject();
            try {
                Set<Principal> s = inner.getPrincipals();
                this.principal = s.iterator().next();
            }
            catch (Exception exception) {
                this.principal = null;
            }
        }
        if (this.principal != null) {
            return this.principal;
        }
        return null;
    }

    protected void merge(SubjectWrapper newSubjectWrapper) {
        Subject newSubject;
        Principal newPrincipal;
        if (newSubjectWrapper == null) {
            return;
        }
        if (this.isAnonymous()) {
            throw new IllegalStateException("Cannot merge authenticated subject wrapper into anonymous subject wrapper!");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Merging new subject wrapper into the current {0}", new Object[]{this});
        }
        if ((newPrincipal = newSubjectWrapper.getPrincipal()) != null) {
            this.principal = newPrincipal;
        }
        if ((newSubject = newSubjectWrapper.getSubject()) == null) {
            return;
        }
        Subject jaasSubject = this.getSubject();
        this.addOrReplace(jaasSubject.getPrincipals(), newSubject.getPrincipals());
        this.addOrReplace(jaasSubject.getPrivateCredentials(), newSubject.getPrivateCredentials());
        this.addOrReplace(jaasSubject.getPublicCredentials(), newSubject.getPublicCredentials());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Merged subject wrapper is {0}", new Object[]{this});
        }
    }

    private <T> void addOrReplace(Set<T> oldValues, Set<T> newValues) {
        oldValues.addAll(newValues);
    }

    public SubjectWrapper createCopy() {
        SubjectWrapper result = null;
        if (this.isAnonymous()) {
            result = new SubjectWrapper();
        } else {
            result = new SubjectWrapper(new Subject(), this.principal);
            result.subject.getPrincipals().addAll(this.subject.getPrincipals());
            result.subject.getPublicCredentials().addAll(this.subject.getPublicCredentials());
            result.subject.getPrivateCredentials().addAll(this.subject.getPrivateCredentials());
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Copy {0} of {1} created", new Object[]{result, this});
        }
        return result;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("[Subject Wrapper: ").append("\r\n");
        res.append("Main Principal: ").append(this.getPrincipal()).append("\r\n");
        res.append("Subject: ").append(this.getSubject());
        res.append("]");
        return res.toString();
    }
}

