/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.common.model.json;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PropertiesAdapterFactory
implements TypeAdapterFactory {
    private static final Type PROPERTY_KEY_TYPE = new TypeToken<String>(){}.getType();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (!this.isPropertyMap(typeToken)) {
            return null;
        }
        final TypeAdapter objectDelegate = gson.getAdapter(Object.class);
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, typeToken);
        return new TypeAdapter<T>(){

            public T read(JsonReader in) throws IOException {
                TreeMap<String, Object> result = new TreeMap<String, Object>();
                in.beginObject();
                while (in.hasNext()) {
                    this.parseProperty(in, result);
                }
                in.endObject();
                return result;
            }

            private void parseProperty(JsonReader in, Map<String, Object> result) throws IOException {
                String key = in.nextName();
                result.put(key, this.parseValue(objectDelegate.read(in)));
            }

            private Object parseValue(Object value) {
                if (value instanceof Double) {
                    return this.attemptToCastToInteger((Double)value);
                }
                if (value instanceof List) {
                    List list = (List)value;
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (Object innerValue : list) {
                        result.add(this.parseValue(innerValue));
                    }
                    return result;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    TreeMap result = new TreeMap();
                    for (Object key : map.keySet()) {
                        result.put(key, this.parseValue(map.get(key)));
                    }
                    return result;
                }
                return value;
            }

            private Object attemptToCastToInteger(Double value) {
                if (this.isInteger(value)) {
                    return value.intValue();
                }
                return value;
            }

            private boolean isInteger(Double value) {
                return value % 1.0 == 0.0;
            }

            public void write(JsonWriter out, T object) throws IOException {
                delegate.write(out, object);
            }
        };
    }

    private boolean isPropertyMap(TypeToken<?> typeToken) {
        if (!Map.class.isAssignableFrom(typeToken.getRawType())) {
            return false;
        }
        if (!(typeToken.getType() instanceof ParameterizedType)) {
            return false;
        }
        Type keyType = ((ParameterizedType)typeToken.getType()).getActualTypeArguments()[0];
        return PROPERTY_KEY_TYPE.equals(keyType);
    }
}

