/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.common.util;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CommonUtil {
    public static boolean isNullOrEmpty(Object value) {
        return value == null || CommonUtil.isEmpty(value);
    }

    public static boolean isEmpty(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }

    public static <T> String toCommaDelimitedString(List<T> objects, String prefix) {
        return CommonUtil.joinStrings(objects, prefix, ",");
    }

    public static <T> String joinStrings(List<T> objects, String prefix, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (T object : objects) {
            sb.append(prefix).append(object.toString());
            if (count++ >= objects.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String repeat(String string, int times) {
        return new String(new char[times]).replaceAll("\u0000", string);
    }

    public static <T> T merge(T originalValue, T overrideValue, T defaultValue) {
        if (overrideValue != null) {
            return overrideValue;
        }
        if (originalValue != null) {
            return originalValue;
        }
        return defaultValue;
    }

    public static void replaceAll(StringBuilder builder, String original, String replacement) {
        int index = builder.indexOf(original);
        while (index != -1) {
            builder.replace(index, index + original.length(), replacement);
            index += replacement.length();
            index = builder.indexOf(original, index);
        }
    }

    public static char[] getCharacterRange(char start, char end) {
        if (start > end) {
            return CommonUtil.getCharacterRange(end, start);
        }
        char[] range = new char[end - start + 1];
        for (int i = 0; i < range.length; ++i) {
            char c = start;
            start = (char)(start + '\u0001');
            range[i] = c;
        }
        return range;
    }

    public static <E> E cast(Object item) {
        return (E)item;
    }

    public static <E> E getOrDefault(E value, E defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static String abbreviate(String string, int limit) {
        if (string.length() <= limit) {
            return string;
        }
        String abbreviationMarker = "...";
        int minimumLimit = "...".length() + 1;
        if (limit <= minimumLimit) {
            throw new IllegalArgumentException(MessageFormat.format("String length limit is below the minimum abbreviation limit of {0}", minimumLimit));
        }
        String trimmedString = string.substring(0, limit - "...".length());
        return trimmedString + "...";
    }
}

