/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sap.cloud.lm.sl.common.ParsingException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final int MAX_LENGTH = 128;

    public static Map<String, Object> convertJsonToMap(InputStream json) throws ParsingException {
        return JsonUtil.convertJsonToMap(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public static <K, V> Map<K, V> convertJsonToMap(InputStream json, Type type) throws ParsingException {
        return JsonUtil.fromJson(json, type, new HashMap(), "Error while converting JSON input stream to map");
    }

    public static Map<String, Object> convertJsonToMap(String json) throws ParsingException {
        return JsonUtil.convertJsonToMap(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public static <K, V> Map<K, V> convertJsonToMap(String json, Type type) throws ParsingException {
        return JsonUtil.fromJson(json, type, new HashMap(), "Error while converting JSON string \"{0}\" to map");
    }

    public static List<Object> convertJsonToList(InputStream json) throws ParsingException {
        return JsonUtil.convertJsonToList(json, new TypeToken<List<Object>>(){}.getType());
    }

    public static <T> List<T> convertJsonToList(InputStream json, Type type) throws ParsingException {
        return JsonUtil.fromJson(json, type, new ArrayList(), "Error while converting JSON input stream to list");
    }

    public static List<Object> convertJsonToList(String json) throws ParsingException {
        return JsonUtil.convertJsonToList(json, new TypeToken<List<Object>>(){}.getType());
    }

    public static <T> List<T> convertJsonToList(String json, Type type) throws ParsingException {
        return JsonUtil.fromJson(json, type, new ArrayList(), "Error while converting JSON string \"{0}\" to list");
    }

    private static <T> T fromJson(String json, Type type, T defaultValue, String errorMessage) throws ParsingException {
        if (json == null || json.isEmpty()) {
            return defaultValue;
        }
        try {
            return (T)new Gson().fromJson(json, type);
        }
        catch (Exception e) {
            throw new ParsingException(e, errorMessage, json.substring(0, Math.min(json.length(), 128)));
        }
    }

    private static <T> T fromJson(InputStream json, Type type, T defaultValue, String errorMessage) throws ParsingException {
        if (json == null) {
            return defaultValue;
        }
        try {
            return (T)new Gson().fromJson((Reader)new InputStreamReader(json, StandardCharsets.UTF_8), type);
        }
        catch (Exception e) {
            throw new ParsingException(e, errorMessage, json);
        }
    }

    public static <T> String toJson(T obj, boolean prettyPrinting) {
        return JsonUtil.toJson(obj, prettyPrinting, false, false);
    }

    public static <T> String toJson(T obj) {
        return JsonUtil.toJson(obj, false);
    }

    public static <T> String toJson(T obj, boolean prettyPrinting, boolean enableExpose, boolean disableHtmlEscaping) {
        GsonBuilder builder = new GsonBuilder();
        if (disableHtmlEscaping) {
            builder.disableHtmlEscaping();
        }
        if (prettyPrinting) {
            builder.setPrettyPrinting();
        }
        if (enableExpose) {
            builder.excludeFieldsWithoutExposeAnnotation();
        }
        return builder.create().toJson(obj);
    }

    public static <T> T fromJson(String json, Type type) throws ParsingException {
        try {
            return (T)new Gson().fromJson(json, type);
        }
        catch (JsonSyntaxException e) {
            throw new ParsingException(e, "Error while parsing JSON string \"{0}\" to type \"{1}\" ", json.substring(0, Math.min(json.length(), 128)), type.toString());
        }
    }
}

