/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListUtil {
    public static <E> List<E> upcastUnmodifiable(List<? extends E> list) {
        return ListUtil.unmodifiable(list);
    }

    public static <E> List<E> upcast(List<? extends E> list) {
        return list == null ? null : new ArrayList<E>(list);
    }

    public static <E> List<E> castUnmodifiable(List<?> list) {
        return ListUtil.unmodifiable(ListUtil.cast(list));
    }

    public static <E> List<E> cast(List<?> list) {
        return list == null ? null : new ArrayList(list);
    }

    public static <E> List<E> unmodifiable(List<? extends E> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    public static <T> List<T> merge(List<T> original, List<T> override) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(original);
        result.addAll(override);
        return result;
    }

    public static <T> void addNonNull(List<T> list, T item) {
        if (item != null) {
            list.add(item);
        }
    }

    public static <T> List<T> asList(T item) {
        if (item == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(item);
    }
}

