/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

public class RangeCollection<KeyType extends Comparable<KeyType>, DataType> {
    private NavigableMap<KeyType, DataType> itemsMap;

    public RangeCollection(NavigableMap<KeyType, DataType> itemsMap) {
        this.itemsMap = itemsMap;
    }

    public List<DataType> getItems(KeyType lowLimit, KeyType highLimit) {
        Comparable finalKey;
        if (this.itemsMap.isEmpty()) {
            return Collections.emptyList();
        }
        Map.Entry<KeyType, DataType> currentEntry = lowLimit == null ? this.itemsMap.firstEntry() : this.itemsMap.ceilingEntry(lowLimit);
        Comparable comparable = finalKey = highLimit == null ? (Comparable)this.itemsMap.lastKey() : (Comparable)this.itemsMap.floorKey(highLimit);
        if (currentEntry == null || finalKey == null) {
            return Collections.emptyList();
        }
        LinkedList<DataType> result = new LinkedList<DataType>();
        while (currentEntry != null && ((Comparable)currentEntry.getKey()).compareTo(finalKey) <= 0) {
            result.add(currentEntry.getValue());
            currentEntry = this.itemsMap.higherEntry(currentEntry.getKey());
        }
        return result;
    }

    public List<DataType> getItems() {
        return new ArrayList(this.itemsMap.values());
    }
}

