/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.common.util;

import com.sap.cloud.lm.sl.common.ParsingException;
import com.sap.cloud.lm.sl.common.SLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    private static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER__ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    private static final String DISALLOW_DOCTYPE_DECLARATION_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";

    public static <T> String toXml(T object) throws SLException {
        return XmlUtil.toXml(object, false);
    }

    public static <T> String toXml(T object, boolean formattedOutput) throws SLException {
        try {
            StringWriter buffer = new StringWriter();
            XmlUtil.getMarshaller(XmlUtil.getContext(object.getClass()), formattedOutput).marshal(object, (Writer)buffer);
            return ((Object)buffer).toString();
        }
        catch (JAXBException e) {
            XmlUtil.handleMarshallingException((Exception)((Object)e));
            return null;
        }
    }

    public static <T> T fromXml(InputStream xml, Class<T> clazz, URL schemaLocation) throws ParsingException {
        return XmlUtil.fromXml(XmlUtil.getAsDocument(xml), clazz, schemaLocation);
    }

    public static <T> T fromXml(InputStream xml, Class<T> clazz) throws ParsingException {
        return XmlUtil.fromXml(xml, clazz, null);
    }

    public static <T> T fromXml(String xml, Class<T> clazz, URL schemaLocation) throws ParsingException {
        return XmlUtil.fromXml(XmlUtil.getAsDocument(xml), clazz, schemaLocation);
    }

    public static <T> T fromXml(String xml, Class<T> clazz) throws ParsingException {
        return XmlUtil.fromXml(xml, clazz, null);
    }

    public static <T> T fromXml(Document xml, Class<T> clazz, URL schemaLocation) throws ParsingException {
        try {
            return (T)XmlUtil.getUnmarshaller(XmlUtil.getContext(clazz), schemaLocation).unmarshal((Node)xml, clazz).getValue();
        }
        catch (JAXBException | SAXException e) {
            XmlUtil.handleUnmarshallingException((Exception)e, schemaLocation);
            return null;
        }
    }

    private static <T> JAXBContext getContext(Class<T> clazz) throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{clazz});
    }

    private static Marshaller getMarshaller(JAXBContext context, boolean formattedOutput) throws SLException {
        try {
            return formattedOutput ? XmlUtil.getFormattingMarshaller(context) : XmlUtil.getRegularMarshaller(context);
        }
        catch (JAXBException e) {
            throw new SLException("Could not create JAXB marshaller", new Object[]{e});
        }
    }

    private static Marshaller getFormattingMarshaller(JAXBContext context) throws JAXBException {
        Marshaller marshaller = XmlUtil.getRegularMarshaller(context);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    private static Marshaller getRegularMarshaller(JAXBContext context) throws JAXBException {
        return context.createMarshaller();
    }

    private static Document getAsDocument(InputStream xml) throws ParsingException {
        return XmlUtil.getAsDocument(new InputSource(xml));
    }

    private static Document getAsDocument(String xml) throws ParsingException {
        return XmlUtil.getAsDocument(new InputSource(new StringReader(xml)));
    }

    private static Document getAsDocument(InputSource xml) throws ParsingException {
        try {
            return XmlUtil.getDocumentBuilder().parse(xml);
        }
        catch (IOException | SAXException e) {
            throw new ParsingException(e, "Error while parsing XML input stream");
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws ParsingException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.setFeature(DISALLOW_DOCTYPE_DECLARATION_FEATURE, true);
            factory.setFeature(EXTERNAL_GENERAL_ENTITIES_FEATURE, false);
            factory.setFeature(EXTERNAL_PARAMETER__ENTITIES_FEATURE, false);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ParsingException("Could not create document builder factory", new Object[]{e});
        }
    }

    private static Unmarshaller getValidatingUnmarshaller(JAXBContext context, URL schemaLocation) throws SAXException, JAXBException {
        Unmarshaller unmarshaller = XmlUtil.getRegularUnmarshaller(context);
        unmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaLocation));
        return unmarshaller;
    }

    private static Unmarshaller getUnmarshaller(JAXBContext context, URL schemaLocation) throws SAXException, ParsingException {
        try {
            return schemaLocation != null ? XmlUtil.getValidatingUnmarshaller(context, schemaLocation) : XmlUtil.getRegularUnmarshaller(context);
        }
        catch (JAXBException e) {
            throw new ParsingException("Could not create JAXB unmarshaller", new Object[]{e});
        }
    }

    private static void handleUnmarshallingException(Exception e, URL schemaLocation) throws ParsingException {
        if (e instanceof SAXException) {
            throw new ParsingException(MessageFormat.format("Could not parse schema at location \"{0}\"", schemaLocation), new Object[]{e});
        }
        if (e instanceof JAXBException && e.getCause() instanceof SAXParseException) {
            Throwable cause = e.getCause();
            throw new ParsingException(cause.getMessage(), new Object[]{cause});
        }
        if (e instanceof JAXBException) {
            throw new ParsingException("An unexpected error occurred while unmarshalling the XML content", new Object[]{e});
        }
    }

    private static Unmarshaller getRegularUnmarshaller(JAXBContext context) throws JAXBException {
        return context.createUnmarshaller();
    }

    private static void handleMarshallingException(Exception e) throws SLException {
        throw new SLException("An unexpected error occurred while marshalling the object", new Object[]{e});
    }
}

