/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.log.dev.cmd.commands.LogCommand;
import com.sap.core.log.dev.cmd.util.LogCmdUtil;
import com.sap.core.log.dev.rest.client.IAppLogsREST;
import com.sap.core.log.dev.rest.client.exceptions.ForbiddenException;
import com.sap.core.log.dev.rest.client.exceptions.LogOperationsException;
import com.sap.core.log.dev.rest.client.exceptions.NotFoundException;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.Console;
import java.io.File;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.GZIPInputStream;

@Parameters(commandDescription="Downloads a particular log file")
public class GetLogFileCommand
extends LogCommand {
    private static final String COMMAND_EXAMPLE_GET_LOG = "neo get-log --account mysubaccount --application demo --user s1234567 --host hanatrial.ondemand.com --directory C:\\MyDemoApps\\log --file jpaas_audit_log.log";
    @Parameter(names={"-f", "--file"}, description="The log file name including its extension")
    protected String logFileName;
    @Parameter(names={"-d", "--directory"}, description="Local folder location under which the file will be downloaded. If the directory you have specified does not exist, it will be created")
    protected File folder;
    @Parameter(names={"-w", "--overwrite"}, description="Overwrites a file with the same name if such already exists. If you do not explicitly include the --overwrite argument, you will be notified and asked if you want to overwrite the file. Default: true")
    protected boolean overwrite;
    private boolean shouldOverwrite = false;

    public void run() throws CommandException {
        IAppLogsREST logClient = null;
        try {
            CheckHelper.checkArgSpecified((String)"-f", (String)"--file", (String)this.logFileName);
            if (this.folder == null) {
                throw new ParameterException("-d or --directory not spcified");
            }
            DumpHelper.dumpOperationList((String)this.getUser(), (String)("Executing [" + this.getName() + "] command with arguments: "), (Object[])this.getArgsToBeDumped().toArray());
            File targetFile = new File(this.folder, this.logFileName);
            this.checkTargetFile(targetFile);
            logClient = this.createLogClient();
            GZIPInputStream appLogFileStream = logClient.getAppLogFileStream(this.logFileName);
            if (!this.folder.exists()) {
                this.folder.mkdirs();
            }
            LogCmdUtil.inputStreamToFile(targetFile, appLogFileStream, !this.shouldOverwrite);
            LogCmdUtil.printSuccessfullOperation(this.getName());
        }
        catch (UnauthorizedException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new CommandException((Exception)e);
        }
        catch (ForbiddenException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new CommandException((Exception)((Object)e));
        }
        catch (LogOperationsException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new CommandException(e.getCause());
            }
            throw new CommandException((Exception)((Object)e));
        }
    }

    private void checkTargetFile(File targetFile) {
        if (!targetFile.exists() || this.overwrite) {
            return;
        }
        String userAnswer = this.getUserAnswer(targetFile);
        this.shouldOverwrite = "y".equals(userAnswer);
        if (!this.shouldOverwrite) {
            System.exit(0);
        }
    }

    protected String getUserAnswer(File targetFile) {
        Console c = System.console();
        if (c == null) {
            throw new CommandException("No console available.");
        }
        String shouldOverwrite = c.readLine(String.format("File %s already exists. Do you want to replace it (y/n)?", targetFile.toString()), new Object[0]);
        return shouldOverwrite;
    }

    public String getName() {
        return "get-log";
    }

    @Override
    protected Collection<String> getArgsToBeDumped() {
        Collection<String> args = super.getArgsToBeDumped();
        Collections.addAll(args, "directory", this.folder.getPath(), "file", this.logFileName, "overwrite", this.overwrite + "");
        return args;
    }

    public String getExample() {
        return COMMAND_EXAMPLE_GET_LOG;
    }
}

