/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.log.dev.app.logs.AppLogFile;
import com.sap.core.log.dev.cmd.commands.LogCommand;
import com.sap.core.log.dev.cmd.util.LastModifiedComparator;
import com.sap.core.log.dev.cmd.util.LogCmdUtil;
import com.sap.core.log.dev.rest.client.IAppLogsREST;
import com.sap.core.log.dev.rest.client.exceptions.ForbiddenException;
import com.sap.core.log.dev.rest.client.exceptions.LogOperationsException;
import com.sap.core.log.dev.rest.client.exceptions.NotFoundException;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists all log files of your application sorted by date in a table format, starting with the latest modified")
public class ListLogFilesCommand
extends LogCommand {
    private static final String COMMAND_EXAMPLE_LIST_LOGS = "neo list-logs --account mysubaccount --application demo --user s1234567 --host hanatrial.ondemand.com";

    public void run() throws CommandException {
        IAppLogsREST logClient = null;
        try {
            DumpHelper.dumpOperationList((String)this.getUser(), (String)("Executing [" + this.getName() + "] command with arguments: "), (Object[])this.getArgsToBeDumped().toArray());
            logClient = this.createLogClient();
            List appLogFiles = logClient.getAppLogFiles();
            this.printLogFilesList(appLogFiles);
        }
        catch (UnauthorizedException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new CommandException((Exception)e);
        }
        catch (ForbiddenException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new CommandException((Exception)((Object)e));
        }
        catch (LogOperationsException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new CommandException(e.getCause());
            }
            throw new CommandException((Exception)((Object)e));
        }
    }

    private void printLogFilesList(List<AppLogFile> appLogFiles) {
        Collections.sort(appLogFiles, new LastModifiedComparator());
        Collections.reverse(appLogFiles);
        System.out.println();
        LogCmdUtil.printSuccessfullOperation(this.getName());
        System.out.format("%1$-24s  %2$11s  %3$-24s\n", "Last Modified", "Size (Bytes)", "File Name");
        System.out.format("%1$-24s  %2$11s  %3$-24s\n", "", "", "");
        for (AppLogFile appLogFile : appLogFiles) {
            String fileName = appLogFile.getName();
            String lastModified = LogCmdUtil.formatDate(appLogFile.getLastModified());
            String size = LogCmdUtil.formatNumber(appLogFile.getSize());
            System.out.format("%1$-24s  %2$11s  %3$-24s\n", lastModified, size, fileName);
        }
        System.out.println();
    }

    public String getName() {
        return "list-logs";
    }

    public String getExample() {
        return COMMAND_EXAMPLE_LIST_LOGS;
    }
}

