/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.log.dev.app.logs.AppLogger;
import com.sap.core.log.dev.cmd.commands.LogCommand;
import com.sap.core.log.dev.cmd.util.LogCmdUtil;
import com.sap.core.log.dev.cmd.util.LoggersComparator;
import com.sap.core.log.dev.rest.client.IAppLogsREST;
import com.sap.core.log.dev.rest.client.exceptions.ForbiddenException;
import com.sap.core.log.dev.rest.client.exceptions.LogOperationsException;
import com.sap.core.log.dev.rest.client.exceptions.NotFoundException;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists all available loggers with their log levels for your application")
public class ListLoggersCommand
extends LogCommand {
    private static final String COMMAND_EXAMPLE_LIST_LOGGERS = "neo list-loggers --account mysubaccount --application demo --user s1234567 --host hanatrial.ondemand.com";

    public void run() throws CommandException {
        IAppLogsREST logClient = null;
        try {
            DumpHelper.dumpOperationList((String)this.getUser(), (String)("Executing [" + this.getName() + "] command with arguments: "), (Object[])this.getArgsToBeDumped().toArray());
            logClient = this.createLogClient();
            List appLoggers = logClient.getAppLoggers();
            this.printLoggersList(appLoggers);
        }
        catch (UnauthorizedException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new CommandException((Exception)e);
        }
        catch (ForbiddenException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new CommandException((Exception)((Object)e));
        }
        catch (LogOperationsException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new CommandException(e.getCause());
            }
            throw new CommandException((Exception)((Object)e));
        }
    }

    private void printLoggersList(List<AppLogger> appLoggers) {
        Collections.sort(appLoggers, new LoggersComparator());
        System.out.println();
        LogCmdUtil.printSuccessfullOperation(this.getName());
        System.out.format("%1$-7s  %2$-50s\n", "Level", "Logger");
        System.out.format("%1$-7s  %2$-50s\n", "", "");
        for (AppLogger appLogger : appLoggers) {
            String level = appLogger.getLevel();
            String name = appLogger.getName();
            System.out.format("%1$-7s  %2$-50s\n", level, name);
        }
    }

    public String getName() {
        return "list-loggers";
    }

    public String getExample() {
        return COMMAND_EXAMPLE_LIST_LOGGERS;
    }
}

