/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.cmd.commands;

import com.sap.core.log.dev.cmd.util.LogCmdUtil;
import com.sap.core.log.dev.rest.client.IAppLogsREST;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.command.ComponentCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

public abstract class LogCommand
extends ComponentCommand {
    protected HttpClient httpClient;

    public void init() throws CommandException {
        super.init();
        CheckHelper.checkAccountAndAppSpecified((String)this.getAccount(), (String)this.getApplication());
    }

    public void cleanup() throws CommandException {
        if (this.httpClient != null && this.httpClient instanceof DefaultHttpClient) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public String getGroup() {
        return "logging";
    }

    protected Collection<String> getArgsToBeDumped() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.getComponent() != null && !this.getComponent().equalsIgnoreCase("web")) {
            Collections.addAll(args, "component", this.getComponent());
        }
        Collections.addAll(args, "host", this.getHost(), "application", this.getApplication(), "account", this.getAccount());
        return args;
    }

    protected IAppLogsREST createLogClient() throws UnauthorizedException, MalformedURLException {
        this.httpClient = this.getHttpClient();
        return LogCmdUtil.createLogRestClient(new URL(this.getHost()), this.getAccount(), this.getApplication(), this.getComponent(), this.httpClient, this.getUser(), this.getPassword());
    }
}

