/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.log.dev.cmd.commands.LogCommand;
import com.sap.core.log.dev.rest.client.IAppLogsREST;
import com.sap.core.log.dev.rest.client.ResetResult;
import com.sap.core.log.dev.rest.client.exceptions.ForbiddenException;
import com.sap.core.log.dev.rest.client.exceptions.LogOperationsException;
import com.sap.core.log.dev.rest.client.exceptions.NotFoundException;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.net.MalformedURLException;
import java.net.UnknownHostException;

@Parameters(commandDescription="Resets all logger levels to their initial state. The change takes effect after application restart.")
public class ResetLogLevelsCommand
extends LogCommand {
    private static final String MSG_RESULT_RESET_LOG_LEVELS_SUCCESS = "Log levels reset successfully.";
    private static final String MSG_RESULT_RESET_LOG_LEVELS_SUCCESS_RESTART = "Log levels reset successfully. Restart the application to apply the change.";
    public static final String COMMAND_DESCRIPTION_RESET_LOG_LEVELS = "Resets all logger levels to their initial state. The change takes effect after application restart.";
    private static final String COMMAND_EXAMPLE_RESET_LOG_LEVELS = "neo reset-log-levels --account mysubaccount --application demo --user s1234567 --host hanatrial.ondemand.com";
    public static final String COMMAND_NAME_RESET_LOG_LEVELS = "reset-log-levels";

    public void run() throws CommandException {
        IAppLogsREST logClient = null;
        try {
            DumpHelper.dumpOperationList((String)this.getUser(), (String)("Executing [" + this.getName() + "] command with arguments: "), (Object[])this.getArgsToBeDumped().toArray());
            logClient = this.createLogClient();
            ResetResult resetResult = logClient.resetAppLoggers();
            String resultMessage = MSG_RESULT_RESET_LOG_LEVELS_SUCCESS_RESTART;
            if (ResetResult.OK == resetResult) {
                resultMessage = MSG_RESULT_RESET_LOG_LEVELS_SUCCESS;
            }
            DumpHelper.dumpWithNewLine((String)resultMessage);
        }
        catch (UnauthorizedException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new CommandException((Exception)e);
        }
        catch (ForbiddenException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new CommandException((Exception)((Object)e));
        }
        catch (LogOperationsException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new CommandException(e.getCause());
            }
            throw new CommandException((Exception)((Object)e));
        }
    }

    public String getName() {
        return COMMAND_NAME_RESET_LOG_LEVELS;
    }

    public String getExample() {
        return COMMAND_EXAMPLE_RESET_LOG_LEVELS;
    }
}

