/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.sap.core.log.dev.app.logs.AppLogger;
import com.sap.core.log.dev.cmd.commands.LogCommand;
import com.sap.core.log.dev.cmd.util.LogCmdUtil;
import com.sap.core.log.dev.rest.client.IAppLogsREST;
import com.sap.core.log.dev.rest.client.exceptions.ForbiddenException;
import com.sap.core.log.dev.rest.client.exceptions.LogOperationsException;
import com.sap.core.log.dev.rest.client.exceptions.NotFoundException;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import com.sap.core.log.dev.rest.client.exceptions.UnsupportedLogLevelException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.Log4jLevelValidator;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Parameters(commandDescription="Sets a log level for one or multiple loggers")
public class SetLogLevelCommand
extends LogCommand {
    private static final String COMMAND_EXAMPLE_SET_LOG_LEVEL = "neo set-log-level --account mysubaccount --application demo --user s1234567 --host hanatrial.ondemand.com --level DEBUG --loggers com.acme.foo,com.acme.bar";
    static final String COMMAND_DESCRIPTION_SET_LOG_LEVEL = "Sets a log level for one or multiple loggers";
    @Parameter(names={"--logger"}, description="Single or multiple comma-separated logger names. Example: com.acme.foo,com.acme.bar", hidden=true)
    protected String logger;
    @Parameter(names={"-g", "--loggers"}, description="Single or multiple comma-separated logger names. Example: com.acme.foo,com.acme.bar")
    protected String loggers;
    @Parameter(names={"-l", "--level"}, description="The log level you want to set for the logger(s). Supported log levels: OFF, ERROR, WARN, INFO, DEBUG, TRACE, ALL", validateWith=Log4jLevelValidator.class)
    protected String level;

    public void run() throws CommandException {
        IAppLogsREST logClient = null;
        try {
            try {
                CheckHelper.checkArgSpecified(null, (String)"--logger", (String)this.logger);
            }
            catch (ParameterException e) {
                CheckHelper.checkArgSpecified((String)"-g", (String)"--loggers", (String)this.loggers);
            }
            CheckHelper.checkArgSpecified((String)"-l", (String)"--level", (String)this.level);
            logClient = this.createLogClient();
            DumpHelper.dumpOperationList((String)this.getUser(), (String)("Executing [" + this.getName() + "] command with arguments: "), (Object[])this.getArgsToBeDumped().toArray());
            List<AppLogger> appLoggers = this.loadAppLoggers();
            if (appLoggers.size() == 0) {
                throw new ParameterException("No logger(s) specified");
            }
            logClient.setAppLoggers(appLoggers);
            LogCmdUtil.printSuccessfullOperation(this.getName());
        }
        catch (UnauthorizedException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new CommandException((Exception)e);
        }
        catch (ForbiddenException e) {
            throw new SecurityException((Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new CommandException((Exception)((Object)e));
        }
        catch (UnsupportedLogLevelException e) {
            throw new CommandException((Exception)((Object)e));
        }
        catch (LogOperationsException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new CommandException(e.getCause());
            }
            throw new CommandException((Exception)((Object)e));
        }
    }

    private List<AppLogger> loadAppLoggers() {
        ArrayList<AppLogger> appLoggers = new ArrayList<AppLogger>();
        Set<String> loggerNames = this.getSpecifiedLoggersNames();
        for (String loggersName : loggerNames) {
            appLoggers.add(new AppLogger(loggersName, this.level));
        }
        return appLoggers;
    }

    private Set<String> getSpecifiedLoggersNames() {
        HashSet loggersNames = new HashSet();
        if (this.loggers != null) {
            Collections.addAll(loggersNames, this.loggers.split(","));
        }
        if (this.logger != null) {
            Collections.addAll(loggersNames, this.logger.split(","));
        }
        HashSet<String> trimmedLoggerNames = new HashSet<String>();
        for (String loggerName : loggersNames) {
            trimmedLoggerNames.add(loggerName.trim());
        }
        return trimmedLoggerNames;
    }

    public String getName() {
        return "set-log-level";
    }

    @Override
    protected Collection<String> getArgsToBeDumped() {
        Collection<String> args = super.getArgsToBeDumped();
        Collections.addAll(args, "loggers", this.loggers, "logger", this.logger, "level", this.level);
        return args;
    }

    public String getExample() {
        return COMMAND_EXAMPLE_SET_LOG_LEVEL;
    }
}

