/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.cmd.util;

import com.sap.core.log.dev.rest.client.AppLogsRESTProvider;
import com.sap.core.log.dev.rest.client.BasicAuthClient;
import com.sap.core.log.dev.rest.client.IAppLogsREST;
import com.sap.core.log.dev.rest.client.exceptions.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class LogCmdUtil {
    private static final Logger LOGGER = Logger.getLogger(LogCmdUtil.class);

    public static IAppLogsREST createLogRestClient(URL landscapeURL, String space, String appliance, String component, HttpClient landscapeHttpClient, String username, String password) throws UnauthorizedException {
        BasicAuthClient basicAuthClient = new BasicAuthClient(landscapeURL, space, appliance, component, landscapeHttpClient);
        return AppLogsRESTProvider.createAppLogsRestClient((BasicAuthClient)basicAuthClient);
    }

    public static void printSuccessfullOperation(String cmdName) {
        System.out.println();
        System.out.println("[" + cmdName + "] operation is successful.");
        System.out.println();
    }

    public static void inputStreamToFile(File targetFile, InputStream fileInputStream) {
        LogCmdUtil.inputStreamToFile(targetFile, fileInputStream, true);
    }

    public static void inputStreamToFile(File targetFile, InputStream fileInputStream, boolean appendToFile) {
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            byte[] bucket = new byte[65536];
            inStream = new BufferedInputStream(fileInputStream);
            outStream = new BufferedOutputStream(new FileOutputStream(targetFile, appendToFile));
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = inStream.read(bucket);
                if (bytesRead <= 0) continue;
                outStream.write(bucket, 0, bytesRead);
            }
        }
        catch (FileNotFoundException e) {
            throw new CommandException((Exception)e);
        }
        catch (IOException e) {
            throw new CommandException((Exception)e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String formatDate(long timestamp) {
        DateFormat f = DateFormat.getDateTimeInstance(2, 3);
        return f.format(new Date(timestamp));
    }

    public static String formatNumber(long number) {
        NumberFormat f = NumberFormat.getIntegerInstance();
        String formatted = f.format(number);
        return formatted.replace('\u00a0', ' ');
    }
}

