/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.client;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConnectivitySocket
extends Socket {
    private static final Logger log = Logger.getLogger(ConnectivitySocket.class);
    private final String tunnelId;
    private final String ssoToken;
    private final String ssoTokenType;
    private final ConnectionProtocol protocol;
    private String proxyAuthorizationToken;

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol) {
        this(tunnelId, null, null, protocol);
    }

    public ConnectivitySocket(String tunnelId, String ssoToken, String ssoTokenType, ConnectionProtocol protocol) {
        this(tunnelId, ssoTokenType, ssoTokenType, protocol, null);
    }

    public ConnectivitySocket(String tunnelId, String ssoToken, String ssoTokenType, ConnectionProtocol protocol, String proxyAuthorizationToken) {
        this.tunnelId = tunnelId;
        this.ssoToken = ssoToken;
        this.ssoTokenType = ssoTokenType;
        this.protocol = protocol;
        this.proxyAuthorizationToken = proxyAuthorizationToken;
    }

    protected InetSocketAddress getProxyAddress() {
        int port = Integer.parseInt(System.getProperty("connectivity.proxy.port", "9001"));
        try {
            return new InetSocketAddress(InetAddress.getByName(null), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unable to get loopback interface address");
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(this.getProxyAddress(), timeout);
        OutputStream outputStream = this.getOutputStream();
        InetSocketAddress endpointInetAddress = (InetSocketAddress)endpoint;
        byte[] connectionProperties = this.serializeRequestProperties(endpointInetAddress);
        outputStream.write(ByteBuffer.allocate(4).putInt(connectionProperties.length).array());
        outputStream.write(connectionProperties);
        outputStream.flush();
        InputStream inputStream = this.getInputStream();
        int returnCode = inputStream.read();
        switch (returnCode) {
            case 0: {
                return;
            }
        }
        throw new SocketException("Unexpected error while connecting to connectivity proxy: " + returnCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeRequestProperties(InetSocketAddress endpointInetAddress) throws IOException {
        ByteArrayOutputStream byteArraysStream = new ByteArrayOutputStream();
        try {
            Properties properties = new Properties();
            properties.put("tunnelId", this.tunnelId);
            properties.put("hostname", endpointInetAddress.getHostName());
            properties.put("port", Integer.toString(endpointInetAddress.getPort()));
            properties.put("connectionProtocol", this.protocol.toString());
            if (this.proxyAuthorizationToken != null) {
                properties.put(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), this.proxyAuthorizationToken);
            }
            if (this.ssoToken != null) {
                properties.put("ssoToken", this.ssoToken);
                properties.put("ssoTokenType", this.ssoTokenType);
            }
            properties.store(byteArraysStream, null);
            byte[] byArray = byteArraysStream.toByteArray();
            return byArray;
        }
        finally {
            block9: {
                try {
                    byteArraysStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)e.toString());
                }
            }
        }
    }
}

