/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.processing;

import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.processing.ConnectionLoggingInboundHandler;
import com.sap.core.connectivity.spi.processing.ConnectionLoggingOutboundHandler;
import com.sap.core.connectivity.spi.processing.OutboundConnectionErrorHandler;
import com.sap.core.connectivity.spi.processing.OutboundConnectionReader;
import com.sap.core.connectivity.spi.util.SSLUtil;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.mapping.HostMapping;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import javax.net.ssl.SSLEngine;
import org.apache.log4j.Logger;

public abstract class AbstractProtocolProcessingChannelInitializer
extends ChannelInitializer<Channel> {
    private static final Logger logger = Logger.getLogger(AbstractProtocolProcessingChannelInitializer.class);
    protected final ProcessingContext processingContext;
    protected final int connectionId;
    protected final HostMapping hostMapping;
    private final int channelWriteTimeoutSeconds;

    public AbstractProtocolProcessingChannelInitializer(ProcessingContext processingContext, int connectionId, HostMapping hostMapping) {
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)processingContext.getServiceRegistry().getService(TunnelConfiguration.class);
        this.channelWriteTimeoutSeconds = tunnelConfiguration.getChannelWriteTimeoutSeconds();
        this.processingContext = processingContext;
        this.connectionId = connectionId;
        this.hostMapping = hostMapping;
    }

    protected final void initChannel(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("defaultWriteTimeoutHandler", (ChannelHandler)new WriteTimeoutHandler(this.channelWriteTimeoutSeconds));
        pipeline.addLast("connectionLoggingInboundHandler", (ChannelHandler)new ConnectionLoggingInboundHandler(this.connectionId));
        this.addSslHandlers(pipeline);
        this.addHandlers(pipeline);
        pipeline.addLast("outboundStreamHandler", (ChannelHandler)new OutboundConnectionReader(this.processingContext, this.connectionId));
        pipeline.addLast("backendErrorHandler", (ChannelHandler)new OutboundConnectionErrorHandler(this.processingContext, this.connectionId));
        pipeline.addLast("connectionLoggingOutboundHandler", (ChannelHandler)new ConnectionLoggingOutboundHandler(this.connectionId));
    }

    public final boolean isChannelSecured() {
        return this.hostMapping.isChannelSecured();
    }

    private final void addSslHandlers(ChannelPipeline pipeline) throws Exception {
        if (!this.hostMapping.isChannelSecured()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Will not add SSL handler for channel: %s", pipeline.channel()));
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("Adding SSL handler for channel: %s", pipeline.channel()));
        }
        SSLEngine engine = this.hostMapping.getSSLContext().createSSLEngine();
        SSLUtil.disableSSLProtocols(engine);
        engine.setUseClientMode(true);
        pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(engine));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)("Failed to initialize a channel: " + ctx.channel()), cause);
        super.exceptionCaught(ctx, cause);
    }

    protected abstract void addHandlers(ChannelPipeline var1) throws Exception;
}

