/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.processing;

import com.sap.cloud.auditlog.AuditLogMessageFactory;
import com.sap.cloud.auditlog.exception.AuditLogWriteException;
import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.logging.ConnectionIdLoggerWrapper;
import com.sap.core.connectivity.spi.processing.OutboundProtocolProcessor;
import com.sap.core.connectivity.spi.processing.TargetHost;
import com.sap.core.connectivity.spi.processing.ToggleErrorHandlingEvent;
import com.sap.core.connectivity.spi.processing.flow.DemandReadEvent;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.statistics.PerformanceStatistics;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.audit.AuditProvider;
import com.sap.core.connectivity.tunnel.api.audit.TunnelSecurityEventAuditMessage;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.mapping.HostMapping;
import com.sap.core.connectivity.tunnel.api.mapping.MappingResolver;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.LinkedList;

public abstract class AbstractProtocolProcessor
implements OutboundProtocolProcessor {
    private static final ConnectionIdLoggerWrapper log = new ConnectionIdLoggerWrapper(AbstractProtocolProcessor.class);
    protected final ProcessingContext processingContext;
    protected final MappingResolver mappingResolver;
    protected final AuditLogMessageFactory auditLogger;
    private final boolean isMemorySafeMode;
    private final long writeWarningThresholdMillis;
    private Channel channel;
    private ChannelFuture connectFuture;
    private volatile boolean isConnectionOpened = false;
    private LinkedList<ByteBuf> bufferQueue = new LinkedList();

    public AbstractProtocolProcessor(ProcessingContext processingContext) {
        this.processingContext = processingContext;
        this.mappingResolver = processingContext.getMappingResolver();
        String tunnelId = processingContext.getTunnel().getId();
        this.auditLogger = ((AuditProvider)processingContext.getServiceRegistry().getService(AuditProvider.class)).getAuditLogMessageFactory(tunnelId);
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)processingContext.getServiceRegistry().getService(TunnelConfiguration.class);
        this.isMemorySafeMode = tunnelConfiguration.getClientMemorySafeMode();
        this.writeWarningThresholdMillis = tunnelConfiguration.getClientTunnelWriteWarningThresholdMillis();
    }

    @Override
    public void openConnection(int connectionId, TargetHost targetHost) {
        HostMapping hostMapping = this.getHostMapping(connectionId, targetHost.getVirtualHost(), targetHost.getVirtualPort(), targetHost.getProtocol());
        if (hostMapping == null) {
            this.sendNoMappingResponse(connectionId, targetHost.getVirtualHost(), targetHost.getVirtualPort());
            return;
        }
        this.establishConnection(connectionId, hostMapping);
    }

    private HostMapping getHostMapping(int connectionId, String virtualHost, String virtualPort, ConnectionProtocol protocol) {
        HostMapping hostMapping = this.mappingResolver.getHostMapping(virtualHost, virtualPort);
        if (hostMapping == null) {
            if (log.isDebugEnabled()) {
                log.debug(connectionId, MessageFormat.format("Mapping for host {0}:{1} not found", virtualHost, virtualPort));
            }
            return null;
        }
        if (protocol.toMappingProtocol() != hostMapping.getProtocol()) {
            if (log.isDebugEnabled()) {
                log.debug(connectionId, MessageFormat.format("Mapping for host {0}:{1} found but specified protocol {2} is different than the expected {3}", new Object[]{virtualHost, virtualPort, hostMapping.getProtocol(), protocol}));
            }
            return null;
        }
        return hostMapping;
    }

    private void sendNoMappingResponse(int connectionId, String virtualHost, String virtualPort) {
        String errorMessage = "Access denied to system {0}:{1}. In case this was a valid request, ensure to expose the system correctly in your cloud connector.";
        MessagePacket errorPacket = this.processingContext.getMessagePacketFactory().createErrorPacket(connectionId, 200, MessageFormat.format(errorMessage, virtualHost, virtualPort));
        this.logAccessDeniedAuditEvent(connectionId, virtualHost, virtualPort);
        this.writeToTunnelChannel(errorPacket);
    }

    private void logAccessDeniedAuditEvent(int connectionId, String virtualHost, String virtualPort) {
        TunnelSecurityEventAuditMessage mess = (TunnelSecurityEventAuditMessage)this.auditLogger.createAuditLogMessage(TunnelSecurityEventAuditMessage.class);
        try {
            String systemId = virtualHost + ":" + virtualPort;
            mess.addCustomAttribute("SYSTEM", systemId);
            mess.addCustomAttribute("tunnelId", this.processingContext.getTunnel().getId());
            mess.setObjectName(systemId);
            mess.setAction("ACCESS_DENIED");
            mess.log(this.getClass());
        }
        catch (AuditLogWriteException ex) {
            String errorMessage = "Unable to write audit log.";
            log.error(connectionId, errorMessage, ex);
            throw new RuntimeException(errorMessage, ex);
        }
    }

    private void establishConnection(int connectionId, HostMapping hostMapping) {
        String internalHost = hostMapping.getInternalHost();
        int internalPort = Integer.parseInt(hostMapping.getInternalPort());
        ChannelInitializer<?> channelInitializer = this.getChannelInitializer(connectionId, hostMapping);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)this.tunnelChannel(connectionId).eventLoop())).channel(NioSocketChannel.class)).handler(channelInitializer)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        PerformanceStatistics stats = this.processingContext.getPerformanceStatistics(connectionId);
        stats.getOpenRemoteConnTime().startMeasure();
        this.connectFuture = bootstrap.connect((SocketAddress)new InetSocketAddress(internalHost, internalPort));
        this.connectFuture.addListener((GenericFutureListener)new OpenConnectionListener(connectionId, hostMapping));
    }

    @Override
    public void closeConnection(int connectionId) {
        if (this.isConnectionOpeningInProgress()) {
            this.connectFuture.cancel(true);
            this.clearBuffer();
            return;
        }
        if (this.channel != null) {
            this.channel.pipeline().fireUserEventTriggered((Object)new ToggleErrorHandlingEvent(false));
            ChannelUtil.close(this.channel);
            if (log.isDebugEnabled()) {
                log.debug(connectionId, MessageFormat.format("Released backend connection channel {0}", this.channel));
            }
        } else {
            this.clearBuffer();
        }
    }

    private boolean isConnectionOpeningInProgress() {
        return this.connectFuture != null && !this.connectFuture.isDone();
    }

    private void clearBuffer() {
        for (ByteBuf buffer : this.bufferQueue) {
            buffer.release();
        }
        this.bufferQueue.clear();
    }

    @Override
    public void write(int connectionId, ByteBuf payload) {
        if (!this.isConnectionOpened()) {
            if (log.isTraceEnabled()) {
                log.trace(connectionId, "Connection not opened, buffering...");
            }
            this.bufferQueue.add(payload);
        } else {
            this.writeToChannel(connectionId, payload);
        }
    }

    private void writeToChannel(int connectionId, ByteBuf payload) {
        if (this.channel != null) {
            if (this.channel.isActive()) {
                if (log.isTraceEnabled()) {
                    log.trace(connectionId, MessageFormat.format("Will send packet with size {0} to backend channel {1}", payload.writerIndex(), this.channel));
                }
                ChannelFuture writeFuture = this.channel.writeAndFlush((Object)payload);
                writeFuture.addListener((GenericFutureListener)this.createWriteFutureListener(writeFuture.channel(), connectionId, payload));
            } else {
                ReferenceCountUtil.release((Object)payload);
                log.error(connectionId, "Discarding packet as connection to backend has been unexpectedly closed");
            }
        } else {
            ReferenceCountUtil.release((Object)payload);
            if (log.isDebugEnabled()) {
                log.debug(connectionId, "Discarding packet as connection to backend could not be opened");
            }
        }
    }

    private ChannelFutureListener createWriteFutureListener(final Channel backendChannel, final int connectionId, final ByteBuf payload) {
        final Channel tunnelChannel = this.tunnelChannel(connectionId);
        final ChannelConfig tunnelChannelConfig = tunnelChannel.config();
        return new ChannelFutureListener(){
            private long startTimeMillis = System.currentTimeMillis();
            private boolean stopReadingFromTunnel;
            {
                boolean bl = this.stopReadingFromTunnel = AbstractProtocolProcessor.this.isMemorySafeMode && !backendChannel.isWritable() && tunnelChannelConfig.isAutoRead();
                if (this.stopReadingFromTunnel) {
                    tunnelChannelConfig.setAutoRead(false);
                    if (log.isTraceEnabled()) {
                        log.trace(connectionId, MessageFormat.format("Set autoread=FALSE on Tunnel channel: {0}; Backend channel: {1} {2}", tunnelChannel, backendChannel, ChannelUtil.getChannelStateDetails(backendChannel)));
                    }
                }
            }

            public void operationComplete(ChannelFuture future) {
                Channel backendFutureChannel = future.channel();
                if (this.stopReadingFromTunnel) {
                    DemandReadEvent demandReadEvent = DemandReadEvent.INSTANCE;
                    tunnelChannelConfig.setAutoRead(true);
                    if (log.isTraceEnabled()) {
                        log.trace(connectionId, MessageFormat.format("Set autoread=TRUE on Tunnel channel: {0}; Backend channel: {1}; Trigger event {2}", tunnelChannel, backendFutureChannel, demandReadEvent.getClass().getSimpleName()));
                    }
                    tunnelChannel.pipeline().fireUserEventTriggered((Object)demandReadEvent);
                }
                int payloadPacketSize = payload.writerIndex();
                if (future.isSuccess()) {
                    long writeTimeMillis;
                    if (log.isTraceEnabled()) {
                        log.trace(connectionId, MessageFormat.format("Sent packet with size {0} to backend channel {1}", payloadPacketSize, backendFutureChannel));
                    }
                    if ((writeTimeMillis = System.currentTimeMillis() - this.startTimeMillis) > AbstractProtocolProcessor.this.writeWarningThresholdMillis) {
                        log.warn(connectionId, MessageFormat.format("Threshold of {0} passed. Packet with size {1} sent for {2} milliseconds to backend channel {3}", AbstractProtocolProcessor.this.writeWarningThresholdMillis, payloadPacketSize, writeTimeMillis, backendFutureChannel));
                    }
                } else {
                    Object cause = future.cause() != null ? future.cause() : "not available";
                    String failureReason = "FAILED";
                    if (future.isCancelled()) {
                        failureReason = "CANCELED";
                    }
                    log.error(connectionId, MessageFormat.format("Write operation {0} for payload message packet with size {1} for client channel {2}. Cause: {3}", failureReason, payloadPacketSize, backendFutureChannel, cause));
                }
            }
        };
    }

    public Channel channel() {
        return this.channel;
    }

    protected Channel tunnelChannel(int connectionId) {
        try {
            return this.processingContext.getTunnel().getChannel(connectionId);
        }
        catch (NoChannelsAvailableException ex) {
            throw new IllegalStateException("No tunnel channels available for connection with id: " + connectionId, ex);
        }
    }

    protected ChannelFuture writeToTunnelChannel(MessagePacket packet) {
        try {
            return this.processingContext.getTunnel().write(packet);
        }
        catch (NoChannelsAvailableException ex) {
            throw new IllegalStateException("No tunnel channels available for connection with id: " + packet.getConnectionId(), ex);
        }
    }

    protected abstract ChannelInitializer<?> getChannelInitializer(int var1, HostMapping var2);

    protected void onOpenConnectionComplete(int connectionId, HostMapping hostMapping) throws Exception {
    }

    protected boolean isConnectionOpened() {
        return this.isConnectionOpened;
    }

    protected void setConnectionOpened(boolean isConnectionOpened) {
        this.isConnectionOpened = isConnectionOpened;
    }

    protected void connectionOpened() {
        this.setConnectionOpened(true);
    }

    protected void reportOpenConnection(PerformanceStatistics stats) {
    }

    class OpenConnectionListener
    implements ChannelFutureListener {
        private final int connectionId;
        private final HostMapping hostMapping;

        public OpenConnectionListener(int connectionId, HostMapping hostMapping) {
            this.connectionId = connectionId;
            this.hostMapping = hostMapping;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            PerformanceStatistics stats = AbstractProtocolProcessor.this.processingContext.getPerformanceStatistics(this.connectionId);
            stats.getOpenRemoteConnTime().stopMeasure();
            AbstractProtocolProcessor.this.reportOpenConnection(stats);
            if (future.isSuccess()) {
                AbstractProtocolProcessor.this.channel = future.channel();
                AbstractProtocolProcessor.this.channel.pipeline().fireUserEventTriggered((Object)new ToggleErrorHandlingEvent(true));
                if (log.isDebugEnabled()) {
                    log.debug(this.connectionId, MessageFormat.format("Successfully opened backend connection {0}", AbstractProtocolProcessor.this.channel));
                }
                AbstractProtocolProcessor.this.onOpenConnectionComplete(this.connectionId, this.hostMapping);
            } else if (future.isCancelled()) {
                if (log.isDebugEnabled()) {
                    log.debug(this.connectionId, "Open backend connection was cancelled");
                }
            } else {
                log.error(this.connectionId, MessageFormat.format("Unable to open connection to backend system: {0}", future.cause().getMessage() != null ? future.cause().getMessage() : future.cause().toString()), future.cause());
                MessagePacket packet = AbstractProtocolProcessor.this.processingContext.getMessagePacketFactory().createErrorPacket(this.connectionId, 202, "Unable to open connection to backend system");
                AbstractProtocolProcessor.this.writeToTunnelChannel(packet);
            }
            for (ByteBuf buffer : AbstractProtocolProcessor.this.bufferQueue) {
                AbstractProtocolProcessor.this.writeToChannel(this.connectionId, buffer);
            }
            AbstractProtocolProcessor.this.bufferQueue.clear();
            AbstractProtocolProcessor.this.connectionOpened();
        }
    }
}

