/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.processing;

import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.logging.ConnectionIdLoggerWrapper;
import com.sap.core.connectivity.spi.processing.ToggleErrorHandlingEvent;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.util.AssertionUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.WriteTimeoutException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class OutboundConnectionErrorHandler
extends ChannelInboundHandlerAdapter {
    private static final ConnectionIdLoggerWrapper log = new ConnectionIdLoggerWrapper(Logger.getLogger(OutboundConnectionErrorHandler.class));
    private final ProcessingContext processingContext;
    private final int connectionId;
    private boolean isErrorHandlingEnabled;

    public OutboundConnectionErrorHandler(ProcessingContext processingContext, int connectionId) {
        this.processingContext = processingContext;
        this.connectionId = connectionId;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof ToggleErrorHandlingEvent) {
            this.handleToggleErrorHandling((ToggleErrorHandlingEvent)event);
        }
    }

    private void handleToggleErrorHandling(ToggleErrorHandlingEvent e) {
        this.isErrorHandlingEnabled = e.isEnabled();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        block5: {
            if (this.isErrorHandlingEnabled) {
                try {
                    if (cause instanceof WriteTimeoutException) {
                        if (log.isDebugEnabled()) {
                            WriteTimeoutException wte = (WriteTimeoutException)cause;
                            log.debug(this.connectionId, MessageFormat.format("Received write timeout exception on channel which shall be closed by the WriteTimeoutHandler {0}", ctx.channel()), (Throwable)wte);
                        }
                        return;
                    }
                    log.error(this.connectionId, "Internal error", cause);
                    MessagePacket packet = this.processingContext.getMessagePacketFactory().createErrorPacket(cause, this.connectionId);
                    this.processingContext.getTunnel().write(packet);
                }
                catch (Exception e) {
                    log.error(this.connectionId, "Exception caught while handling an exception for channel " + ctx.channel(), e);
                    if ($assertionsDisabled || AssertionUtil.propagateException(e)) break block5;
                    throw new AssertionError();
                }
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        block3: {
            if (this.isErrorHandlingEnabled) {
                try {
                    String message = "Backend channel is closed";
                    int errorCode = 300;
                    MessagePacket packet = this.processingContext.getMessagePacketFactory().createErrorPacket(this.connectionId, errorCode, message);
                    this.processingContext.getTunnel().write(packet);
                }
                catch (Exception e) {
                    log.error(this.connectionId, "Exception caught while closing an outbound channel " + ctx.channel(), e);
                    if ($assertionsDisabled || AssertionUtil.propagateException(e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }
}

