/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.processing;

import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.Tunnel;
import com.sap.core.connectivity.spi.processing.flow.DemandReadEvent;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class OutboundConnectionReader
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final String FLOW_CONTROL_HANDLER_NAME = "flowControlHandler";
    private static Logger log = Logger.getLogger(OutboundConnectionReader.class);
    private final ProcessingContext processingContext;
    private final int connectionId;
    private final boolean isMemorySafeMode;
    private final long tunnelWriteWarningThresholdMillis;
    private boolean isChannelReadComplete;

    public OutboundConnectionReader(ProcessingContext processingContext, int connectionId) {
        this.processingContext = processingContext;
        this.connectionId = connectionId;
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)processingContext.getServiceRegistry().getService(TunnelConfiguration.class);
        this.isMemorySafeMode = tunnelConfiguration.getClientMemorySafeMode();
        this.tunnelWriteWarningThresholdMillis = tunnelConfiguration.getClientTunnelWriteWarningThresholdMillis();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.isMemorySafeMode) {
            ctx.pipeline().addBefore(ctx.name(), FLOW_CONTROL_HANDLER_NAME, (ChannelHandler)new FlowControlHandler());
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.isMemorySafeMode) {
            ctx.pipeline().remove(FLOW_CONTROL_HANDLER_NAME);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        this.isChannelReadComplete = false;
        final PayloadMessagePacket payloadPacket = this.processingContext.getMessagePacketFactory().createPayloadPacket(this.connectionId, buffer);
        final Tunnel tunnel = this.processingContext.getTunnel();
        final Channel backendChannel = ctx.channel();
        final ChannelFuture tunnelWriteFuture = tunnel.write(payloadPacket);
        final Channel tunnelChannel = tunnelWriteFuture.channel();
        tunnelWriteFuture.addListener((GenericFutureListener)new ChannelFutureListener(){
            private long startTimeMillis = System.currentTimeMillis();
            private boolean stopReadingFromBackend;
            {
                boolean bl = this.stopReadingFromBackend = OutboundConnectionReader.this.isMemorySafeMode && !tunnelWriteFuture.channel().isWritable() && backendChannel.config().isAutoRead();
                if (this.stopReadingFromBackend) {
                    backendChannel.config().setAutoRead(false);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)MessageFormat.format("Set autoread=FALSE on Backend channel: {0}; Tunnel channel: {1} {2}", backendChannel, tunnelChannel, ChannelUtil.getChannelStateDetails(tunnelChannel)));
                    }
                }
            }

            public void operationComplete(ChannelFuture future) {
                if (this.stopReadingFromBackend) {
                    DemandReadEvent demandReadEvent = DemandReadEvent.INSTANCE;
                    backendChannel.config().setAutoRead(true);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)MessageFormat.format("Set autoread=TRUE on Backend channel: {0}; Tunnel channel: {1}; Trigger event {2}", backendChannel, tunnelChannel, demandReadEvent.getClass().getSimpleName()));
                    }
                    backendChannel.pipeline().fireUserEventTriggered((Object)demandReadEvent);
                }
                int payloadPacketSize = payloadPacket.getPayload().writerIndex();
                if (future.isSuccess()) {
                    long tunnelWriteTimeMillis;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)MessageFormat.format("Sent message of type {0} with payload size {1} to tunnel channel {2}", payloadPacket.getType(), payloadPacketSize, tunnelChannel));
                    }
                    if ((tunnelWriteTimeMillis = System.currentTimeMillis() - this.startTimeMillis) > OutboundConnectionReader.this.tunnelWriteWarningThresholdMillis) {
                        log.warn((Object)MessageFormat.format("Threshold of {0} passed. Message of type {1} with payload size {2} sent for {3} milliseconds over tunnel channel {4}. Tunnel id \"{5}\"", OutboundConnectionReader.this.tunnelWriteWarningThresholdMillis, payloadPacket.getType(), payloadPacket.getPayload().writerIndex(), tunnelWriteTimeMillis, tunnelChannel, tunnel.getId()));
                    }
                } else {
                    Object cause = future.cause() != null ? future.cause() : "not available";
                    String failureReason = "FAILED";
                    if (future.isCancelled()) {
                        failureReason = "CANCELED";
                    }
                    log.error((Object)MessageFormat.format("Write operation {0} for message of type {1} with payload size {2} for tunnel channel {3}. Cause: {4}. Tunnel id \"{5}\"", failureReason, payloadPacket.getType(), payloadPacketSize, tunnelChannel, cause, tunnel.getId()));
                }
            }
        });
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof DemandReadEvent) {
            if (this.isChannelReadComplete && ctx.channel().config().isAutoRead()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"userEventTriggered -> triggering ctx.read()");
                }
                ctx.read();
            }
            return;
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.isChannelReadComplete = true;
        super.channelReadComplete(ctx);
    }
}

