/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.processing;

import com.sap.core.connectivity.spi.ConnectionProtocol;

public class TargetHost {
    private final String virtualHost;
    private final String virtualPort;
    private final ConnectionProtocol protocol;

    public TargetHost(String virtualHost, String virtualPort, ConnectionProtocol protocol) {
        this.virtualHost = virtualHost;
        this.virtualPort = virtualPort;
        this.protocol = protocol;
        if (virtualHost == null || virtualPort == null || protocol == null) {
            throw new IllegalArgumentException();
        }
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getVirtualPort() {
        return this.virtualPort;
    }

    public ConnectionProtocol getProtocol() {
        return this.protocol;
    }

    public int hashCode() {
        int hash = this.virtualHost.hashCode();
        hash = hash * 17 + this.virtualPort.hashCode();
        hash = hash * 17 + this.protocol.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TargetHost)) {
            return false;
        }
        TargetHost other = (TargetHost)obj;
        if (!this.virtualHost.equals(other.virtualHost)) {
            return false;
        }
        if (!this.virtualPort.equals(other.virtualPort)) {
            return false;
        }
        return this.protocol.equals((Object)other.protocol);
    }

    public String toString() {
        return "[virtualHost=" + this.virtualHost + ", virtualPort=" + this.virtualPort + ", protocol=" + (Object)((Object)this.protocol) + "]";
    }
}

