/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.statistics;

import com.sap.core.connectivity.spi.statistics.RequestStatistic;
import com.sap.core.connectivity.spi.statistics.TimeStatistic;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import java.util.HashMap;
import java.util.Map;

public class PerformanceStatistics {
    private static final Map<Integer, PerformanceStatistics> CONNECTION_STATISTICS = new HashMap<Integer, PerformanceStatistics>();
    private static final PerformanceStatistics SINGLETON_DUMMY_STATS = new PerformanceStatistics();
    private int connectionId;
    private TimeStatistic totalTime = new TimeStatistic("total");
    private TimeStatistic externalTime = new TimeStatistic("ext");
    private TimeStatistic latencyEffectsTime = new TimeStatistic("latency");
    private TimeStatistic generateSSOTokenTime = new TimeStatistic("generateSSOToken");
    private TimeStatistic validateSSOTokenTime = new TimeStatistic("validateSSOToken");
    private TimeStatistic openRemoteConnTime = new TimeStatistic("openRemoteConn");
    private RequestStatistic requestStatistic = new RequestStatistic();
    private boolean sapStatisticsEnabled;
    private static boolean performanceStatisticsEnabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerformanceStatistics getStatistics(int connectionId) {
        PerformanceStatistics stats = CONNECTION_STATISTICS.get(connectionId);
        if (stats == null && PerformanceStatistics.isPerformanceStatisticsEnabled().booleanValue()) {
            Map<Integer, PerformanceStatistics> map = CONNECTION_STATISTICS;
            synchronized (map) {
                stats = new PerformanceStatistics();
                stats.connectionId = connectionId;
                CONNECTION_STATISTICS.put(connectionId, stats);
            }
        }
        return stats != null ? stats : SINGLETON_DUMMY_STATS;
    }

    public static Boolean isPerformanceStatisticsEnabled() {
        return performanceStatisticsEnabled;
    }

    public static void setPerformanceStatisticsEnabled(boolean performanceStatisticsEnabled) {
        PerformanceStatistics.performanceStatisticsEnabled = performanceStatisticsEnabled;
    }

    public TimeStatistic getTotalTime() {
        return this.totalTime;
    }

    public TimeStatistic getExternalTime() {
        return this.externalTime;
    }

    public TimeStatistic getGenerateSSOTokenTime() {
        return this.generateSSOTokenTime;
    }

    public TimeStatistic getValidateSSOTokenTime() {
        return this.validateSSOTokenTime;
    }

    public TimeStatistic getOpenRemoteConnTime() {
        return this.openRemoteConnTime;
    }

    public TimeStatistic getLatencyEffectsTime() {
        return this.latencyEffectsTime;
    }

    public RequestStatistic getRequestStatistic() {
        return this.requestStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<Integer, PerformanceStatistics> map = CONNECTION_STATISTICS;
        synchronized (map) {
            CONNECTION_STATISTICS.remove(this.connectionId);
        }
    }

    public static int size() {
        return CONNECTION_STATISTICS.size();
    }

    public static void clear() {
        CONNECTION_STATISTICS.clear();
    }

    public boolean isSapStatisticsEnabled() {
        return this.sapStatisticsEnabled;
    }

    public void setSapStatisticsEnabled(boolean enabled) {
        this.sapStatisticsEnabled = enabled;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String toShortConnectionDescription() {
        return "connection " + ChannelUtil.formatConnectionId(this.getConnectionId()) + " to " + this.requestStatistic.getProtocol().name().toLowerCase() + "://" + this.requestStatistic.getVirtualHost() + ":" + this.requestStatistic.getVirtualPort() + (this.requestStatistic.getResource() == null ? "" : " request " + this.requestStatistic.getResource());
    }

    public String getFormattedTimeStatistics() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.totalTime);
        builder.append(",");
        builder.append(this.externalTime);
        builder.append(",");
        builder.append(this.latencyEffectsTime);
        if (this.openRemoteConnTime.isMeasured()) {
            builder.append(",");
            builder.append(this.openRemoteConnTime);
        }
        if (this.generateSSOTokenTime.isMeasured()) {
            builder.append(",");
            builder.append(this.generateSSOTokenTime);
        }
        if (this.validateSSOTokenTime.isMeasured()) {
            builder.append(",");
            builder.append(this.validateSSOTokenTime);
        }
        return builder.toString();
    }
}

