/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.statistics;

import java.util.concurrent.TimeUnit;

public class TimeStatistic {
    public static final String TIME_STAT_TOTAL = "total";
    public static final String TIME_STAT_EXTERNAL = "ext";
    public static final String TIME_STAT_LATENCY = "latency";
    public static final String TIME_STAT_GENERATE_SSO_TOKEN = "generateSSOToken";
    public static final String TIME_STAT_OPEN_REMOTE_CONN = "openRemoteConn";
    public static final String TIME_STAT_VALIDATE_SSO_TOKEN = "validateSSOToken";
    private boolean isMeasureStarted;
    private boolean isPaused;
    private long startTimeNano;
    private long elapsedTimeMs = 0L;
    private long finishedTimestamp = 0L;
    private String name;

    public TimeStatistic(String name) {
        this.name = name;
    }

    public void startMeasure() {
        this.isMeasureStarted = true;
        this.isPaused = false;
        this.finishedTimestamp = 0L;
        this.elapsedTimeMs = 0L;
        this.startTimeNano = System.nanoTime();
    }

    public void resumeMeasure() {
        if (this.isPaused && this.isMeasureStarted) {
            this.isPaused = false;
            this.startTimeNano = System.nanoTime();
        }
    }

    public void pauseMeasure() {
        if (!this.isPaused && this.isMeasureStarted) {
            this.isPaused = true;
            this.elapsedTimeMs += TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeNano);
        }
    }

    public void stopMeasure() {
        if (this.isMeasureStarted && !this.isPaused) {
            this.elapsedTimeMs += TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeNano);
        }
        this.isMeasureStarted = false;
        this.finishedTimestamp = System.currentTimeMillis();
    }

    public long getElapsedTime() {
        if (this.isMeasureStarted && !this.isPaused) {
            return this.elapsedTimeMs + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeNano);
        }
        return this.elapsedTimeMs;
    }

    public long getFinishedTimestamp() {
        return this.finishedTimestamp;
    }

    public boolean isMeasured() {
        return this.finishedTimestamp > 0L;
    }

    public boolean isMeasureStarted() {
        return this.isMeasureStarted;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "=" + this.getElapsedTime();
    }
}

