/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.util;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class ChannelUtil {
    private static final Logger log = Logger.getLogger(ChannelUtil.class);

    private ChannelUtil() {
    }

    public static void close(Channel channel) {
        if (channel.isActive()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Closing channel " + channel));
            }
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public static void closeImmediately(Channel channel) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Closing channel immediately " + channel));
        }
        channel.close();
    }

    public static String formatConnectionId(int connectionId) {
        return String.format("0x%08x", connectionId);
    }

    public static String getChannelStateDetails(Channel channel) {
        return MessageFormat.format("[id: {0} isOpen: {1}; isActive: {2}; isRegistered: {3}; isWritable: {4}; bytesBeforeWritable: {5}; bytesBeforeUnwritable: {6}; autoRead: {7}]", channel.id(), channel.isOpen(), channel.isActive(), channel.isRegistered(), channel.isWritable(), channel.bytesBeforeWritable(), channel.bytesBeforeUnwritable(), channel.config().isAutoRead());
    }
}

