/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.util;

import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;

public class SSLUtil {
    private static final String SSLV2HELLO_PROTOCOL = "SSLv2Hello";

    public static SSLEngine disableSSLProtocols(SSLEngine engine) {
        String[] enabledProtocols = SSLUtil.excludeSSLProtocols(engine.getSupportedProtocols());
        engine.setEnabledProtocols(enabledProtocols);
        return engine;
    }

    public static SSLEngine disableSSLProtocolsWithoutSSLv2Hello(SSLEngine engine) {
        String[] enabledProtocols = SSLUtil.excludeSSLProtocols(engine.getSupportedProtocols(), false);
        engine.setEnabledProtocols(enabledProtocols);
        return engine;
    }

    public static SSLSocket disableSSLProtocols(SSLSocket socket) {
        String[] enabledProtocols = SSLUtil.excludeSSLProtocols(socket.getSupportedProtocols());
        socket.setEnabledProtocols(enabledProtocols);
        return socket;
    }

    private static String[] excludeSSLProtocols(String[] supportedProtocols) {
        return SSLUtil.excludeSSLProtocols(supportedProtocols, true);
    }

    private static String[] excludeSSLProtocols(String[] supportedProtocols, boolean excludeSSLv2Hello) {
        String[] enabledProtocols = null;
        if (supportedProtocols != null) {
            ArrayList<String> enabledProtocolsList = new ArrayList<String>(supportedProtocols.length);
            for (String protocol : supportedProtocols) {
                if (protocol.startsWith("SSL") && (excludeSSLv2Hello || !protocol.equals(SSLV2HELLO_PROTOCOL))) continue;
                enabledProtocolsList.add(protocol);
            }
            enabledProtocols = enabledProtocolsList.toArray(new String[enabledProtocolsList.size()]);
        }
        return enabledProtocols;
    }
}

