/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.spi.util;

import java.net.URI;
import java.net.URISyntaxException;

public class URIUtil {
    public static URI createURI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        StringBuffer sb = new StringBuffer();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        if (host != null) {
            boolean needBrackets;
            sb.append("//");
            if (userInfo != null) {
                sb.append(userInfo);
                sb.append('@');
            }
            boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(host);
            if (needBrackets) {
                sb.append(']');
            }
            if (port != -1) {
                sb.append(':');
                sb.append(port);
            }
        }
        if (path != null) {
            sb.append(path);
        }
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        if (fragment != null) {
            sb.append('#');
            sb.append(fragment);
        }
        return new URI(sb.toString());
    }

    public static URI createRelativeURI(String scheme, String userInfo, String host, int port, String path, String query, String fragment, String hostHeaderValue) throws URISyntaxException {
        if (host != null && hostHeaderValue != null && userInfo == null) {
            StringBuffer sb = new StringBuffer();
            if (path != null) {
                sb.append(path);
            }
            if (query != null) {
                sb.append('?');
                sb.append(query);
            }
            if (fragment != null) {
                sb.append('#');
                sb.append(fragment);
            }
            return new URI(sb.toString());
        }
        return URIUtil.createURI(scheme, userInfo, host, port, path, query, fragment);
    }
}

