/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.monitoring.web.client;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sap.core.monitoring.web.client.MonitoringResponse;
import com.sap.core.monitoring.web.common.CustomChecksInfo;
import com.sap.core.monitoring.web.common.CustomGroupInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;

public class MonitoringBasicAuthClient {
    private static final Logger LOG = Logger.getLogger(MonitoringBasicAuthClient.class);
    private static final String UTF_8 = "UTF-8";
    private static final String CSRF_TOKEN_HEADER_NAME = "X-CSRF-TOKEN";
    private static final String CSRF_TOKEN_HEADER_FETCH_VALUE = "Fetch";
    private static final String CSRF_TOKEN_RQUIRED = "X-CSRF-TOKEN: Required";
    private static final int STATUS_OK = 200;
    private static final int STATUS_CREATED = 201;
    private static final int STATUS_FORBIDDEN = 403;
    private HttpClient client;
    private final URL monitoringSei;
    private String customServicePath = "monitoring/service";
    private String customContactPath = "alerting/contact";
    private final Map<String, String> csrfTokens = new HashMap<String, String>();

    public MonitoringBasicAuthClient(HttpClient client, URL monitoringSei) {
        this.client = client;
        this.monitoringSei = monitoringSei;
    }

    public void setCustomServicePath(String path) {
        this.customServicePath = path;
    }

    public void setCustomContactPath(String path) {
        this.customContactPath = path;
    }

    public MonitoringResponse<?> addCustomServiceConfiguration(CustomChecksInfo checkInfo) {
        String space = checkInfo.getSpace();
        String appliance = checkInfo.getAppliance();
        String component = checkInfo.getComponent();
        Path path = new Path(this.customServicePath, space, appliance, component);
        return this.httpStatusResponse(path, RequestMethod.PUT, checkInfo);
    }

    public MonitoringResponse<?> updateCustomServiceConfiguration(CustomChecksInfo checkInfo) {
        String space = checkInfo.getSpace();
        String appliance = checkInfo.getAppliance();
        String component = checkInfo.getComponent();
        Path path = new Path(this.customServicePath, space, appliance, component);
        return this.httpStatusResponse(path, RequestMethod.POST, checkInfo);
    }

    public MonitoringResponse<CustomChecksInfo[]> listCustomServiceConfigurationRecursively(CustomChecksInfo checkInfo) {
        String space = checkInfo.getSpace();
        String appliance = checkInfo.getAppliance();
        String component = checkInfo.getComponent();
        String serviceTemplate = checkInfo.getServiceTemplate();
        String serviceName = checkInfo.getServiceName();
        Path path = new Path(this.customServicePath, space, appliance, component, serviceTemplate, serviceName);
        return this.httpEntityResponse(path, RequestMethod.GET, CustomChecksInfo[].class);
    }

    public MonitoringResponse<CustomChecksInfo[]> listCustomServiceConfiguration(CustomChecksInfo checkInfo) {
        MonitoringResponse<CustomChecksInfo[]> response = this.listCustomServiceConfigurationRecursively(checkInfo);
        if (response.getStatus() == 200) {
            CustomChecksInfo[] customChecks = response.getEntity();
            CustomChecksInfo[] filteredChecks = MonitoringBasicAuthClient.filterCustomChecks(customChecks, checkInfo);
            response.setEntity(filteredChecks);
        }
        return response;
    }

    public MonitoringResponse<?> deleteCustomServiceConfiguration(CustomChecksInfo checkInfo) {
        String space = checkInfo.getSpace();
        String appliance = checkInfo.getAppliance();
        String component = checkInfo.getComponent();
        String template = checkInfo.getServiceTemplate();
        String serviceName = checkInfo.getServiceName();
        Path path = new Path(this.customServicePath, space, appliance, component, template, serviceName);
        return this.httpStatusResponse(path, RequestMethod.DELETE, new Object[0]);
    }

    public MonitoringResponse<?> addContactConfiguration(CustomGroupInfo groupInfo) {
        String space = groupInfo.getSpace();
        String appliance = groupInfo.getAppliance();
        String component = groupInfo.getComponent();
        Path path = new Path(this.customContactPath, space, appliance, component);
        return this.httpStatusResponse(path, RequestMethod.PUT, groupInfo);
    }

    public MonitoringResponse<?> updateContactConfiguration(CustomGroupInfo groupInfo) {
        String space = groupInfo.getSpace();
        String appliance = groupInfo.getAppliance();
        String component = groupInfo.getComponent();
        Path path = new Path(this.customContactPath, space, appliance, component);
        return this.httpStatusResponse(path, RequestMethod.POST, groupInfo);
    }

    public MonitoringResponse<CustomGroupInfo[]> listContactConfigurationRecursively(CustomGroupInfo groupInfo) {
        String space = groupInfo.getSpace();
        String appliance = groupInfo.getAppliance();
        String component = groupInfo.getComponent();
        Path path = new Path(this.customContactPath, space, appliance, component);
        return this.httpEntityResponse(path, RequestMethod.GET, CustomGroupInfo[].class);
    }

    public MonitoringResponse<CustomGroupInfo[]> listContactConfiguration(CustomGroupInfo groupInfo) {
        MonitoringResponse<CustomGroupInfo[]> response = this.listContactConfigurationRecursively(groupInfo);
        if (response.getStatus() == 200) {
            CustomGroupInfo[] contacts = response.getEntity();
            CustomGroupInfo[] filteredContacts = MonitoringBasicAuthClient.filterContactConfigurations(contacts, groupInfo);
            response.setEntity(filteredContacts);
        }
        return response;
    }

    public MonitoringResponse<?> deleteContactConfiguration(CustomGroupInfo groupInfo) {
        String space = groupInfo.getSpace();
        String appliance = groupInfo.getAppliance();
        String component = groupInfo.getComponent();
        String contact = groupInfo.getContactGroup();
        Path path = new Path(this.customContactPath, space, appliance, component, contact);
        return this.httpStatusResponse(path, RequestMethod.DELETE, new Object[0]);
    }

    public HttpUriRequest createRequest(Path path, RequestMethod method, Object ... o) throws IOException {
        StringEntity entity = null;
        if (o != null && o.length == 1) {
            Gson gson = new Gson();
            String json = gson.toJson(o[0]);
            entity = new StringEntity(json, UTF_8);
            entity.setContentType("application/json");
        }
        URL requestUrl = new URL(this.monitoringSei, path.getPath());
        HttpGet request = null;
        switch (method) {
            case PUT: {
                HttpPut httpPut = new HttpPut(requestUrl.toString());
                if (entity != null) {
                    httpPut.setEntity((HttpEntity)entity);
                }
                request = httpPut;
                break;
            }
            case POST: {
                HttpPost httpPost = new HttpPost(requestUrl.toString());
                if (entity != null) {
                    httpPost.setEntity((HttpEntity)entity);
                }
                request = httpPost;
                break;
            }
            case GET: {
                HttpGet httpGet;
                request = httpGet = new HttpGet(requestUrl.toString());
                break;
            }
            case DELETE: {
                HttpDelete httpDelete = new HttpDelete(requestUrl.toString());
                request = httpDelete;
                break;
            }
        }
        if (request != null) {
            String csrfToken = this.getCsrfToken(path.getServiceEndpoint(), this.client);
            request.addHeader(CSRF_TOKEN_HEADER_NAME, csrfToken);
        }
        return request;
    }

    public MonitoringResponse<?> httpStatusResponse(Path path, RequestMethod method, Object ... o) {
        try {
            HttpResponse response = this.executeRequest(path, method, o);
            return this.getStatusResponse(response);
        }
        catch (IOException e) {
            return this.getErrorResponse(e);
        }
    }

    public <T> MonitoringResponse<T> httpEntityResponse(Path path, RequestMethod method, Class<T> objectClass) {
        try {
            HttpResponse response = this.executeRequest(path, method, new Object[0]);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200 && statusCode != 201) {
                MonitoringResponse<T> statusResponse = this.getErrorResponse(response);
                return statusResponse;
            }
            InputStreamReader responseReader = new InputStreamReader(response.getEntity().getContent(), UTF_8);
            Gson gson = new Gson();
            Object jsonObject = gson.fromJson((Reader)responseReader, objectClass);
            return this.getEntityResponse(response, jsonObject);
        }
        catch (JsonSyntaxException e) {
            return this.getErrorResponse(e);
        }
        catch (IOException e) {
            return this.getErrorResponse(e);
        }
    }

    private HttpResponse executeRequest(Path path, RequestMethod method, Object ... o) throws IOException {
        HttpUriRequest request = this.createRequest(path, method, o);
        HttpResponse response = this.client.execute(request);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() == 403 && CSRF_TOKEN_RQUIRED.equals(statusLine.getReasonPhrase())) {
            this.csrfTokens.remove(path.getServiceEndpoint());
            request = this.createRequest(path, method, o);
            response = this.client.execute(request);
        }
        return response;
    }

    public MonitoringResponse<?> getStatusResponse(HttpResponse response) {
        try {
            MonitoringResponse statusResponse = new MonitoringResponse();
            statusResponse.setStatus(response.getStatusLine().getStatusCode());
            this.setErrorMessage(response, statusResponse);
            MonitoringResponse monitoringResponse = statusResponse;
            return monitoringResponse;
        }
        finally {
            this.readAndCloseResponse(response);
        }
    }

    public <T> MonitoringResponse<T> getErrorResponse(HttpResponse response) {
        try {
            MonitoringResponse statusResponse = new MonitoringResponse();
            statusResponse.setStatus(response.getStatusLine().getStatusCode());
            this.setErrorMessage(response, statusResponse);
            MonitoringResponse monitoringResponse = statusResponse;
            return monitoringResponse;
        }
        finally {
            this.readAndCloseResponse(response);
        }
    }

    private void setErrorMessage(HttpResponse response, MonitoringResponse<?> statusResponse) {
        Header errorHeader = response.getFirstHeader("errorMessage");
        if (errorHeader != null) {
            statusResponse.setErrorMessage(errorHeader.getValue());
        }
    }

    public <T> MonitoringResponse<T> getErrorResponse(Throwable t) {
        MonitoringResponse errorResponse = new MonitoringResponse();
        errorResponse.setStatus(-1);
        errorResponse.setErrorMessage(t.getMessage());
        return errorResponse;
    }

    public <T> MonitoringResponse<T> getEntityResponse(HttpResponse response, T o) {
        try {
            MonitoringResponse<T> statusResponse = new MonitoringResponse<T>();
            statusResponse.setStatus(response.getStatusLine().getStatusCode());
            statusResponse.setEntity(o);
            this.setErrorMessage(response, statusResponse);
            MonitoringResponse<T> monitoringResponse = statusResponse;
            return monitoringResponse;
        }
        finally {
            this.readAndCloseResponse(response);
        }
    }

    private void readAndCloseResponse(HttpResponse response) {
        if (response == null) {
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream instream = null;
            try {
                try {
                    instream = entity.getContent();
                    byte[] buff = new byte[4096];
                    while (instream.read(buff) != -1) {
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (instream != null) {
                            instream.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Failed to close stream", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    if (instream != null) {
                        instream.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)"Failed to close stream", (Throwable)e);
                }
            }
        }
    }

    public void close() {
        if (this.client != null) {
            this.client.getConnectionManager().shutdown();
            this.client = null;
        }
    }

    private String getCsrfToken(String path, HttpClient httpClient) throws IOException {
        String csrfToken = this.csrfTokens.get(path);
        if (csrfToken != null) {
            return csrfToken;
        }
        String uri = new URL(this.monitoringSei, path).toString();
        HttpHead httpHead = new HttpHead(uri);
        httpHead.addHeader(CSRF_TOKEN_HEADER_NAME, CSRF_TOKEN_HEADER_FETCH_VALUE);
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpHead);
            if (response.containsHeader(CSRF_TOKEN_HEADER_NAME)) {
                csrfToken = response.getFirstHeader(CSRF_TOKEN_HEADER_NAME).getValue();
                this.csrfTokens.put(path, csrfToken);
            } else {
                LOG.warn((Object)"Could not obtain X-CSRF-TOKEN");
            }
        }
        finally {
            if (response != null) {
                this.readAndCloseResponse(response);
            }
        }
        return csrfToken;
    }

    public static CustomChecksInfo[] filterCustomChecks(CustomChecksInfo[] customChecks, CustomChecksInfo filter) {
        ArrayList<CustomChecksInfo> filtered = new ArrayList<CustomChecksInfo>();
        if (customChecks != null && customChecks.length > 0) {
            CustomChecksInfo[] customChecksInfoArray = customChecks;
            int n = customChecks.length;
            int n2 = 0;
            while (n2 < n) {
                CustomChecksInfo check = customChecksInfoArray[n2];
                if (MonitoringBasicAuthClient.equalOrBothNull(check.getSpace(), filter.getSpace()) && MonitoringBasicAuthClient.equalOrBothNull(check.getAppliance(), filter.getAppliance()) && MonitoringBasicAuthClient.equalOrBothNull(check.getComponent(), filter.getComponent())) {
                    filtered.add(check);
                }
                ++n2;
            }
        }
        return filtered.toArray(new CustomChecksInfo[0]);
    }

    public static boolean equalOrBothNull(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null) {
            return false;
        }
        if (str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static CustomGroupInfo[] filterContactConfigurations(CustomGroupInfo[] contacts, CustomGroupInfo filter) {
        ArrayList<CustomGroupInfo> filtered = new ArrayList<CustomGroupInfo>();
        if (contacts != null && contacts.length > 0) {
            CustomGroupInfo[] customGroupInfoArray = contacts;
            int n = contacts.length;
            int n2 = 0;
            while (n2 < n) {
                CustomGroupInfo contact = customGroupInfoArray[n2];
                if (MonitoringBasicAuthClient.equalOrBothNull(contact.getSpace(), filter.getSpace()) && MonitoringBasicAuthClient.equalOrBothNull(contact.getAppliance(), filter.getAppliance()) && MonitoringBasicAuthClient.equalOrBothNull(contact.getComponent(), filter.getComponent())) {
                    filtered.add(contact);
                }
                ++n2;
            }
        }
        return filtered.toArray(new CustomGroupInfo[0]);
    }

    static class Path {
        private static final String UTF_8 = "UTF-8";
        private static final char PATH_SEPARATOR = '/';
        private static final String MISSING_VALUE = "_null";
        private final String serviceEndpoint;
        private final String[] elements;

        public Path(String serviceEndpoint, String ... elements) {
            this.serviceEndpoint = serviceEndpoint;
            this.elements = elements;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public String getPath() {
            StringBuilder pathBuilder = new StringBuilder(this.serviceEndpoint);
            pathBuilder.append('/');
            if (this.elements != null) {
                String[] stringArray = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    element = element == null ? MISSING_VALUE : this.encode(element);
                    pathBuilder.append(element);
                    pathBuilder.append('/');
                    ++n2;
                }
            }
            return pathBuilder.toString();
        }

        private String encode(String string) {
            try {
                string = URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Could not encode string " + string + " using encoding " + "UTF-8"), (Throwable)e);
            }
            return string;
        }
    }

    private static enum RequestMethod {
        POST,
        PUT,
        GET,
        DELETE;

    }
}

