/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.client.ClusterResponse;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EjbObjectInputStream;
import org.apache.openejb.client.FlushableGZIPOutputStream;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.RequestType;
import org.apache.openejb.client.Response;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.serializer.EJBDSerializer;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.context.RequestInfos;
import org.apache.openejb.server.ejbd.AuthRequestHandler;
import org.apache.openejb.server.ejbd.ClientObjectFactory;
import org.apache.openejb.server.ejbd.ClusterRequestHandler;
import org.apache.openejb.server.ejbd.EjbRequestHandler;
import org.apache.openejb.server.ejbd.JndiRequestHandler;
import org.apache.openejb.server.ejbd.LogoutRequestHandler;
import org.apache.openejb.server.ejbd.RequestHandler;
import org.apache.openejb.server.stream.CountingInputStream;
import org.apache.openejb.server.stream.CountingOutputStream;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Exceptions;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class EjbDaemon
implements ApplicationServer {
    static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE, (String)"org.apache.openejb.server.util.resources");
    private ClientObjectFactory clientObjectFactory;
    private RequestHandler ejbHandler;
    private JndiRequestHandler jndiHandler;
    private RequestHandler authHandler;
    private RequestHandler logoutHandler;
    private ClusterRequestHandler clusterHandler;
    private ContainerSystem containerSystem;
    private boolean gzip;
    private EJBDSerializer serializer = null;
    private int timeout = 14400000;
    private boolean countStreams;
    private SecurityService securityService;

    public void init(Properties props) throws Exception {
        DiscoveryAgent discovery;
        this.containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.clientObjectFactory = new ClientObjectFactory(this, props);
        this.ejbHandler = new EjbRequestHandler(this);
        this.jndiHandler = new JndiRequestHandler(this);
        this.authHandler = new AuthRequestHandler(this);
        this.logoutHandler = new LogoutRequestHandler(this);
        this.clusterHandler = new ClusterRequestHandler(this);
        this.gzip = "true".equalsIgnoreCase(props.getProperty("gzip", "false"));
        try {
            this.timeout = Integer.parseInt(props.getProperty("timeout", "14400000"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String serializer = props.getProperty("serializer", null);
        if (serializer != null) {
            try {
                this.serializer = (EJBDSerializer)EJBDSerializer.class.cast(Thread.currentThread().getContextClassLoader().loadClass(serializer).newInstance());
            }
            catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
                this.serializer = new ContextualSerializer(serializer);
            }
        }
        if ((discovery = (DiscoveryAgent)SystemInstance.get().getComponent(DiscoveryAgent.class)) != null) {
            discovery.setDiscoveryListener((DiscoveryListener)this.clusterHandler);
        }
        this.countStreams = Boolean.parseBoolean(props.getProperty("stream.count", Boolean.toString(this.jndiHandler.isDebug())));
        this.securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Socket socket) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            if (socket.isClosed()) {
                return;
            }
            socket.setSoTimeout(this.timeout);
            if (this.gzip) {
                in = new GZIPInputStream(new BufferedInputStream(socket.getInputStream()));
                out = new BufferedOutputStream((OutputStream)new FlushableGZIPOutputStream(socket.getOutputStream()));
            } else {
                in = new BufferedInputStream(socket.getInputStream());
                out = new BufferedOutputStream(socket.getOutputStream());
            }
            RequestInfos.initRequestInfo((Socket)socket);
            this.service(in, out);
        }
        finally {
            if (null != out) {
                try {
                    out.flush();
                }
                catch (Throwable throwable) {}
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
            if (null != in) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {}
            }
            RequestInfos.clearRequestInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(InputStream rawIn, OutputStream rawOut) throws IOException {
        String msg;
        ProtocolMetaData clientProtocol = new ProtocolMetaData();
        ObjectInputStream ois = null;
        ObjectOutputStream oos = null;
        RequestType requestType = null;
        byte requestTypeByte = RequestType.NOP_REQUEST.getCode();
        try {
            Response response;
            RequestInfos.RequestInfo info = RequestInfos.info();
            info.setInputStream((InputStream)(this.countStreams ? new CountingInputStream(rawIn) : rawIn));
            InputStream cis = info.getInputStream();
            clientProtocol.readExternal(cis);
            ois = new EjbObjectInputStream(cis);
            ServerMetaData serverMetaData = new ServerMetaData();
            serverMetaData.readExternal((ObjectInput)ois);
            ClientObjectFactory.serverMetaData.set(serverMetaData);
            requestTypeByte = ois.readByte();
            requestType = RequestType.valueOf((byte)requestTypeByte);
            if (requestType == RequestType.NOP_REQUEST) {
                return;
            }
            ClusterResponse clusterResponse = null;
            if (requestType == RequestType.CLUSTER_REQUEST) {
                clusterResponse = this.clusterHandler.processRequest(ois, clientProtocol);
                Throwable failure = clusterResponse.getFailure();
                if (null != clusterResponse && null != failure) {
                    this.clusterHandler.getLogger().debug("Failed to write to ClusterResponse", failure);
                    try {
                        info.setOutputStream((OutputStream)(this.countStreams ? new CountingOutputStream(rawOut) : rawOut));
                        oos = new ObjectOutputStream(info.getOutputStream());
                        clusterResponse.setMetaData(clientProtocol);
                        clusterResponse.writeExternal((ObjectOutput)oos);
                        oos.flush();
                    }
                    catch (IOException ie) {
                        String m = "Failed to write to ClusterResponse: " + ie.getMessage();
                        this.clusterHandler.getLogger().error(m, (Throwable)ie);
                        throw Exceptions.newIOException((String)m, (Throwable)ie);
                    }
                    throw failure;
                }
            }
            if ((requestType = RequestType.valueOf((byte)(requestTypeByte = ois.readByte()))) == RequestType.NOP_REQUEST) {
                return;
            }
            switch (requestType) {
                case EJB_REQUEST: {
                    response = this.processEjbRequest(ois, clientProtocol);
                    break;
                }
                case JNDI_REQUEST: {
                    response = this.processJndiRequest(ois, clientProtocol);
                    break;
                }
                case AUTH_REQUEST: {
                    response = this.processAuthRequest(ois, clientProtocol);
                    break;
                }
                case LOGOUT_REQUEST: {
                    response = this.processLogoutRequest(ois, clientProtocol);
                    break;
                }
                default: {
                    logger.error("\"" + requestType + " " + clientProtocol.getSpec() + "\" FAIL \"Unknown request type " + requestType);
                    return;
                }
            }
            try {
                info.setOutputStream((OutputStream)(this.countStreams ? new CountingOutputStream(rawOut) : rawOut));
                OutputStream cos = info.getOutputStream();
                clientProtocol.writeExternal(cos);
                cos.flush();
                oos = new ObjectOutputStream(cos);
                this.clusterHandler.processResponse((Response)clusterResponse, oos, clientProtocol);
                oos.flush();
            }
            finally {
                switch (requestType) {
                    case EJB_REQUEST: {
                        this.processEjbResponse(response, oos, clientProtocol);
                        break;
                    }
                    case JNDI_REQUEST: {
                        this.processJndiResponse(response, oos, clientProtocol);
                        break;
                    }
                    case AUTH_REQUEST: {
                        this.processAuthResponse(response, oos, clientProtocol);
                        break;
                    }
                    case LOGOUT_REQUEST: {
                        this.processLogoutResponse(response, oos, clientProtocol);
                        break;
                    }
                    default: {
                        logger.error("\"" + requestType + " " + clientProtocol.getSpec() + "\" FAIL \"Unknown response type " + requestType);
                    }
                }
            }
        }
        catch (IllegalArgumentException iae) {
            msg = "\"" + clientProtocol.getSpec() + "\" FAIL \"Unknown request type " + requestTypeByte;
            if (logger.isDebugEnabled()) {
                logger.debug(msg, (Throwable)iae);
            } else {
                logger.warning(msg + " - Debug for StackTrace");
            }
        }
        catch (SecurityException e) {
            msg = "\"" + requestType + " " + clientProtocol.getSpec() + "\" FAIL \"Security error - " + e.getMessage() + "\"";
            if (logger.isDebugEnabled()) {
                logger.debug(msg, (Throwable)e);
            } else {
                logger.warning(msg + " - Debug for StackTrace");
            }
        }
        catch (Throwable e) {
            msg = "\"" + requestType + " " + clientProtocol.getSpec() + "\" FAIL \"Unexpected error - " + e.getMessage() + "\"";
            if (logger.isDebugEnabled()) {
                logger.debug(msg, e);
            } else {
                logger.warning(msg + " - Debug for StackTrace");
            }
        }
        finally {
            try {
                ClientObjectFactory.serverMetaData.remove();
            }
            finally {
                if (null != oos) {
                    try {
                        oos.flush();
                    }
                    catch (Throwable iae) {}
                    try {
                        oos.close();
                    }
                    catch (Throwable iae) {}
                }
                if (null != ois) {
                    try {
                        ois.close();
                    }
                    catch (Throwable iae) {}
                }
                this.securityService.disassociate();
            }
        }
    }

    protected BeanContext getDeployment(EJBRequest req) throws RemoteException {
        String deploymentId = req.getDeploymentId();
        BeanContext beanContext = this.containerSystem.getBeanContext((Object)deploymentId);
        if (beanContext == null) {
            throw new RemoteException("No deployment: " + deploymentId);
        }
        return beanContext;
    }

    public Response processEjbRequest(ObjectInputStream in, ProtocolMetaData metaData) throws Exception {
        return this.ejbHandler.processRequest(in, metaData);
    }

    public Response processJndiRequest(ObjectInputStream in, ProtocolMetaData metaData) throws Exception {
        return this.jndiHandler.processRequest(in, metaData);
    }

    public Response processAuthRequest(ObjectInputStream in, ProtocolMetaData metaData) throws Exception {
        return this.authHandler.processRequest(in, metaData);
    }

    public Response processLogoutRequest(ObjectInputStream in, ProtocolMetaData metaData) throws Exception {
        return this.logoutHandler.processRequest(in, metaData);
    }

    public void processEjbResponse(Response response, ObjectOutputStream out, ProtocolMetaData metaData) throws Exception {
        this.ejbHandler.processResponse(response, out, metaData);
    }

    public void processJndiResponse(Response response, ObjectOutputStream out, ProtocolMetaData metaData) throws Exception {
        this.jndiHandler.processResponse(response, out, metaData);
    }

    public void processAuthResponse(Response response, ObjectOutputStream out, ProtocolMetaData metaData) throws Exception {
        this.authHandler.processResponse(response, out, metaData);
    }

    public void processLogoutResponse(Response response, ObjectOutputStream out, ProtocolMetaData metaData) throws Exception {
        this.logoutHandler.processResponse(response, out, metaData);
    }

    public EJBMetaData getEJBMetaData(ProxyInfo info) {
        return this.clientObjectFactory.getEJBMetaData(info);
    }

    public Handle getHandle(ProxyInfo info) {
        return this.clientObjectFactory.getHandle(info);
    }

    public HomeHandle getHomeHandle(ProxyInfo info) {
        return this.clientObjectFactory.getHomeHandle(info);
    }

    public EJBObject getEJBObject(ProxyInfo info) {
        return this.clientObjectFactory.getEJBObject(info);
    }

    public Object getBusinessObject(ProxyInfo info) {
        return this.clientObjectFactory.getBusinessObject(info);
    }

    public EJBHome getEJBHome(ProxyInfo info) {
        return this.clientObjectFactory.getEJBHome(info);
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public EJBDSerializer getSerializer() {
        return this.serializer;
    }

    private static class ContextualSerializer
    implements EJBDSerializer {
        private final String classname;

        public ContextualSerializer(String serializer) {
            this.classname = serializer;
        }

        public Serializable serialize(Object o) {
            return this.instance().serialize(o);
        }

        public Object deserialize(Serializable o, Class<?> clazz) {
            return this.instance().deserialize(o, clazz);
        }

        private EJBDSerializer instance() {
            try {
                return (EJBDSerializer)EJBDSerializer.class.cast(Thread.currentThread().getContextClassLoader().loadClass(this.classname).newInstance());
            }
            catch (Exception e) {
                throw new OpenEJBRuntimeException(e);
            }
        }
    }
}

