/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.sp.loginmodule;

import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestIdFactory {
    private final Logger logger = LoggerFactory.getLogger(RequestIdFactory.class);
    private static RequestIdFactory factory;
    private Mac mac = null;

    private RequestIdFactory() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("HmacSHA256");
            SecretKey sk = kg.generateKey();
            this.mac = Mac.getInstance("HmacSHA256");
            this.mac.init(sk);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("NoSuchAlgorithmException - error accured while initialiate SAML2 request id factory", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            this.logger.error("InvalidKeyException - error accured while initialiate SAML2 request id factory", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static synchronized RequestIdFactory getRequestIdFactory() {
        if (factory == null) {
            factory = new RequestIdFactory();
        }
        return factory;
    }

    public String generateId() {
        try {
            String id = SAML2Utils.generateUUID();
            byte[] hash = this.generageHMAC(id.getBytes(Charset.forName("UTF-8")));
            String result = String.valueOf(id) + "-" + this.modifiedBase64Encode(hash);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Request id generated " + result);
            }
            return result;
        }
        catch (SAML2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String modifiedBase64Encode(byte[] toEncode) throws SAML2Exception {
        String result = SAML2Utils.encodeBase64((byte[])toEncode);
        if ((result = result.replace('+', '.').replace('/', '_')).endsWith("==")) {
            result = result.substring(0, result.length() - 2);
        } else if (result.endsWith("=")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private synchronized byte[] generageHMAC(byte[] input) {
        return this.mac.doFinal(input);
    }

    public void validateRequestId(String requestId, SAML2LocalSP localSP) throws LoginException {
        this.checkSign(requestId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Request id requestId validated successfully " + requestId);
        }
    }

    private void checkSign(String requestId) throws LoginException {
        if (requestId == null || requestId.indexOf(45) == -1) {
            throw new LoginException("Invalid request id: " + requestId);
        }
        String uuid = requestId.substring(0, requestId.lastIndexOf(45));
        String hash = requestId.substring(requestId.lastIndexOf(45) + 1);
        byte[] expectedHMAC = this.generageHMAC(uuid.getBytes(Charset.forName("UTF-8")));
        try {
            String expectedHash = this.modifiedBase64Encode(expectedHMAC);
            if (!hash.equals(expectedHash)) {
                throw new LoginException("Invalid request id, wrong origin: " + requestId);
            }
        }
        catch (SAML2Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Error occured while validate signature of id " + requestId, (Throwable)e);
            }
            throw new LoginException(e.getMessage());
        }
    }
}

