/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.sp.loginmodule;

import com.sap.core.jpaas.security.auth.service.TenantSessionCookieConfigration;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2LocalSPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2TrustedIdPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessor;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessorFactory;
import com.sap.core.jpaas.security.saml2.sp.exception.SAML2JPaaSException;
import com.sap.core.jpaas.security.saml2.sp.loginmodule.RequestIdFactory;
import com.sap.core.jpaas.security.saml2.sp.loginmodule.SAML2JPaaSPrincipal;
import com.sap.core.jpaas.security.saml2.sp.loginmodule.SAML2SingleSignOnCredenial;
import com.sap.core.jpaas.security.saml2.sp.util.MultiDomainServiceUtil;
import com.sap.core.jpaas.security.saml2.sp.util.RelayStateUtil;
import com.sap.core.jpaas.security.saml2.sp.util.UMHelper;
import com.sap.core.jpaas.security.utils.AuditLogUtil;
import com.sap.core.tenant.api.Tenant;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.engine.lib.security.login.SubjectWrapper;
import com.sap.security.auth.service.UserSession;
import com.sap.security.auth.util.Utils;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.commons.Attribute;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.lib.bindings.HTTPPostBinding;
import com.sap.security.saml2.lib.callbacks.SAMLGetterCallback;
import com.sap.security.saml2.lib.callbacks.SAMLSetterCallback;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.saml2.sp.sso.AuthenticationRequirements;
import com.sap.security.saml2.sp.sso.SAML2Authentication;
import com.sap.security.saml2.sp.sso.SAML2PrincipalWrapper;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2JPaaSLoginModule
implements LoginModule {
    static final String INVALID_USER_NAME_ERROR_MESSAGE = "Invalid user name";
    private static final String SAML_ASSERTION_ATTRIBUTES = "saml.assertion.attributes";
    private static final Logger logger = LoggerFactory.getLogger(SAML2JPaaSLoginModule.class);
    private CallbackHandler callbackHandler = null;
    private Subject subject = null;
    private boolean sendAuthnRequest = true;
    private boolean adminMode = false;
    private boolean isAppToAppSso;
    private SAML2ConfigurationJPaaSImpl saml2Config;
    private SAML2TrustedIdPJPaaSImpl idp;
    private SAML2JPaaSPrincipal saml2JPaaSPrincipal = null;
    private SAML2SingleSignOnCredenial ssoCredential = null;
    private boolean restoreOriginalRequest = true;
    private boolean expectSecondFactor = false;
    private String urlAnchorPart = null;
    private Map<String, Object> sharedState;
    private SAML2Response saml2Response;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.sharedState = sharedState;
        this.sendAuthnRequest = !"passive".equals(options.get("mode"));
        this.expectSecondFactor = Boolean.parseBoolean((String)options.get("secondfactor"));
        this.adminMode = Boolean.parseBoolean((String)options.get("adminmode"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean login() throws LoginException {
        block18: {
            URL refererURL;
            String refererHost;
            block17: {
                logger.debug("Entering SAML2JPaaSLoginModule.login()");
                try {
                    if (!this.expectSecondFactor) break block17;
                    this.saml2JPaaSPrincipal = this.getPrincipalFromSession();
                    if (this.saml2JPaaSPrincipal == null) break block17;
                    this.putSAMLPrincipalInSharedState();
                    this.sendAuthnRequest = false;
                    this.restoreOriginalRequest = false;
                    return true;
                }
                catch (Exception e) {
                    this.sendAuthnRequest = false;
                    AuditLogUtil.auditLogMessage((String)("Unable to retrieve SAMLResponse and request URL: " + e.getMessage()), this.getClass());
                    logger.error("Failed to process SAML message", (Throwable)e);
                    if (e instanceof LoginException) {
                        throw (LoginException)e;
                    }
                    LoginException le = new LoginException(e.getMessage());
                    le.initCause(e);
                    throw le;
                }
            }
            String samlResponseBase64 = this.getSAMLResponseFromRequest();
            if (samlResponseBase64 == null) break block18;
            logger.debug("Raw saml response: {}", (Object)samlResponseBase64);
            this.sendAuthnRequest = false;
            this.initSAML2Configuration();
            String samlResponseXML = SAML2Utils.decodeBase64AsString((String)samlResponseBase64);
            String recipientUrl = this.getRequestURL();
            String refererHeader = this.getRefererHeader();
            String serverName = this.getServerName();
            logger.debug("Response: {}\nRecipient URL: {}\nReferer: {}\nServer name: {}", new Object[]{samlResponseXML, recipientUrl, refererHeader, serverName});
            this.saml2Response = this.getSAMLAuthenticationInstance().parseSAML2Response(samlResponseXML);
            String originalRequestId = null;
            if (this.saml2Response.getInResponseTo() != null) {
                logger.debug("SP initiated SSO");
                String[] relayStateValues = this.getRelayState();
                if (this.validateRelayState(relayStateValues)) {
                    this.urlAnchorPart = RelayStateUtil.retrieveURLAnchorPart(this.callbackHandler, relayStateValues[0]);
                    HashMap<String, String> relayCookieValueSet = null;
                    if (this.saml2Config.getLocalSP().isMultiDomainServiceEnabled()) {
                        relayCookieValueSet = RelayStateUtil.removeRelayStateCookie(this.callbackHandler, "mds" + relayStateValues[0], (SAML2LocalSP)this.saml2Config.getLocalSP());
                        recipientUrl = this.saml2Config.getLocalSP().getEndpointsURL();
                        logger.debug("Multi domain service is enabled, recipient url is now: {}", (Object)recipientUrl);
                    } else {
                        relayCookieValueSet = RelayStateUtil.removeRelayStateCookie(this.callbackHandler, relayStateValues[0], (SAML2LocalSP)this.saml2Config.getLocalSP());
                    }
                    if (relayCookieValueSet == null) throw new LoginException("No RelayState cookie found in the request. SAML 2.0 authentication failed.");
                    originalRequestId = relayCookieValueSet.get("reqId");
                    if (logger.isDebugEnabled()) {
                        logger.debug("RelayState app url: {}", (Object)relayCookieValueSet.get("appUrl"));
                        logger.debug("RelayState original req id: {}", (Object)originalRequestId);
                    }
                } else {
                    logger.debug("No relay state cookie found");
                }
            }
            SAML2PrincipalWrapper principalWrapper = null;
            String xProxyHostHeader = this.getXProxyHostHeader();
            if (!this.isAppToAppSso && refererHeader != null && serverName != null && (SAML2JPaaSLoginModule.areDomainsEqual(refererHost = (refererURL = new URL(refererHeader)).getHost(), serverName) || SAML2JPaaSLoginModule.areDomainsEqual(refererHost, xProxyHostHeader))) {
                principalWrapper = this.getSAMLAuthenticationInstance().validateResponseAssertion((SAML2SPConfiguration)this.saml2Config, this.saml2Response, originalRequestId, recipientUrl, refererHeader);
            }
            if (principalWrapper == null) {
                principalWrapper = this.getSAMLAuthenticationInstance().validateResponseAssertion((SAML2SPConfiguration)this.saml2Config, this.saml2Response, originalRequestId, recipientUrl);
            }
            String credentialType = this.isAppToAppSso ? "AppToAppSSO" : "SAML2";
            this.ssoCredential = new SAML2SingleSignOnCredenial(credentialType, principalWrapper.getAssertion());
            SAML2Principal principal = principalWrapper.getSaml2Principal();
            if (originalRequestId != null) {
                RequestIdFactory.getRequestIdFactory().validateRequestId(originalRequestId, (SAML2LocalSP)this.saml2Config.getLocalSP());
            }
            logger.debug("SAMLResponse successfully validated with result: \n{}", (Object)principal);
            this.saml2JPaaSPrincipal = UMHelper.createSAML2JPaaSPrincipal(principal, this.saml2Config.getTrustedIdP(principal.getIdPName()));
            if (this.isOnlySAMLResponseSigned()) {
                this.saml2JPaaSPrincipal.setAssertionUnsigned(true);
            }
            this.validateUserName(this.saml2JPaaSPrincipal);
            this.saml2JPaaSPrincipal.setIssuer("saml2_idp:" + principal.getIdPName());
            this.saml2JPaaSPrincipal.setSaml2IdpCert(principal.getSaml2IdpCert());
            if (this.expectSecondFactor) {
                this.putSAMLPrincipalInSharedState();
                this.putSAMLPrincipalInSession();
            }
            logger.debug("Exiting login method successfully");
            return true;
        }
        if (Utils.isImpersonationScenario((CallbackHandler)this.callbackHandler)) {
            logger.debug("Impersonation scenario triggered but SAML2 Response not found in the request body");
            throw new LoginException("Impersonation scenario triggered but SAML2 Response not found in the request body");
        }
        logger.debug("No SAMLResponse found in request");
        return false;
    }

    private boolean isOnlySAMLResponseSigned() {
        SAML2Assertion assertion = (SAML2Assertion)this.saml2Response.getAssertions().get(0);
        return this.saml2Response.isSigned() && !assertion.isSigned();
    }

    private String getSAMLResponseFromRequest() throws UnsupportedCallbackException, IOException {
        String samlResponseBase64 = null;
        String authzHeader = this.getAuthorizationHeader();
        if (authzHeader != null && authzHeader.startsWith("SAML2.0 ")) {
            samlResponseBase64 = authzHeader.substring("SAML2.0 ".length());
            this.isAppToAppSso = true;
            this.restoreOriginalRequest = false;
            logger.debug("Processing application to application SSO scenario");
        } else {
            samlResponseBase64 = this.getSAMLResponseFromBody();
        }
        return samlResponseBase64;
    }

    private String getAuthorizationHeader() throws UnsupportedCallbackException, IOException {
        HttpGetterCallback authzHeaderCallback = new HttpGetterCallback();
        authzHeaderCallback.setType((byte)1);
        authzHeaderCallback.setName("Authorization");
        this.callbackHandler.handle(new Callback[]{authzHeaderCallback});
        return (String)authzHeaderCallback.getValue();
    }

    private String getSAMLResponseFromBody() throws UnsupportedCallbackException, IOException {
        HttpGetterCallback samlResponseCallback = new HttpGetterCallback();
        samlResponseCallback.setType((byte)3);
        samlResponseCallback.setName("SAMLResponse");
        this.callbackHandler.handle(new Callback[]{samlResponseCallback});
        String[] saml2ResponseValues = (String[])samlResponseCallback.getValue();
        if (saml2ResponseValues != null && saml2ResponseValues.length > 0) {
            return saml2ResponseValues[0];
        }
        return null;
    }

    private String getRequestURL() throws UnsupportedCallbackException, IOException {
        HttpGetterCallback requestUrlCallback = new HttpGetterCallback();
        requestUrlCallback.setType((byte)17);
        this.callbackHandler.handle(new Callback[]{requestUrlCallback});
        return (String)requestUrlCallback.getValue();
    }

    private String getRefererHeader() throws UnsupportedCallbackException, IOException {
        HttpGetterCallback refererHeaderCallback = new HttpGetterCallback();
        refererHeaderCallback.setType((byte)1);
        refererHeaderCallback.setName("Referer");
        this.callbackHandler.handle(new Callback[]{refererHeaderCallback});
        return (String)refererHeaderCallback.getValue();
    }

    private String getServerName() throws UnsupportedCallbackException, IOException {
        HttpGetterCallback serverNameCallback = new HttpGetterCallback();
        serverNameCallback.setType((byte)27);
        this.callbackHandler.handle(new Callback[]{serverNameCallback});
        return (String)serverNameCallback.getValue();
    }

    private String[] getRelayState() throws UnsupportedCallbackException, IOException {
        HttpGetterCallback relayStateCallback = new HttpGetterCallback();
        relayStateCallback.setType((byte)3);
        relayStateCallback.setName("RelayState");
        this.callbackHandler.handle(new Callback[]{relayStateCallback});
        return (String[])relayStateCallback.getValue();
    }

    private String getXProxyHostHeader() throws UnsupportedCallbackException, IOException {
        HttpGetterCallback xProxyHostCallback = new HttpGetterCallback();
        xProxyHostCallback.setType((byte)1);
        xProxyHostCallback.setName("x-proxy-host");
        this.callbackHandler.handle(new Callback[]{xProxyHostCallback});
        return (String)xProxyHostCallback.getValue();
    }

    SAML2Authentication getSAMLAuthenticationInstance() {
        return SAML2Authentication.getInstance();
    }

    private void validateUserName(SAML2JPaaSPrincipal principal) throws LoginException {
        String userName = principal.getName();
        if (userName.contains("\n") || userName.contains("\r")) {
            throw new LoginException(INVALID_USER_NAME_ERROR_MESSAGE);
        }
    }

    private boolean validateRelayState(String[] relayStateValues) {
        boolean isRelayStateValid;
        boolean isRelayStatePresent = relayStateValues != null && relayStateValues.length > 0;
        boolean bl = isRelayStateValid = isRelayStatePresent && (RelayStateUtil.isOriginalUrlCookieName(relayStateValues[0]) || RelayStateUtil.isMdsRelayStateCookieName(relayStateValues[0]));
        return isRelayStatePresent && isRelayStateValid;
    }

    private SAML2JPaaSPrincipal getPrincipalFromSession() throws Exception {
        HttpGetterCallback sessionAttributeCallback = new HttpGetterCallback();
        sessionAttributeCallback.setType((byte)10);
        sessionAttributeCallback.setName("com.sap.cloud.security.firstfactor.credentials");
        this.callbackHandler.handle(new Callback[]{sessionAttributeCallback});
        Object value = sessionAttributeCallback.getValue();
        if (value != null && SAML2Principal.class.isAssignableFrom(value.getClass())) {
            return (SAML2JPaaSPrincipal)((Object)value);
        }
        return null;
    }

    private void putSAMLPrincipalInSession() throws IOException, UnsupportedCallbackException {
        HttpSetterCallback createSessionCallback = new HttpSetterCallback();
        createSessionCallback.setType((byte)26);
        HttpSetterCallback sessionAttributeCallback = this.createSessionAttributeCallback("com.sap.cloud.security.firstfactor.credentials", (Object)this.saml2JPaaSPrincipal);
        HttpSetterCallback authMethodAttributeCallback = this.createSessionAttributeCallback("com.sap.cloud.security.login.authn.method.name", "SAMLWITHPASSCODE");
        this.callbackHandler.handle(new Callback[]{createSessionCallback, sessionAttributeCallback, authMethodAttributeCallback});
    }

    private HttpSetterCallback createSessionAttributeCallback(String attributeName, Object attributeValue) {
        HttpSetterCallback attributeCallback = new HttpSetterCallback();
        attributeCallback.setType((byte)10);
        attributeCallback.setName(attributeName);
        attributeCallback.setValue(attributeValue);
        return attributeCallback;
    }

    private void removePrincipalFromSharedState() {
        this.sharedState.remove("principal");
    }

    private void putSAMLPrincipalInSharedState() {
        this.sharedState.put("principal", (Object)this.saml2JPaaSPrincipal);
    }

    @Override
    public boolean commit() throws LoginException {
        logger.debug("Entering SAML2JPaaSLoginModule.commit()");
        if (this.saml2JPaaSPrincipal != null) {
            SAMLGetterCallback sgc;
            this.subject.getPrincipals().add((Principal)((Object)this.saml2JPaaSPrincipal));
            logger.debug("SAML2JPaaSPrincipal added to Subject");
            if (this.ssoCredential != null) {
                this.subject.getPrivateCredentials().add(this.ssoCredential);
                logger.debug("SingleSignOnCredential added to Subject private credentials.");
            }
            if (this.saml2JPaaSPrincipal.getSaml2IdpCert() != null) {
                this.subject.getPublicCredentials().add(this.saml2JPaaSPrincipal.getSaml2IdpCert());
            }
            if (!this.updateUser()) {
                logger.error("Could not update user with data from principal. Authentication for user " + this.saml2JPaaSPrincipal.getName() + " failed.");
                AuditLogUtil.auditLogMessage((String)("Could not update user with data from principal. Authentication for user " + this.saml2JPaaSPrincipal.getName() + " failed."), this.getClass());
                throw new LoginException("Could not update user with data from principal. Authentication for user " + this.saml2JPaaSPrincipal.getName() + " failed.");
            }
            String originalUrl = null;
            try {
                sgc = new SAMLGetterCallback();
                sgc.setType((byte)13);
                sgc.setName("redirect_url");
                this.callbackHandler.handle(new Callback[]{sgc});
                originalUrl = (String)sgc.getValue();
                if (originalUrl == null) {
                    SAMLGetterCallback requestCallbackHandler = new SAMLGetterCallback();
                    requestCallbackHandler.setType((byte)17);
                    this.callbackHandler.handle(new Callback[]{requestCallbackHandler});
                    originalUrl = (String)requestCallbackHandler.getValue();
                }
                if (originalUrl != null && originalUrl.startsWith("http")) {
                    originalUrl = new URL(originalUrl).getFile();
                }
            }
            catch (Exception e) {
                logger.error("Could not get original URL", (Throwable)e);
                AuditLogUtil.auditLogMessage((String)("SAML2 Login: could not get original application URL: " + e.getMessage()), this.getClass());
                throw new LoginException("SAML2 Login: could not get original application URL");
            }
            if (this.urlAnchorPart != null) {
                originalUrl = String.valueOf(originalUrl) + this.urlAnchorPart;
            }
            if (originalUrl != null) {
                try {
                    sgc = new SAMLGetterCallback();
                    sgc.setType((byte)13);
                    sgc.setName("saml2post");
                    this.callbackHandler.handle(new Callback[]{sgc});
                    String isPost = (String)sgc.getValue();
                    if (this.restoreOriginalRequest && !"true".equalsIgnoreCase(isPost)) {
                        logger.debug("Restoring original url [{}].", (Object)originalUrl);
                        SAMLSetterCallback ssc = new SAMLSetterCallback();
                        ssc.setType((byte)19);
                        ssc.setValue((Object)originalUrl);
                        this.callbackHandler.handle(new Callback[]{ssc});
                    }
                }
                catch (Exception e) {
                    logger.error("Could not restore to original URL", (Throwable)e);
                    AuditLogUtil.auditLogMessage((String)("SAML2 Login: could not restore original application URL: " + e.getMessage()), this.getClass());
                    throw new LoginException("SAML2 Login: could not restore original application URL");
                }
            }
            this.setPrincipalAttributesInSession();
            logger.debug("Exiting commit method successfully");
            return true;
        }
        logger.debug("Exiting commit method with false, saml2 principal is null");
        return false;
    }

    boolean updateUser() {
        return UMHelper.updateUser(this.saml2JPaaSPrincipal);
    }

    private void setPrincipalAttributesInSession() {
        Set samlAttributes = this.saml2JPaaSPrincipal.getAttributes();
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute samlAttribute : samlAttributes) {
            List values = samlAttribute.getValues();
            if (values == null || values.size() <= 0) continue;
            attributes.put(samlAttribute.getName(), (String)values.get(0));
        }
        logger.debug("Setting SAML2 assertion attributes as session attribute. Attributes set: {}", attributes);
        HttpSetterCallback sessionAttributeSetter = new HttpSetterCallback();
        sessionAttributeSetter.setName(SAML_ASSERTION_ATTRIBUTES);
        sessionAttributeSetter.setType((byte)10);
        sessionAttributeSetter.setValue(attributes);
        try {
            this.callbackHandler.handle(new Callback[]{sessionAttributeSetter});
        }
        catch (Exception e) {
            logger.error("Failed to set SAML2 assertion attributes in the session", (Throwable)e);
        }
    }

    @Override
    public boolean abort() throws LoginException {
        logger.debug("Entering SAML2JPaaSLoginModule.abort()");
        if (this.expectSecondFactor) {
            this.removePrincipalFromSharedState();
        }
        if (this.sendAuthnRequest) {
            this.initSAML2Configuration();
            SAML2LocalSPJPaaSImpl localSP = this.saml2Config.getLocalSP();
            RelayStateUtil.removeOldCookies(this.callbackHandler, (SAML2LocalSP)localSP);
            try {
                if (this.isAjaxRequest()) {
                    logger.debug("abort -> ajax request");
                    this.sendEmptyAuthnRequest();
                    return true;
                }
            }
            catch (Exception e) {
                throw new LoginException(e.getMessage());
            }
            logger.debug("abort -> check multi domain service");
            if (localSP.isMultiDomainServiceEnabled()) {
                ArrayList<Callback> callbacks;
                String relayState;
                String value;
                HttpSetterCallback authnRequestCallback;
                String requestId;
                block27: {
                    logger.debug("abort -> multi domain service enabled");
                    String requestUrl = null;
                    SAMLGetterCallback requestCallbackHandler = new SAMLGetterCallback();
                    requestCallbackHandler.setType((byte)17);
                    try {
                        this.callbackHandler.handle(new Callback[]{requestCallbackHandler});
                        requestUrl = (String)requestCallbackHandler.getValue();
                    }
                    catch (Exception e) {
                        logger.error("Unable to retreive request url", (Throwable)e);
                        AuditLogUtil.auditLogMessage((String)("Unable to retreive request url: " + e.getMessage()), this.getClass());
                    }
                    requestId = RequestIdFactory.getRequestIdFactory().generateId();
                    authnRequestCallback = new HttpSetterCallback();
                    value = null;
                    relayState = "ouc" + RelayStateUtil.generateRandomRelayStateString();
                    callbacks = new ArrayList<Callback>();
                    String mdsUrl = String.valueOf(localSP.getEndpointsURL()) + "/" + "saml2/sp/mds";
                    logger.debug("MDS url: {}", (Object)mdsUrl);
                    try {
                        if ("HTTP-POST".equalsIgnoreCase(this.idp.getIdpSSOBinding())) {
                            value = MultiDomainServiceUtil.createSSORequestHttpBody(Tenant.getId(), requestUrl, requestId, mdsUrl, relayState, this.idp, localSP);
                            authnRequestCallback.setType((byte)9);
                            callbacks.addAll(this.getPOSTBindingHeaderCallbacks());
                            logger.debug("AuthnRequest will be send over HTTP-POST binding");
                            break block27;
                        }
                        if ("HTTP-Redirect".equalsIgnoreCase(this.idp.getIdpSSOBinding())) {
                            value = MultiDomainServiceUtil.createSSORequestUrl(Tenant.getId(), requestUrl, requestId, mdsUrl, relayState, this.idp, localSP);
                            authnRequestCallback.setType((byte)19);
                            logger.debug("AuthnRequest will be send over HTTP-Redirect binding");
                            break block27;
                        }
                        logger.error("AuthnRequest cannot be send to the IDP. Unknown binding: " + this.idp.getIdpSSOBinding());
                        return true;
                    }
                    catch (Exception e) {
                        logger.error("Error occured while creating SSO request", (Throwable)e);
                        AuditLogUtil.auditLogMessage((String)("Error occured while creating SSO request: " + e.getMessage()), this.getClass());
                        return true;
                    }
                }
                RelayStateUtil.setRelayStateCookie(this.callbackHandler, "mds" + relayState, (SAML2LocalSP)localSP, requestId);
                logger.debug("auth request callback value: {}", (Object)value);
                authnRequestCallback.setValue((Object)value);
                callbacks.add((Callback)authnRequestCallback);
                HttpSetterCallback loginRequestHeaderCallback = this.buildLoginRquestHeaderCallback("login-request");
                callbacks.add((Callback)loginRequestHeaderCallback);
                try {
                    this.callbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
                }
                catch (Exception e) {
                    logger.error("Unable to send the AuthnRequest to the IDP", (Throwable)e);
                    AuditLogUtil.auditLogMessage((String)("Unable to send the AuthnRequest to the IDP: " + e.getMessage()), this.getClass());
                }
            } else {
                String requestId;
                ArrayList<Callback> callbacks;
                String relayState;
                String value;
                HttpSetterCallback authnRequestCallback;
                block28: {
                    String requestUrl = null;
                    if ("APP_URL".equalsIgnoreCase(this.idp.getSsoAcsUrl())) {
                        SAMLGetterCallback requestCallbackHandler = new SAMLGetterCallback();
                        requestCallbackHandler.setType((byte)17);
                        try {
                            this.callbackHandler.handle(new Callback[]{requestCallbackHandler});
                            requestUrl = (String)requestCallbackHandler.getValue();
                        }
                        catch (Exception e) {
                            logger.error("Unable to retreive request url", (Throwable)e);
                            AuditLogUtil.auditLogMessage((String)("Unable to retreive request url: " + e.getMessage()), this.getClass());
                        }
                    } else {
                        requestUrl = this.idp.getSsoAcsUrl();
                    }
                    authnRequestCallback = new HttpSetterCallback();
                    value = null;
                    relayState = "ouc" + RelayStateUtil.generateRandomRelayStateString();
                    logger.debug("Authn Request generation: saml2config: {} idpName: {} relayState: {} requestUrl: {}", new Object[]{this.saml2Config, this.idp.getName(), relayState, requestUrl});
                    callbacks = new ArrayList<Callback>();
                    requestId = null;
                    try {
                        requestId = RequestIdFactory.getRequestIdFactory().generateId();
                        if ("HTTP-POST".equalsIgnoreCase(this.idp.getIdpSSOBinding())) {
                            AuthenticationRequirements authenticationRequirements = new AuthenticationRequirements();
                            authenticationRequirements.setForceAuthentication(Boolean.valueOf(this.saml2Config.isForceAuthentication()));
                            value = this.getSAMLAuthenticationInstance().createSSORequestHttpBody((SAML2SPConfiguration)this.saml2Config, this.idp.getName(), relayState, requestUrl, authenticationRequirements, requestId);
                            authnRequestCallback.setType((byte)9);
                            callbacks.addAll(this.getPOSTBindingHeaderCallbacks());
                            logger.debug("AuthnRequest will be send over HTTP-POST binding");
                            break block28;
                        }
                        if ("HTTP-Redirect".equalsIgnoreCase(this.idp.getIdpSSOBinding())) {
                            value = this.getSAMLAuthenticationInstance().createSSORequestUrl((SAML2SPConfiguration)this.saml2Config, this.idp.getName(), relayState, requestUrl, null, requestId);
                            authnRequestCallback.setType((byte)19);
                            if (logger.isDebugEnabled()) {
                                logger.debug("AuthnRequest will be send over HTTP-Redirect binding");
                            }
                            break block28;
                        }
                        logger.error("AuthnRequest cannot be send to the IDP. Unknown binding: " + this.idp.getIdpSSOBinding());
                        return true;
                    }
                    catch (Exception e) {
                        logger.error("Error occured while creating SSO request", (Throwable)e);
                        AuditLogUtil.auditLogMessage((String)("Error occured while creating SSO request: " + e.getMessage()), this.getClass());
                        return true;
                    }
                }
                RelayStateUtil.setRelayStateCookie(this.callbackHandler, relayState, (SAML2LocalSP)localSP, requestId);
                logger.debug("auth request callback value: {}", (Object)value);
                authnRequestCallback.setValue((Object)value);
                callbacks.add((Callback)authnRequestCallback);
                HttpSetterCallback loginRequestHeaderCallback = this.buildLoginRquestHeaderCallback("login-request");
                callbacks.add((Callback)loginRequestHeaderCallback);
                try {
                    this.callbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
                }
                catch (Exception e) {
                    logger.error("Unable to send the AuthnRequest to the IDP", (Throwable)e);
                    AuditLogUtil.auditLogMessage((String)("Unable to send the AuthnRequest to the IDP: " + e.getMessage()), this.getClass());
                }
            }
        } else {
            logger.debug("SAML2JPaaSLoginModule.abort() will exit with true without sending authenticatio nrequest");
        }
        return true;
    }

    private void sendEmptyAuthnRequest() {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        HttpSetterCallback authnRequestCallback = new HttpSetterCallback();
        if ("HTTP-POST".equalsIgnoreCase(this.idp.getIdpSSOBinding())) {
            authnRequestCallback.setType((byte)9);
            authnRequestCallback.setValue((Object)"<!DOCTYPE html PUBLIC \"-//WAPFORUM//DTD XHTML Mobile 1.0//EN\" \"http://www.wapforum.org/DTD/xhtml-mobile10.dtd\">\r\n<html \r\n    xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <head>\r\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, shrink-to-fit=no\">\r\n            <meta http-equiv=\"pragma\" content=\"no-cache\" />\r\n        </head>\r\n        <body style=\"background-color:#FFFFFF\">\r\n    <h1>Unauthorized</h1>\r\n        <HR size=\"1\" noshade=\"noshade\">\r\n            <p>\r\n                <b>type</b> Status report\r\n            </p>\r\n            <p>\r\n                <b>message</b>\r\n                <u>Unauthorized</u>\r\n            </p>\r\n            <p>\r\n                <b>description</b>\r\n                <u>This request requires HTTP authentication.</u>\r\n            </p>\r\n        </body>\r\n    </html>");
            callbacks.addAll(this.getPOSTBindingHeaderCallbacks());
            logger.debug("AuthnRequest will be send over HTTP-POST binding");
        } else if ("HTTP-Redirect".equalsIgnoreCase(this.idp.getIdpSSOBinding())) {
            authnRequestCallback.setType((byte)19);
            logger.debug("AuthnRequest will be send over HTTP-Redirect binding");
        } else {
            String erroMsg = "AuthnRequest cannot be send to the IDP. Unknown binding: " + this.idp.getIdpSSOBinding();
            logger.error(erroMsg);
            throw new RuntimeException(erroMsg);
        }
        callbacks.add((Callback)authnRequestCallback);
        HttpSetterCallback loginRequestHeaderCallback = this.buildLoginRquestHeaderCallback("login-request");
        callbacks.add((Callback)loginRequestHeaderCallback);
        this.executeCallbacks(callbacks);
    }

    private void executeCallbacks(Collection<Callback> callbacks) {
        try {
            this.callbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
        }
        catch (Exception e) {
            logger.error("Unable to send the AuthnRequest to the IDP", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isAjaxRequest() {
        HttpGetterCallback getAjaxRequestHeader = new HttpGetterCallback();
        getAjaxRequestHeader.setType((byte)1);
        getAjaxRequestHeader.setName("X-Requested-With");
        try {
            this.callbackHandler.handle(new Callback[]{getAjaxRequestHeader});
            return "XMLHttpRequest".equalsIgnoreCase((String)getAjaxRequestHeader.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve request header " + getAjaxRequestHeader.getName() + " to check ajax request. ", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean logout() throws LoginException {
        block30: {
            block28: {
                block27: {
                    block29: {
                        block26: {
                            SAML2JPaaSLoginModule.logger.debug("Entering SAML2JPaaSLoginModule.logout()");
                            principal = null;
                            jpaasPrincipalSet = this.subject.getPrincipals(SAML2Principal.class);
                            SAML2JPaaSLoginModule.logger.debug("saml2principal count in subject {}", (Object)jpaasPrincipalSet.size());
                            if (jpaasPrincipalSet.size() > 1) {
                                SAML2JPaaSLoginModule.logger.error("There are more than one SAML2Principal instances in subject");
                                return false;
                            }
                            if (jpaasPrincipalSet.size() == 1) {
                                principal = jpaasPrincipalSet.iterator().next();
                                SAML2JPaaSLoginModule.logger.debug("principal: {}", (Object)principal);
                                this.subject.getPrincipals().remove(principal);
                                SAML2JPaaSLoginModule.logger.debug("SAML2JPaaSPrincipal [{}] removed from subject", (Object)principal.getName());
                            } else {
                                session = UserSession.getInstance();
                                SAML2JPaaSLoginModule.logger.debug("check for principals in user session");
                                subjectWrapper = (SubjectWrapper)session.getSubject();
                                if (subjectWrapper != null) {
                                    principals = subjectWrapper.getSubject().getPrincipals();
                                    if (principals != null) {
                                        SAML2JPaaSLoginModule.logger.debug("user session principals size: {}", (Object)principals.size());
                                        for (Principal p : principals) {
                                            SAML2JPaaSLoginModule.logger.debug("user session principal: {}", (Object)p);
                                            if (p instanceof SAML2Principal) {
                                                principal = (SAML2Principal)p;
                                                break;
                                            }
                                            SAML2JPaaSLoginModule.logger.debug("Principal is not instance of SAML2Principal");
                                        }
                                    } else {
                                        SAML2JPaaSLoginModule.logger.debug("user session principal set is null");
                                    }
                                }
                            }
                            if (principal == null) break block28;
                            this.initSAML2Configuration();
                            SAML2JPaaSLoginModule.logger.debug("Principal found. Try to send logout request");
                            this.idp = this.saml2Config.getTrustedIdP(principal.getIdPName());
                            localSP = this.saml2Config.getLocalSP();
                            if (this.idp == null) {
                                SAML2JPaaSLoginModule.logger.error("Specified idp in principal " + principal.getIdPName() + " was not found between trusted idp providers for sp " + localSP.getName());
                                return false;
                            }
                            if (!this.idp.getEnabled()) {
                                SAML2JPaaSLoginModule.logger.error("Specified in principal  " + principal.getIdPName() + " is not enabled for sp " + localSP.getName());
                                return false;
                            }
                            SAML2JPaaSLoginModule.logger.debug("Name id format from principal is {}", (Object)principal.getNameIdFormat());
                            if (!localSP.isMultiDomainServiceEnabled()) break block29;
                            SAML2JPaaSLoginModule.logger.debug("logout -> multi domain service enabled");
                            requestUrl = null;
                            requestCallbackHandler = new SAMLGetterCallback();
                            requestCallbackHandler.setType((byte)17);
                            try {
                                this.callbackHandler.handle(new Callback[]{requestCallbackHandler});
                                requestUrl = (String)requestCallbackHandler.getValue();
                            }
                            catch (Exception e) {
                                SAML2JPaaSLoginModule.logger.error("Unable to retreive request url", (Throwable)e);
                                AuditLogUtil.auditLogMessage((String)("Unable to retreive request url: " + e.getMessage()), this.getClass());
                            }
                            authnRequestCallback = new HttpSetterCallback();
                            value = null;
                            callbacks = new ArrayList<Callback>();
                            mdsUrl = String.valueOf(localSP.getEndpointsURL()) + "/" + "saml2/sp/mds";
                            SAML2JPaaSLoginModule.logger.debug("MDS url: {}", (Object)mdsUrl);
                            try {
                                if ("HTTP-POST".equalsIgnoreCase(this.idp.getIdpSLOBinding())) {
                                    value = MultiDomainServiceUtil.createSLORequestHttpBody(Tenant.getId(), requestUrl, mdsUrl, principal, this.idp, localSP);
                                    authnRequestCallback.setType((byte)9);
                                    callbacks.addAll(this.getPOSTBindingHeaderCallbacks());
                                    SAML2JPaaSLoginModule.logger.debug("logout request will be send over HTTP-POST binding");
                                    break block26;
                                }
                                if ("HTTP-Redirect".equalsIgnoreCase(this.idp.getIdpSLOBinding())) {
                                    value = MultiDomainServiceUtil.createSLORequestUrl(Tenant.getId(), requestUrl, mdsUrl, principal, this.idp, localSP);
                                    authnRequestCallback.setType((byte)19);
                                    SAML2JPaaSLoginModule.logger.debug("logout request will be send over HTTP-Redirect binding");
                                    break block26;
                                }
                                SAML2JPaaSLoginModule.logger.error("Logout request cannot be send to the IDP. Unknown binding: " + this.idp.getIdpSLOBinding());
                                return true;
                            }
                            catch (Exception e) {
                                SAML2JPaaSLoginModule.logger.error("Error occured while creating SLO request", (Throwable)e);
                                AuditLogUtil.auditLogMessage((String)("Error occured while creating SLO request: " + e.getMessage()), this.getClass());
                                return true;
                            }
                        }
                        loginRequestHeaderCallback = this.buildLoginRquestHeaderCallback("logout-request");
                        callbacks.add((Callback)loginRequestHeaderCallback);
                        SAML2JPaaSLoginModule.logger.debug("logout request callback value: {}", (Object)value);
                        authnRequestCallback.setValue((Object)value);
                        callbacks.add((Callback)authnRequestCallback);
                        try {
                            this.callbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
                        }
                        catch (Exception e) {
                            SAML2JPaaSLoginModule.logger.error("Unable to send the logout request to the IDP", (Throwable)e);
                            AuditLogUtil.auditLogMessage((String)("Unable to send the logout request to the IDP: " + e.getMessage()), this.getClass());
                        }
                        break block30;
                    }
                    try {
                        block31: {
                            callbacks = new ArrayList<Object>();
                            if (!this.idp.getSLOEndpoints().isEmpty()) break block31;
                            SAML2JPaaSLoginModule.logger.debug("No SLO endpoint found, terminating only local session.");
                            requestUrl = null;
                            requestCallbackHandler = new SAMLGetterCallback();
                            requestCallbackHandler.setType((byte)17);
                            try {
                                this.callbackHandler.handle(new Callback[]{requestCallbackHandler});
                                requestUrl = (String)requestCallbackHandler.getValue();
                            }
                            catch (Exception e) {
                                SAML2JPaaSLoginModule.logger.error("Unable to retreive request url", (Throwable)e);
                                AuditLogUtil.auditLogMessage((String)("Unable to retreive request url: " + e.getMessage()), this.getClass());
                            }
                            redirect = new HttpSetterCallback();
                            redirect.setType((byte)19);
                            redirect.setValue((Object)requestUrl);
                            callbacks.add(redirect);
                            ** GOTO lbl144
                        }
                        logoutRequestCallback = new HttpSetterCallback();
                        value = null;
                        relayState = "ouc" + RelayStateUtil.generateRandomRelayStateString();
                        if ("HTTP-POST".equalsIgnoreCase(this.idp.getIdpSLOBinding())) {
                            value = this.getSAMLAuthenticationInstance().createSLORequestHttpBody((SAML2SPConfiguration)this.saml2Config, principal, relayState);
                            logoutRequestCallback.setType((byte)9);
                            callbacks.addAll(this.getPOSTBindingHeaderCallbacks());
                            SAML2JPaaSLoginModule.logger.debug("LogoutRequest will be send over HTTP-POST binding");
                            break block27;
                        }
                        if ("HTTP-Redirect".equalsIgnoreCase(this.idp.getIdpSLOBinding())) {
                            value = this.getSAMLAuthenticationInstance().createSLORequestUrl((SAML2SPConfiguration)this.saml2Config, principal, relayState);
                            logoutRequestCallback.setType((byte)19);
                            SAML2JPaaSLoginModule.logger.debug("LogoutRequest will be send over HTTP-Redirect binding");
                            break block27;
                        }
                        SAML2JPaaSLoginModule.logger.error("LogoutRequest cannot be send to the IDP. Unknown binding: {}", (Object)this.idp.getIdpSLOBinding());
                        return false;
                    }
                    catch (Exception e) {
                        SAML2JPaaSLoginModule.logger.trace("Error occured while creating/sending the LogoutRequest", (Throwable)e);
                        AuditLogUtil.auditLogMessage((String)("Error occured while creating/sending the LogoutRequest: " + e.getMessage()), this.getClass());
                        return false;
                    }
                }
                RelayStateUtil.setRelayStateCookie(this.callbackHandler, relayState, (SAML2LocalSP)localSP, "");
                logoutRequestCallback.setValue((Object)value);
                callbacks.add(logoutRequestCallback);
lbl144:
                // 2 sources

                loginRequestHeaderCallback = this.buildLoginRquestHeaderCallback("logout-request");
                callbacks.add(loginRequestHeaderCallback);
                this.callbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
            }
            SAML2JPaaSLoginModule.logger.debug("SAML2Principal was not found in subject");
        }
        return true;
    }

    private HttpSetterCallback buildLoginRquestHeaderCallback(String value) {
        HttpSetterCallback loginRequestHeaderCallback = new HttpSetterCallback();
        loginRequestHeaderCallback.setType((byte)1);
        loginRequestHeaderCallback.setName("com.sap.cloud.security.login");
        loginRequestHeaderCallback.setValue((Object)value);
        return loginRequestHeaderCallback;
    }

    private SAML2TrustedIdPJPaaSImpl retrieveIdpProvider(SAML2ConfigurationJPaaSImpl saml2Cfg, CallbackHandler callbackHandler) throws SAML2JPaaSException {
        Collection idpsList = saml2Cfg.getTrustedProviders();
        if (idpsList == null || idpsList.size() == 0) {
            throw new SAML2JPaaSException("There is no trusted idp provider defined for sp " + saml2Cfg.getLocalSP().getName());
        }
        String defaultIdp = null;
        HttpGetterCallback idpParamCallback = new HttpGetterCallback();
        idpParamCallback.setType((byte)3);
        idpParamCallback.setName("saml2idp");
        try {
            callbackHandler.handle(new Callback[]{idpParamCallback});
            String[] value = (String[])idpParamCallback.getValue();
            if (value != null && value.length > 0) {
                defaultIdp = value[0];
            }
            logger.debug("Identity Provider name defined as request parameter is {}", defaultIdp);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve saml2idp as request parameter", (Throwable)e);
            AuditLogUtil.auditLogMessage((String)("Unable to retrieve saml2idp as request parameter: " + e.getMessage()), this.getClass());
        }
        if (defaultIdp == null || defaultIdp.equals("")) {
            defaultIdp = saml2Cfg.getLocalSP().getDefaultIDP();
        }
        if (defaultIdp == null || defaultIdp.equals("")) {
            AuditLogUtil.auditLogMessage((String)("There is no default trusted idp provider defined for sp " + saml2Cfg.getLocalSP().getDefaultIDP()), this.getClass());
            throw new SAML2JPaaSException("There is no default trusted idp provider defined for sp " + saml2Cfg.getLocalSP().getDefaultIDP());
        }
        SAML2TrustedIdPJPaaSImpl result = null;
        for (SAML2TrustedIdPJPaaSImpl idp : idpsList) {
            if (!defaultIdp.equals(idp.getName())) continue;
            if (idp.isUnsolicited()) {
                String errorMessage = String.format("Specified idp %s was unsolicited  and can't be used for authentication.", defaultIdp);
                AuditLogUtil.auditLogMessage((String)errorMessage, this.getClass());
                throw new SAML2JPaaSException(errorMessage);
            }
            result = idp;
            break;
        }
        if (result == null) {
            String errorMessage = String.format("Specified idp %s was not found between trusted idp providers for sp %s", defaultIdp, saml2Cfg.getLocalSP().getDefaultIDP());
            AuditLogUtil.auditLogMessage((String)errorMessage, this.getClass());
            throw new SAML2JPaaSException(errorMessage);
        }
        if (!result.getEnabled()) {
            AuditLogUtil.auditLogMessage((String)("Specified idp " + defaultIdp + " is not enabled for sp " + saml2Cfg.getLocalSP().getDefaultIDP()), this.getClass());
            throw new SAML2JPaaSException("Specified idp " + defaultIdp + " is not enabled for sp " + saml2Cfg.getLocalSP().getDefaultIDP());
        }
        return result;
    }

    private Collection<Callback> getPOSTBindingHeaderCallbacks() {
        ArrayList<Callback> result = new ArrayList<Callback>(3);
        HttpSetterCallback contentTypeCallback = new HttpSetterCallback();
        contentTypeCallback.setType((byte)1);
        contentTypeCallback.setName("Content-Type");
        contentTypeCallback.setValue((Object)"text/html; charset=utf-8");
        result.add((Callback)contentTypeCallback);
        Map cacheControlHeaders = HTTPPostBinding.getCacheControlHeaders();
        for (String headerName : cacheControlHeaders.keySet()) {
            HttpSetterCallback callback = new HttpSetterCallback();
            callback.setType((byte)1);
            callback.setName(headerName);
            callback.setValue(cacheControlHeaders.get(headerName));
            result.add((Callback)callback);
        }
        return result;
    }

    private void initSAML2Configuration() throws LoginException {
        try {
            logger.debug("entering initSAML2Configuration");
            this.saml2Config = this.loadConfiguration();
            if (this.saml2Config != null) {
                if (!this.saml2Config.isEnabled()) {
                    logger.debug("SAML2 Configuration is disabled!");
                    AuditLogUtil.auditLogMessage((String)"SAML2 Configuration is disabled!", this.getClass());
                    throw new LoginException("SAML2 configuration is disabled.");
                }
                if (this.sendAuthnRequest) {
                    try {
                        this.idp = this.retrieveIdpProvider(this.saml2Config, this.callbackHandler);
                    }
                    catch (SAML2JPaaSException e) {
                        logger.error("Error in SAML2 idp configuration. JPaaS SAML2 Login module initialization failed", (Throwable)e);
                        AuditLogUtil.auditLogMessage((String)("Error in SAML2 idp configuration. JPaaS SAML2 Login module initialization failed: " + e.getMessage()), this.getClass());
                        LoginException le = new LoginException("Error in SAML2 configuration trusted idp part. JPaaS SAML2 Login module initialization failed");
                        le.initCause(e);
                        throw le;
                    }
                    catch (Exception e) {
                        logger.error("Error while retrieveing SAML2 idp configuration. JPaaS SAML2 Login module initialization failed", (Throwable)e);
                        AuditLogUtil.auditLogMessage((String)("Error in trusted idp SAML2 configuration. JPaaS SAML2 Login module initialization failed: " + e.getMessage()), this.getClass());
                        LoginException le = new LoginException("Error in trusted idp SAML2 configuration. JPaaS SAML2 Login module initialization failed");
                        le.initCause(e);
                        throw le;
                    }
                } else {
                    logger.debug("JPaaS SAML2 login module is configured in passive mode and no IDP configuration will be loaded");
                }
            } else {
                logger.error("SAML2 json configuration is null. JPaaS SAML2 Login module initialization failed");
                throw new LoginException("SAML2 json configuration is null. JPaaS SAML2 Login module initialization failed");
            }
            logger.debug("exit initSAML2Configuration -> {}", (Object)this.saml2Config);
        }
        catch (Exception t) {
            if (t instanceof LoginException) {
                AuditLogUtil.auditLogMessage((String)("Login error: " + t.getMessage()), this.getClass());
                throw (LoginException)t;
            }
            logger.error("Exception during SAML2 configuration initialization occured", (Throwable)t);
            AuditLogUtil.auditLogMessage((String)("Exception during SAML2 configuration initialization occured: " + t.getMessage()), this.getClass());
            throw new LoginException("Exception during SAML2 configuration initialization occured " + t);
        }
    }

    private SAML2ConfigurationJPaaSImpl loadConfiguration() throws LoginException {
        if (this.adminMode) {
            return this.loadAdminConfiguration();
        }
        return this.loadApplicationConfiguration();
    }

    private SAML2ConfigurationJPaaSImpl loadApplicationConfiguration() throws LoginException {
        try {
            ConfigurationAccessor configurationAccessor = this.createApplicationConfigurationAccessor();
            return configurationAccessor.getConfiguration();
        }
        catch (Exception e) {
            logger.error("Error in SAML2 configuration. JPaaS SAML2 Login module initialization failed", (Throwable)e);
            AuditLogUtil.auditLogMessage((String)("Error in SAML2 configuration. JPaaS SAML2 Login module initialization failed: " + e.getMessage()), this.getClass());
            throw new LoginException("Error in SAML2 configuration. JPaaS SAML2 Login module initialization failed");
        }
    }

    private SAML2ConfigurationJPaaSImpl loadAdminConfiguration() {
        String tenantAlias = this.getTenantAlias();
        logger.debug("Trying to read SAML admin configuration for tenant with alias: [{}].", (Object)tenantAlias);
        String account = System.getenv("HC_ACCOUNT");
        ConfigurationAccessor configurationAccessor = this.createAdminConfigurationAccessor();
        return configurationAccessor.getConfiguration(account, tenantAlias);
    }

    ConfigurationAccessor createAdminConfigurationAccessor() {
        return ConfigurationAccessorFactory.createAdminConfigurationAccessor();
    }

    ConfigurationAccessor createApplicationConfigurationAccessor() {
        return ConfigurationAccessorFactory.createApplicationConfigurationAccessor();
    }

    String getTenantAlias() {
        return Tenant.getData().getAlias();
    }

    private static boolean areDomainsEqual(String host1, String host2) {
        logger.debug("Entering SAML2JPaaSLoginModule.areDomainsEqual() with host1 = [{}] and host2=[{}].", (Object)host1, (Object)host2);
        if (host1 == null || host2 == null) {
            return false;
        }
        if (host1.equals(host2)) {
            return true;
        }
        String domain1 = TenantSessionCookieConfigration.getInstance().getDomain(host1);
        String domain2 = TenantSessionCookieConfigration.getInstance().getDomain(host2);
        if (domain1 == null && domain2 == null) {
            logger.debug("Exiting SAML2JPaaSLoginModule.areDomainsEqual(). Returning false.");
            return false;
        }
        if (domain1 != null && domain1.equals(domain2)) {
            logger.debug("Exiting SAML2JPaaSLoginModule.areDomainsEqual(). Returning true.");
            return true;
        }
        logger.debug("Exiting SAML2JPaaSLoginModule.areDomainsEqual(). Returning false.");
        return false;
    }
}

