/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.sp.service;

import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2TrustedIdPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessorFactory;
import com.sap.core.jpaas.security.saml2.sp.util.UMHelper;
import com.sap.core.jpaas.security.utils.umhelper.UserGroupsService;
import com.sap.security.saml2.commons.Attribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserGroupsServiceImpl
implements UserGroupsService {
    public Set<String> readUserGroups(String idpName, Map<String, List<String>> assertionAttributes) {
        SAML2ConfigurationJPaaSImpl saml2Config = ConfigurationAccessorFactory.createApplicationConfigurationAccessor().getConfiguration();
        SAML2TrustedIdPJPaaSImpl idp = null;
        if (idpName != null && !idpName.trim().equals("")) {
            idp = saml2Config.getTrustedIdP(idpName);
        } else {
            String defaultIdpName = saml2Config.getLocalSP().getDefaultIDP();
            idp = saml2Config.getTrustedIdP(defaultIdpName);
        }
        HashSet<String> allUserGroups = null;
        if (idp != null) {
            List defaultGroups = idp.getDefaultGroupsList();
            List assertionGroupMappings = idp.getAssertionBasedGroupsList();
            Map<String, Attribute> assertionAttributesObjects = this.convertToAssertionAttributesObjects(assertionAttributes);
            allUserGroups = UMHelper.getAllUserGroups(defaultGroups, assertionGroupMappings, assertionAttributesObjects);
        }
        return allUserGroups;
    }

    private Map<String, Attribute> convertToAssertionAttributesObjects(Map<String, List<String>> assertionAttributes) {
        HashMap<String, Attribute> assertionAttributesObjects = new HashMap<String, Attribute>();
        for (String assertionName : assertionAttributes.keySet()) {
            List<String> values = assertionAttributes.get(assertionName);
            Attribute attribute = new Attribute(null, assertionName, values);
            assertionAttributesObjects.put(assertionName, attribute);
        }
        return assertionAttributesObjects;
    }
}

