/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.sp.util;

import com.sap.core.jpaas.security.saml2.service.SAML2ServiceConfiguration;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessor;
import com.sap.core.jpaas.security.saml2.service.cfg.accessor.ConfigurationAccessorFactory;
import com.sap.core.jpaas.security.saml2.sp.util.RelayStateUtil;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.commons.exceptions.SAML2EndpointException;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointsUtil {
    private static final Pattern ADMIN_PATH_INFO_PATTERN = Pattern.compile(".*/.*/admin$");
    private static final Logger logger = LoggerFactory.getLogger(EndpointsUtil.class);

    public static SAML2ConfigurationJPaaSImpl getConfigurationByTenantAlias(String tenantAlias) {
        ConfigurationAccessor configurationAccessor = EndpointsUtil.createApplicationConfigurationAccessor();
        return configurationAccessor.getConfiguration(null, tenantAlias);
    }

    public static SAML2ConfigurationJPaaSImpl getConfiguration(String path) {
        logger.debug("Get configration with path {}", (Object)path);
        String[] accountAndAlias = EndpointsUtil.getAccountAndTenantAliasFromPath(path);
        String account = accountAndAlias[0];
        String tenantAlias = accountAndAlias[1];
        logger.debug("Account [{}], tenant alias[{}] taken from path [{}].", new Object[]{account, tenantAlias, path});
        if (EndpointsUtil.isAdminEndpoint(path)) {
            return EndpointsUtil.readSAML2AdminConfiguration(account, tenantAlias);
        }
        return EndpointsUtil.readSAML2Configuration(path, account, tenantAlias);
    }

    private static SAML2ConfigurationJPaaSImpl readSAML2Configuration(String path, String account, String tenantAlias) {
        ConfigurationAccessor configurationAccessor = EndpointsUtil.createApplicationConfigurationAccessor();
        if (path == null) {
            return EndpointsUtil.getDefaultSAML2Configuration(configurationAccessor);
        }
        if (SAML2ServiceConfiguration.getInstance().getExcludedProviders().contains(path)) {
            logger.debug("Provider {} found in excluded provide list. Switch to old SLO implementation", (Object)path);
            return null;
        }
        return configurationAccessor.getConfiguration(account, tenantAlias);
    }

    private static SAML2ConfigurationJPaaSImpl readSAML2AdminConfiguration(String account, String tenantAlias) {
        ConfigurationAccessor adminCfgAccessor = EndpointsUtil.createAdminConfigurationAccessor();
        return adminCfgAccessor.getConfiguration(account, tenantAlias);
    }

    private static SAML2ConfigurationJPaaSImpl getDefaultSAML2Configuration(ConfigurationAccessor configurationAccessor) {
        return configurationAccessor.getConfiguration(null, null);
    }

    static ConfigurationAccessor createAdminConfigurationAccessor() {
        return ConfigurationAccessorFactory.createAdminConfigurationAccessor();
    }

    static ConfigurationAccessor createApplicationConfigurationAccessor() {
        return ConfigurationAccessorFactory.createApplicationConfigurationAccessor();
    }

    private static boolean isAdminEndpoint(String path) {
        return path != null && ADMIN_PATH_INFO_PATTERN.matcher(path).matches();
    }

    public static String[] getAccountAndTenantAliasFromPath(String path) {
        String account = null;
        String tenantAlias = null;
        if (path != null) {
            String[] parts;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((parts = path.split("/")) != null) {
                if (parts.length == 1) {
                    account = parts[0];
                } else if (parts.length >= 2) {
                    account = parts[0];
                    tenantAlias = parts[1];
                }
            } else {
                logger.debug("Could not retireve saml2 json configuration for path {}", (Object)path);
            }
        }
        return new String[]{account, tenantAlias};
    }

    public static void setResponseContentType(HttpServletResponse httpResponse) {
        String initialContentType = httpResponse.getContentType();
        if (initialContentType == null || initialContentType.trim().length() < 1) {
            logger.debug("HTTP response does not have specified content type. Service Provider will specify \"{}\" as content type.", (Object)"text/html; charset=utf-8");
            httpResponse.setHeader("Content-Type", "text/html; charset=utf-8");
        }
    }

    public static void checkHTTPSRequirements(HttpServletRequest request, HttpServletResponse response, SAML2LocalSP spConfig) throws SAML2EndpointException {
        if (!spConfig.isPlainHTTPConnectionsEnabled() && !request.isSecure()) {
            String fullMessage = "Service Provider SLO endpoint received unsecured request over HTTP that is not allowed.";
            logger.warn(fullMessage);
            throw new SAML2EndpointException(401, fullMessage);
        }
    }

    public static String getOriginalApplicationUrl(HttpServletRequest request, SAML2LocalSP localSP, String relayState, String endpointName) throws SAML2EndpointException {
        if (relayState == null) {
            String fullMessage = String.format("Service Provider endpoint %s could not redirect to original application URL because it has not received RelayState.", endpointName);
            logger.warn(fullMessage);
            throw new SAML2EndpointException(400, fullMessage);
        }
        if (!relayState.startsWith("ouc")) {
            EndpointsUtil.throwBadRequestException("Service Provider endpoint %s could not redirect to original application URL because it could not convert the received RelayState to original application URL.", endpointName);
        }
        String applicationUrl = null;
        HashMap<String, String> relayStateValue = null;
        try {
            relayStateValue = RelayStateUtil.retrieveRelayStateValue(request, localSP, relayState);
        }
        catch (Exception exception) {
            EndpointsUtil.throwBadRequestException("Service Provider endpoint %s could not redirect to original application URL because it could not convert the received RelayState to original application URL.", endpointName);
        }
        if (relayStateValue == null) {
            EndpointsUtil.throwBadRequestException("Service Provider endpoint %s could not redirect to original application URL because it could not get the RelayState value from the request.", endpointName);
        }
        if ((applicationUrl = relayStateValue.get("appUrl")) == null) {
            EndpointsUtil.throwBadRequestException("Service Provider endpoint %s could not redirect to original application URL because it could not convert the received RelayState to original application URL.", endpointName);
        }
        return applicationUrl;
    }

    private static void throwBadRequestException(String message, String endpointName) throws SAML2EndpointException {
        String fullMessage = String.format(message, endpointName);
        logger.error(fullMessage);
        throw new SAML2EndpointException(400, fullMessage);
    }
}

