/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.sp.util;

import com.sap.core.jpaas.security.auth.service.P3PHeaderHandler;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2LocalSPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2TrustedIdPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.json.DomainConfiguration;
import com.sap.core.jpaas.security.saml2.sp.exception.SAML2JPaaSInvalidParameterException;
import com.sap.core.jpaas.security.saml2.sp.util.MultiDomainParams;
import com.sap.engine.lib.xml.signature.crypto.CustomSignature;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.resources.SAML2ResourceBundle;
import com.sap.security.saml2.lib.xmlsecurity.CertificateVerifier;
import com.sap.security.saml2.lib.xmlsecurity.XMLSignatureDOM;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDomainServiceUtil {
    private static final String MDS_SLO_COOKIE_VALUE_SEPARATOR_REGEX = "\\;";
    public static final String MDS_PARAM_TENAT_ID = "tenantId";
    public static final String MDS_PARAM_IDP_NAME = "idpName";
    public static final String MDS_PARAM_REQUEST_URL = "requestUrl";
    public static final String MDS_PARAM_REQUEST_ID = "requestId";
    public static final String MDS_PARAM_RELAY_STATE = "relayState";
    public static final String MDS_PARAM_SIGNATURE = "signature";
    public static final String MDS_PARAM_STATUS = "status";
    public static final String MDS_PARAM_REQUEST = "request";
    public static final String MDS_PARAM_ACTION = "action";
    public static final String MDS_PARAM_PRINCIPAL_NAME = "principalName";
    public static final String MDS_PARAM_PRINCIPAL_NAME_ID = "principalNameId";
    public static final String MDS_PARAM_PRINCIPAL_NAME_ID_FORMAT = "principalNameIdFormat";
    public static final String MDS_PARAM_PRINCIPAL_SESSION_INDEXES = "principalSessionIndexes";
    public static final String MDS_ACTION_SSO = "sso";
    public static final String MDS_ACTION_SLO = "slo";
    public static final String MDS_RELAY_STATE_COOKIE_PREFIX = "mds";
    private static final String HTML_BEGINNING = "<html><head><meta http-equiv=\"cache-control\" content=\"no-cache\" /><meta http-equiv=\"pragma\" content=\"no-cache\" /></head>";
    private static final String HTML_BODY_ANCHOR_COOKIE_PART1 = "<body style=\"background-color:#FFFFFF\" onload=\"var url=window.location.hash;if(url&&0!==url.length){document.cookie='";
    private static final String HTML_BODY_ANCHOR_COOKIE_PART2 = "=&quot;'+encodeURIComponent(url) + '&quot;';}document.forms[0].submit()\"><p><script language=\"javascript\">document.write(\"";
    private static final String HTML_CONTINUATION = "\");</script></p><noscript><p>";
    private static final String FORM_BEGINNING = "</p></noscript><form method=\"post\" action=\"";
    private static final String FORM_BEGINNING_CLOSE = "\">";
    private static final String INPUT_PARAM_TENANT_ID = "<input type=\"hidden\" name=\"tenantId\" value=\"";
    private static final String INPUT_PARAM_IDP_NAME = "<input type=\"hidden\" name=\"idpName\" value=\"";
    private static final String INPUT_PARAM_REQUEST_URL = "<input type=\"hidden\" name=\"requestUrl\" value=\"";
    private static final String INPUT_PARAM_REQUEST_ID = "<input type=\"hidden\" name=\"requestId\" value=\"";
    private static final String INPUT_PARAM_RELAY_STATE = "<input type=\"hidden\" name=\"relayState\" value=\"";
    private static final String INPUT_PARAM_SIGNATURE = "<input type=\"hidden\" name=\"signature\" value=\"";
    private static final String INPUT_PARAM_ACTION = "<input type=\"hidden\" name=\"action\" value=\"";
    private static final String INPUT_PARAM_PRINCIPAL_NAME = "<input type=\"hidden\" name=\"principalName\" value=\"";
    private static final String INPUT_PARAM_PRINCIPAL_NAME_ID = "<input type=\"hidden\" name=\"principalNameId\" value=\"";
    private static final String INPUT_PARAM_PRINCIPAL_NAME_ID_FORMAT = "<input type=\"hidden\" name=\"principalNameIdFormat\" value=\"";
    private static final String INPUT_PARAM_PRINCIPAL_SESSION_INDEXES = "<input type=\"hidden\" name=\"principalSessionIndexes\" value=\"";
    private static final String INPUT_ENDING = "\"/>";
    private static final String SUBMIT_BUTTON = "<noscript><input type=\"submit\" value=\"";
    private static final String FORM_AND_HTML_ENDING = "\"/></noscript></form></body></html>";
    private static final Logger logger = LoggerFactory.getLogger(MultiDomainServiceUtil.class);
    public static final String ENCODING = "UTF-8";
    public static final String MULTI_DOMAIN_TRUSTED_IDP_NAME = "local_multi_domain_idp";
    private static final String DOMAIN_COOKIE_PREFIX = "sso_domains";
    private static final String DOMAIN_LOGOUT_COOKIE_PREFIX = "slo_domains";

    public static String createSSORequestHttpBody(String tenantId, String requestUrl, String requestId, String mdsUrl, String relayState, SAML2TrustedIdPJPaaSImpl idp, SAML2LocalSPJPaaSImpl localSP) throws SAML2Exception {
        return MultiDomainServiceUtil.createRequestHttpBody(tenantId, requestUrl, requestId, mdsUrl, relayState, null, true, idp, localSP);
    }

    public static String createSLORequestHttpBody(String tenantId, String requestUrl, String mdsUrl, SAML2Principal principal, SAML2TrustedIdPJPaaSImpl idp, SAML2LocalSPJPaaSImpl localSP) throws SAML2Exception {
        return MultiDomainServiceUtil.createRequestHttpBody(tenantId, requestUrl, null, mdsUrl, null, principal, false, idp, localSP);
    }

    private static String createRequestHttpBody(String tenantId, String requestUrl, String requestId, String mdsUrl, String relayState, SAML2Principal principal, boolean isSso, SAML2TrustedIdPJPaaSImpl idp, SAML2LocalSPJPaaSImpl localSP) throws SAML2Exception {
        String requestIdEnc = null;
        String relayStateEnc = null;
        String principalNameEnc = null;
        String principalNameIdEnc = null;
        String principalNameIdFormatEnc = null;
        String principalSessionIndexesEnc = null;
        String signatureEnc = null;
        ArrayList<String> toBeSigned = null;
        String idpName = idp.getName();
        DigestAlgorithm digestAlgorithm = idp.getDigestAlgorithm();
        if (isSso) {
            requestIdEnc = SAML2Utils.encodeBase64AsString((String)requestId);
            relayStateEnc = SAML2Utils.encodeBase64AsString((String)relayState);
            toBeSigned = new ArrayList<String>(Arrays.asList(tenantId, idpName, requestUrl, requestId, relayState, MDS_ACTION_SSO));
        } else {
            String principalName = principal.getName();
            String principalNameId = principal.getNameId();
            List principalSessionIndexes = principal.getSessionIndexes();
            String principalNameIdFormat = principal.getNameIdFormat();
            principalNameEnc = SAML2Utils.encodeBase64AsString((String)principalName);
            principalNameIdEnc = SAML2Utils.encodeBase64AsString((String)principalNameId);
            principalNameIdFormatEnc = SAML2Utils.encodeBase64AsString((String)principalNameIdFormat);
            toBeSigned = new ArrayList<String>(Arrays.asList(tenantId, idpName, requestUrl, principalName, principalNameId, principalNameIdFormat, MDS_ACTION_SLO));
            if (principalSessionIndexes != null && principalSessionIndexes.size() > 0) {
                String principalSessionIndexesStr = MultiDomainServiceUtil.join(principalSessionIndexes, ",");
                principalSessionIndexesEnc = SAML2Utils.encodeBase64AsString((String)principalSessionIndexesStr);
                toBeSigned.addAll(principalSessionIndexes);
            }
        }
        PrivateKey privateKey = MultiDomainServiceUtil.getPrivateKey((SAML2LocalSP)localSP);
        signatureEnc = MultiDomainServiceUtil.buildSignature(toBeSigned, privateKey, digestAlgorithm);
        String tenantIdEnc = SAML2Utils.encodeBase64AsString((String)tenantId);
        String idpNameEnc = SAML2Utils.encodeBase64AsString((String)idpName);
        String requestUrlEnc = SAML2Utils.encodeBase64AsString((String)requestUrl);
        SAML2ResourceBundle resourceBundle = SAML2ResourceBundle.getInstance();
        StringBuilder builder = new StringBuilder(500);
        builder.append(HTML_BEGINNING);
        builder.append(HTML_BODY_ANCHOR_COOKIE_PART1);
        builder.append(String.valueOf(relayState) + "_anchor");
        builder.append(HTML_BODY_ANCHOR_COOKIE_PART2);
        builder.append(resourceBundle.getResource("POST_MSG", null));
        builder.append(HTML_CONTINUATION);
        builder.append(resourceBundle.getResource("POST_MSG_NO_SCRIPT", null));
        builder.append(FORM_BEGINNING);
        builder.append(mdsUrl);
        builder.append(FORM_BEGINNING_CLOSE);
        builder.append(INPUT_PARAM_TENANT_ID).append(tenantIdEnc).append(INPUT_ENDING);
        builder.append(INPUT_PARAM_IDP_NAME).append(idpNameEnc).append(INPUT_ENDING);
        builder.append(INPUT_PARAM_REQUEST_URL).append(requestUrlEnc).append(INPUT_ENDING);
        if (isSso) {
            builder.append(INPUT_PARAM_REQUEST_ID).append(requestIdEnc).append(INPUT_ENDING);
            builder.append(INPUT_PARAM_RELAY_STATE).append(relayStateEnc).append(INPUT_ENDING);
            builder.append(INPUT_PARAM_ACTION).append(MDS_ACTION_SSO).append(INPUT_ENDING);
        } else {
            builder.append(INPUT_PARAM_ACTION).append(MDS_ACTION_SLO).append(INPUT_ENDING);
            builder.append(INPUT_PARAM_PRINCIPAL_NAME).append(principalNameEnc).append(INPUT_ENDING);
            builder.append(INPUT_PARAM_PRINCIPAL_NAME_ID).append(principalNameIdEnc).append(INPUT_ENDING);
            builder.append(INPUT_PARAM_PRINCIPAL_NAME_ID_FORMAT).append(principalNameIdFormatEnc).append(INPUT_ENDING);
            if (principalSessionIndexesEnc != null) {
                builder.append(INPUT_PARAM_PRINCIPAL_SESSION_INDEXES).append(principalSessionIndexesEnc).append(INPUT_ENDING);
            }
        }
        builder.append(INPUT_PARAM_SIGNATURE).append(signatureEnc).append(INPUT_ENDING);
        builder.append(SUBMIT_BUTTON);
        builder.append(SAML2ResourceBundle.getInstance().getResource("POST_BUTTON_CONTINUE", null));
        builder.append(FORM_AND_HTML_ENDING);
        return builder.toString();
    }

    public static String createSSORequestUrl(String tenantId, String requestUrl, String requestId, String mdsUrl, String relayState, SAML2TrustedIdPJPaaSImpl idp, SAML2LocalSPJPaaSImpl localSP) throws SAML2Exception {
        return MultiDomainServiceUtil.createRequestUrl(tenantId, requestUrl, requestId, mdsUrl, relayState, null, true, idp, localSP);
    }

    public static String createSLORequestUrl(String tenantId, String requestUrl, String mdsUrl, SAML2Principal principal, SAML2TrustedIdPJPaaSImpl idp, SAML2LocalSPJPaaSImpl localSP) throws SAML2Exception {
        return MultiDomainServiceUtil.createRequestUrl(tenantId, requestUrl, null, mdsUrl, null, principal, false, idp, localSP);
    }

    private static String createRequestUrl(String tenantId, String requestUrl, String requestId, String mdsUrl, String relayState, SAML2Principal principal, boolean isSso, SAML2TrustedIdPJPaaSImpl idp, SAML2LocalSPJPaaSImpl localSP) throws SAML2Exception {
        String requestIdEnc = null;
        String relayStateEnc = null;
        String principalNameEnc = null;
        String principalNameIdEnc = null;
        String principalNameIdFormatEnc = null;
        String principalSessionIndexesEnc = null;
        ArrayList<String> toBeSigned = null;
        String signatureEnc = null;
        String idpName = idp.getName();
        DigestAlgorithm digestAlgorithm = idp.getDigestAlgorithm();
        try {
            if (isSso) {
                requestIdEnc = URLEncoder.encode(requestId, ENCODING);
                relayStateEnc = URLEncoder.encode(relayState, ENCODING);
                toBeSigned = new ArrayList<String>(Arrays.asList(tenantId, idpName, requestUrl, requestId, relayState, MDS_ACTION_SSO));
            } else {
                principalNameEnc = URLEncoder.encode(principal.getName(), ENCODING);
                principalNameIdEnc = URLEncoder.encode(principal.getNameId(), ENCODING);
                principalNameIdFormatEnc = URLEncoder.encode(principal.getNameIdFormat(), ENCODING);
                if (principal.getSessionIndexes() != null && principal.getSessionIndexes().size() > 0) {
                    String principalSessionIndexes = MultiDomainServiceUtil.join(principal.getSessionIndexes(), ",");
                    principalSessionIndexesEnc = URLEncoder.encode(principalSessionIndexes, ENCODING);
                }
                toBeSigned = new ArrayList<String>(Arrays.asList(tenantId, idpName, requestUrl, principal.getName(), principal.getNameId(), principal.getNameIdFormat(), MDS_ACTION_SLO));
                if (principal.getSessionIndexes() != null) {
                    toBeSigned.addAll(principal.getSessionIndexes());
                }
            }
            PrivateKey privateKey = MultiDomainServiceUtil.getPrivateKey((SAML2LocalSP)localSP);
            String buildSignature = MultiDomainServiceUtil.buildSignature(toBeSigned, privateKey, digestAlgorithm);
            signatureEnc = URLEncoder.encode(buildSignature, ENCODING);
            String tenantIdEnc = URLEncoder.encode(tenantId, ENCODING);
            String idpNameEnc = URLEncoder.encode(idpName, ENCODING);
            String requestUrlEnc = URLEncoder.encode(requestUrl, ENCODING);
            StringBuilder builder = new StringBuilder(500);
            builder.append(mdsUrl);
            if (mdsUrl.indexOf(63) < 0) {
                builder.append('?');
            } else {
                builder.append('&');
            }
            builder.append(MDS_PARAM_TENAT_ID).append('=').append(tenantIdEnc);
            builder.append('&').append(MDS_PARAM_IDP_NAME).append('=').append(idpNameEnc);
            builder.append('&').append(MDS_PARAM_REQUEST_URL).append('=').append(requestUrlEnc);
            if (isSso) {
                builder.append('&').append(MDS_PARAM_REQUEST_ID).append('=').append(requestIdEnc);
                builder.append('&').append(MDS_PARAM_RELAY_STATE).append('=').append(relayStateEnc);
                builder.append('&').append(MDS_PARAM_ACTION).append('=').append(MDS_ACTION_SSO);
            } else {
                builder.append('&').append(MDS_PARAM_ACTION).append('=').append(MDS_ACTION_SLO);
                builder.append('&').append(MDS_PARAM_PRINCIPAL_NAME).append('=').append(principalNameEnc);
                builder.append('&').append(MDS_PARAM_PRINCIPAL_NAME_ID).append('=').append(principalNameIdEnc);
                builder.append('&').append(MDS_PARAM_PRINCIPAL_NAME_ID_FORMAT).append('=').append(principalNameIdFormatEnc);
                if (principalSessionIndexesEnc != null) {
                    builder.append('&').append(MDS_PARAM_PRINCIPAL_SESSION_INDEXES).append('=').append(principalSessionIndexesEnc);
                }
            }
            builder.append('&').append(MDS_PARAM_SIGNATURE).append('=').append(signatureEnc);
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new SAML2Exception((Throwable)e);
        }
    }

    public static MultiDomainParams retrieveParams(HttpServletRequest request, boolean isGet) throws SAML2JPaaSInvalidParameterException {
        String tenantId = null;
        String idpName = null;
        String requestUrl = null;
        String requestId = null;
        String signature = null;
        String relayState = null;
        String action = null;
        String principalName = null;
        String principalNameId = null;
        String principalNameIdFormat = null;
        String principalSessionIndexes = null;
        tenantId = request.getParameter(MDS_PARAM_TENAT_ID);
        idpName = request.getParameter(MDS_PARAM_IDP_NAME);
        requestUrl = request.getParameter(MDS_PARAM_REQUEST_URL);
        requestId = request.getParameter(MDS_PARAM_REQUEST_ID);
        signature = request.getParameter(MDS_PARAM_SIGNATURE);
        relayState = request.getParameter(MDS_PARAM_RELAY_STATE);
        action = request.getParameter(MDS_PARAM_ACTION);
        principalName = request.getParameter(MDS_PARAM_PRINCIPAL_NAME);
        principalNameId = request.getParameter(MDS_PARAM_PRINCIPAL_NAME_ID);
        principalNameIdFormat = request.getParameter(MDS_PARAM_PRINCIPAL_NAME_ID_FORMAT);
        principalSessionIndexes = request.getParameter(MDS_PARAM_PRINCIPAL_SESSION_INDEXES);
        if (tenantId == null || "".equals(tenantId.trim())) {
            throw new SAML2JPaaSInvalidParameterException("Mandatory request parameter tenant id is missing.");
        }
        if (idpName == null) {
            throw new SAML2JPaaSInvalidParameterException("Mandatory request parameter IdP name is missing.");
        }
        if (requestUrl == null) {
            throw new SAML2JPaaSInvalidParameterException("Mandatory request parameter request URL is missing.");
        }
        if (signature == null) {
            throw new SAML2JPaaSInvalidParameterException("Mandatory request parameter signature is missing.");
        }
        if (action == null) {
            throw new SAML2JPaaSInvalidParameterException("Mandatory request parameter action is missing.");
        }
        if (MDS_ACTION_SSO.equals(action)) {
            if (requestId == null) {
                throw new SAML2JPaaSInvalidParameterException("Request id parameter is missing.");
            }
        } else {
            if (principalName == null) {
                throw new SAML2JPaaSInvalidParameterException("Principal name parameter is missing.");
            }
            if (principalNameId == null) {
                throw new SAML2JPaaSInvalidParameterException("Principal name id parameter is missing.");
            }
            if (principalNameIdFormat == null) {
                throw new SAML2JPaaSInvalidParameterException("Principal name id format parameter is missing.");
            }
        }
        MultiDomainParams result = new MultiDomainParams();
        if (isGet) {
            result.setTenantId(tenantId);
            result.setIdpName(idpName);
            result.setRequestUrl(requestUrl);
            if (MDS_ACTION_SSO.equals(action)) {
                result.setRequestId(requestId);
                result.setRelayState(relayState);
            } else {
                result.setPrincipalName(principalName);
                result.setPrincipalNameId(principalNameId);
                result.setPrincipalNameIdFormat(principalNameIdFormat);
                result.setPrincipalSessionIndexes(MultiDomainServiceUtil.convertToList(principalSessionIndexes));
            }
            result.setSignature(signature);
            result.setAction(action);
        } else {
            try {
                result.setTenantId(SAML2Utils.decodeBase64AsString((String)tenantId));
                result.setIdpName(SAML2Utils.decodeBase64AsString((String)idpName));
                result.setRequestUrl(SAML2Utils.decodeBase64AsString((String)requestUrl));
                if (MDS_ACTION_SSO.equals(action)) {
                    result.setRequestId(SAML2Utils.decodeBase64AsString((String)requestId));
                    result.setRelayState(SAML2Utils.decodeBase64AsString((String)relayState));
                } else {
                    result.setPrincipalName(SAML2Utils.decodeBase64AsString((String)principalName));
                    result.setPrincipalNameId(SAML2Utils.decodeBase64AsString((String)principalNameId));
                    result.setPrincipalNameIdFormat(SAML2Utils.decodeBase64AsString((String)principalNameIdFormat));
                    result.setPrincipalSessionIndexes(MultiDomainServiceUtil.convertToList(SAML2Utils.decodeBase64AsString((String)principalSessionIndexes)));
                }
                result.setSignature(signature);
                result.setAction(action);
            }
            catch (SAML2Exception e) {
                logger.error("Could not base64 decode url params.", (Throwable)e);
                throw new SAML2JPaaSInvalidParameterException("Could not base64 decode url params.", (Exception)((Object)e));
            }
        }
        return result;
    }

    private static List<String> convertToList(String principalSessionIndexes) {
        if (principalSessionIndexes != null) {
            String[] splittedSessionIndexes = principalSessionIndexes.split(",");
            return new ArrayList<String>(Arrays.asList(splittedSessionIndexes));
        }
        return new ArrayList<String>();
    }

    public static boolean validateParamsSignature(MultiDomainParams params, SAML2LocalSPJPaaSImpl localSP, DigestAlgorithm digestAlgorithm) throws ServletException {
        ArrayList<String> toBeVerified;
        String tenantId = params.getTenantId();
        String idpName = params.getIdpName();
        String requestUrl = params.getRequestUrl();
        String signature = params.getSignature();
        if (MDS_ACTION_SSO.equals(params.getAction())) {
            String requestId = params.getRequestId();
            String relayState = params.getRelayState();
            toBeVerified = new ArrayList<String>(Arrays.asList(tenantId, idpName, requestUrl, requestId, relayState, MDS_ACTION_SSO));
        } else {
            String principalName = params.getPrincipalName();
            String principalNameId = params.getPrincipalNameId();
            String principalNameIdFormat = params.getPrincipalNameIdFormat();
            List<String> principalSessionIndexes = params.getPrincipalSessionIndexes();
            toBeVerified = new ArrayList<String>(Arrays.asList(tenantId, idpName, requestUrl, principalName, principalNameId, principalNameIdFormat, MDS_ACTION_SLO));
            if (principalSessionIndexes != null) {
                toBeVerified.addAll(principalSessionIndexes);
            }
        }
        try {
            return MultiDomainServiceUtil.validateSignature(toBeVerified, signature, localSP, digestAlgorithm);
        }
        catch (SAML2Exception e) {
            logger.error("Error occured while validate signature", (Throwable)e);
            throw new ServletException("Error occured while validate signature", (Throwable)e);
        }
    }

    public static void validateSAML2Cfg(SAML2ConfigurationJPaaSImpl saml2Config, String tenantId, String idpName) throws ServletException {
        if (saml2Config == null) {
            String errorMessage = "Could not validate and process the request, because SAML2 json configuration is null. Initialization failed.";
            logger.error(errorMessage);
            throw new ServletException(errorMessage);
        }
        if (!saml2Config.isEnabled()) {
            String errorMessage = "Could not validate and process the request, because the SAML2 configuration is disabled.";
            logger.error(errorMessage);
            throw new ServletException(errorMessage);
        }
        SAML2LocalSPJPaaSImpl localSP = saml2Config.getLocalSP();
        if (localSP == null) {
            String errorMessage = String.format("Error in SAML2 idp configuration. Initialization failed: Specified SAML json configuration does not conatin SP.", new Object[0]);
            logger.error(errorMessage);
            throw new ServletException(errorMessage);
        }
        SAML2TrustedIdPJPaaSImpl idp = saml2Config.getTrustedIdP(idpName);
        if (idp == null) {
            String errorMessage = String.format("Error in SAML2 idp configuration. Initialization failed: Specified idp %s was not found between trusted idp providers for sp %s", idpName, localSP.getDefaultIDP());
            logger.error(errorMessage);
            throw new ServletException(errorMessage);
        }
        if (!idp.getEnabled()) {
            String errorMessage = String.format("Error in SAML2 idp configuration. Initialization failed: Specified idp %s is not enabled for sp %s.", idpName, localSP.getDefaultIDP());
            logger.error(errorMessage);
            throw new ServletException(errorMessage);
        }
    }

    public static String createMultiDomainCookieName(String account, String tenantAlias) {
        return "sso_domains_" + account + "_" + tenantAlias;
    }

    public static String createMultiDomainLogoutCookieName(String account, String tenantAlias) {
        return "slo_domains_" + account + "_" + tenantAlias;
    }

    public static Cookie getCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie c = cookieArray[n2];
                if (cookieName.equals(c.getName())) {
                    return c;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void updateCookie(String cookieName, String cookieValue, HttpServletResponse response) {
        try {
            Cookie updatedCookie = new Cookie(cookieName, URLEncoder.encode(cookieValue, ENCODING));
            updatedCookie.setHttpOnly(true);
            updatedCookie.setPath("/");
            updatedCookie.setSecure(true);
            response.addCookie(updatedCookie);
            P3PHeaderHandler.handleP3PHeader((HttpServletResponse)response);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("unsupported encoding while encode a cookie value for cookie " + cookieName);
            return;
        }
    }

    public static String[] getDomainsFromCookie(String path, HttpServletRequest request) {
        String cookieName = MultiDomainServiceUtil.getMultiDomainCookieName(path);
        if (cookieName == null) {
            return null;
        }
        Cookie foundCookie = MultiDomainServiceUtil.getCookie(cookieName, request);
        String cookieValue = null;
        if (foundCookie != null) {
            cookieValue = foundCookie.getValue();
        }
        if (cookieValue == null) {
            return null;
        }
        try {
            cookieValue = URLDecoder.decode(cookieValue, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("unsupported encoding while decode a cookie value for cookie " + cookieName);
            return null;
        }
        return cookieValue.split(":");
    }

    public static String getMultiDomainCookieName(String path) {
        String[] splitted = MultiDomainServiceUtil.splitPath(path);
        if (splitted == null) {
            return null;
        }
        return MultiDomainServiceUtil.createMultiDomainCookieName(splitted[0], splitted[1]);
    }

    public static void issueMultiDomainLogoutCookie(String relayState, String requestId, String status, String idpName, boolean isRequest, String path, HttpServletResponse response) {
        String[] splitted = MultiDomainServiceUtil.splitPath(path);
        if (splitted == null) {
            return;
        }
        String cookieName = MultiDomainServiceUtil.createMultiDomainLogoutCookieName(splitted[0], splitted[1]);
        String value = "relayState=" + relayState;
        if (requestId != null) {
            value = String.valueOf(value) + ";" + MDS_PARAM_REQUEST_ID + "=" + requestId;
        }
        if (status != null) {
            value = String.valueOf(value) + ";" + MDS_PARAM_STATUS + "=" + status;
        }
        if (idpName != null) {
            value = String.valueOf(value) + ";" + MDS_PARAM_IDP_NAME + "=" + idpName;
        }
        value = isRequest ? String.valueOf(value) + ";" + MDS_PARAM_REQUEST + "=true" : String.valueOf(value) + ";" + MDS_PARAM_REQUEST + "=false";
        MultiDomainServiceUtil.updateCookie(cookieName, value, response);
    }

    public static DomainConfiguration getDomainConfiguration(List<DomainConfiguration> domainCfg, String domainName) {
        if (domainCfg == null || domainName == null) {
            return null;
        }
        for (DomainConfiguration d : domainCfg) {
            if (!domainName.equals(MultiDomainServiceUtil.getDomain(d.getApplicationDomainSloUrl()))) continue;
            return d;
        }
        return null;
    }

    public static String getMappedDomain(List<DomainConfiguration> domainCfg, String appDomainName) {
        if (logger.isDebugEnabled()) {
            logger.debug("appDomainName: " + appDomainName + " domainCfg: " + domainCfg);
        }
        if (domainCfg == null || appDomainName == null) {
            return null;
        }
        for (DomainConfiguration d : domainCfg) {
            String domainName = MultiDomainServiceUtil.getDomain(d.getApplicationDomainSloUrl());
            if (logger.isDebugEnabled()) {
                logger.debug("domain name: " + domainName);
            }
            if (domainName.indexOf(appDomainName) == -1 && appDomainName.indexOf(domainName) == -1) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("mapped domain name: " + domainName);
            }
            return domainName;
        }
        return null;
    }

    public static String getDomain(String url) {
        if (url == null) {
            return null;
        }
        String domain = url;
        if (domain.indexOf("//") != -1) {
            domain = domain.substring(domain.indexOf("//") + 2);
        }
        if (domain.indexOf(47) != -1) {
            domain = domain.substring(0, domain.indexOf(47));
        }
        if (domain.indexOf(63) != -1) {
            domain = domain.substring(0, domain.indexOf(63));
        }
        if (domain.indexOf(58) != -1) {
            domain = domain.substring(0, domain.indexOf(58));
        }
        return domain;
    }

    public static String[] splitPath(String path) {
        String[] parts;
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((parts = path.split("/")).length == 2) {
            return parts;
        }
        if (parts.length == 1) {
            return new String[]{parts[0], ""};
        }
        return null;
    }

    public static void clearCookie(String name, HttpServletResponse response) {
        Cookie updatedCookie = new Cookie(name, "0");
        updatedCookie.setHttpOnly(true);
        updatedCookie.setPath("/");
        updatedCookie.setSecure(true);
        updatedCookie.setMaxAge(0);
        response.addCookie(updatedCookie);
        P3PHeaderHandler.handleP3PHeader((HttpServletResponse)response);
    }

    public static MultiDomainParams clearMultiDomainLogoutCookie(String path, HttpServletRequest request, HttpServletResponse response) {
        String multiDomainSLOCookieName = MultiDomainServiceUtil.getMultiDomainCookieNameFromRequestPath(path);
        if (multiDomainSLOCookieName == null) {
            return null;
        }
        MultiDomainServiceUtil.clearCookie(multiDomainSLOCookieName, response);
        String multiDomainSLOCookieValue = MultiDomainServiceUtil.getCookieValue(multiDomainSLOCookieName, request);
        return MultiDomainServiceUtil.createMultiDomainParametersFromCookieValue(multiDomainSLOCookieValue);
    }

    private static MultiDomainParams createMultiDomainParametersFromCookieValue(String multiDomainSLOCookieValue) {
        String[] multiDomainSLOCookieParams = multiDomainSLOCookieValue.split(MDS_SLO_COOKIE_VALUE_SEPARATOR_REGEX);
        logger.debug("Multi domain coolie value [{}] split in {} parts", (Object)multiDomainSLOCookieValue, (Object)multiDomainSLOCookieParams.length);
        MultiDomainParams result = new MultiDomainParams();
        String[] stringArray = multiDomainSLOCookieParams;
        int n = multiDomainSLOCookieParams.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String[] keyValuePair = part.split("=");
            String key = keyValuePair[0];
            String value = keyValuePair.length > 1 ? keyValuePair[1] : "";
            MultiDomainServiceUtil.updateMultiDomainParams(result, key, value);
            ++n2;
        }
        return result;
    }

    private static String getMultiDomainCookieNameFromRequestPath(String path) {
        String[] split = MultiDomainServiceUtil.splitPath(path);
        if (split == null) {
            logger.error("Error occured during multi domain logout");
            return null;
        }
        return MultiDomainServiceUtil.createMultiDomainLogoutCookieName(split[0], split[1]);
    }

    private static String getCookieValue(String cookieName, HttpServletRequest request) {
        Cookie multiDomainCookie = MultiDomainServiceUtil.getCookie(cookieName, request);
        if (multiDomainCookie == null) {
            return null;
        }
        try {
            return URLDecoder.decode(multiDomainCookie.getValue(), ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("unsupported encoding while decode a cookie value for cookie {} ", (Object)cookieName);
            return null;
        }
    }

    private static void updateMultiDomainParams(MultiDomainParams result, String key, String value) {
        if (MDS_PARAM_RELAY_STATE.equals(key)) {
            result.setRelayState(value);
        } else if (MDS_PARAM_REQUEST_ID.equals(key)) {
            result.setRequestId(value);
        } else if (MDS_PARAM_STATUS.equals(key)) {
            result.setStatus(value);
        } else if (MDS_PARAM_IDP_NAME.equals(key)) {
            result.setIdpName(value);
        } else if (MDS_PARAM_REQUEST.equals(key)) {
            result.setRequest(Boolean.parseBoolean(value));
        }
    }

    private static Certificate getCertificateForSignature(SAML2LocalSP localSP) throws SAML2Exception {
        try {
            Certificate certificateForSignature = localSP.getCertificateForSignature();
            return certificateForSignature;
        }
        catch (SAML2ConfigurationException e) {
            logger.error("Error occured while validating the signature", (Throwable)e);
            throw new SAML2Exception("Error occured while validating the signature", (Throwable)e);
        }
    }

    private static PrivateKey getPrivateKey(SAML2LocalSP localSP) throws SAML2Exception {
        try {
            PrivateKey key = localSP.getPrivateKeyForSignature();
            return key;
        }
        catch (SAML2ConfigurationException e) {
            logger.error("Error occured while getting private key for signature", (Throwable)e);
            throw new SAML2Exception("Error occured while getting private key for signature", (Throwable)e);
        }
    }

    private static String buildSignature(List<String> toBeSigned, PrivateKey privateKey, DigestAlgorithm digestAlgorithm) throws SAML2Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("buildSignature called");
        }
        StringBuffer data = new StringBuffer(500);
        int i = 0;
        while (i < toBeSigned.size()) {
            data.append(toBeSigned.get(i));
            ++i;
        }
        String sigAlg = MultiDomainServiceUtil.getSignatureAlg(privateKey, digestAlgorithm);
        byte[] signatureValue = MultiDomainServiceUtil.calculateSignature(data.toString(), privateKey, sigAlg);
        String base64EncodedSignatureValue = SAML2Utils.encodeBase64((byte[])signatureValue);
        base64EncodedSignatureValue = base64EncodedSignatureValue.replaceAll("\\s", "");
        return base64EncodedSignatureValue;
    }

    private static boolean validateSignature(List<String> toBeVerified, String signatureValue, SAML2LocalSPJPaaSImpl localSP, DigestAlgorithm digestAlgorithm) throws SAML2Exception {
        StringBuffer data = new StringBuffer(500);
        int i = 0;
        while (i < toBeVerified.size()) {
            data.append(toBeVerified.get(i));
            ++i;
        }
        Certificate certificateForSignature = MultiDomainServiceUtil.getCertificateForSignature((SAML2LocalSP)localSP);
        PrivateKey privateKey = MultiDomainServiceUtil.getPrivateKey((SAML2LocalSP)localSP);
        String sigAlg = MultiDomainServiceUtil.getSignatureAlg(privateKey, digestAlgorithm);
        byte[] sigValue = SAML2Utils.decodeBase64((String)signatureValue);
        return MultiDomainServiceUtil.verifySignature(data.toString(), certificateForSignature, sigAlg, sigValue);
    }

    private static String getSignatureAlg(PrivateKey key, DigestAlgorithm digestAlgorithm) throws SAML2Exception {
        String digestAlgorithmName = null;
        if (digestAlgorithm != null) {
            digestAlgorithmName = digestAlgorithm.getName();
        }
        if (digestAlgorithmName == null) {
            digestAlgorithmName = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        return XMLSignatureDOM.extractSignatureAlgorithm((PrivateKey)key, (String)digestAlgorithmName);
    }

    private static byte[] calculateSignature(String dataForSign, PrivateKey key, String signatureAlgorithmURI) throws SAML2Exception {
        Reusable reusable = null;
        try {
            byte[] signedValue;
            reusable = Reusable.getInstance((String)signatureAlgorithmURI);
            CustomSignature sig = (CustomSignature)reusable;
            sig.initSign((Key)key);
            sig.update(dataForSign.getBytes(ENCODING));
            byte[] byArray = signedValue = sig.sign();
            return byArray;
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to calculate " + signatureAlgorithmURI + " signature for: " + dataForSign, (Throwable)e);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    private static boolean verifySignature(String dataForVerify, Certificate cert, String sigAlg, byte[] sigValue) throws SAML2Exception {
        CertificateVerifier.getInstance().verifyCertificate(cert);
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance((String)sigAlg);
            CustomSignature sig = (CustomSignature)reusable;
            byte[] toCheck = sigValue;
            sig.initVerify((Key)cert.getPublicKey());
            sig.update(dataForVerify.getBytes(ENCODING));
            boolean bl = sig.verify(toCheck);
            return bl;
        }
        catch (Exception e) {
            throw new SAML2Exception("Unable to validate signature", (Throwable)e);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    private static String join(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

