/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.sp.util;

import com.sap.core.jpaas.security.auth.service.P3PHeaderHandler;
import com.sap.core.jpaas.security.auth.service.TenantSessionCookieConfigration;
import com.sap.core.jpaas.security.saml2.sp.exception.SAML2JPaaSException;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.security.auth.callback.ExtractCookiesCallback;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayStateUtil {
    private static final String BEGINNING_OF_TIME = "0; Max-Age=0; Expires=Thu, 01-Jan-1970 00:00:10 GMT";
    private static final int DEFAULT_LENGTH = 20;
    private static final SecureRandom random = new SecureRandom();
    private static final String COOKIE_NAME_PREFIX = "ouc";
    private static final Logger logger = LoggerFactory.getLogger(RelayStateUtil.class);
    private static TenantSessionCookieConfigration tenantSessionCookieConfig = TenantSessionCookieConfigration.getInstance();

    public static void setRelayStateCookie(CallbackHandler callbackHandler, String relayState, SAML2LocalSP localSP, String requestId) {
        HttpGetterCallback requestUrlCallback = new HttpGetterCallback();
        requestUrlCallback.setType((byte)17);
        try {
            callbackHandler.handle(new Callback[]{requestUrlCallback});
            String requestUrl = (String)requestUrlCallback.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Url that will be put in relay state: " + requestUrl);
            }
            String cookie = RelayStateUtil.generateCookieValue(requestUrl, requestId, false, localSP);
            cookie = String.valueOf(cookie) + RelayStateUtil.generateRelayStateCookieAttributes(callbackHandler);
            logger.debug("Relay State Cookie Value: {}", (Object)cookie);
            HttpSetterCallback cookieCallback = new HttpSetterCallback();
            cookieCallback.setType((byte)2);
            cookieCallback.setName(relayState);
            cookieCallback.setValue((Object)cookie);
            callbackHandler.handle(new Callback[]{cookieCallback});
        }
        catch (Exception e) {
            logger.trace("Unable to set RelayState cookie", (Throwable)e);
        }
    }

    public static HashMap<String, String> removeRelayStateCookie(CallbackHandler callbackHandler, String relayState, SAML2LocalSP localSP) {
        HttpGetterCallback cookieGetterCallback = new HttpGetterCallback();
        cookieGetterCallback.setType((byte)2);
        cookieGetterCallback.setName(relayState);
        HttpSetterCallback cookieSetterCallback = new HttpSetterCallback();
        cookieSetterCallback.setType((byte)2);
        cookieSetterCallback.setName(relayState);
        cookieSetterCallback.setValue((Object)(BEGINNING_OF_TIME + RelayStateUtil.generateRelayStateCookieAttributes(callbackHandler)));
        try {
            callbackHandler.handle(new Callback[]{cookieGetterCallback, cookieSetterCallback});
            String cookie = (String)cookieGetterCallback.getValue();
            if (cookie != null) {
                return RelayStateUtil.parseRelayStateCookieValue(cookie, localSP);
            }
            logger.error("No cookie found for name " + relayState);
        }
        catch (Exception e) {
            logger.error("Unable to remove RelayState cookie", (Throwable)e);
        }
        return null;
    }

    public static String retrieveURLAnchorPart(CallbackHandler callbackHandler, String relayState) {
        HttpGetterCallback cookieGetterCallback = new HttpGetterCallback();
        cookieGetterCallback.setType((byte)2);
        cookieGetterCallback.setName(String.valueOf(relayState) + "_anchor");
        HttpSetterCallback cookieSetterCallback = new HttpSetterCallback();
        cookieSetterCallback.setType((byte)2);
        cookieSetterCallback.setName(String.valueOf(relayState) + "_anchor");
        cookieSetterCallback.setValue((Object)BEGINNING_OF_TIME);
        try {
            callbackHandler.handle(new Callback[]{cookieGetterCallback, cookieSetterCallback});
            String cookie = (String)cookieGetterCallback.getValue();
            if (cookie != null) {
                String anchorPart = URLDecoder.decode(cookie, "utf-8");
                if (logger.isDebugEnabled()) {
                    logger.debug("Retrived anchor part: " + anchorPart);
                }
                return anchorPart;
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve anchor part from application URL", (Throwable)e);
        }
        return null;
    }

    public static void removeRelayStateCookie(HttpServletRequest request, HttpServletResponse response, String relayState) {
        String host = request.getServerName();
        String domain = tenantSessionCookieConfig.getDomain(host);
        response.addHeader("set-cookie", String.valueOf(relayState) + "=0; Max-Age=0; Expires=Thu, 01-Jan-1970 00:00:10 GMT" + RelayStateUtil.generateRelayStateCookieAttributes(request, response, domain));
        P3PHeaderHandler.handleP3PHeader((HttpServletResponse)response);
    }

    public static void removeRelayStateCookieForAllMatchingDomains(HttpServletRequest request, HttpServletResponse response, String relayState) {
        response.addHeader("set-cookie", String.valueOf(relayState) + "=0; Max-Age=0; Expires=Thu, 01-Jan-1970 00:00:10 GMT" + RelayStateUtil.generateRelayStateCookieAttributes(request, response, null));
        P3PHeaderHandler.handleP3PHeader((HttpServletResponse)response);
        String host = request.getServerName();
        Set domains = tenantSessionCookieConfig.getAllMatchingDomains(host);
        if (domains != null) {
            for (String domain : domains) {
                response.addHeader("set-cookie", String.valueOf(relayState) + "=0; Max-Age=0; Expires=Thu, 01-Jan-1970 00:00:10 GMT" + RelayStateUtil.generateRelayStateCookieAttributes(request, response, domain));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("No matching domains were found for host: " + host);
        }
    }

    public static void removeTenantCookies(HttpServletRequest request, HttpServletResponse response) {
        try {
            String cookieNamePrefix = tenantSessionCookieConfig.getCookieNamePrefix();
            if (logger.isDebugEnabled()) {
                logger.debug("Removing tenant session cookie: " + cookieNamePrefix);
            }
            String host = request.getServerName();
            String domain = tenantSessionCookieConfig.getDomain(host);
            Cookie[] cookies = request.getCookies();
            if (cookies == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("There are not tenant cookies found in the request.");
                }
                return;
            }
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().contains(cookieNamePrefix)) {
                    RelayStateUtil.removeTenantCookie(request, response, cookie.getName(), domain);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error("Problem while removing tenant session cookie. Problems may occur with SingleLogout later on.", (Throwable)e);
        }
    }

    public static void removeTenantCookie(HttpServletRequest request, HttpServletResponse response, String tenantSessionCookieName, String domain) {
        Cookie cookie = new Cookie(tenantSessionCookieName, "0");
        cookie.setValue("0");
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(0);
        String tenantSessionCookieDomain = TenantSessionCookieConfigration.getInstance().getDomain(request.getServerName());
        if (tenantSessionCookieDomain != null) {
            cookie.setDomain(tenantSessionCookieDomain);
        }
        response.addCookie(cookie);
        P3PHeaderHandler.handleP3PHeader((HttpServletResponse)response);
        logger.debug("Removing tenant cookie with name: {} and domain {}", (Object)tenantSessionCookieName, (Object)cookie.getDomain());
    }

    public static String generateRandomRelayStateString() {
        return RelayStateUtil.randomString(20);
    }

    public static HashMap<String, String> retrieveRelayStateValue(HttpServletRequest request, SAML2LocalSP localSP, String relayState) throws SAML2Exception, SAML2JPaaSException {
        String cookieValue = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equalsIgnoreCase(relayState)) {
                    cookieValue = cookie.getValue();
                    break;
                }
                ++n2;
            }
        }
        return RelayStateUtil.parseRelayStateCookieValue(cookieValue, localSP);
    }

    public static void removeOldCookies(CallbackHandler callbackHandler, SAML2LocalSP localSP) {
        ExtractCookiesCallback cookiesCallback = new ExtractCookiesCallback();
        try {
            callbackHandler.handle(new Callback[]{cookiesCallback});
            Cookie[] cookies = (Cookie[])cookiesCallback.getCookies();
            List<Cookie> oldCookies = RelayStateUtil.listOldCookies(cookies, localSP);
            for (Cookie cookie : oldCookies) {
                RelayStateUtil.removeCookie(callbackHandler, cookie);
            }
        }
        catch (Exception e) {
            logger.error("Unable to remove old relaystate cookies", (Throwable)e);
        }
    }

    public static List<Cookie> listOldCookies(Cookie[] allCookies, SAML2LocalSP localSP) {
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        try {
            if (allCookies == null) {
                return result;
            }
            if (allCookies.length < 10) {
                return result;
            }
            Cookie[] cookieArray = allCookies;
            int n = allCookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie != null && (RelayStateUtil.isOriginalUrlCookieName(cookie.getName()) || RelayStateUtil.isMdsRelayStateCookieName(cookie.getName()))) {
                    try {
                        long maxLifeTime;
                        long timestamp = RelayStateUtil.extractRelayCookieCreationTime(localSP, cookie);
                        if (timestamp != 0L && (maxLifeTime = timestamp + 60000L) < System.currentTimeMillis()) {
                            result.add(cookie);
                        }
                    }
                    catch (SAML2JPaaSException sAML2JPaaSException) {}
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error("Unable to list old relaystate cookies", (Throwable)e);
        }
        return result;
    }

    private static void removeCookie(CallbackHandler callbackHandler, Cookie cookie) throws IOException, UnsupportedCallbackException {
        HttpSetterCallback cookieSetterCallback = new HttpSetterCallback();
        cookieSetterCallback.setType((byte)2);
        cookieSetterCallback.setName(cookie.getName());
        cookieSetterCallback.setValue((Object)(BEGINNING_OF_TIME + RelayStateUtil.generateRelayStateCookieAttributes(callbackHandler)));
        callbackHandler.handle(new Callback[]{cookieSetterCallback});
    }

    private static long extractRelayCookieCreationTime(SAML2LocalSP localSP, Cookie cookie) throws SAML2JPaaSException, SAML2Exception {
        String relayStateCookieTimestamp;
        long timestamp = 0L;
        HashMap<String, String> relayStateCookieValues = RelayStateUtil.parseRelayStateCookieValue(cookie.getValue(), localSP);
        if (relayStateCookieValues != null && (relayStateCookieTimestamp = relayStateCookieValues.get("timestamp")) != null) {
            timestamp = Long.parseLong(relayStateCookieTimestamp);
        }
        return timestamp;
    }

    private static HashMap<String, String> parseRelayStateCookieValue(String cookieValue, SAML2LocalSP localSP) throws SAML2JPaaSException, SAML2Exception {
        HashMap<String, String> result = null;
        if (cookieValue != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Original application URL cookie value: {}", (Object)cookieValue);
            }
            String decryptedValue = RelayStateUtil.decodeRelayStateValue(cookieValue, localSP);
            if (logger.isDebugEnabled()) {
                logger.debug("Decrypted original application URL cookie value: {}", (Object)decryptedValue);
            }
            String[] parts = decryptedValue.split(";");
            result = RelayStateUtil.parsePairs(parts);
        } else {
            logger.warn("Original application URL cookie not found in HTTP request.");
        }
        return result;
    }

    private static String randomString(int len) {
        char[] chars = new char[len + 2];
        chars[0] = 114;
        chars[1] = 115;
        int i = 2;
        while (i < chars.length) {
            chars[i] = (char)(97 + random.nextInt(26));
            ++i;
        }
        return String.valueOf(chars);
    }

    public static String generateCookieValue(String applicationUrl, String requestId, boolean isProxying, SAML2LocalSP localSP) throws NoSuchAlgorithmException, SAML2JPaaSException, SAML2Exception {
        String appPart = RelayStateUtil.generateKeyValuePair("appUrl", applicationUrl);
        String reqPart = RelayStateUtil.generateKeyValuePair("reqId", requestId);
        String proxyPart = RelayStateUtil.generateKeyValuePair("proxy", String.valueOf(isProxying));
        String timestamp = RelayStateUtil.generateKeyValuePair("timestamp", String.valueOf(System.currentTimeMillis()));
        String randomPart = RelayStateUtil.generateRandomPart();
        StringBuilder value = new StringBuilder();
        value.append(randomPart).append(";");
        value.append(appPart).append(";");
        value.append(reqPart).append(";");
        value.append(timestamp).append(";");
        value.append(proxyPart);
        String plainValue = value.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Plain original application URL cookie value: {}", new Object[]{plainValue});
        }
        String encryptedValue = RelayStateUtil.encodeRelayStateValue(plainValue, localSP);
        if (logger.isDebugEnabled()) {
            logger.debug("Encrypted original application URL cookie value: {}", new Object[]{encryptedValue});
        }
        return encryptedValue;
    }

    private static String generateKeyValuePair(String name, String value) throws SAML2Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("=").append(SAML2Utils.encodeBase64AsString((String)value));
        if (logger.isDebugEnabled()) {
            logger.debug("Name-value pair [name = {}, value = {}] added to original application URL cookie value.", new Object[]{name, value});
        }
        return sb.toString();
    }

    private static String encodeRelayStateValue(String value, SAML2LocalSP localSP) throws SAML2JPaaSException {
        try {
            byte[] keyBytes = RelayStateUtil.getSymmetricKey(localSP);
            SecretKeySpec symmetricKey = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec initVector = new IvParameterSpec(RelayStateUtil.getInitializationVector(localSP));
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)symmetricKey, initVector);
            byte[] encryptedBytes = cipher.doFinal(value.getBytes("UTF-8"));
            if (logger.isDebugEnabled()) {
                logger.debug("Relay state value successfully encrypted");
            }
            String base64Encoded = SAML2Utils.encodeBase64((byte[])encryptedBytes);
            String urlEncoded = URLEncoder.encode(base64Encoded, "UTF-8");
            return urlEncoded;
        }
        catch (Exception e) {
            logger.warn("Could not encrypt original application URL cookie.", (Throwable)e);
            throw new SAML2JPaaSException("Could not encrypt original application URL cookie", e);
        }
    }

    private static String generateRandomPart() throws NoSuchAlgorithmException, SAML2Exception {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] seed = random.generateSeed(10);
        random.setSeed(seed);
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return SAML2Utils.encodeBase64((byte[])bytes);
    }

    private static byte[] getSymmetricKey(SAML2LocalSP localSP) throws SAML2ConfigurationException, SAML2JPaaSException {
        PrivateKey privateKey = localSP.getPrivateKeyForEncryption();
        if (privateKey == null) {
            throw new SAML2JPaaSException("Original application URL cookie could not be encrypted because the private key for encryption is not configured");
        }
        byte[] bytes = new byte[16];
        System.arraycopy(privateKey.getEncoded(), 0, bytes, 0, 16);
        return bytes;
    }

    private static byte[] getInitializationVector(SAML2LocalSP localSP) throws SAML2ConfigurationException, SAML2JPaaSException {
        PrivateKey privateKey = localSP.getPrivateKeyForEncryption();
        if (privateKey == null) {
            throw new SAML2ConfigurationException("Original application URL cookie could not be ecrypted because the private key for encryption is not configured");
        }
        byte[] bytes = new byte[16];
        System.arraycopy(privateKey.getEncoded(), 16, bytes, 0, 16);
        return bytes;
    }

    private static String decodeRelayStateValue(String value, SAML2LocalSP localSP) throws SAML2JPaaSException {
        try {
            String decodedString = URLDecoder.decode(value, "UTF-8");
            byte[] decodedBytes = SAML2Utils.decodeBase64((String)decodedString);
            byte[] keyBytes = RelayStateUtil.getSymmetricKey(localSP);
            SecretKeySpec symmetricKey = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec initVector = new IvParameterSpec(RelayStateUtil.getInitializationVector(localSP));
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)symmetricKey, initVector);
            String decryptedString = new String(cipher.doFinal(decodedBytes), "UTF-8");
            if (logger.isDebugEnabled()) {
                logger.debug("Original application URL cookie successfully decrypted.");
            }
            return decryptedString;
        }
        catch (Exception e) {
            logger.warn("Could not decrypt original application URL cookie.", (Throwable)e);
            throw new SAML2JPaaSException("Could not decrypt original application URL cookie.", e);
        }
    }

    private static HashMap<String, String> parsePairs(String[] pairs) throws SAML2Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            int pos = pair.indexOf(61);
            if (pos != -1) {
                String key = pair.substring(0, pos);
                String value = pair.substring(pos + 1);
                if (value.length() > 0) {
                    value = SAML2Utils.decodeBase64AsString((String)value);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Value [{}] extracted from name-value pair with key [{}] from original application URL cookie value.", new Object[]{value, key});
                    }
                }
                result.put(key, value);
            }
            ++n2;
        }
        return result;
    }

    private static String generateRelayStateCookieAttributes(HttpServletRequest request, HttpServletResponse response, String domain) {
        boolean isSecure = request.isSecure();
        String result = RelayStateUtil.generateRelayStateCookieAttributes(isSecure, domain);
        return result;
    }

    public static String generateRelayStateCookieAttributes(boolean isSecure, String domain) {
        StringBuilder sb = new StringBuilder();
        if (domain != null) {
            sb.append("; Domain=").append(domain);
        }
        sb.append("; Path=/");
        if (isSecure) {
            sb.append("; Secure");
        }
        sb.append("; HttpOnly");
        return sb.toString();
    }

    private static String generateRelayStateCookieAttributes(CallbackHandler callbackHandler) {
        boolean isSecure = false;
        String host = null;
        try {
            HttpGetterCallback getterServerNameCallback = new HttpGetterCallback();
            getterServerNameCallback.setType((byte)27);
            HttpGetterCallback isSecureCallback = new HttpGetterCallback();
            isSecureCallback.setType((byte)7);
            callbackHandler.handle(new Callback[]{getterServerNameCallback, isSecureCallback});
            host = (String)getterServerNameCallback.getValue();
            isSecure = (Boolean)isSecureCallback.getValue();
        }
        catch (Exception e) {
            logger.error("Error getting server name header and is secure values", (Throwable)e);
        }
        String domain = tenantSessionCookieConfig.getDomain(host);
        String result = RelayStateUtil.generateRelayStateCookieAttributes(isSecure, domain);
        return result;
    }

    public static boolean isOriginalUrlCookieName(String name) {
        return name != null && name.startsWith(COOKIE_NAME_PREFIX);
    }

    public static boolean isMdsRelayStateCookieName(String name) {
        return name != null && name.startsWith("mds");
    }
}

