/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.saml2.sp.util;

import com.sap.core.jpaas.security.saml2.service.cfg.SAML2TrustedIdPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.json.AssertionBasedAttribute;
import com.sap.core.jpaas.security.saml2.service.cfg.json.AssertionBasedGroup;
import com.sap.core.jpaas.security.saml2.service.cfg.json.AssertionRule;
import com.sap.core.jpaas.security.saml2.service.cfg.json.DefaultAttribute;
import com.sap.core.jpaas.security.saml2.sp.exception.SAML2JPaaSException;
import com.sap.core.jpaas.security.saml2.sp.loginmodule.SAML2JPaaSPrincipal;
import com.sap.core.jpaas.security.saml2.sp.util.UserAttribute;
import com.sap.security.saml2.commons.Attribute;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.um.service.api.ModifiableUserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.modify.ModifiableUser;
import com.sap.security.um.user.modify.ModifiableUserEx;
import com.sap.security.um.user.modify.ModifiableUserProvider;
import com.sap.security.um.user.modify.ReadonlyAttributeException;
import com.sap.security.um.user.modify.UnsupportedUserAttributeValueException;
import com.sap.security.um.user.modify.UnsupportedUserNameException;
import com.sap.security.um.user.modify.UserAlreadyExistsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMHelper {
    private static final Logger logger = LoggerFactory.getLogger(UMHelper.class);

    public static SAML2JPaaSPrincipal createSAML2JPaaSPrincipal(SAML2Principal samlPrincipal, SAML2TrustedIdPJPaaSImpl idp) throws SAML2JPaaSException {
        String principalName = samlPrincipal.getName();
        Set attributes = samlPrincipal.getAttributes();
        Map<String, Attribute> assertionAttributes = UMHelper.organizeSAMLPrincipalAttributes(attributes);
        logger.debug("Assertion attributes: [{}]", assertionAttributes);
        List<UserAttribute> userAttributes = UMHelper.calculateUserAttributes(assertionAttributes, idp);
        HashSet<String> allUserGroups = UMHelper.calculateUserGroups(assertionAttributes, idp);
        String name = UMHelper.generateJPaaSPrincipalName(principalName, idp, assertionAttributes);
        return new SAML2JPaaSPrincipal(name, samlPrincipal, userAttributes, allUserGroups);
    }

    public static HashSet<String> calculateUserGroups(Map<String, Attribute> assertionAttributes, SAML2TrustedIdPJPaaSImpl idp) {
        logger.debug("Trying to resolve all user groups.");
        List assertionBasedGroupsList = idp.getAssertionBasedGroupsList();
        logger.debug("Assertion based groups read from the SAML configuration: [{}]", (Object)assertionBasedGroupsList);
        List defaultGroupsList = idp.getDefaultGroupsList();
        logger.debug("Default groups read from the SAML configuration: [{}]", (Object)defaultGroupsList);
        HashSet<String> allUserGroups = UMHelper.getAllUserGroups(defaultGroupsList, assertionBasedGroupsList, assertionAttributes);
        logger.debug("Resolved user groups: [{}]", allUserGroups);
        return allUserGroups;
    }

    public static List<UserAttribute> calculateUserAttributes(Map<String, Attribute> assertionAttributes, SAML2TrustedIdPJPaaSImpl idp) throws SAML2JPaaSException {
        logger.debug("Trying to resolve all user attributes.");
        List assertionToPrincipalAttributesMappings = idp.getAssertionBasedAttributesList();
        logger.debug("Assertion based attributes read from the SAML configuration: [{}]", (Object)assertionToPrincipalAttributesMappings);
        List defaultAttributesList = idp.getDefaultAttributesList();
        logger.debug("Default assertion attributes read from the SAML configuration: [{}]", (Object)defaultAttributesList);
        ArrayList<UserAttribute> userAttributes = new ArrayList<UserAttribute>();
        userAttributes.addAll(UMHelper.getUserAttributesFromDefaultAttributes(defaultAttributesList));
        userAttributes.addAll(UMHelper.getUserAttributesFromAssertionBasedAttributes(assertionToPrincipalAttributesMappings, assertionAttributes));
        logger.debug("Resolved user attributes: [{}]", userAttributes);
        return userAttributes;
    }

    public static Map<String, Attribute> organizeSAMLPrincipalAttributes(Set<Attribute> principalAttributes) {
        HashMap<String, Attribute> assertionAttributes = new HashMap<String, Attribute>();
        for (Attribute assertionAttribute : principalAttributes) {
            assertionAttributes.put(assertionAttribute.getName(), assertionAttribute);
        }
        return assertionAttributes;
    }

    private static List<UserAttribute> getUserAttributesFromAssertionBasedAttributes(List<AssertionBasedAttribute> assertionBasedAttributesList, Map<String, Attribute> assertionAttributes) {
        ArrayList<UserAttribute> userAttributes = new ArrayList<UserAttribute>();
        for (AssertionBasedAttribute assertionBasedAttribute : assertionBasedAttributesList) {
            if ("*".equals(assertionBasedAttribute.getAssertionAttribute())) {
                logger.debug("Wildcard is used as assertion attribute name in assertion based attribute mappings. Assigning all assertion attributes as principal attributes.");
                for (Attribute assertionAttribute : assertionAttributes.values()) {
                    if (assertionAttribute.getValues() == null) continue;
                    UserAttribute userAttribute = new UserAttribute(assertionAttribute.getName(), assertionAttribute.getValues());
                    userAttributes.add(userAttribute);
                }
                continue;
            }
            Attribute assertionAttribute = assertionAttributes.get(assertionBasedAttribute.getAssertionAttribute());
            if (assertionAttribute == null) continue;
            UserAttribute userAttribute = new UserAttribute(assertionBasedAttribute.getPrincipalAttribute(), assertionAttribute.getValues());
            userAttributes.add(userAttribute);
        }
        return userAttributes;
    }

    private static List<UserAttribute> getUserAttributesFromDefaultAttributes(List<DefaultAttribute> defaultAttributesList) {
        ArrayList<UserAttribute> userAttributes = new ArrayList<UserAttribute>();
        HashMap<String, ArrayList<String>> defaultAttributesMap = new HashMap<String, ArrayList<String>>();
        if (defaultAttributesList != null) {
            for (DefaultAttribute defaultAttribute : defaultAttributesList) {
                ArrayList<String> values = (ArrayList<String>)defaultAttributesMap.get(defaultAttribute.getDefaultAttribute());
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(defaultAttribute.getValue());
                defaultAttributesMap.put(defaultAttribute.getDefaultAttribute(), values);
            }
        }
        if (defaultAttributesMap != null && !defaultAttributesMap.isEmpty()) {
            for (String name : defaultAttributesMap.keySet()) {
                UserAttribute userAttr = new UserAttribute(name, (List)defaultAttributesMap.get(name));
                userAttributes.add(userAttr);
            }
        }
        return userAttributes;
    }

    public static HashSet<String> getAllUserGroups(List<String> defaultGroupsList, List<AssertionBasedGroup> assertionBasedGroupsList, Map<String, Attribute> assertionAttributes) {
        HashSet<String> allUserGroups;
        block4: {
            block3: {
                allUserGroups = new HashSet<String>();
                Attribute attr = assertionAttributes.get("com.sap.core.jpaas.security.um.groups");
                if (attr == null) break block3;
                logger.debug("Groups will be resolved from {} assertion attribute.", (Object)"com.sap.core.jpaas.security.um.groups");
                List values = attr.getValues();
                if (values == null || values.size() <= 0) break block4;
                String groupList = (String)values.get(0);
                StringTokenizer tokenizer = new StringTokenizer(groupList, ";");
                while (tokenizer.hasMoreTokens()) {
                    String groupToken = tokenizer.nextToken();
                    allUserGroups.add(groupToken);
                }
                break block4;
            }
            logger.debug("Groups will be resolved from assertion based group rules.");
            allUserGroups.addAll(defaultGroupsList);
            for (AssertionBasedGroup group : assertionBasedGroupsList) {
                List rules = group.getRules();
                boolean rulesSatisfied = true;
                for (AssertionRule rule : rules) {
                    if (rule.isSatisfied(assertionAttributes)) continue;
                    rulesSatisfied = false;
                    break;
                }
                if (!rulesSatisfied) continue;
                allUserGroups.add(group.getGroup());
            }
        }
        return allUserGroups;
    }

    private static String generateJPaaSPrincipalName(String principalOrgName, SAML2TrustedIdPJPaaSImpl idp, Map<String, Attribute> assertionAttributes) throws SAML2JPaaSException {
        String userIDSuffix;
        String name = null;
        String userIDSourceType = idp.getUserIDSourceType();
        if (userIDSourceType == null) {
            throw new SAML2JPaaSException("Parameter for user id source is null");
        }
        if (userIDSourceType.equals("subject") || userIDSourceType.equals("assertion_subject")) {
            name = principalOrgName;
        } else if (userIDSourceType.startsWith("attribute") || userIDSourceType.startsWith("assertion_attribute")) {
            String userIDSourceValue = idp.getUserIDSourceValue();
            Attribute assertionAttribute = assertionAttributes.get(userIDSourceValue);
            if (assertionAttribute == null) {
                throw new SAML2JPaaSException("Assertion attribute '" + userIDSourceValue + "' not found");
            }
            List values = assertionAttribute.getValues();
            if (values == null || values.size() == 0) {
                throw new SAML2JPaaSException("Assertion attribute '" + userIDSourceValue + "' has 'null' value");
            }
            name = (String)values.get(0);
        }
        String userIDPrefix = idp.getUserIDPrefix();
        if (userIDPrefix != null) {
            name = String.valueOf(userIDPrefix) + name;
        }
        if ((userIDSuffix = idp.getUserIDSuffix()) != null) {
            name = String.valueOf(name) + userIDSuffix;
        }
        return name;
    }

    public static boolean updateUser(SAML2JPaaSPrincipal jpaasSaml2Principal) {
        String userName = jpaasSaml2Principal.getName();
        List<UserAttribute> attributes = jpaasSaml2Principal.getUserAttributes();
        Set<String> groups = jpaasSaml2Principal.getGroups();
        return UMHelper.updateUser(userName, attributes, groups);
    }

    public static boolean updateUser(String userName, List<UserAttribute> attributes, Set<String> groups) {
        ModifiableUser user = null;
        ModifiableUserEx userEx = null;
        try {
            ModifiableUserProvider userProvider;
            if (logger.isDebugEnabled()) {
                logger.debug("User {} with attributes {} and groups {} will be created from pricipal", new Object[]{userName, attributes, groups});
            }
            if ((userProvider = ModifiableUserManagementAccessor.getModifiableUserProvider()) != null) {
                user = userProvider.getModifiableUser(userName);
                if (user == null) {
                    user = userProvider.createUser(userName);
                }
                if (user instanceof ModifiableUserEx) {
                    userEx = (ModifiableUserEx)user;
                }
                if (attributes != null) {
                    for (UserAttribute attribute : attributes) {
                        List<String> values = attribute.getValue();
                        if (values == null || values.isEmpty()) continue;
                        try {
                            if (userEx != null) {
                                userEx.setAttributeValues(attribute.getName(), values.toArray(new String[values.size()]));
                                continue;
                            }
                            user.setAttribute(attribute.getName(), attribute.getValue().get(0));
                        }
                        catch (ReadonlyAttributeException e) {
                            logger.error("Cound not add read-only attribute [ " + attribute.getName() + "]", (Throwable)e);
                        }
                        catch (UnsupportedUserAttributeException e) {
                            logger.error("The attribute [" + attribute.getName() + "] is not supported and cannot be added to user", (Throwable)e);
                        }
                        catch (UnsupportedUserAttributeValueException e) {
                            logger.error("The value [" + values.get(0) + "] is not supported for attribute [" + attribute.getName() + "]", (Throwable)e);
                        }
                    }
                }
                if (userEx != null) {
                    userEx.setGroups(groups);
                }
                userProvider.persistUser(user);
                if (logger.isDebugEnabled()) {
                    logger.debug("User {} was created and saved", (Object)userName);
                }
            } else {
                logger.error("No ModifiableUserProvider found. Cannot cache user.");
            }
        }
        catch (PersistenceException e) {
            logger.error("User provider failed to access user " + userName, (Throwable)e);
            return false;
        }
        catch (UnsupportedUserNameException e) {
            logger.error("Failed to create user because the provided name [" + userName + "] is not supported.", (Throwable)e);
            return false;
        }
        catch (UserAlreadyExistsException e) {
            logger.error("User " + userName + " already exists. Failed to persist", (Throwable)e);
            return false;
        }
        return true;
    }
}

