/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.cfg.SAML2CfgFactory;
import com.sap.security.saml2.cfg.enums.ComparisonMethod;
import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SAML2PolicyType;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2GlobalConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2LocalProvidersConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2PoliciesConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2TrustedIdPsConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Policy;
import com.sap.security.saml2.cfg.interfaces.read.SAML2PolicyIdPCustomizedData;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecified;
import com.sap.security.saml2.commons.AuthnContext;
import com.sap.security.saml2.commons.AuthnContextList;
import com.sap.security.saml2.commons.AuthnContextsMapping;
import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.commons.SAML2LMProxyingData;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPList;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Scoping;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.saml2.sp.LoginResult;
import com.sap.security.saml2.sp.ProviderSelectionService;
import com.sap.security.saml2.sp.SAML2LoginModuleUtil;
import com.sap.security.saml2.sp.exception.BadCredentialsException;
import com.sap.security.saml2.sp.exception.LoginFailedException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

public class ConfigurationManager {
    private static final Location LOCATION = Location.getLocation(ConfigurationManager.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA-1";
    private static final String POLICY_LOGIN_MODULE_OPTION = "policy";
    private byte providerExecutionMode = 0;
    private CallbackHandler callbackHandler;
    private LoginResult loginResult;
    private boolean isDefaultConfiguration;
    private boolean idpSelected = false;
    private SAML2Config saml2Config;
    private SAML2LocalSP localSPConfig;
    private SAML2LocalIdP localIdPConfig;
    private SAML2TrustedIdP trustedIdPConfig;
    private Map<String, String> loginModuleOptions;
    private Boolean forceAuthn = null;
    private Boolean isPassive = null;
    private Boolean sendSPReponse = null;
    private AuthnContextList authnContexts = null;
    private ComparisonMethod comparisonMethod = null;
    private ProviderSelectionService providerSelectionService;
    private List<String> scopingIdPList;
    private SAML2LMProxyingData proxyingData;

    ConfigurationManager(String providerName, CallbackHandler callbackHandler, Map options, LoginResult loginResult) {
        this.callbackHandler = callbackHandler;
        this.loginResult = loginResult;
        this.loginModuleOptions = options;
        this.isDefaultConfiguration = false;
        try {
            SAML2GlobalConfig globalConfig = SAML2CfgFactory.getSAML2GlobalConfig();
            if (globalConfig == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000124", (String)"Service Provider cannot load global SAML2 configuration.");
                throw new SecurityException("Service Provider cannot load global SAML2 configuration.");
            }
            this.saml2Config = globalConfig.getSAML2Configuration(providerName);
            if (this.saml2Config == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000125", (String)"Service Provider cannot load SAML2 configuration: [{0}].", (Object[])new Object[]{providerName});
                throw new SecurityException("Cannot load SAML2 configuration: " + providerName);
            }
        }
        catch (SAML2ConfigurationException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000125", (String)"Service Provider cannot load SAML2 configuration: [{0}].", (Object[])new Object[]{providerName});
            throw new SecurityException("Cannot load SAML2 configuration: " + providerName, e);
        }
        this.providerSelectionService = new ProviderSelectionService(this, callbackHandler);
        this.proxyingData = new SAML2LMProxyingData(options);
    }

    ConfigurationManager(CallbackHandler callbackHandler, Map options, LoginResult loginResult) {
        this.callbackHandler = callbackHandler;
        this.loginResult = loginResult;
        this.loginModuleOptions = options;
        this.isDefaultConfiguration = true;
        try {
            SAML2GlobalConfig globalConfig = SAML2CfgFactory.getSAML2GlobalConfig();
            if (globalConfig == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000124", (String)"Service Provider cannot load global SAML2 configuration.");
                throw new SecurityException("Service Provider cannot load global SAML2 configuration.");
            }
            this.saml2Config = globalConfig.getDefaultSAML2Configuration();
            if (this.saml2Config == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000126", (String)"Service Provider cannot load default SAML2 configuration.");
                throw new SecurityException("Cannot load default SAML2 configuration.");
            }
        }
        catch (SAML2ConfigurationException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000126", (String)"Service Provider cannot load default SAML2 configuration.");
            throw new SecurityException("Cannot load default SAML2 configuration.", e);
        }
        this.providerSelectionService = new ProviderSelectionService(this, callbackHandler);
        this.proxyingData = new SAML2LMProxyingData(options);
    }

    void setProviderExecutionMode(byte providerExecMode) {
        this.providerExecutionMode = providerExecMode;
    }

    SAML2Config getSAML2Config() {
        if (this.saml2Config == null) {
            throw new IllegalStateException("SAML2 configuration is not loaded.");
        }
        return this.saml2Config;
    }

    SAML2LocalProvider getLocalProvider() {
        if (this.saml2Config == null) {
            throw new IllegalStateException("SAML2 configuration is not loaded.");
        }
        SAML2LocalProvidersConfig localConfig = this.saml2Config.getLocalProvidersConfiguration();
        return localConfig.getLocalProvider();
    }

    public SAML2LocalSP getLocalSP() {
        if (this.localSPConfig == null) {
            throw new IllegalStateException("Service Provider configuration is not loaded.");
        }
        return this.localSPConfig;
    }

    SAML2TrustedIdP getTrustedIdP() {
        if (this.trustedIdPConfig == null) {
            throw new IllegalStateException("Trusted Identity Provider configuration is not loaded.");
        }
        return this.trustedIdPConfig;
    }

    SAML2LocalIdP getLocalIdP() {
        if (this.localIdPConfig == null) {
            throw new IllegalStateException("Local Identity Provider configuration is not loaded.");
        }
        return this.localIdPConfig;
    }

    SAML2LMProxyingData getProxyingData() {
        return this.proxyingData;
    }

    boolean isLocalIdP() {
        return this.localIdPConfig != null;
    }

    boolean isDefaultSAML2Configuration() {
        return this.isDefaultConfiguration;
    }

    boolean isIdPSelected() {
        return this.idpSelected;
    }

    public boolean loadConfigurations(boolean isLocalAccess, SAML2Principal principal, Object token, String loginResultIdPName) throws LoginException {
        SAML2LocalProvidersConfig configs = this.saml2Config.getLocalProvidersConfiguration();
        if (configs.isIdentityProviderEnabled()) {
            if (configs.isServiceProviderEnabled()) {
                if (isLocalAccess) {
                    this.localSPConfig = configs.getLocalSP();
                    this.localIdPConfig = configs.getLocalIdP();
                    if (LOCATION.beInfo()) {
                        LOCATION.infoT("Local IdP is enabled. Local SP is enabled. Access type is local.");
                        LOCATION.infoT("Service Provider configuration: {0}", new Object[]{this.localSPConfig});
                    }
                } else {
                    this.localSPConfig = configs.getLocalSP();
                    if (LOCATION.beInfo()) {
                        LOCATION.infoT("Local IdP is enabled. Local SP is enabled. Access type is not local.");
                        LOCATION.infoT("Service Provider configuration: {0}", new Object[]{this.localSPConfig});
                    }
                    this.selectIdP(principal, token, loginResultIdPName, true);
                    if (!this.idpSelected) {
                        this.localIdPConfig = configs.getLocalIdP();
                        if (this.localIdPConfig == null) {
                            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000128", (String)"Local Identity Provider configuration could not be loaded.");
                            this.loginResult.throwLoginFailedException("Local Identity Provider configuration cannot be loaded.");
                        } else {
                            LOCATION.infoT("Service Provider selects local Identity Provider.");
                        }
                    }
                }
            } else {
                this.localIdPConfig = configs.getLocalIdP();
                if (this.localIdPConfig == null) {
                    SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000128", (String)"Local Identity Provider configuration could not be loaded.");
                    this.loginResult.throwLoginFailedException("Local Identity Provider configuration cannot be loaded.");
                }
                LOCATION.infoT("Local IdP is enabled. Local SP is disabled.");
            }
        } else if (configs.isServiceProviderEnabled()) {
            this.localSPConfig = configs.getLocalSP();
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Local IdP is disabled. Local SP is enabled.");
                LOCATION.infoT("Service Provider configuration: {0}", new Object[]{this.localSPConfig});
            }
            this.selectIdP(principal, token, loginResultIdPName, false);
            if (!this.idpSelected) {
                this.trustedIdPConfig = this.getDefaultTrustedIdP();
                this.validateIdPConfiguration(null, null, true);
                LOCATION.infoT("Service Provider selects default trusted Identity Provider.");
            }
        } else {
            LOCATION.infoT("Local IdP is disabled. Local SP is disabled.");
            return false;
        }
        if (this.trustedIdPConfig != null) {
            this.loginResult.setIdpName(this.trustedIdPConfig.getName());
            LOCATION.infoT("Trusted Identity Provider configuration: {0}", new Object[]{this.trustedIdPConfig});
        } else {
            this.loginResult.setIdpName(this.localIdPConfig.getName());
            LOCATION.infoT("Local Identity Provider configuration: {0}", new Object[]{this.localIdPConfig});
        }
        return true;
    }

    void loadConfigurations(SAML2Principal principal) throws LoginFailedException {
        SAML2LocalProvidersConfig configs = this.saml2Config.getLocalProvidersConfiguration();
        if (configs == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000129", (String)"Local providers configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Local providers configuration cannot be loaded.");
        }
        this.localSPConfig = configs.getLocalSP();
        if (this.localSPConfig == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000121", (String)"Service Provider configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Service Provider configuration cannot be loaded.");
        }
        LOCATION.infoT("Service Provider configuration: {0}", new Object[]{this.localSPConfig});
        this.trustedIdPConfig = this.getTrustedIdP(principal.getIdPName());
        this.validateIdPConfiguration(principal.getIdPName(), "previous SAML authentication", false);
        this.loginResult.setIdpName(this.trustedIdPConfig.getName());
        LOCATION.infoT("Trusted Identity Provider configuration: {0}", new Object[]{this.trustedIdPConfig});
    }

    void loadLocalConfigurations() throws LoginFailedException {
        SAML2LocalProvidersConfig configs = this.saml2Config.getLocalProvidersConfiguration();
        if (configs == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000129", (String)"Local providers configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Local providers configuration cannot be loaded.");
        }
        this.localIdPConfig = configs.getLocalIdP();
        if (this.localIdPConfig == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000128", (String)"Local Identity Provider configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Local Identity Provider configuration could not be loaded.");
        }
        LOCATION.infoT("Local Identity Provider configuration: {0}", new Object[]{this.localIdPConfig});
        this.localSPConfig = configs.getLocalSP();
        if (this.localSPConfig == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000121", (String)"Service Provider configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Service Provider configuration cannot be loaded.");
        }
        LOCATION.infoT("Local Service Provider configuration: {0}", new Object[]{this.localSPConfig});
        this.loginResult.setIdpName(this.localIdPConfig.getName());
    }

    private void selectIdP(SAML2Principal principal, Object token, String loginResultIdPName, boolean isIdPEnabled) throws LoginException {
        if (principal != null) {
            boolean isLocal = false;
            try {
                isLocal = principal.isLocalProvider(this.getLocalProvider().getName());
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Failed to check Local Provider in SAML2Principal.", (Throwable)e);
            }
            if (isLocal) {
                this.localIdPConfig = this.saml2Config.getLocalProvidersConfiguration().getLocalIdP();
            } else {
                this.trustedIdPConfig = this.getTrustedIdP(principal.getIdPName());
                this.validateIdPConfiguration(principal.getIdPName(), "previous SAML authentication", false);
            }
            LOCATION.infoT("Identity Provider selected based on previous SAML2 authentication.");
        } else if (token instanceof SAML2Response) {
            this.trustedIdPConfig = this.getTrustedIdP((SAML2Response)token);
            LOCATION.infoT("Identity Provider selected based on SAML2Response received.");
        } else if (token instanceof SAML2Artifact) {
            this.trustedIdPConfig = this.getTrustedIdP((SAML2Artifact)token);
            LOCATION.infoT("Identity Provider selected based on SAML2Artifact received.");
        } else if (token instanceof SAML2Assertion) {
            this.trustedIdPConfig = this.getTrustedIdP((SAML2Assertion)token);
            LOCATION.infoT("Identity Provider selected based on SAML2Assertion received.");
        } else if (loginResultIdPName != null) {
            this.trustedIdPConfig = this.getTrustedIdP(loginResultIdPName);
            this.validateIdPConfiguration(loginResultIdPName, "saved state from last successful SAML2 authentication", false);
            LOCATION.infoT("Identity Provider selected based on saved state from last successful SAML2 authentication.");
        } else {
            if (!this.hasTrustedIdPConfigured()) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000123", (String)"Service Provider does not have any configured trusted Identity Providers.");
                this.loginResult.throwLoginFailedException("Service Provider does not have any trusted Identity Providers configured.");
            }
            if (this.providerSelectionService.isManualIdPSelectionMode()) {
                String[] idpList = this.getIdPListFromURL();
                if (this.providerSelectionService.hasUserSelectedIdP()) {
                    Object o = null;
                    try {
                        o = SAML2LoginModuleUtil.getRequestAttribute(this.callbackHandler, "com.sap.engine.security.authentication.salt_check");
                    }
                    catch (Exception e) {
                        LOCATION.traceThrowableT(100, "Unable to obtain salt check result (attribute com.sap.engine.security.authentication.salt_check , args, exc)", (Throwable)e);
                    }
                    boolean salt_check_result = true;
                    if (o instanceof Boolean) {
                        salt_check_result = (Boolean)o;
                        if (!salt_check_result) {
                            LOCATION.warningT("Salt check failed - manual idp selection not possible. See SAP Note 1441999 for more details.");
                        }
                    } else {
                        LOCATION.infoT("Older version of security api - no salt check is performed.");
                    }
                    String identityProviderName = this.selectIdPFromList(idpList, false);
                    if (salt_check_result && identityProviderName != null && this.selectIdPFromURLParameter(identityProviderName)) {
                        LOCATION.infoT("Identity Provider selected based on URL parameter [saml2idp] received.");
                    } else {
                        this.loginResult.throwManualIdPSelectionException("User has selected an Identity Provider that is not trusted or enabled.");
                    }
                } else {
                    if (!this.providerSelectionService.isRequestFromExternalIdPDiscoveryService()) {
                        if (this.localSPConfig.isToUseExternalIdPDiscoveryReadService()) {
                            this.loginResult.throwIdPDiscoveryException("Service Provider redirects to IdP Discovery Service to evaluate the CDC cookie.");
                        } else {
                            LOCATION.debugT("External IdP Discovery Service is disabled.");
                        }
                    }
                    this.loginResult.throwManualIdPSelectionException("Service Provider redirects to logon application for manual IdP selection.");
                }
            } else if (this.proxyingData.isProxying()) {
                List idpNames;
                String identityProviderName;
                SAML2IDPList idpList;
                SAML2Scoping scoping = this.proxyingData.getOriginalRequestScoping();
                if (scoping != null && (idpList = scoping.getIDPList()) != null && (identityProviderName = this.selectIdPFromList((idpNames = SAML2Utils.convertIdPEntriesToIdPNames((List)idpList.getIdPEntries())).toArray(new String[idpNames.size()]), false)) != null) {
                    LOCATION.infoT("Identity Provider selected based on Scoping IdPList contained in the original AuthnRequest.");
                    this.trustedIdPConfig = this.getTrustedIdP(identityProviderName);
                }
            } else {
                String[] idpList = this.getIdPListFromURL();
                String identityProviderName = this.selectIdPFromList(idpList, false);
                if (identityProviderName != null) {
                    this.selectIdPFromURLParameter(identityProviderName);
                    if (this.providerSelectionService.isRequestFromExternalIdPDiscoveryService()) {
                        LOCATION.infoT("Identity Provider selected based on common domain cookie processed by the external IdP Discovery Service.");
                    } else {
                        LOCATION.infoT("Identity Provider selected based on URL parameter [saml2idp] received.");
                    }
                } else if (idpList != null && idpList.length > 0) {
                    this.scopingIdPList = Arrays.asList(idpList);
                } else {
                    this.selectIdPFromCDC();
                }
            }
        }
        this.idpSelected = this.trustedIdPConfig != null || this.localIdPConfig != null;
    }

    List<String> getScopingIdPList() {
        return this.scopingIdPList;
    }

    private SAML2TrustedIdP getTrustedIdP(SAML2Response response) throws BadCredentialsException, LoginFailedException {
        LOCATION.debugT("Loading IdP configuration based on SAML2 response received.");
        SAML2NameID issuerNameId = response.getIssuer();
        if (issuerNameId == null || issuerNameId.getName() == null) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000018", (String)"Service Provider received SAML2Response that does not specify an issuer.");
            this.loginResult.throwBadCredentialException("SAML2Response does not specify an issuer.");
        }
        this.trustedIdPConfig = this.getTrustedIdP(issuerNameId.getName());
        this.validateIdPConfiguration(issuerNameId.getName(), "SAML2Response", false);
        return this.trustedIdPConfig;
    }

    private SAML2TrustedIdP getTrustedIdP(SAML2Artifact artifact) throws BadCredentialsException, LoginFailedException {
        LOCATION.debugT("Loading IdP configuration based on SAML2 artifact received.");
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            LOCATION.traceThrowableT(500, "Failed to create instance of MessageDigest: SHA-1", (Throwable)e);
            this.loginResult.throwLoginFailedException("Failed to create instance of MessageDigest: SHA-1", e);
        }
        byte[] sourceID = artifact.getSourceID();
        Collection trustedIdPs = this.saml2Config.getTrustedIdPsConfiguration().getAllTrustedIdPs();
        for (SAML2TrustedIdP trustedIdP : trustedIdPs) {
            byte[] digestedByteArr = messageDigest.digest(trustedIdP.getName().getBytes(Charset.forName("UTF-8")));
            messageDigest.reset();
            if (!Arrays.equals(sourceID, digestedByteArr)) continue;
            this.trustedIdPConfig = trustedIdP;
            this.validateIdPConfiguration(trustedIdP.getName(), "SAML2Artifact", false);
            return this.trustedIdPConfig;
        }
        SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000127", (String)"Service Provider could not select trusted Identity Provider based on SAML2Artifact received because the issuer is not among the list of its trusted providers.");
        this.loginResult.throwBadCredentialException("No trusted Identity Provider matches the source id of the artifact.");
        return this.trustedIdPConfig;
    }

    private SAML2TrustedIdP getTrustedIdP(SAML2Assertion assertion) throws LoginException {
        LOCATION.debugT("Loading IdP configuration based on SAML2Assertion received.");
        SAML2NameID issuerNameId = assertion.getIssuer();
        if (issuerNameId == null || issuerNameId.getName() == null) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000091", (String)"Service Provider received SAML2Assertion that does not specify an issuer. ");
            this.loginResult.throwBadCredentialException("SAML2Assertion does not specify an issuer.");
        }
        this.trustedIdPConfig = this.getTrustedIdP(issuerNameId.getName());
        this.validateIdPConfiguration(issuerNameId.getName(), "SAML2Assertion", false);
        return this.trustedIdPConfig;
    }

    SAML2TrustedIdP getTrustedIdP(String name) {
        SAML2TrustedIdPsConfig trustedIdPsConfig = this.saml2Config.getTrustedIdPsConfiguration();
        SAML2TrustedIdP trustedIdP = trustedIdPsConfig.getTrustedIdP(name);
        if (trustedIdP != null) {
            return trustedIdP;
        }
        SAML2TrustedIdP defaultIdP = this.getDefaultTrustedIdP();
        if (defaultIdP != null && defaultIdP.getName().equalsIgnoreCase(name)) {
            return defaultIdP;
        }
        return null;
    }

    private SAML2TrustedIdP getDefaultTrustedIdP() {
        SAML2TrustedIdPsConfig trustedIdPsConfig = this.saml2Config.getTrustedIdPsConfiguration();
        SAML2TrustedIdP trustedIdP = trustedIdPsConfig.getDefaultTrustedIdP();
        return trustedIdP;
    }

    private boolean hasTrustedIdPConfigured() {
        SAML2TrustedIdPsConfig trustedIdPsConfig = this.saml2Config.getTrustedIdPsConfiguration();
        Collection idpNames = trustedIdPsConfig.getAllTrustedIdPNames();
        return idpNames != null && !idpNames.isEmpty();
    }

    private void validateIdPConfiguration(String idpName, String cause, boolean isDefault) throws LoginFailedException {
        if (this.trustedIdPConfig == null) {
            if (isDefault) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000119", (String)"Service Provider could not load default trusted Identity Provider configuration.");
                this.loginResult.throwLoginFailedException("Default trusted IdP configuration cannot be loaded.");
            } else {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000118", (String)"Service Provider could not load trusted Identity Provider configuration [{0}] based on {1}.", (Object[])new Object[]{idpName, cause});
                this.loginResult.throwLoginFailedException("Trusted IdP configuration cannot be loaded: " + idpName);
            }
        }
        if (!this.trustedIdPConfig.isEnabled()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000120", (String)"Service Provider could not use trusted Identity Provider [{0}] because it is disabled.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Trusted Identity Provider configuration: {0}", new Object[]{this.trustedIdPConfig});
            }
            this.loginResult.throwLoginFailedException("Trusted IdP configuration is disabled: " + this.trustedIdPConfig.getName());
        }
    }

    SAML2NameIdFormat getNameIDFormat() {
        SAML2NameIdFormat nameIdFormat = null;
        String paramNameIdFormat = null;
        try {
            paramNameIdFormat = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2nameidformat");
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not get Name ID Format request parameter.", (Throwable)e);
            return null;
        }
        if (paramNameIdFormat != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Name ID Format received as HTTP request parameter: [{0}]", new Object[]{paramNameIdFormat});
            }
            if (paramNameIdFormat.length() == 0) {
                nameIdFormat = null;
            } else if ("persistent".equalsIgnoreCase(paramNameIdFormat)) {
                if (this.trustedIdPConfig.getNameIdFormatPersistent().isSupported()) {
                    nameIdFormat = SAML2NameIdFormat.PERSISTENT;
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Name ID Format [{0}] received as HTTP request parameter is not supported.", new Object[]{paramNameIdFormat});
                }
            } else if ("transient".equalsIgnoreCase(paramNameIdFormat)) {
                if (this.trustedIdPConfig.getNameIdFormatTransient().isSupported()) {
                    nameIdFormat = SAML2NameIdFormat.TRANSIENT;
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Name ID Format [{0}] received as HTTP request parameter is not supported.", new Object[]{paramNameIdFormat});
                }
            } else if ("unspecified".equalsIgnoreCase(paramNameIdFormat)) {
                if (this.trustedIdPConfig.getNameIdFormatUnspecified().isSupported()) {
                    nameIdFormat = SAML2NameIdFormat.UNSPECIFIED;
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Name ID Format [{0}] received as HTTP request parameter is not supported.", new Object[]{paramNameIdFormat});
                }
            } else if ("email".equalsIgnoreCase(paramNameIdFormat)) {
                if (this.trustedIdPConfig.getNameIdFormatEmail().isSupported()) {
                    nameIdFormat = SAML2NameIdFormat.E_MAIL;
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Name ID Format [{0}] received as HTTP request parameter is not supported.", new Object[]{paramNameIdFormat});
                }
            } else if ("kerberos".equalsIgnoreCase(paramNameIdFormat)) {
                if (this.trustedIdPConfig.getNameIdFormatKerberos().isSupported()) {
                    nameIdFormat = SAML2NameIdFormat.KERBEROS;
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Name ID Format [{0}] received as HTTP request parameter is not supported.", new Object[]{paramNameIdFormat});
                }
            } else if ("windowsname".equalsIgnoreCase(paramNameIdFormat)) {
                if (this.trustedIdPConfig.getNameIdFormatWindows().isSupported()) {
                    nameIdFormat = SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME;
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Name ID Format [{0}] received as HTTP request parameter is not supported.", new Object[]{paramNameIdFormat});
                }
            } else if ("x509".equalsIgnoreCase(paramNameIdFormat)) {
                if (this.trustedIdPConfig.getNameIdFormatX509().isSupported()) {
                    nameIdFormat = SAML2NameIdFormat.X509_SUBJECT_NAME;
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Name ID Format [{0}] received as HTTP request parameter is not supported.", new Object[]{paramNameIdFormat});
                }
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("Name ID Format [{0}] received as HTTP request parameter is not supported.", new Object[]{paramNameIdFormat});
            }
        } else {
            nameIdFormat = this.trustedIdPConfig.getDefaultNameIdFormat();
        }
        return nameIdFormat;
    }

    boolean getAllowCreate(SAML2NameIdFormat nameIdFormat) throws LoginException {
        boolean allowCreate = false;
        try {
            SAML2NameIdFormatUnspecified unspecifiedNameIdFormat;
            String allowCreateValue = null;
            if (this.providerExecutionMode == 1) {
                allowCreateValue = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2allowcreate");
            }
            if (allowCreateValue != null) {
                allowCreate = Boolean.parseBoolean(allowCreateValue);
            } else if (nameIdFormat == SAML2NameIdFormat.PERSISTENT) {
                SAML2NameIdFormatPersistentTrustedIdP persistentNameIdFormat = this.trustedIdPConfig.getNameIdFormatPersistent();
                if (persistentNameIdFormat != null) {
                    allowCreate = persistentNameIdFormat.isAllowCreate();
                }
            } else if ((nameIdFormat == null || nameIdFormat == SAML2NameIdFormat.UNSPECIFIED) && (unspecifiedNameIdFormat = this.trustedIdPConfig.getNameIdFormatUnspecified()) != null) {
                allowCreate = unspecifiedNameIdFormat.isAllowCreate();
            }
        }
        catch (Exception e) {
            this.loginResult.throwLoginFailedException("Error getting Allow Create as a HTTP request parameter.", e);
        }
        return allowCreate;
    }

    boolean getForceAuthentication() throws LoginException {
        if (this.forceAuthn == null) {
            try {
                if (this.proxyingData.isProxying()) {
                    this.forceAuthn = this.proxyingData.isOriginalRequestForceAuthn();
                } else {
                    SAML2Policy policy = this.getPolicy();
                    if (policy != null) {
                        this.forceAuthn = SAML2PolicyType.FORCED_REAUTHENTICATION == policy.getType();
                    } else {
                        String forceAuthnValue = null;
                        if (this.providerExecutionMode == 1) {
                            forceAuthnValue = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2forceauthn");
                        }
                        if (forceAuthnValue == null) {
                            String authnType = this.loginModuleOptions.get("authn.type");
                            this.forceAuthn = "forced".equalsIgnoreCase(authnType);
                        } else {
                            this.forceAuthn = Boolean.parseBoolean(forceAuthnValue);
                        }
                    }
                }
            }
            catch (LoginException e) {
                throw e;
            }
            catch (Exception e) {
                this.loginResult.throwLoginFailedException("Could not determine whether policy type is forced authentication. Reason: " + e.getMessage(), e);
            }
        }
        return this.forceAuthn;
    }

    boolean isPassive() throws LoginException {
        if (this.isPassive == null) {
            try {
                if (this.proxyingData.isProxying()) {
                    this.isPassive = this.proxyingData.isOriginalRequestIsPassive();
                } else {
                    SAML2Policy policy = this.getPolicy();
                    if (policy != null) {
                        this.isPassive = SAML2PolicyType.PASSIVE == policy.getType();
                    } else {
                        String isPassiveValue = null;
                        if (this.providerExecutionMode == 1) {
                            isPassiveValue = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2ispassive");
                        }
                        if (isPassiveValue == null) {
                            String authnType = this.loginModuleOptions.get("authn.type");
                            this.isPassive = "passive".equalsIgnoreCase(authnType);
                        } else {
                            this.isPassive = Boolean.parseBoolean(isPassiveValue);
                        }
                    }
                }
            }
            catch (LoginException e) {
                throw e;
            }
            catch (Exception e) {
                this.loginResult.throwLoginFailedException("Could not determine whether policy type is passive. Reason: " + e.getMessage(), e);
            }
        }
        return this.isPassive;
    }

    boolean sendSPReponse() throws LoginException {
        if (this.sendSPReponse == null) {
            this.sendSPReponse = Boolean.parseBoolean("true");
            try {
                String sendResponseOption = this.loginModuleOptions.get("sp.response");
                if ("false".equalsIgnoreCase(sendResponseOption)) {
                    this.sendSPReponse = Boolean.parseBoolean("false");
                }
            }
            catch (Exception e) {
                this.loginResult.throwLoginFailedException("Could not determine whether SP is configured to send response. Reason: " + e.getMessage(), e);
            }
        }
        return this.sendSPReponse;
    }

    ComparisonMethod getRequestedAuthnContextComparisonMethod() throws LoginFailedException {
        if (this.comparisonMethod == null && !this.isLocalIdP()) {
            boolean isCustomized = false;
            SAML2Policy policy = this.getPolicy();
            if (policy != null) {
                SAML2PolicyIdPCustomizedData customizedData = policy.getIdPCustomizedData(this.trustedIdPConfig.getName());
                boolean bl = isCustomized = customizedData != null;
                if (isCustomized) {
                    this.comparisonMethod = customizedData.getRequestedAuthnContextComparisonMethod();
                    if (this.comparisonMethod != null) {
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT("Comparison method [{0}] configured in policy IdP customized data.", new Object[]{this.comparisonMethod.getName()});
                        }
                    } else {
                        LOCATION.debugT("No comparison method configured in policy IdP customized data.");
                    }
                } else {
                    try {
                        this.comparisonMethod = this.getComparisonMethodFromParamOrConfiguration();
                    }
                    catch (Exception e) {
                        throw new LoginFailedException("Unable to get the comparison method", e);
                    }
                    LOCATION.debugT("No IdP customized data configured in policy.");
                    if (this.comparisonMethod != null) {
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT("Comparison method [{0}] configured for trusted IdP.", new Object[]{this.comparisonMethod.getName()});
                        }
                    } else {
                        LOCATION.debugT("No comparison method configured for trusted IdP.");
                    }
                }
            } else {
                try {
                    this.comparisonMethod = this.getComparisonMethodFromParamOrConfiguration();
                }
                catch (Exception e) {
                    throw new LoginFailedException("Unable to get the comparison method", e);
                }
            }
        }
        return this.comparisonMethod;
    }

    AuthnContextList getAuthenticationContexts() throws LoginFailedException {
        if (this.authnContexts == null) {
            this.authnContexts = new AuthnContextList();
            if (this.proxyingData.isProxying()) {
                List originalRequestRequestedAuthnContexts = this.proxyingData.getOriginalRequestRequestedAuthnContexts();
                if (originalRequestRequestedAuthnContexts != null && !originalRequestRequestedAuthnContexts.isEmpty()) {
                    for (String authnContextName : originalRequestRequestedAuthnContexts) {
                        AuthnContext ac = new AuthnContext(authnContextName, authnContextName, false, true, true, false);
                        this.authnContexts.add(ac);
                    }
                }
            } else {
                SAML2Policy policy = this.getPolicy();
                if (policy != null) {
                    this.handleAuthnContextsFromPolicy(policy);
                } else {
                    this.handleAuthnContextsFromParamOrOption();
                }
            }
        }
        return this.authnContexts;
    }

    private void handleAuthnContextsFromParamOrOption() throws LoginFailedException {
        SAML2LocalProvider localProvider = this.saml2Config.getLocalProvidersConfiguration().getLocalProvider();
        try {
            String authnContextsValue = this.getAuthnContextsFromParamOrOption();
            if (authnContextsValue != null) {
                List names = AuthnContextsMapping.parseAuthnContextString((SAML2LocalProvider)localProvider, (String)authnContextsValue);
                this.authnContexts = this.getAuthnContextsFromNames(localProvider, names);
            } else if (!this.isLocalIdP()) {
                List contextNames = this.trustedIdPConfig.getAuthenticationContextNames();
                this.authnContexts = this.getAuthnContextsFromNames(localProvider, contextNames);
            }
        }
        catch (Exception e) {
            this.loginResult.throwLoginFailedException("Error getting Authentication Contexts as HTTP request parameter.", e);
        }
    }

    private void handleAuthnContextsFromPolicy(SAML2Policy policy) throws LoginFailedException {
        SAML2LocalProvider localProvider = this.saml2Config.getLocalProvidersConfiguration().getLocalProvider();
        List<String> authnContextList = null;
        if (this.isLocalIdP()) {
            authnContextList = policy.getAuthnContextsHTTPS();
            if (authnContextList == null || authnContextList.isEmpty()) {
                authnContextList = policy.getAuthnContextsHTTP();
            }
        } else {
            SAML2PolicyIdPCustomizedData customizedData = policy.getIdPCustomizedData(this.trustedIdPConfig.getName());
            if (customizedData != null) {
                authnContextList = customizedData.getAuthnContexts();
            } else {
                try {
                    String authnContext = this.getAuthnContextsFromParamOrOption();
                    if (authnContext != null) {
                        authnContextList = Arrays.asList(authnContext);
                    }
                }
                catch (Exception e) {
                    throw new LoginFailedException("Unable to get authentication contexts.", e);
                }
            }
        }
        if (authnContextList != null && !authnContextList.isEmpty()) {
            this.authnContexts = this.getAuthnContextsFromNames(localProvider, authnContextList);
        }
    }

    private String getAuthnContextsFromParamOrOption() throws Exception {
        String authnContextsValue = null;
        if (this.providerExecutionMode == 1) {
            authnContextsValue = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2authncontexts");
        }
        if (authnContextsValue == null) {
            if (this.isLocalIdP()) {
                authnContextsValue = this.loginModuleOptions.get("authn.contexts.http");
                if (authnContextsValue == null) {
                    authnContextsValue = this.loginModuleOptions.get("authn.contexts.https");
                }
            } else {
                String optionName = "authn.contexts." + this.trustedIdPConfig.getName();
                authnContextsValue = this.loginModuleOptions.get(optionName);
            }
        }
        return authnContextsValue;
    }

    private ComparisonMethod getComparisonMethodFromParamOrConfiguration() throws Exception {
        ComparisonMethod comparisonMethod = null;
        if (this.providerExecutionMode == 1) {
            String comparisonMethodValue = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2comparison");
            comparisonMethod = ComparisonMethod.getComparisonMethod((String)comparisonMethodValue);
        }
        if (comparisonMethod == null && !this.isLocalIdP()) {
            comparisonMethod = this.trustedIdPConfig.getRequestedAuthnContextComparisonMethod();
        }
        return comparisonMethod;
    }

    private AuthnContextList getAuthnContextsFromNames(SAML2LocalProvider localProvider, List<String> contextNames) throws LoginFailedException {
        AuthnContextList contexts = new AuthnContextList();
        if (contextNames != null && !contextNames.isEmpty()) {
            for (String name : contextNames) {
                SAML2CfgAuthenticationContext c = localProvider.getAuthenticationContextByName(name);
                if (c == null) {
                    c = localProvider.getAuthenticationContextByAlias(name);
                }
                if (c != null) {
                    AuthnContext ac = new AuthnContext(c.getName(), c.getAlias(), c.isInteractive(), c.isHTTPS(), c.isHTTP(), c.isCustom());
                    contexts.add(ac);
                    continue;
                }
                this.loginResult.throwLoginFailedException("Authentication context could not be found in configuration: " + name);
            }
        }
        return contexts;
    }

    int getACSIndex() throws LoginException {
        int acsIndex = -1;
        if (this.providerExecutionMode == 1) {
            try {
                String acsIndexRequestParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2acsindex");
                if (acsIndexRequestParam != null) {
                    acsIndex = Integer.valueOf(acsIndexRequestParam);
                }
            }
            catch (Exception e) {
                this.loginResult.throwLoginFailedException("Error getting ACS index as a HTTP request parameter.", e);
            }
        }
        if (acsIndex == -1) {
            acsIndex = this.trustedIdPConfig.getResponseRequirementAssertionConsumerIndex();
        }
        return acsIndex;
    }

    ResponseRequirementType getACSResponseRequirement() throws LoginException {
        ResponseRequirementType responseRequirementType;
        block13: {
            responseRequirementType = null;
            if (this.providerExecutionMode == 1) {
                try {
                    String ascNone = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2acs");
                    if ("none".equalsIgnoreCase(ascNone)) {
                        responseRequirementType = ResponseRequirementType.IDP_DEFAULT;
                        break block13;
                    }
                    int acsIndex = -1;
                    try {
                        String acsIndexRequestParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2acsindex");
                        if (acsIndexRequestParam != null) {
                            acsIndex = Integer.valueOf(acsIndexRequestParam);
                        }
                    }
                    catch (Exception e) {
                        this.loginResult.throwLoginFailedException("Error getting ACS index as a HTTP request parameter.", e);
                    }
                    if (acsIndex != -1) {
                        responseRequirementType = ResponseRequirementType.ASSERTION_CONSUMER_INDEX;
                    } else {
                        String acsUrlRequestParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2acsurl");
                        if (acsUrlRequestParam != null) {
                            responseRequirementType = ResponseRequirementType.CUSTOM_VALUE;
                        } else {
                            String responseBindingRequestParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2responsebinding");
                            if (responseBindingRequestParam != null) {
                                responseRequirementType = ResponseRequirementType.ASSERTION_CONSUMER_URL;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.loginResult.throwLoginFailedException("Error getting ACS ResponseRequirement as a HTTP request parameter.", e);
                }
            }
        }
        if (responseRequirementType == null) {
            responseRequirementType = this.trustedIdPConfig.getResponseRequirementType();
        }
        return responseRequirementType;
    }

    String getACSUrl() throws LoginException {
        String acsUrl = null;
        if (this.providerExecutionMode == 1) {
            try {
                String acsUrlRequestParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2acsurl");
                if (acsUrlRequestParam != null) {
                    acsUrl = acsUrlRequestParam;
                }
            }
            catch (Exception e) {
                this.loginResult.throwLoginFailedException("Error getting ACS url as a HTTP request parameter.", e);
            }
        }
        if (acsUrl == null) {
            acsUrl = this.trustedIdPConfig.getResponseRequirementAssertionConsumerURL();
        }
        return acsUrl;
    }

    SAML2Binding getResponseBinding() throws LoginException {
        SAML2Binding responseBinding = null;
        if (this.providerExecutionMode == 1) {
            try {
                String bindingAlias = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2responsebinding");
                responseBinding = CommonSAML2Utils.getBindingFromAlias((String)bindingAlias);
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Could not get binding as request parameter.", (Throwable)e);
            }
        }
        if (responseBinding == null) {
            responseBinding = this.trustedIdPConfig.getResponseRequirementBinding();
        }
        return responseBinding;
    }

    boolean isSAML2FunctionalityEnabled() {
        SAML2LocalProvidersConfig localProviders = this.saml2Config.getLocalProvidersConfiguration();
        return localProviders.isSAML2FunctionalityEnabled();
    }

    Certificate getCertificateForSignature() throws LoginException {
        Certificate certificate = null;
        try {
            certificate = this.localSPConfig.getCertificateForSignature();
            if (certificate == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000115", (String)"Service Provider cannot read its certificate for signature from configuration.");
                this.loginResult.throwLoginFailedException("Could not read Service Provider certificate for signature.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not read Service Provider certificate for signature.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000115", (String)"Service Provider cannot read its certificate for signature from configuration.");
            this.loginResult.throwLoginFailedException("Could not read Service Provider certificate for signature.", e);
        }
        return certificate;
    }

    Certificate getTrustedIdPCertificateForSignature() throws LoginException {
        Certificate certificate = null;
        try {
            certificate = this.trustedIdPConfig.getCertificateForSignature();
            if (certificate == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000113", (String)"Service Provider cannot read trusted Identity Provider [{0}] certificate for signature from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
                this.loginResult.throwLoginFailedException("Could not read trusted Identity Provider certificate for signature.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not read trusted Identity Provider certificate for signature.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000113", (String)"Service Provider cannot read trusted Identity Provider [{0}] certificate for signature from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
            this.loginResult.throwLoginFailedException("Could not read trusted Identity Provider certificate for signature.", e);
        }
        return certificate;
    }

    PublicKey getTrustedIdPPublicKeyForEncryption() throws LoginException {
        PublicKey publicKey = null;
        try {
            publicKey = this.trustedIdPConfig.getPublicKeyForEncryption();
            if (publicKey == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000114", (String)"Service Provider cannot read trusted Identity Provider [{0}] public key for encryption from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
                this.loginResult.throwLoginFailedException("Could not read trusted Identity Provider public key for encryption.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not read trusted Identity Provider public key for encryption.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000114", (String)"Service Provider cannot read trusted Identity Provider [{0}] public key for encryption from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
            this.loginResult.throwLoginFailedException("Could not read trusted Identity Provider public key for encryption.", e);
        }
        return publicKey;
    }

    PrivateKey getPrivateKeyForEncryption() throws LoginException {
        PrivateKey privateKey = null;
        try {
            privateKey = this.localSPConfig.getPrivateKeyForEncryption();
            if (privateKey == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000109", (String)"Service Provider cannot read its private key for encryption from configuration.");
                this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for encryption from configuration.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Service Provider cannot read its private key for encryption from configuration.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000109", (String)"Service Provider cannot read its private key for encryption from configuration.");
            this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for encryption from configuration.", e);
        }
        return privateKey;
    }

    PrivateKey getPrivateKeyForSignature() throws LoginException {
        PrivateKey privateKey = null;
        try {
            privateKey = this.localSPConfig.getPrivateKeyForSignature();
            if (privateKey == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000108", (String)"Service Provider cannot read its private key for signature from configuration.");
                this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Service Provider cannot read its private key for signature from configuration.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000108", (String)"Service Provider cannot read its private key for signature from configuration.");
            this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.", e);
        }
        return privateKey;
    }

    SAML2Endpoint getSSOEndpoint() throws LoginFailedException {
        SAML2Endpoint endpoint = null;
        SAML2Binding binding = this.getBindingFromURLParameter();
        if (binding != null) {
            List endpoints;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SSO Binding specified by URL parameter: [{0}]", new Object[]{binding.getName()});
            }
            if ((endpoints = this.trustedIdPConfig.getSingleSignOnEndpoints(binding)) != null && endpoints.size() != 0) {
                endpoint = (SAML2Endpoint)endpoints.get(0);
            } else {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000130", (String)"Service Provider has no SSO endpoints configured by binding [{0}] for trusted Identity Provider [{1}].", (Object[])new Object[]{binding.getName(), this.trustedIdPConfig.getName()});
                this.loginResult.throwLoginFailedException("Service Provider has no SSO endpoints configured by binding [" + binding.getName() + "] for trusted Identity Provider [" + this.trustedIdPConfig.getName() + "].");
            }
        } else {
            endpoint = this.trustedIdPConfig.getDefaultSingleSignOnEndpoint();
            if (endpoint == null) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000117", (String)"Service Provider cannot read default Signle Sign-On endpoint for trusted Identity Provider [{0}] from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
                this.loginResult.throwLoginFailedException("Default SSO endpoint is not configured for trusted IdP: " + this.trustedIdPConfig.getName());
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SSO Endpoint for trusted Identity Provider [{0}]: \n{1}", new Object[]{this.trustedIdPConfig.getName(), endpoint});
        }
        return endpoint;
    }

    /*
     * Enabled aggressive block sorting
     */
    SAML2Endpoint getSLOEndpoint() throws LoginFailedException {
        SAML2Endpoint endpoint;
        block6: {
            endpoint = null;
            SAML2Binding binding = this.getBindingFromURLParameter();
            if (binding != null) {
                List endpoints;
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("SLO Binding specified by URL parameter: [{0}]", new Object[]{binding.getName()});
                }
                if ((endpoints = this.trustedIdPConfig.getSingleLogoutEndpoints(binding)) != null && endpoints.size() != 0) {
                    endpoint = (SAML2Endpoint)endpoints.get(0);
                    break block6;
                } else {
                    SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000131", (String)"Service Provider has no SLO endpoints configured by binding [{0}] for trusted Identity Provider [{1}] and only local session will be logged out.", (Object[])new Object[]{binding.getName(), this.trustedIdPConfig.getName()});
                    return null;
                }
            }
            endpoint = this.trustedIdPConfig.getDefaultSingleLogoutEndpoint();
            if (endpoint == null) {
                SimpleLogger.log((int)300, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000003", (String)"Service Provider has no default SLO endpoint configured for trusted Identity Provider [{0}] and only local session will be logged out.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
                return null;
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SLO Endpoint for trusted Identity Provider [{0}]: \n{1}", new Object[]{this.trustedIdPConfig.getName(), endpoint});
        }
        return endpoint;
    }

    SAML2Binding getBindingFromURLParameter() throws LoginFailedException {
        SAML2Binding binding = null;
        if (this.providerExecutionMode == 1) {
            try {
                String bindingAlias = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2binding");
                binding = CommonSAML2Utils.getBindingFromAlias((String)bindingAlias);
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Could not get binding as request parameter.", (Throwable)e);
            }
        }
        return binding;
    }

    String[] getIdPListFromURL() {
        Object[] idpList = null;
        try {
            String idpParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "j_saml2idp");
            if (idpParam == null) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("IdP List missing - using fallback.");
                }
                idpParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2idp");
            }
            if (idpParam == null) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("IdP List is not specified with URL parameter.");
                }
            } else if (idpParam.length() == 0) {
                idpList = new String[]{};
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Empty IdP List is specified with URL parameter.");
                }
            } else {
                idpList = idpParam.split(";");
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("IdP List extracted from URL parameter [{0}]: {1}", new Object[]{idpParam, Arrays.toString(idpList)});
                }
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not get IdP list as a URL parameter.", (Throwable)e);
            return null;
        }
        return idpList;
    }

    private String selectIdPFromList(String[] idpList, boolean receivedFromCDC) {
        if (idpList == null || idpList.length == 0) {
            return null;
        }
        String receivedFrom = receivedFromCDC ? "common domain cookie" : "URL parameter";
        SAML2LocalIdP localIdPCfg = this.saml2Config.getLocalProvidersConfiguration().getLocalIdP();
        String idpListString = Arrays.toString(idpList);
        String[] stringArray = idpList;
        int n = idpList.length;
        int n2 = 0;
        while (n2 < n) {
            String idp = stringArray[n2];
            SAML2TrustedIdP idpConfig = this.getTrustedIdP(idp);
            if (idpConfig != null) {
                if (idpConfig.isEnabled()) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Trusted IdP [{0}] selected from the IdP list [{1}].", new Object[]{idp, idpListString});
                    }
                    return idp;
                }
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000133", (String)"Service Provider has received IdP list [{0}] as {1} that contains trusted IdP [{2}] which is not enabled.", (Object[])new Object[]{idpListString, receivedFrom, idp});
            } else {
                if (localIdPCfg != null && idp.equalsIgnoreCase(localIdPCfg.getName())) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Local IdP [{0}] selected from the IdP list [{1}].", new Object[]{idp, idpListString});
                    }
                    return idp;
                }
                SimpleLogger.log((int)300, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000132", (String)"Service Provider has received IdP list [{0}] as {1} that contains IdP [{2}] which is not trusted.", (Object[])new Object[]{idpListString, receivedFrom, idp});
            }
            ++n2;
        }
        SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000134", (String)"Service Provider has received IdP list [{0}] as {1} but none of the IdPs contained is trusted and enabled.", (Object[])new Object[]{idpListString, receivedFrom});
        return null;
    }

    private boolean selectIdPFromCDC() throws LoginException {
        boolean shouldTryExternalIdPDiscovery;
        boolean bl = shouldTryExternalIdPDiscovery = this.localSPConfig.isToUseExternalIdPDiscoveryReadService() && !this.providerSelectionService.isRequestFromExternalIdPDiscoveryService();
        if (this.localSPConfig.isToUseInternalIdPDiscoveryReadService()) {
            String[] idpList = this.providerSelectionService.internalGetVisitedProviderNames();
            String selectedIdP = this.selectIdPFromList(idpList, true);
            if (selectedIdP != null) {
                LOCATION.infoT("Identity Provider selected based on common domain cookie received.");
                this.trustedIdPConfig = this.getTrustedIdP(selectedIdP);
                return true;
            }
            if (idpList == null || idpList.length > 0) {
                // empty if block
            }
        }
        if (shouldTryExternalIdPDiscovery) {
            this.loginResult.throwIdPDiscoveryException("Service Provider redirects to IdP Discovery Service to evaluate the CDC cookie.");
        }
        return false;
    }

    boolean setManualIdPSelectionAttributes() {
        if (this.isIdPSelected()) {
            return false;
        }
        return this.providerSelectionService.setManualIdPSelectionAttributes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean selectIdPFromURLParameter(String identityProviderName) throws LoginException {
        this.trustedIdPConfig = this.getTrustedIdP(identityProviderName);
        if (this.trustedIdPConfig == null) {
            SAML2LocalIdP local = this.saml2Config.getLocalProvidersConfiguration().getLocalIdP();
            if (local == null || !local.getName().equalsIgnoreCase(identityProviderName)) return false;
            this.localIdPConfig = local;
            return true;
        } else {
            this.validateIdPConfiguration(identityProviderName, "URL parameter", false);
        }
        return true;
    }

    ProviderSelectionService getProviderSelectionService() {
        return this.providerSelectionService;
    }

    private SAML2Policy getPolicy() throws LoginFailedException {
        String policyName = this.loginModuleOptions.get(POLICY_LOGIN_MODULE_OPTION);
        if (policyName != null && policyName.length() != 0) {
            SAML2PoliciesConfig policyConfigurations = this.saml2Config.getPoliciesConfiguration();
            SAML2Policy policy = policyConfigurations.getPolicy(policyName);
            if (policy == null) {
                throw new LoginFailedException("SAML2 policy [" + policyName + "] specified as login module option cannot be found in SAML2 configuration.");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SAML2 policy to be used: {0}", new Object[]{policyName});
            }
            return policy;
        }
        LOCATION.debugT("SAML2 policy is not configured as a login module option.");
        return null;
    }
}

