/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2BindingDirection;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.commons.AuthnContextList;
import com.sap.security.saml2.commons.AuthnContextsMapping;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.commons.idpaccess.IdPAccessor;
import com.sap.security.saml2.sp.ConfigurationManager;
import com.sap.security.saml2.sp.LoginResult;
import com.sap.security.saml2.sp.SAML2LoginModuleUtil;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

public class LocalAuthenticationService {
    private static final Location LOCATION = Location.getLocation(LocalAuthenticationService.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"AuthenticationLog");
    private ConfigurationManager configManager;
    private CallbackHandler callbackHandler;
    private SAML2Principal saml2Principal;
    private LoginResult loginResult;
    private Map<String, Object> sharedState;
    private Map<String, String> options;

    LocalAuthenticationService(ConfigurationManager configManager, CallbackHandler callbackHandler, SAML2Principal saml2Principal, LoginResult loginResult, Map<String, Object> sharedState, Map<String, String> options) {
        this.configManager = configManager;
        this.callbackHandler = callbackHandler;
        this.saml2Principal = saml2Principal;
        this.loginResult = loginResult;
        this.sharedState = sharedState;
        this.options = options;
    }

    void redirectToIdP() throws LoginException {
        try {
            String ssoLocation;
            if (this.configManager.getForceAuthentication()) {
                this.setTimeStampInSession();
            }
            if ((ssoLocation = this.configManager.getLocalIdP().getSingleSignOnLocationHardCoded()) == null || ssoLocation.length() == 0) {
                throw new LoginException("Single Sign-On hard coded location is not configured in the local IdP configuration.");
            }
            String authnContexts = AuthnContextsMapping.buildAuthnContextString((List)this.configManager.getAuthenticationContexts().getNames());
            String relayState = SAML2LoginModuleUtil.getRelativeUrl(this.callbackHandler, this.options);
            String authnType = null;
            if (this.configManager.getForceAuthentication()) {
                authnType = "forced";
            } else if (this.configManager.isPassive()) {
                authnType = "passive";
            }
            String redirectUrl = this.buildRedirectUrlLocalIdP(ssoLocation, relayState, authnType, authnContexts);
            SAML2LoginModuleUtil.redirect(this.callbackHandler, redirectUrl);
        }
        catch (Exception e) {
            LoginException le = new LoginException("Error redirecting to local IdP.");
            le.initCause(e);
            throw le;
        }
    }

    void logout() throws LoginException {
        LOCATION.infoT("Service Provider triggers logout to local Identity Provider.");
        SAML2LocalIdP localIdP = this.configManager.getLocalIdP();
        if (!localIdP.isIdPInitiatedSLOEnabled()) {
            LOCATION.debugT("Local Service Provider will not redirect to local Identity Provider to perform a logout because IdP-Initiated SLO has been disabled in the configuration. Local context will be terminated.");
            this.sharedState.put("com.sap.security.saml2.sp.SAML2LoginModule_LoginModuleDetails", "Local Service Provider will not redirect to local Identity Provider to perform a logout because IdP-Initiated SLO has been disabled in the configuration. Local context will be terminated.");
            return;
        }
        try {
            SAML2BindingDirection bindingDirection = this.getSLOBindingDirection();
            if (SAML2BindingDirection.BACK_CHANNEL == bindingDirection) {
                if (this.configManager.isDefaultSAML2Configuration()) {
                    IdPAccessor.getInstance().getIdentityProviderAccess().logoutServiceProviders();
                } else {
                    String localIdPName = localIdP.getName();
                    IdPAccessor.getInstance().getIdentityProviderAccess().logoutServiceProviders(localIdPName);
                }
                LOCATION.debugT("Local Logout executed over back-channel.");
            } else if (SAML2BindingDirection.FRONT_CHANNEL == bindingDirection) {
                String redirectUrl = null;
                String sloLocation = this.configManager.getLocalIdP().getSingleLogoutLocationHardCoded();
                if (sloLocation == null || sloLocation.length() == 0) {
                    throw new LoginException("Single Logout hard coded location is not configured in the local IdP configuration.");
                }
                if (this.configManager.isDefaultSAML2Configuration()) {
                    redirectUrl = sloLocation;
                } else {
                    SAML2LocalProvider localProvider = this.configManager.getLocalProvider();
                    redirectUrl = SAML2LoginModuleUtil.addProviderNameToUrl(sloLocation, localProvider.getName());
                }
                String relayState = SAML2LoginModuleUtil.getOriginalUrl(this.callbackHandler, this.options);
                redirectUrl = String.valueOf(redirectUrl) + "?RelayState=" + URLEncoder.encode(relayState, "UTF-8");
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Local Logout front-channel redirect URL: {0}", new Object[]{redirectUrl});
                }
                SAML2LoginModuleUtil.redirect(this.callbackHandler, redirectUrl);
                throw new LoginException("Executing Local Logout.");
            }
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            LoginException le = new LoginException("Could not perform Local Logout.");
            le.initCause(e);
            throw le;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void login() throws LoginException {
        if (this.saml2Principal != null) {
            try {
                SAML2LocalProvider localProvider = this.configManager.getLocalProvider();
                if (!this.saml2Principal.getIdPName().equalsIgnoreCase(localProvider.getName())) {
                    SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000008", (String)"Local Provider [{0}] is different from the provider [{1}] set in the SAMLPrincipal.", (Object[])new Object[]{localProvider.getName(), this.saml2Principal.getIdPName()});
                    throw new LoginException("Local provider name is different from provider saved in SAML2Principal.");
                }
                AuthnContextList authenticatedContexts = this.saml2Principal.getAuthnContexts();
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Authenticated contexts in principal: {0}", new Object[]{authenticatedContexts});
                }
                AuthnContextList configuredContexts = this.configManager.getAuthenticationContexts();
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Configured contexts for the application: {0}", new Object[]{configuredContexts});
                }
                boolean shouldChallenge = false;
                if (this.configManager.getForceAuthentication()) {
                    Long timeStamp = this.getTimeStampFromSession();
                    boolean hasInteractiveAuthentication = false;
                    hasInteractiveAuthentication = configuredContexts.isEmpty() ? authenticatedContexts.hasAuthnContext(timeStamp, this.configManager.getForceAuthentication()) : authenticatedContexts.hasAuthnContext(timeStamp, configuredContexts);
                    boolean bl = shouldChallenge = !hasInteractiveAuthentication;
                }
                if (!shouldChallenge) {
                    boolean isSufficientContexts = configuredContexts.isEmpty() || authenticatedContexts.hasSufficient(configuredContexts);
                    boolean bl = shouldChallenge = !isSufficientContexts;
                }
                if (shouldChallenge) {
                    this.authenticationChallenge();
                    return;
                }
                this.ssoBetweenApplications();
                if (!SAML2LoginModuleUtil.isOriginalRequestPost(this.callbackHandler)) return;
                SAML2LoginModuleUtil.restorePostParams(this.callbackHandler);
                return;
            }
            catch (LoginException e) {
                throw e;
            }
            catch (Exception e) {
                LoginException le = new LoginException("Local login failed.");
                le.initCause(e);
                throw le;
            }
        } else {
            this.authenticationChallenge();
        }
    }

    private void authenticationChallenge() throws LoginException {
        LOCATION.debugT("Service Provider triggers Initial Authentication Challenge.");
        LOCATION.infoT("Service Provider triggers authentication to local Identity Provider.");
        this.loginResult.throwCredentialNotFoundException("Authentication Challenge due to missing credentials.");
    }

    private void ssoBetweenApplications() {
        LOCATION.debugT("Service Provider performs Single Sign-On between Applications.");
        this.loginResult.setLocalUser(this.saml2Principal.getName());
        this.loginResult.setLoginStatus((byte)5);
    }

    private void setTimeStampInSession() throws Exception {
        long ts = Calendar.getInstance().getTimeInMillis();
        if (SAML2LoginModuleUtil.isSessionAnonymous()) {
            SAML2LoginModuleUtil.setRuntimeModelAttribute(this.callbackHandler, "com.sap.security.saml2.sp.LocalAuthnTimeStamp", ts);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Force authentication required. TimeStamp set in runtime model: {0}", new Object[]{ts});
            }
        } else {
            SAML2LoginModuleUtil.setSessionAttribute(this.callbackHandler, "com.sap.security.saml2.sp.LocalAuthnTimeStamp", ts);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Force authentication required. TimeStamp set in application session: {0}", new Object[]{ts});
            }
        }
    }

    private Long getTimeStampFromSession() throws Exception {
        Long timeStamp = 0L;
        if (SAML2LoginModuleUtil.isSessionAnonymous()) {
            timeStamp = (Long)SAML2LoginModuleUtil.removeRuntimeModelAttribute(this.callbackHandler, "com.sap.security.saml2.sp.LocalAuthnTimeStamp");
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication type is forced. Application session is anonymous. TimeStamp retrieved from runtime model: {0}", new Object[]{timeStamp});
            }
        } else if (!SAML2LoginModuleUtil.isSessionProlongation(this.callbackHandler)) {
            timeStamp = (Long)SAML2LoginModuleUtil.getSessionAttribute(this.callbackHandler, "com.sap.security.saml2.sp.LocalAuthnTimeStamp");
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication type is forced. Application session is not anonymous. TimeStamp retrieved from session: {0}", new Object[]{timeStamp});
            }
            SAML2LoginModuleUtil.setSessionAttribute(this.callbackHandler, "com.sap.security.saml2.sp.LocalAuthnTimeStamp", null);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("TimeStamp removed from session successfully.");
            }
        }
        return timeStamp;
    }

    private String buildRedirectUrlLocalIdP(String ssoLocation, String relayState, String authnType, String authnContexts) throws UnsupportedEncodingException {
        StringBuilder redirectUrl = new StringBuilder();
        if (!this.configManager.isDefaultSAML2Configuration()) {
            SAML2LocalProvider localProvider = this.configManager.getLocalProvider();
            redirectUrl.append(SAML2LoginModuleUtil.addProviderNameToUrl(ssoLocation, localProvider.getName()));
        } else {
            redirectUrl.append(ssoLocation);
        }
        redirectUrl.append("?");
        redirectUrl.append("RelayState");
        redirectUrl.append("=");
        redirectUrl.append(URLEncoder.encode(relayState, "UTF-8"));
        if (authnType != null) {
            redirectUrl.append("&");
            redirectUrl.append("saml2authnpolicy");
            redirectUrl.append("=");
            redirectUrl.append(authnType);
        }
        if (authnContexts.length() != 0) {
            if (authnContexts.endsWith(";")) {
                authnContexts = authnContexts.substring(0, authnContexts.length() - 1);
            }
            redirectUrl.append("&");
            redirectUrl.append("saml2authncontexts");
            redirectUrl.append("=");
            redirectUrl.append(authnContexts);
        }
        String url = redirectUrl.toString();
        if (SAML2LoginModuleUtil.isOriginalRequestPost(this.callbackHandler)) {
            SAML2LoginModuleUtil.storePostParams(this.callbackHandler);
            url = SAML2LoginModuleUtil.addSAML2PostParameter(url);
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Local login is using redirect URL: {0}", new Object[]{url});
        }
        return url;
    }

    private SAML2BindingDirection getSLOBindingDirection() throws LoginException {
        SAML2Binding binding = this.configManager.getBindingFromURLParameter();
        SAML2BindingDirection bindingDirection = null;
        if (binding != null) {
            bindingDirection = SAML2Binding.SOAP_BINDING.equals((Object)binding) ? SAML2BindingDirection.BACK_CHANNEL : SAML2BindingDirection.FRONT_CHANNEL;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("IdP-Initiated SLO binding direction [{0}] selected based on binding [{1}] specified by URL parameter.", new Object[]{bindingDirection, binding.getName()});
            }
        } else {
            SAML2LocalIdP localIdP = this.configManager.getLocalIdP();
            bindingDirection = localIdP.getIdPInitiatedSingleLogoutDirection();
            if (bindingDirection == null) {
                throw new LoginException("IdP-Initated SLO direction is not configured.");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("IdP-Initiated SLO binding direction: [{0}]", new Object[]{bindingDirection});
            }
        }
        return bindingDirection;
    }
}

