/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.commons.AuditData;
import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.commons.IdPProxyContext;
import com.sap.security.saml2.lib.attributes.AttributeValues;
import com.sap.security.saml2.sp.exception.BadCredentialsException;
import com.sap.security.saml2.sp.exception.LoginFailedException;
import com.sap.security.saml2.sp.exception.NameIdMappingFailedException;
import com.sap.security.saml2.sp.exception.NameIdMappingNoSuchUserException;
import com.sap.tc.logging.Location;
import java.util.Date;
import javax.security.auth.login.CredentialNotFoundException;
import javax.security.auth.login.LoginException;

public class LoginResult {
    private static final Location LOCATION = Location.getLocation(LoginResult.class);
    static final String RESUMING_AUTHENTICATION_MSG = "Resuming SAML2 authentication based on already validated SAML2 token in previous authentication attempt.";
    static final byte STATUS_CODE_CHALLENGE = 0;
    static final byte STATUS_CODE_AUTHENTICATION = 1;
    static final byte STATUS_CODE_FAILURE = 2;
    static final byte STATUS_CODE_REAUTHENTICATION = 3;
    static final byte STATUS_CODE_FEDERATION = 4;
    static final byte STATUS_CODE_SSO = 5;
    static final byte STATUS_CODE_IDPDISCOVERY = 6;
    static final byte STATUS_CODE_MANUAL_IDP_SELECTION = 7;
    private String localUser;
    private String principalNameId;
    private String principalNameIdFormat;
    private String nameIdSPProvidedID;
    private String subjectNameIdSPNameQualifier;
    private String subjectNameIdNameQualifier;
    private AttributeValues assertionAttributes;
    private String idpName;
    private String sessionIndex;
    private String clusterWideClientID;
    private Date sessionNotOnOrAfter;
    private Date subjectConfirmationNotOnOrAfter;
    private String authnContext;
    private String tokenId;
    private boolean federationRequired = false;
    private byte loginStatus = (byte)2;
    private IdPProxyContext idpProxyContext;
    private AuditData auditData = new AuditData();
    private boolean hasLoginResultInSession;
    private boolean isSAML2ResponseSigned;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LoginResult: \nlocalUser=").append(this.localUser);
        sb.append("\nprincipalNameId=").append(this.principalNameId);
        sb.append("\nprincipalNameIdFormat=").append(this.principalNameIdFormat);
        sb.append("\nnameIdSPProvidedID=").append(this.nameIdSPProvidedID);
        sb.append("\nsubjectNameIdSPNameQualifier=").append(this.subjectNameIdSPNameQualifier);
        sb.append("\nsubjectNameIdNameQualifier=").append(this.subjectNameIdNameQualifier);
        sb.append("\nassertionAttributes=").append(this.assertionAttributes);
        sb.append("\nidpName=").append(this.idpName);
        sb.append("\nsessionIndex=").append(this.sessionIndex);
        sb.append("\nclusterWideClientID=").append(this.clusterWideClientID);
        sb.append("\nsessionNotOnOrAfter=").append(this.sessionNotOnOrAfter);
        sb.append("\nsubjectConfirmationNotOnOrAfter=").append(this.subjectConfirmationNotOnOrAfter);
        sb.append("\nauthnContext=").append(this.authnContext);
        sb.append("\ntokenId=").append(this.tokenId);
        sb.append("\nloginStatus=").append(this.loginStatus);
        sb.append("\nfederationRequired=").append(this.federationRequired);
        sb.append("\nIdP Proxy Context=").append(this.idpProxyContext);
        sb.append("\nauditData=").append(this.auditData);
        sb.append("\nisSAML2ResponseSigned=").append(this.isSAML2ResponseSigned);
        return sb.toString();
    }

    public String getLocalUser() {
        return this.localUser;
    }

    void setLocalUser(String localUser) {
        this.localUser = localUser;
    }

    String getSessionIndex() {
        return this.sessionIndex;
    }

    void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    String getPrincipalNameId() {
        return this.principalNameId;
    }

    void setPrincipalNameId(String principalNameId) {
        this.principalNameId = principalNameId;
    }

    String getPrincipalNameIdFormat() {
        return this.principalNameIdFormat;
    }

    void setPrincipalNameIdFormat(String principalNameIdFormat) {
        this.principalNameIdFormat = principalNameIdFormat;
    }

    String getNameIdSPProvidedId() {
        return this.nameIdSPProvidedID;
    }

    void setNameIdSPProvidedId(String nameIdSPProvidedID) {
        this.nameIdSPProvidedID = nameIdSPProvidedID;
    }

    String getSubjectNameIdSPNameQualifier() {
        return this.subjectNameIdSPNameQualifier;
    }

    void setSubjectNameIdSPNameQualifier(String subjectNameIdSPNameQualifier) {
        this.subjectNameIdSPNameQualifier = subjectNameIdSPNameQualifier;
    }

    String getSubjectNameIdNameQualifier() {
        return this.subjectNameIdNameQualifier;
    }

    void setSubjectNameIdNameQualifier(String subjectNameQualifier) {
        this.subjectNameIdNameQualifier = subjectNameQualifier;
    }

    AttributeValues getAssertionAttributes() {
        return this.assertionAttributes;
    }

    void setAssertionAttributes(AttributeValues assertionAttributes) {
        this.assertionAttributes = assertionAttributes;
    }

    String getIdpName() {
        return this.idpName;
    }

    void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public String getAuthenticationContext() {
        return this.authnContext;
    }

    void setAuthenticationContext(String authnContext) {
        this.authnContext = authnContext;
    }

    String getTokenId() {
        return this.tokenId;
    }

    void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    byte getLoginStatus() {
        return this.loginStatus;
    }

    void setLoginStatus(byte loginStatus) {
        this.loginStatus = loginStatus;
    }

    NameIdMappingNoSuchUserException getMappingFailedException() {
        return new NameIdMappingNoSuchUserException(RESUMING_AUTHENTICATION_MSG);
    }

    void throwCredentialNotFoundException(String message) throws CredentialNotFoundException {
        String auditMessage = null;
        auditMessage = this.auditData.getAssertion() != null ? CommonSAML2Utils.getRejectedAssertionAuditString((AuditData)this.auditData, (String)message) : message;
        this.loginStatus = 0;
        throw new CredentialNotFoundException(auditMessage);
    }

    void throwIdPDiscoveryException(String message) throws LoginException {
        this.loginStatus = (byte)6;
        throw new LoginException(message);
    }

    void throwManualIdPSelectionException(String message) throws LoginException {
        this.loginStatus = (byte)7;
        throw new LoginException(message);
    }

    void throwLoginFailedException(String message) throws LoginFailedException {
        String auditMessage = this.getAuditMessage(message);
        this.loginStatus = (byte)2;
        throw new LoginFailedException(auditMessage);
    }

    void throwLoginFailedException(String message, Throwable cause) throws LoginFailedException {
        LOCATION.traceThrowableT(100, message, cause);
        String auditMessage = this.getAuditMessage(message);
        this.loginStatus = (byte)2;
        throw new LoginFailedException(auditMessage, cause);
    }

    void throwBadCredentialException(String message) throws BadCredentialsException {
        String auditMessage = this.getAuditMessage(message);
        this.loginStatus = (byte)2;
        throw new BadCredentialsException(auditMessage);
    }

    void throwBadCredentialException(String message, Throwable cause) throws BadCredentialsException {
        String auditMessage = this.getAuditMessage(message);
        this.loginStatus = (byte)2;
        throw new BadCredentialsException(auditMessage, cause);
    }

    void throwInteractiveFederationRequired(String message) throws NameIdMappingNoSuchUserException {
        String auditMessage = CommonSAML2Utils.getSuccessAssertionAuditString((AuditData)this.auditData, (String)message);
        this.loginStatus = (byte)4;
        throw new NameIdMappingNoSuchUserException(auditMessage);
    }

    void throwNameIDMappingNoSuchUserException(String message) throws NameIdMappingNoSuchUserException {
        String auditMessage = CommonSAML2Utils.getRejectedAssertionAuditString((AuditData)this.auditData, (String)message);
        this.loginStatus = (byte)2;
        throw new NameIdMappingNoSuchUserException(auditMessage);
    }

    void throwNameIDMappingFailedException(String message, Throwable cause) throws NameIdMappingFailedException {
        LOCATION.traceThrowableT(100, message, cause);
        String auditMessage = CommonSAML2Utils.getRejectedAssertionAuditString((AuditData)this.auditData, (String)message);
        this.loginStatus = (byte)2;
        throw new NameIdMappingFailedException(auditMessage, cause);
    }

    void throwNameIDMappingFailedException(String message) throws NameIdMappingFailedException {
        String auditMessage = CommonSAML2Utils.getRejectedAssertionAuditString((AuditData)this.auditData, (String)message);
        this.loginStatus = (byte)2;
        throw new NameIdMappingFailedException(auditMessage);
    }

    String getClusterWideClientID() {
        return this.clusterWideClientID;
    }

    void setClusterWideClientID(String clientId) {
        this.clusterWideClientID = clientId;
    }

    Date getSessionNotOnOrAfter() {
        return this.sessionNotOnOrAfter;
    }

    void setSessionNotOnOrAfter(Date sessionNotOnOrAfter) {
        this.sessionNotOnOrAfter = sessionNotOnOrAfter;
    }

    Date getSubjectConfirmationNotOnOrAfter() {
        return this.subjectConfirmationNotOnOrAfter;
    }

    void setSubjectConfirmationNotOnOrAfter(Date subjectConfirmationNotOnOrAfter) {
        this.subjectConfirmationNotOnOrAfter = subjectConfirmationNotOnOrAfter;
    }

    boolean isFederationRequired() {
        return this.federationRequired;
    }

    void setFederationRequired(boolean federationRequired) {
        this.federationRequired = federationRequired;
    }

    IdPProxyContext getIdpProxyContext() {
        return this.idpProxyContext;
    }

    void setIdpProxyContext(IdPProxyContext idpProxyContext) {
        this.idpProxyContext = idpProxyContext;
    }

    AuditData getAuditData() {
        return this.auditData;
    }

    private String getAuditMessage(String message) {
        String auditMessage = null;
        auditMessage = this.auditData.getAssertion() != null ? CommonSAML2Utils.getRejectedAssertionAuditString((AuditData)this.auditData, (String)message) : (this.auditData.getSaml2ResponseBase() != null ? CommonSAML2Utils.getRejectedResponseAuditString((AuditData)this.auditData, (String)message) : message);
        return auditMessage;
    }

    boolean hasLoginResultInSession() {
        return this.hasLoginResultInSession;
    }

    void setLoginResultInSession(boolean hasLoginResultInSession) {
        this.hasLoginResultInSession = hasLoginResultInSession;
    }

    boolean isSAML2ResponseSigned() {
        return this.isSAML2ResponseSigned;
    }

    void setSAML2ResponseSigned(boolean isSAML2ResponseSigned) {
        this.isSAML2ResponseSigned = isSAML2ResponseSigned;
    }
}

