/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OriginalUrlCookie {
    private static final Location LOCATION = Location.getLocation(OriginalUrlCookie.class);
    private static final String COOKIE_NAME_PREFIX = "ouc";
    private static final String COOKIE_PATH = "/";
    private static final String COOKIE_PARTS_DELIMITER = ";";
    private static final String APPLICATION_URL_PART = "appUrl";
    private static final String REQUEST_ID_PART = "reqId";
    private static final String PROXYING_PART = "proxy";
    private static final String TIMESTAMP_PART = "timestamp";
    private static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String SECRET_KEY_ALGORITHM = "AES";
    private static final int SECURE_RANDOM_SEED_SIZE = 10;
    private static final int SECURE_RANDOM_BYTE_SIZE = 20;
    private SAML2LocalSP localSP;
    private CallbackHandler callbackHandler;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String originalUrl;
    private String requestId;
    private boolean proxyingFlag;
    private boolean isCallerServlet;
    private boolean isSecure;
    private long timestamp;

    public OriginalUrlCookie(CallbackHandler callbackHandler, SAML2LocalSP localSP) {
        this.callbackHandler = callbackHandler;
        this.localSP = localSP;
        this.isCallerServlet = false;
        this.isSecure = !localSP.isPlainHTTPConnectionsEnabled();
    }

    public OriginalUrlCookie(HttpServletRequest request, HttpServletResponse response, SAML2LocalSP localSP) {
        this.request = request;
        this.response = response;
        this.localSP = localSP;
        this.isCallerServlet = true;
        this.isSecure = !localSP.isPlainHTTPConnectionsEnabled();
    }

    public Long getTimestampOfCreation() {
        return this.timestamp;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public boolean isProxyingFlag() {
        return this.proxyingFlag;
    }

    public static boolean isOriginalUrlCookieName(String name) {
        return name != null && name.startsWith(COOKIE_NAME_PREFIX);
    }

    public String addCookie(String applicationUrl, String requestId) throws Exception {
        return this.addCookie(applicationUrl, requestId, false);
    }

    public String addCookie(String applicationUrl, String requestId, boolean isProxying) throws Exception {
        String cookieName = this.generateCookieName(requestId);
        String cookie = this.generateCookieValue(applicationUrl, requestId, isProxying);
        this.addCookieToResponse(cookieName, cookie);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Application URL [{0}] set as cookie: name = [{1}], value = [{2}]", new Object[]{applicationUrl, cookieName, cookie});
        }
        return cookieName;
    }

    public void parseCookie(String cookieName) throws Exception {
        if (!OriginalUrlCookie.isOriginalUrlCookieName(cookieName)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Could not parse original application URL cookie because the provided name is invalid: {0}", new Object[]{cookieName});
            }
        } else {
            String cookieValue = (String)this.getCookieFromRequest(cookieName);
            if (cookieValue != null) {
                String[] parts;
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Original application URL cookie value: {0}", new Object[]{cookieValue});
                }
                String decryptedValue = this.decrypt(cookieValue);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Decrypted original application URL cookie value: {0}", new Object[]{decryptedValue});
                }
                if ((parts = decryptedValue.split(COOKIE_PARTS_DELIMITER)).length != 5) {
                    throw new Exception("Invalid cookie value: " + decryptedValue);
                }
                this.handleCookieParts(parts);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("OUC cookie parsed to: \nOriginal application URL: {0}\nRequestID: {1}\nProxyFlag: {2}", new Object[]{this.originalUrl, this.requestId, this.proxyingFlag});
                }
            } else {
                LOCATION.warningT("Original application URL cookie not found in HTTP request.");
            }
        }
    }

    private void handleCookieParts(String[] parts) throws Exception {
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String timestamp;
            String part = stringArray[n2];
            if (part.startsWith(APPLICATION_URL_PART)) {
                this.originalUrl = this.getValueFromPair(part);
            } else if (part.startsWith(REQUEST_ID_PART)) {
                this.requestId = this.getValueFromPair(part);
            } else if (part.startsWith(PROXYING_PART)) {
                this.proxyingFlag = Boolean.parseBoolean(this.getValueFromPair(part));
            } else if (part.startsWith(TIMESTAMP_PART) && !"".equals(timestamp = this.getValueFromPair(part))) {
                this.timestamp = Long.parseLong(timestamp);
            }
            ++n2;
        }
    }

    public void removeCookie(String name) {
        if (OriginalUrlCookie.isOriginalUrlCookieName(name)) {
            StringBuilder sbCookieValue = new StringBuilder(" ; Max-Age=0; Expires=Thu, 01-Jan-1970 00:00:10 GMT");
            String domain = this.getCookieDomainAttribute();
            if (domain != null) {
                sbCookieValue.append("; domain=");
                sbCookieValue.append(domain);
            }
            sbCookieValue.append("; path=");
            sbCookieValue.append(COOKIE_PATH);
            if (this.isSecure) {
                sbCookieValue.append("; secure");
            }
            sbCookieValue.append("; HttpOnly");
            if (this.isCallerServlet) {
                this.response.addHeader("set-cookie", String.valueOf(name) + "=" + sbCookieValue.toString());
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Application URL cookie [{0}] successfully removed.", new Object[]{name});
                }
            } else {
                try {
                    HttpSetterCallback setCookieCb = new HttpSetterCallback();
                    setCookieCb.setType((byte)1);
                    setCookieCb.setName("set-cookie");
                    setCookieCb.setValue((Object)(String.valueOf(name) + "=" + sbCookieValue.toString()));
                    this.callbackHandler.handle(new Callback[]{setCookieCb});
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Application URL cookie [{0}] successfully removed.", new Object[]{name});
                    }
                }
                catch (Exception e) {
                    LOCATION.traceThrowableT(500, "Could not remove original application URL cookie from HTTP request.", (Throwable)e);
                }
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Could not remove original application URL cookie because the provided name is invalid: {0}", new Object[]{name});
        }
    }

    private String generateCookieName(String requestId) {
        StringBuilder name = new StringBuilder(COOKIE_NAME_PREFIX);
        int hashCodeInt = requestId.hashCode();
        if (hashCodeInt < 0) {
            hashCodeInt *= -1;
        }
        String hashCode = String.valueOf(hashCodeInt);
        int i = 0;
        while (i < hashCode.length()) {
            int next = Integer.parseInt(String.valueOf(hashCode.charAt(i)));
            next = next * 25 / 10;
            name.append((char)(97 + next));
            ++i;
        }
        return name.toString();
    }

    private String generateCookieValue(String applicationUrl, String requestId, boolean isProxying) throws NoSuchAlgorithmException, SAML2Exception {
        String appPart = this.generateKeyValuePair(APPLICATION_URL_PART, applicationUrl);
        String reqPart = this.generateKeyValuePair(REQUEST_ID_PART, requestId);
        String proxyPart = this.generateKeyValuePair(PROXYING_PART, String.valueOf(isProxying));
        String timestamp = this.generateKeyValuePair(TIMESTAMP_PART, String.valueOf(System.currentTimeMillis()));
        String randomPart = this.generateRandomPart();
        StringBuilder value = new StringBuilder();
        value.append(randomPart).append(COOKIE_PARTS_DELIMITER);
        value.append(appPart).append(COOKIE_PARTS_DELIMITER);
        value.append(reqPart).append(COOKIE_PARTS_DELIMITER);
        value.append(timestamp).append(COOKIE_PARTS_DELIMITER);
        value.append(proxyPart);
        String plainValue = value.toString();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Plain original application URL cookie value: {0}", new Object[]{plainValue});
        }
        String encryptedValue = this.encrypt(plainValue);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Encrypted original application URL cookie value: {0}", new Object[]{encryptedValue});
        }
        return encryptedValue;
    }

    private String generateKeyValuePair(String name, String value) throws SAML2Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("=").append(SAML2Utils.encodeBase64AsString((String)value));
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Name-value pair [name = {0}, value = {1}] added to original application URL cookie value.", new Object[]{name, value});
        }
        return sb.toString();
    }

    private String getValueFromPair(String pair) throws Exception {
        int pos = pair.indexOf(61);
        if (pos != -1) {
            String value = pair.substring(pos + 1);
            if (value.length() > 0) {
                String decodedValue = SAML2Utils.decodeBase64AsString((String)value);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Value [{0}] extracted from name-value pair [{1}] from original application URL cookie value.", new Object[]{value, pair});
                }
                return decodedValue;
            }
            return value;
        }
        throw new Exception("Invalid name-value pair in original application URL cookie value: " + pair);
    }

    private String generateRandomPart() throws NoSuchAlgorithmException, SAML2Exception {
        SecureRandom random = SecureRandom.getInstance(SECURE_RANDOM_ALGORITHM);
        byte[] seed = random.generateSeed(10);
        random.setSeed(seed);
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return SAML2Utils.encodeBase64((byte[])bytes);
    }

    private Object getCookieFromRequest(String name) {
        if (!this.isCallerServlet) {
            try {
                HttpGetterCallback getCookieCb = new HttpGetterCallback();
                getCookieCb.setType((byte)2);
                getCookieCb.setName(name);
                this.callbackHandler.handle(new Callback[]{getCookieCb});
                return getCookieCb.getValue();
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Could not get original application URL cookie from HTTP request.", (Throwable)e);
            }
        } else {
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                Cookie[] cookieArray = cookies;
                int n = cookies.length;
                int n2 = 0;
                while (n2 < n) {
                    Cookie cookie = cookieArray[n2];
                    if (cookie.getName().equalsIgnoreCase(name)) {
                        return cookie.getValue();
                    }
                    ++n2;
                }
            } else {
                LOCATION.debugT("HTTP request contains no cookies. Original application URL cookie not found in request.");
            }
        }
        return null;
    }

    private void addCookieToResponse(String name, String value) {
        if (this.isCallerServlet) {
            throw new IllegalStateException("Only SAML2LoginModule could set original application URL.");
        }
        StringBuilder sbCookieValue = new StringBuilder();
        sbCookieValue.append(value);
        String domain = this.getCookieDomainAttribute();
        if (domain != null) {
            sbCookieValue.append("; domain=");
            sbCookieValue.append(domain);
        }
        sbCookieValue.append("; path=");
        sbCookieValue.append(COOKIE_PATH);
        if (this.isSecure) {
            sbCookieValue.append("; secure");
        }
        sbCookieValue.append("; HttpOnly");
        HttpSetterCallback setCookieCb = new HttpSetterCallback();
        setCookieCb.setType((byte)2);
        setCookieCb.setName(name);
        setCookieCb.setValue((Object)sbCookieValue.toString());
        try {
            this.callbackHandler.handle(new Callback[]{setCookieCb});
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could add original application URL cookie to HTTP response.", (Throwable)e);
        }
    }

    private String getCookieDomainAttribute() {
        String domain = null;
        int relaxLevel = this.localSP.getDomainRelaxLevel();
        if (relaxLevel > 0) {
            String hostname = this.getHostName();
            if (hostname != null) {
                boolean isIPAddress = hostname.matches("(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9])[.]){3}(([2]([0-4][0-9]|[5][0-5])|[0-1]?[0-9]?[0-9]))");
                if (isIPAddress) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Host name is an IP address. Configuration setting for relax domain will be ignored.");
                    }
                } else if (hostname.indexOf(46) == -1) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Host name is not a fully qualified domain name. Configuration setting for relax domain will be ignored.");
                    }
                } else {
                    Vector<Integer> v = new Vector<Integer>();
                    int i = 0;
                    while (i < hostname.length()) {
                        if (hostname.charAt(i) == '.') {
                            v.add(new Integer(i));
                        }
                        ++i;
                    }
                    if (v.size() > relaxLevel) {
                        domain = hostname.substring((Integer)v.elementAt(relaxLevel - 1));
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT("Original URL cookie domain attribute: {0}", new Object[]{domain});
                        }
                    } else if (LOCATION.beDebug()) {
                        LOCATION.debugT("Relax domain level value [{0}] is greater than number of subdomains [{1}]. Configuration setting for relax domain will be ignored.", new Object[]{relaxLevel, v.size()});
                    }
                }
            } else {
                LOCATION.warningT("Could not get host header from HTTP request. Configuration setting for relax domain will be ignored.");
            }
        }
        return domain;
    }

    private String getHostName() {
        int colon;
        String hostname = null;
        if (this.isCallerServlet) {
            hostname = this.request.getServerName();
        } else {
            HttpGetterCallback getterCallback = new HttpGetterCallback();
            getterCallback.setType((byte)1);
            getterCallback.setName("Host");
            try {
                this.callbackHandler.handle(new Callback[]{getterCallback});
                hostname = (String)getterCallback.getValue();
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Could not get host header from HTTP request.", (Throwable)e);
            }
        }
        if (hostname != null && (colon = hostname.indexOf(58)) != -1) {
            hostname = hostname.substring(0, colon);
        }
        return hostname;
    }

    private String encrypt(String toEncrypt) throws SAML2Exception {
        try {
            byte[] keyBytes = this.getSymmetricKey();
            SecretKeySpec symmetricKey = new SecretKeySpec(keyBytes, SECRET_KEY_ALGORITHM);
            IvParameterSpec initVector = new IvParameterSpec(this.getInitializationVector());
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(1, (Key)symmetricKey, initVector);
            byte[] encryptedBytes = cipher.doFinal(toEncrypt.getBytes("UTF-8"));
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Original application URL cookie successfully encrypted.");
            }
            String base64Encoded = SAML2Utils.encodeBase64((byte[])encryptedBytes);
            String urlEncoded = URLEncoder.encode(base64Encoded, "UTF-8");
            return urlEncoded;
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(400, "Could not encrypt original application URL cookie.", (Throwable)e);
            throw new SAML2Exception("Could not encrypt original application URL cookie.", (Throwable)e);
        }
    }

    private String decrypt(String toDecrypt) throws SAML2Exception {
        try {
            String decodedString = URLDecoder.decode(toDecrypt, "UTF-8");
            byte[] decodedBytes = SAML2Utils.decodeBase64((String)decodedString);
            byte[] keyBytes = this.getSymmetricKey();
            SecretKeySpec symmetricKey = new SecretKeySpec(keyBytes, SECRET_KEY_ALGORITHM);
            IvParameterSpec initVector = new IvParameterSpec(this.getInitializationVector());
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(2, (Key)symmetricKey, initVector);
            String decryptedString = new String(cipher.doFinal(decodedBytes), "UTF-8");
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Original application URL cookie successfully decrypted.");
            }
            return decryptedString;
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(400, "Could not decrypt original application URL cookie.", (Throwable)e);
            throw new SAML2Exception("Could not decrypt original application URL cookie.", (Throwable)e);
        }
    }

    private byte[] getInitializationVector() throws SAML2ConfigurationException {
        PrivateKey privateKey = this.localSP.getPrivateKeyForEncryption();
        if (privateKey == null) {
            throw new SAML2ConfigurationException("Original application URL cookie not decrypted because the private key for encryption is not configured.");
        }
        byte[] bytes = new byte[16];
        System.arraycopy(privateKey.getEncoded(), 16, bytes, 0, 16);
        return bytes;
    }

    private byte[] getSymmetricKey() throws SAML2ConfigurationException {
        PrivateKey privateKey = this.localSP.getPrivateKeyForEncryption();
        if (privateKey == null) {
            throw new SAML2ConfigurationException("Original application URL cookie not decrypted because the private key for encryption is not configured.");
        }
        byte[] bytes = new byte[16];
        System.arraycopy(privateKey.getEncoded(), 0, bytes, 0, 16);
        return bytes;
    }
}

