/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.cfg.enums.SAML2IdPSelectionMode;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2LocalProvidersConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2TrustedIdPsConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.lib.common.SAML2ServicesManager;
import com.sap.security.saml2.sp.ConfigurationManager;
import com.sap.security.saml2.sp.SAML2LoginModuleUtil;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;

public class ProviderSelectionService {
    private static final Location LOCATION = Location.getLocation(ProviderSelectionService.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");
    private ConfigurationManager configManager;
    private SAML2Config saml2Config;
    private CallbackHandler callbackHandler;
    private Boolean isManualIdPSelectionMode;

    ProviderSelectionService(ConfigurationManager configManager, CallbackHandler callbackHandler) {
        this.configManager = configManager;
        this.saml2Config = configManager.getSAML2Config();
        this.callbackHandler = callbackHandler;
    }

    boolean setManualIdPSelectionAttributes() {
        if (!this.isManualIdPSelectionMode()) {
            return false;
        }
        Map<String, String> trustedIdPList = this.buildTrustedIdPList();
        if (trustedIdPList.isEmpty()) {
            return false;
        }
        if (trustedIdPList.size() == 1) {
            SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/idp_discovery", trustedIdPList);
        } else {
            TreeMap<String, String> visitedIdPList = new TreeMap<String, String>();
            String visitedSelected = this.buildVisitedIdPList(visitedIdPList);
            try {
                if (this.configManager.isLocalIdP()) {
                    SAML2LocalIdP localIdP = this.configManager.getLocalIdP();
                    String localIdPName = localIdP.getName();
                    SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/idp_discovery_default", localIdPName);
                    trustedIdPList.put(localIdPName, localIdPName);
                } else if (this.saml2Config.getLocalProvidersConfiguration().isIdentityProviderEnabled()) {
                    String localIdPName = this.saml2Config.getLocalProvidersConfiguration().getLocalIdP().getName();
                    SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/idp_discovery_default", localIdPName);
                    trustedIdPList.put(localIdPName, localIdPName);
                } else {
                    String defaultIdPName = this.saml2Config.getTrustedIdPsConfiguration().getDefaultTrustedIdPName();
                    SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/idp_discovery_default", defaultIdPName);
                }
                SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/idp_discovery", trustedIdPList);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("List of trusted Identity Providers set as [{0}] HTTP request attribute: {1}.", new Object[]{"sap.com/idp_discovery", trustedIdPList});
                }
                if (!visitedIdPList.isEmpty()) {
                    SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/idp_discovery_visited", visitedIdPList);
                    SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/idp_discovery_visited_selected", visitedSelected);
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("List of visited Identity Providers set as [{0}] HTTP request attribute: {1}.", new Object[]{"sap.com/idp_discovery_visited", visitedIdPList});
                    }
                }
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Error setting request attribute for IdP Discovery.", (Throwable)e);
            }
        }
        return true;
    }

    boolean isManualIdPSelectionMode() {
        if (this.isManualIdPSelectionMode == null) {
            SAML2LocalProvidersConfig localProvidersConfig = this.saml2Config.getLocalProvidersConfiguration();
            if (localProvidersConfig.isServiceProviderEnabled()) {
                SAML2LocalProvidersConfig localProviders = this.saml2Config.getLocalProvidersConfiguration();
                SAML2LocalSP localSP = localProviders.getLocalSP();
                if (localSP.getIdPSelectionMode() == SAML2IdPSelectionMode.MANUAL) {
                    LOCATION.debugT("Manual IdP Selection mode configured for the Service Provider.");
                    this.isManualIdPSelectionMode = true;
                } else {
                    LOCATION.debugT("Automatic IdP Selection mode configured for the Service Provider.");
                    this.isManualIdPSelectionMode = false;
                }
            } else {
                this.isManualIdPSelectionMode = false;
            }
        }
        return this.isManualIdPSelectionMode;
    }

    private String[] externalGetVisitedProviderNames() {
        SAML2LocalProvidersConfig localProvidersConfig = this.saml2Config.getLocalProvidersConfiguration();
        if (localProvidersConfig.isServiceProviderEnabled()) {
            SAML2LocalProvidersConfig localProviders = this.saml2Config.getLocalProvidersConfiguration();
            SAML2LocalSP localSP = localProviders.getLocalSP();
            if (localSP.isToUseExternalIdPDiscoveryReadService()) {
                if (this.isRequestFromExternalIdPDiscoveryService()) {
                    return this.configManager.getIdPListFromURL();
                }
            } else {
                LOCATION.debugT("External IdP Discovery Service is disabled.");
            }
        }
        return null;
    }

    String[] internalGetVisitedProviderNames() {
        SAML2LocalProvidersConfig localProvidersConfig = this.saml2Config.getLocalProvidersConfiguration();
        if (localProvidersConfig.isServiceProviderEnabled()) {
            SAML2LocalProvidersConfig localProviders = this.saml2Config.getLocalProvidersConfiguration();
            SAML2LocalSP localSP = localProviders.getLocalSP();
            if (localSP.isToUseInternalIdPDiscoveryReadService()) {
                String cookieValue = SAML2LoginModuleUtil.getCookie(this.callbackHandler, "_saml_idp");
                if (cookieValue != null && cookieValue.length() != 0) {
                    List providers = SAML2ServicesManager.getInstance().createCDCReader().extractVisitedProviders(cookieValue);
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("CDC cookie contains IdP list: {0}", new Object[]{providers});
                    }
                    String[] idpList = new String[providers.size()];
                    providers.toArray(idpList);
                    return idpList;
                }
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("CDC cookie not received in HTTP request.");
                }
            } else {
                LOCATION.debugT("Internal IdP Discovery Service is disabled.");
            }
        }
        return null;
    }

    boolean hasUserSelectedIdP() {
        String selected;
        try {
            selected = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2idpselected");
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not obtain HTTP request parameter: saml2idpselected", (Throwable)e);
            return false;
        }
        return "logonapp".equalsIgnoreCase(selected);
    }

    boolean isRequestFromExternalIdPDiscoveryService() {
        String selected;
        try {
            selected = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "saml2idpselected");
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not obtain HTTP request parameter: saml2idpselected", (Throwable)e);
            return false;
        }
        return "cdc".equalsIgnoreCase(selected);
    }

    private Map<String, String> buildTrustedIdPList() {
        SAML2TrustedIdPsConfig trustedIdPsConfig = this.saml2Config.getTrustedIdPsConfiguration();
        Collection trustedIdPs = trustedIdPsConfig.getAllTrustedIdPs();
        TreeMap<String, String> idpList = new TreeMap<String, String>();
        for (SAML2TrustedIdP trustedIdP : trustedIdPs) {
            if (!trustedIdP.isEnabled()) {
                if (!LOCATION.beDebug()) continue;
                LOCATION.debugT("Trusted Identity Provider: [{0}] is disabled and will not be added to the manual IdP selection list", new Object[]{trustedIdP.getName()});
                continue;
            }
            String name = trustedIdP.getName();
            String description = trustedIdP.getDescription();
            if (description != null && description.length() != 0) {
                idpList.put(name, description);
                continue;
            }
            idpList.put(name, name);
        }
        return this.sortByValue(idpList);
    }

    private String[] getMergedVisitedProviders() {
        String[] internalVisitedProviders = this.internalGetVisitedProviderNames();
        String[] externalVisitedProviders = this.externalGetVisitedProviderNames();
        if (internalVisitedProviders == null && externalVisitedProviders == null) {
            return null;
        }
        int intenalSize = internalVisitedProviders != null ? internalVisitedProviders.length : 0;
        int externalSize = externalVisitedProviders != null ? externalVisitedProviders.length : 0;
        String[] visitedProviders = new String[intenalSize + externalSize];
        if (internalVisitedProviders != null) {
            System.arraycopy(internalVisitedProviders, 0, visitedProviders, 0, intenalSize);
        }
        if (externalVisitedProviders != null) {
            System.arraycopy(externalVisitedProviders, 0, visitedProviders, intenalSize, externalSize);
        }
        return visitedProviders;
    }

    private String buildVisitedIdPList(Map<String, String> idpList) {
        String[] visitedProviders = this.getMergedVisitedProviders();
        if (visitedProviders != null) {
            String[] stringArray = visitedProviders;
            int n = visitedProviders.length;
            int n2 = 0;
            while (n2 < n) {
                String idpName = stringArray[n2];
                if (!idpList.containsKey(idpName)) {
                    SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP(idpName);
                    if (trustedIdP == null) {
                        SimpleLogger.log((int)300, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000132", (String)"Service Provider has received IdP list [{0}] as {1} that contains IdP [{2}] which is not trusted.", (Object[])new Object[]{visitedProviders, "common domain cookie", idpName});
                    } else if (!trustedIdP.isEnabled()) {
                        SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000133", (String)"Service Provider has received IdP list [{0}] as {1} that contains trusted IdP [{2}] which is not enabled.", (Object[])new Object[]{visitedProviders, "common domain cookie", idpName});
                    } else {
                        String name = trustedIdP.getName();
                        String description = trustedIdP.getDescription();
                        if (description != null && description.length() != 0) {
                            idpList.put(name, description);
                        } else {
                            idpList.put(name, name);
                        }
                    }
                }
                ++n2;
            }
            if (!idpList.isEmpty()) {
                this.sortByValue(idpList);
                stringArray = visitedProviders;
                n = visitedProviders.length;
                n2 = 0;
                while (n2 < n) {
                    String toSelect = stringArray[n2];
                    if (idpList.containsKey(toSelect)) {
                        return toSelect;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private <K, V> Map<K, V> sortByValue(Map<K, V> in) {
        TreeMap<V, K> swapped = new TreeMap<V, K>();
        for (Map.Entry<K, V> entry : in.entrySet()) {
            swapped.put(entry.getValue(), entry.getKey());
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : swapped.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }
}

