/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.core.jpaas.security.utils.AuditLogUtil;
import com.sap.security.auth.callback.ExtractCookiesCallback;
import com.sap.security.auth.service.UserSession;
import com.sap.security.saml2.cfg.enums.ComparisonMethod;
import com.sap.security.saml2.cfg.enums.EncryptionAlgorithm;
import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatEmailTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecifiedTrustedIdP;
import com.sap.security.saml2.commons.Attribute;
import com.sap.security.saml2.commons.AuditData;
import com.sap.security.saml2.commons.AuthnContext;
import com.sap.security.saml2.commons.AuthnContextList;
import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.commons.interfaces.services.SSO2Service;
import com.sap.security.saml2.lib.attributes.AttributeValuePair;
import com.sap.security.saml2.lib.attributes.AttributeValues;
import com.sap.security.saml2.lib.bindings.HTTPPostBinding;
import com.sap.security.saml2.lib.bindings.HTTPRedirectBindingDeflate;
import com.sap.security.saml2.lib.bindings.PAOSDataFactory;
import com.sap.security.saml2.lib.bindings.PAOSHTTPBinding;
import com.sap.security.saml2.lib.callbacks.SAML2GetterCallbacksPAOSHeaders;
import com.sap.security.saml2.lib.callbacks.SAML2GetterCallbacksPAOSMessage;
import com.sap.security.saml2.lib.callbacks.SAML2SetterCallbacksPAOSMessage;
import com.sap.security.saml2.lib.callbacks.SAMLSetterCallback;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.common.exceptions.SAML2AlreadyConsumedException;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPEntry;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPList;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Scoping;
import com.sap.security.saml2.lib.interfaces.bindings.ECPResponseMessage;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderECPRequest;
import com.sap.security.saml2.lib.interfaces.bindings.SOAPHeaderPAOSRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ResponseBase;
import com.sap.security.saml2.sp.ConfigurationManager;
import com.sap.security.saml2.sp.LocalAuthenticationService;
import com.sap.security.saml2.sp.LoginResult;
import com.sap.security.saml2.sp.OriginalUrlCookie;
import com.sap.security.saml2.sp.ResponseValidationService;
import com.sap.security.saml2.sp.SAML2LoginModuleUtil;
import com.sap.security.saml2.sp.TestOutputFormatter;
import com.sap.security.saml2.sp.UserMaintenanceService;
import com.sap.security.saml2.sp.UserMappingService;
import com.sap.security.saml2.sp.Utils;
import com.sap.security.saml2.sp.exception.BadCredentialsException;
import com.sap.security.saml2.sp.exception.LoginFailedException;
import com.sap.security.saml2.sp.exception.NameIdMappingFailedException;
import com.sap.security.um.service.api.ModifiableUserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.modify.ModifiableUser;
import com.sap.security.um.user.modify.ModifiableUserProvider;
import com.sap.security.um.user.modify.ReadonlyAttributeException;
import com.sap.security.um.user.modify.UnsupportedUserAttributeValueException;
import com.sap.security.um.user.modify.UnsupportedUserNameException;
import com.sap.security.um.user.modify.UserAlreadyExistsException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.Cookie;

public class SAML2LoginModule
implements LoginModule {
    private static final Location LOCATION = Location.getLocation(SAML2LoginModule.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");
    private static final String REQUEST_ATTRIBUTE_SESSION_INDEX = "requestAttributeSessionIndex";
    private static final String SAML2_PASSIVE_REQUEST = "com.sap.security.saml2.passive_request";
    private Map<String, Object> sharedState;
    private Map<String, String> options;
    private CallbackHandler callbackHandler;
    private Subject subject;
    private byte execMode = 0;
    private boolean isLocalAccess = false;
    private boolean isDisabledByOptionOrConfig = false;
    private SAML2Principal saml2Principal;
    private SAML2Response saml2Response;
    private SAML2Artifact saml2Artifact;
    private SAML2Assertion saml2Assertion;
    private SAML2Binding saml2Binding;
    private String relayState;
    private LoginResult loginResult;
    private ConfigurationManager configManager;
    private LocalAuthenticationService localAuthnService;
    private UserMappingService userMappingService;
    private TestOutputFormatter testOutput = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (LOCATION.bePath()) {
            LOCATION.entering("initialize", new Object[]{subject, callbackHandler, sharedState, options});
        }
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.sharedState = sharedState;
        this.options = options;
        this.loginResult = new LoginResult();
        this.configManager = Utils.loadConfigurationManager(options, callbackHandler, this.loginResult);
        if (!this.determineExecutionMode()) {
            return;
        }
        this.determineAccessType();
        this.testOutput = new TestOutputFormatter(this.execMode);
        this.loadSAML2Principal();
        this.localAuthnService = new LocalAuthenticationService(this.configManager, callbackHandler, this.saml2Principal, this.loginResult, sharedState, options);
        this.userMappingService = new UserMappingService(this.configManager, this.loginResult, sharedState);
        if (LOCATION.bePath()) {
            LOCATION.exiting("initialize");
        }
    }

    @Override
    public boolean abort() throws LoginException {
        boolean interactivePersistentFederation;
        if (LOCATION.bePath()) {
            LOCATION.entering("abort");
        }
        if (this.execMode == 2) {
            if (LOCATION.bePath()) {
                LOCATION.exiting("abort", (Object)false);
            }
            return false;
        }
        byte loginStatus = this.loginResult.getLoginStatus();
        boolean isPersistentNameIdFormat = SAML2NameIdFormat.PERSISTENT.getName().equalsIgnoreCase(this.loginResult.getPrincipalNameIdFormat());
        boolean bl = interactivePersistentFederation = loginStatus == 4 && isPersistentNameIdFormat;
        if (loginStatus == 0) {
            if (SAML2LoginModuleUtil.isCurrentRequestPost(this.callbackHandler)) {
                SAML2LoginModuleUtil.storePostParams(this.callbackHandler);
            }
            if (this.configManager.isLocalIdP()) {
                this.localAuthnService.redirectToIdP();
            } else {
                try {
                    this.removeOldCookies();
                }
                catch (Exception e) {
                    AuditLogUtil.auditLogMessage((String)"Unable to delete old url cookies.", SAML2LoginModule.class);
                    LOCATION.traceThrowableT(400, "Unable to delete old url cookies.", (Throwable)e);
                }
                this.sendAuthnRequest();
            }
        } else if (loginStatus == 7) {
            if (SAML2LoginModuleUtil.isCurrentRequestPost(this.callbackHandler)) {
                SAML2LoginModuleUtil.storePostParams(this.callbackHandler);
            }
            this.configManager.setManualIdPSelectionAttributes();
        } else if (loginStatus == 6) {
            if (SAML2LoginModuleUtil.isCurrentRequestPost(this.callbackHandler)) {
                SAML2LoginModuleUtil.storePostParams(this.callbackHandler);
            }
            try {
                SAML2LoginModuleUtil.redirectToIdPDiscoveryService(this.callbackHandler, this.options, this.configManager.getLocalSP());
            }
            catch (Exception e) {
                AuditLogUtil.auditLogMessage((String)"Could not redirect to IdP Discovery Service.", SAML2LoginModule.class);
                LOCATION.traceThrowableT(500, "Could not redirect to IdP Discovery Service.", (Throwable)e);
                LoginException le = new LoginException("Could not redirect to IdP Discovery Service.");
                le.initCause(e);
                throw le;
            }
        } else if (loginStatus == 1 || loginStatus == 3 || loginStatus == 5) {
            this.onOverallAuthenticationFailed();
            OriginalUrlCookie ouc = new OriginalUrlCookie(this.callbackHandler, this.configManager.getLocalSP());
            ouc.removeCookie(this.relayState);
        } else if (interactivePersistentFederation) {
            this.setFederationRequiredAttributes();
            this.onOverallAuthenticationFailed();
        } else if (loginStatus == 2) {
            this.setErrorMessagesAttribute(this.callbackHandler, "errorMessages", this.saml2Response);
            if (this.configManager.getProviderSelectionService().isManualIdPSelectionMode()) {
                this.configManager.getProviderSelectionService().setManualIdPSelectionAttributes();
            }
            this.onSAML2AuthenticationFailed();
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting("abort", (Object)true);
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean interactivePersistentFederation;
        if (LOCATION.bePath()) {
            LOCATION.entering("commit");
        }
        if (this.execMode == 2) {
            if (LOCATION.bePath()) {
                LOCATION.exiting("commit", (Object)false);
            }
            return false;
        }
        byte loginStatus = this.loginResult.getLoginStatus();
        boolean isPersistentNameIdFormat = SAML2NameIdFormat.PERSISTENT.getName().equalsIgnoreCase(this.loginResult.getPrincipalNameIdFormat());
        boolean bl = interactivePersistentFederation = loginStatus == 4 && isPersistentNameIdFormat;
        if (interactivePersistentFederation) {
            this.interactivePersistentFederation();
        } else if (loginStatus == 3 || loginStatus == 1) {
            String spName = this.configManager.isLocalIdP() ? null : this.configManager.getLocalSP().getName();
            AuthnContext newContext = Utils.getAuthenticationContext(this.configManager, this.loginResult);
            this.createPrincipalWithAttributes(spName, newContext);
        } else if (loginStatus == 5) {
            this.testOutput.setReceivedEntry("SSOBetweenApplications", "true");
        }
        try {
            SAML2LoginModuleUtil.setSessionAttribute(this.callbackHandler, "com.sap.security.saml2.sp.LoginResult", null);
        }
        catch (Exception e) {
            AuditLogUtil.auditLogMessage((String)"Error removing LoginResult from HTTP session.", SAML2LoginModule.class);
            LOCATION.traceThrowableT(500, "Error removing LoginResult from HTTP session.", (Throwable)e);
        }
        if (this.execMode == 1) {
            this.setTestOutputInSession();
        }
        if (loginStatus == 1 || loginStatus == 3 || loginStatus == 5 || this.loginResult.isFederationRequired()) {
            this.onSuccessfulSAML2Authentication(loginStatus);
        }
        SAML2LoginModuleUtil.logAssertionInfo(this.loginResult, this.sharedState);
        if (LOCATION.bePath()) {
            LOCATION.exiting("commit", (Object)true);
        }
        return true;
    }

    private void createPrincipalWithAttributes(String spName, AuthnContext newContext) throws NameIdMappingFailedException, BadCredentialsException {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        List profileAttributes = null;
        if (this.loginResult.getPrincipalNameIdFormat() == null || this.loginResult.getPrincipalNameIdFormat().length() < 1 || SAML2NameIdFormat.UNSPECIFIED.getName().equals(this.loginResult.getPrincipalNameIdFormat())) {
            profileAttributes = ((SAML2NameIdFormatUnspecifiedTrustedIdP)this.configManager.getTrustedIdP().getNameIdFormatUnspecified()).getProfileAttributes();
        } else if (SAML2NameIdFormat.E_MAIL.getName().equals(this.loginResult.getPrincipalNameIdFormat())) {
            profileAttributes = ((SAML2NameIdFormatEmailTrustedIdP)this.configManager.getTrustedIdP().getNameIdFormatEmail()).getProfileAttributes();
        } else if (SAML2NameIdFormat.TRANSIENT.getName().equals(this.loginResult.getPrincipalNameIdFormat())) {
            profileAttributes = this.configManager.getTrustedIdP().getNameIdFormatTransient().getProfileAttributes();
        } else {
            this.loginResult.throwBadCredentialException("Not supported NameId format with name: " + this.loginResult.getPrincipalNameIdFormat());
        }
        this.userMappingService.mapProfileAttributes(this.loginResult.getPrincipalNameId(), profileAttributes, this.loginResult.getAssertionAttributes(), attributes);
        this.setAttributesInSessionForTestMode(attributes);
        this.saml2Principal = Utils.createSAML2Principal(this.saml2Principal, attributes, newContext, this.loginResult, spName);
    }

    private void setAttributesInSessionForTestMode(Set<Attribute> attributes) {
        if (this.execMode == 1) {
            HashMap<String, Object[]> assertionAttributes = new HashMap<String, Object[]>();
            for (Attribute attr : attributes) {
                assertionAttributes.put(attr.getName(), attr.getValues().toArray());
            }
            UserSession.getInstance().setAttribute("com.sap.security.saml2.sp.AssertionAttributes", assertionAttributes);
        }
    }

    @Override
    public boolean login() throws LoginException {
        SAML2Artifact tokenInRequest;
        if (LOCATION.bePath()) {
            LOCATION.entering("login");
        }
        if (this.execMode == 2) {
            if (this.isDisabledByOptionOrConfig) {
                if (LOCATION.bePath()) {
                    LOCATION.exiting("login", (Object)false);
                }
                return false;
            }
            throw new LoginException("SAML2 functionality is disabled by URL parameter.");
        }
        LoginResult loginResultInSession = this.getLoginResultFromSession();
        this.loginResult.setLoginResultInSession(loginResultInSession != null);
        this.readSAML2TokenFromRequest();
        String loginResultIdPName = this.loginResult.hasLoginResultInSession() ? loginResultInSession.getIdpName() : null;
        Object object = tokenInRequest = this.saml2Response == null ? this.saml2Artifact : this.saml2Response;
        if (tokenInRequest != null && this.configManager.isPassive() && !this.configManager.sendSPReponse()) {
            SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, SAML2_PASSIVE_REQUEST, "true");
        }
        if (this.saml2Response != null) {
            this.testOutput.setReceivedEntry("Consent", this.saml2Response.getConsent());
        }
        if (this.isLocalAccess && tokenInRequest != null) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000083", (String)"Service Provider has rejected the SAML2 token received because the accessed application is configured as a local resource and does not accept SAML2 tokens from external providers.");
            this.loginResult.throwLoginFailedException("Service Provider application is configured as local resource and cannot process SAML2 tokens from external Identity Providers.");
        }
        if (!this.configManager.loadConfigurations(this.isLocalAccess, this.saml2Principal, tokenInRequest, loginResultIdPName)) {
            this.execMode = (byte)2;
            LOCATION.debugT("SAML2LoginModule is running in execution mode: DISABLED.");
            return false;
        }
        this.checkHttpsRequirements();
        this.checkSupportedBinding();
        if (this.configManager.isLocalIdP()) {
            this.localAuthnService.login();
        } else {
            this.remoteLogin();
        }
        this.sharedState.put("javax.security.auth.login.name", this.loginResult.getLocalUser());
        AttributeValues attributes = this.loginResult.getAssertionAttributes();
        if (attributes != null) {
            for (String attribute : attributes.keySet()) {
                AttributeValuePair valuePair = attributes.get(attribute);
                this.testOutput.setAssertionAttribute(attribute, valuePair.getFormat(), valuePair.getValuesAsStrings().toString());
            }
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting("login", (Object)true);
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (LOCATION.bePath()) {
            LOCATION.entering("logout");
        }
        if (this.execMode == 2) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Service Provider executes Local Logout because SAML2 functionality has been disabled.");
            }
            if (LOCATION.bePath()) {
                LOCATION.exiting("logout", (Object)false);
            }
            return false;
        }
        boolean logoutResult = true;
        if (this.saml2Principal != null) {
            SSO2Service sso2Service = SAML2CommonServicesManager.getInstance().getSSO2ServiceInstance();
            if (sso2Service.isLogonTicketInSubject()) {
                sso2Service.removeLogonTicket(this.subject, this.callbackHandler, this.sharedState, new HashMap());
            }
            SAML2LocalProvider localProvider = this.configManager.getLocalProvider();
            boolean isLocal = false;
            try {
                isLocal = this.saml2Principal.isLocalProvider(localProvider.getName());
            }
            catch (Exception e) {
                AuditLogUtil.auditLogMessage((String)"Failed to check Local Provider in SAML2Principal.", SAML2LoginModule.class);
                LOCATION.traceThrowableT(500, "Failed to check Local Provider in SAML2Principal.", (Throwable)e);
            }
            if (isLocal) {
                this.configManager.loadLocalConfigurations();
                this.localAuthnService.logout();
            } else {
                Utils.removePrincipal(this.subject);
                this.configManager.loadConfigurations(this.saml2Principal);
                logoutResult = this.globalLogout();
            }
        } else {
            LOCATION.infoT("Service Provider could not perform global logout because there is no SAML authentication context.");
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting("logout", (Object)logoutResult);
        }
        return logoutResult;
    }

    private void readSAML2TokenFromRequest() throws LoginException {
        if (this.saml2Response == null && this.saml2Artifact == null) {
            try {
                String parameterNameSAMLResponse = "SAMLResponse";
                String parameterNameSAMLArtifact = "SAMLart";
                String parameterNameSAMLRelayState = "RelayState";
                if (this.configManager.getProxyingData().isProxying()) {
                    parameterNameSAMLResponse = "ProxySAMLResponse";
                    parameterNameSAMLArtifact = "ProxySAMLart";
                    parameterNameSAMLRelayState = "ProxyRelayState";
                }
                this.saml2Response = (SAML2Response)SAML2LoginModuleUtil.getRequestParameter(this.callbackHandler, parameterNameSAMLResponse);
                if (this.saml2Response == null) {
                    this.saml2Artifact = (SAML2Artifact)SAML2LoginModuleUtil.getRequestParameter(this.callbackHandler, parameterNameSAMLArtifact);
                    if (this.saml2Artifact == null) {
                        SAML2GetterCallbacksPAOSHeaders paosHeadersGetterCallbacks = new SAML2GetterCallbacksPAOSHeaders();
                        paosHeadersGetterCallbacks.handle(this.callbackHandler);
                        if (PAOSHTTPBinding.isPAOSMessage((SAML2GetterCallbacksPAOSHeaders)paosHeadersGetterCallbacks)) {
                            this.saml2Binding = SAML2Binding.PAOS_BINDING;
                            SAML2GetterCallbacksPAOSMessage paosMessageGetterCallbacks = new SAML2GetterCallbacksPAOSMessage();
                            paosMessageGetterCallbacks.handle(this.callbackHandler);
                            ECPResponseMessage ecpResponse = PAOSHTTPBinding.extractECPResponseMessage((SAML2GetterCallbacksPAOSMessage)paosMessageGetterCallbacks);
                            this.saml2Response = ecpResponse.getSAML2Response();
                            this.relayState = ecpResponse.getRelayState();
                            this.loginResult.getAuditData().setSaml2ResponseBase((SAML2ResponseBase)this.saml2Response);
                            this.loginResult.setTokenId(this.saml2Response.getID());
                            this.testOutput.setReceivedEntry("Token", "ECP Response");
                            LOCATION.debugT("PAOSMessage received in the HTTP request.");
                        } else {
                            LOCATION.debugT("No SAML2 message received in the HTTP request.");
                        }
                    } else {
                        this.relayState = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, parameterNameSAMLRelayState);
                        this.saml2Binding = SAML2Binding.HTTP_ARTIFACT_BINDING;
                        this.loginResult.setTokenId(this.saml2Artifact.getValue());
                        this.testOutput.setReceivedEntry("Token", "SAMLart");
                        if (LOCATION.beInfo()) {
                            LOCATION.infoT("Received Artifact: {0} through binding: {1}", new Object[]{this.saml2Artifact.getValue(), this.saml2Binding.getName()});
                        }
                    }
                } else {
                    this.relayState = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, parameterNameSAMLRelayState);
                    this.saml2Binding = SAML2Binding.HTTP_POST_BINDING;
                    this.loginResult.getAuditData().setSaml2ResponseBase((SAML2ResponseBase)this.saml2Response);
                    this.loginResult.setTokenId(this.saml2Response.getID());
                    this.testOutput.setReceivedEntry("Token", "SAMLResponse");
                    if (LOCATION.beInfo()) {
                        String signed = this.saml2Response.isSigned() ? "signed" : "unsigned";
                        LOCATION.infoT("Received {0} authentication Response (top level status code: {1}, second level status code: {2}) from Identity Provider: {3} through binding: {4}\n SAML2 message:\n {5}", new Object[]{signed, this.saml2Response.getTopLevelStatusCode(), this.saml2Response.getSecondLevelStatusCode(), this.saml2Response.getIssuer() != null ? this.saml2Response.getIssuer().getName() : this.saml2Response.getIssuer(), this.saml2Binding, this.saml2Response.getXMLRepresentation()});
                    }
                }
            }
            catch (Exception e) {
                AuditLogUtil.auditLogMessage((String)"Could not extract SAML2 message from request.", SAML2LoginModule.class);
                LOCATION.traceThrowableT(500, "Could not extract SAML2 message from request.", (Throwable)e);
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000010", (String)"Service Provider could not extract SAML2 message from request. Reason: {0}", (Object[])new Object[]{e.getMessage()});
                this.loginResult.throwLoginFailedException("Service Provider could not extract SAML2 message from request.", e);
            }
        }
    }

    private LoginResult getLoginResultFromSession() throws LoginException {
        LoginResult lrInSession = null;
        try {
            lrInSession = (LoginResult)SAML2LoginModuleUtil.getSessionAttribute(this.callbackHandler, "com.sap.security.saml2.sp.LoginResult");
        }
        catch (Exception e) {
            AuditLogUtil.auditLogMessage((String)"Could not get LoginResult from application session.", SAML2LoginModule.class);
            LOCATION.traceThrowableT(500, "Could not get LoginResult from application session.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000011", (String)"Service Provider could not extract SAML2 context from application session. Reason: {0}", (Object[])new Object[]{e.getMessage()});
            this.loginResult.throwLoginFailedException("Service Provider could not extract SAML2 context from application session.", e);
        }
        return lrInSession;
    }

    private boolean isTokenInRequest() throws LoginException {
        this.readSAML2TokenFromRequest();
        return this.saml2Response != null || this.saml2Artifact != null;
    }

    private boolean isToResumeAuthentication() throws LoginException {
        LoginResult loginResultInSession = this.getLoginResultFromSession();
        if (loginResultInSession == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("LoginResult not found in HTTP session.");
            }
            return false;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("LoginResult in HTTP session: {0}", new Object[]{loginResultInSession});
        }
        if (this.isTokenInRequest()) {
            String tokenId = null;
            if (this.saml2Artifact != null) {
                tokenId = this.saml2Artifact.getValue();
            } else if (this.saml2Response != null) {
                tokenId = this.saml2Response.getID();
            }
            if (tokenId != null && tokenId.equals(loginResultInSession.getTokenId())) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("LoginResult token ID equals received SAML2Token ID. Authentication will be resumed based on LoginResult in HTTP session.");
                }
                this.loginResult = loginResultInSession;
                this.loginResult.setLoginResultInSession(true);
                this.userMappingService = new UserMappingService(this.configManager, this.loginResult, this.sharedState);
                return true;
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("LoginResult token ID [{0}] does not equal received token ID [{1}]. Authentication cannot be resumed.", new Object[]{loginResultInSession.getTokenId(), tokenId});
            }
            return false;
        }
        LOCATION.debugT("LoginResult found in HTTP session but SAML2 token not found in HTTP request so authentication will not be resumed.");
        return false;
    }

    private boolean isRequiredAuthentication() throws LoginException {
        if (this.saml2Principal == null) {
            throw new IllegalStateException("This method should be called only in reauthentication use cases where the principal is not null.");
        }
        if (this.configManager.getForceAuthentication()) {
            LOCATION.infoT("Service Provider triggers re-authentication due to force authentication configured for the current application.");
            return true;
        }
        AuthnContextList principalAuthnContexts = this.saml2Principal.getAuthnContexts();
        if (this.isAuthnContextsSufficient(principalAuthnContexts)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication contexts [{0}] in the SAML2Principal are sufficient against authentication contexts [{1}] configured for the application.", new Object[]{principalAuthnContexts, this.configManager.getAuthenticationContexts()});
            }
            return false;
        }
        if (LOCATION.beInfo()) {
            LOCATION.infoT("Service Provider triggers re-authentication due to authentication contexts [{0}] in the SAML2 context not sufficient against authentication contexts [{1}] configured for the application.", new Object[]{principalAuthnContexts, this.configManager.getAuthenticationContexts()});
        }
        return true;
    }

    private boolean isAuthnContextsSufficient(AuthnContextList authenticatedContexts) throws LoginException {
        AuthnContextList configContexts = this.configManager.getAuthenticationContexts();
        if (configContexts.isEmpty()) {
            LOCATION.debugT("Authentication contexts are not configured for the Service Provider application.");
            return true;
        }
        return authenticatedContexts.hasSufficient(configContexts);
    }

    private void resumeAuthentication() throws LoginException {
        LOCATION.debugT("Service Provider resumes authentication based on login state saved from previous authentication.");
        if (this.loginResult.getLoginStatus() == 4) {
            boolean isAtomaticAccountCreationTriggered = false;
            try {
                String automaticAccountCreationParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "automaticAccountCreation");
                if ("true".equalsIgnoreCase(automaticAccountCreationParam)) {
                    isAtomaticAccountCreationTriggered = true;
                    if (LOCATION.beInfo()) {
                        LOCATION.infoT("User has chosen to create account automatically");
                    }
                }
            }
            catch (Exception e) {
                AuditLogUtil.auditLogMessage((String)"Could not get request parameter for automatic account creation.", SAML2LoginModule.class);
                LOCATION.traceThrowableT(500, "Could not get request parameter for automatic account creation.", (Throwable)e);
            }
            if (isAtomaticAccountCreationTriggered) {
                if (!CommonSAML2Utils.checkSalt((CallbackHandler)this.callbackHandler)) {
                    LOCATION.warningT("Salt check failed. Automatic account creation cannot be triggered. See SAP Note 1441999 for more details.");
                    this.loginResult.throwLoginFailedException("Salt check failed. Automatic account creation cannot be triggered. See SAP Note 1441999 for more details.");
                }
                this.loginResult.throwLoginFailedException("Automatic account creation is not supported.");
            } else {
                throw this.loginResult.getMappingFailedException();
            }
        }
    }

    private void initialAuthentication() throws LoginException {
        LOCATION.debugT("Service Provider performs Initial Authentication.");
        if (this.saml2Artifact != null) {
            this.resolveIdPIssuedArtifact();
        }
        this.processSAML2Response();
        this.userMappingService.mapNameId(this.saml2Assertion);
        this.loginResult.setLoginStatus((byte)1);
    }

    private void processSAML2Response() throws LoginException {
        if (this.configManager.getForceAuthentication() && this.saml2Response.getInResponseTo() == null) {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Service Provider triggers re-authentication due to force authentication configured for the current application and unsolicited response received from Identity Provider [{0}].", new Object[]{this.configManager.getTrustedIdP().getName()});
            }
            this.loginResult.throwCredentialNotFoundException("Reauthentication required due to force authentication and unsolicited SAML2Response received.");
        }
        this.validateSAML2Response();
        this.checkAuthenticationContexts();
    }

    private void checkAuthenticationContexts() throws LoginException {
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        ComparisonMethod comparisonMethod = this.configManager.getRequestedAuthnContextComparisonMethod();
        if (comparisonMethod != null && comparisonMethod != ComparisonMethod.EXACT && this.saml2Response.getInResponseTo() != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Service Provider has initiated SSO with comparison method [{0}]. The authentication contexts in the SAML2Assertion are always accepted.", new Object[]{comparisonMethod.getName()});
            }
        } else {
            AuthnContextList authenticatedContexts = new AuthnContextList();
            authenticatedContexts.add(Utils.getAuthenticationContext(this.configManager, this.loginResult));
            if (this.isAuthnContextsSufficient(authenticatedContexts)) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Authentication contexts in SAML2Assertion [{0}] are sufficient against configured authentication contexts for the application [{1}].", new Object[]{authenticatedContexts, this.configManager.getAuthenticationContexts()});
                }
            } else if (this.saml2Response.getInResponseTo() == null) {
                if (LOCATION.beInfo()) {
                    LOCATION.infoT("Service Provider triggers re-authentication due to authentication contexts [{0}] in the SAML2Assertion not sufficient against configured authentication contexts [{1}] for the application and unsolicited response received from Identity Provider [{2}].", new Object[]{authenticatedContexts, this.configManager.getAuthenticationContexts(), trustedIdP.getName()});
                }
                this.loginResult.throwCredentialNotFoundException("Reauthentication required due to authentication contexts in the SAML2Assertion not sufficient against configured authentication contexts for the application.");
            } else {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000002", (String)"Service Provider could not authenticate the user due to authentication contexts [{0}] in the SAML2Assertion not sufficient against configured authentication contexts [{1}] for the application and solicited response received from Identity Provider [{2}]. ", (Object[])new Object[]{authenticatedContexts, this.configManager.getAuthenticationContexts(), trustedIdP.getName()});
                this.loginResult.throwBadCredentialException("Authentication failed because of insufficient authentication contexts and solicited SAML2Response received.");
            }
        }
    }

    private void validateSAML2Response() throws LoginException {
        boolean isFrontChannelRequest = this.saml2Artifact == null;
        ResponseValidationService rvs = new ResponseValidationService(this.saml2Response, this.configManager, this.callbackHandler, this.options, this.loginResult, this.testOutput, isFrontChannelRequest, this.relayState);
        this.saml2Assertion = rvs.validateResponse();
        try {
            SAML2CommonServicesManager.getInstance().getConsumedAssertionService().consume(this.saml2Assertion, this.loginResult.getSubjectConfirmationNotOnOrAfter());
        }
        catch (SAML2AlreadyConsumedException e) {
            AuditLogUtil.auditLogMessage((String)("Service Provider has received SAML2Assertion from Identity Provider " + this.configManager.getTrustedIdP().getName() + " that is already consumed."), SAML2LoginModule.class);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000028", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that is already consumed.", (Object[])new Object[]{this.configManager.getTrustedIdP().getName()});
            this.loginResult.throwLoginFailedException("SAML2Assertion received in the SAML2Response is already consumed.", e);
        }
        catch (SAML2Exception e) {
            AuditLogUtil.auditLogMessage((String)("Service Provider has received SAML2Assertion from Identity Provider " + this.configManager.getTrustedIdP().getName() + " but could not check whether it is already consumed. Reason: " + e.getMessage()), SAML2LoginModule.class);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000029", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] but could not check whether it is already consumed. Reason: {1}", (Object[])new Object[]{this.configManager.getTrustedIdP().getName(), e.getMessage()});
            this.loginResult.throwLoginFailedException("Already consumed assertion check failed.", e);
        }
    }

    private void authenticationChallenge() throws LoginException {
        LOCATION.debugT("Service Provider performs Initial Authentication Challenge.");
        SAML2LocalSP localSP = this.configManager.getLocalSP();
        if (localSP.isSPInitiatedSSOEnabled()) {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Service Provider triggers authentication to trusted Identity Provider [{0}].", new Object[]{this.configManager.getTrustedIdP().getName()});
            }
            this.loginResult.throwCredentialNotFoundException("Authentication Challenge due to missing credentials.");
        } else {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000136", (String)"Service Provider could not initiate authentication because SP-Initiated SSO has been disabled in the configuration.");
            this.loginResult.throwLoginFailedException("Service Provider could not initiate authentication because SP-Initiated SSO has been disabled in the configuration.");
        }
    }

    private void ssoBetweenApplications() {
        LOCATION.infoT("Service Provider has granted access to current appllication because of already existing SAML2 context.");
        this.loginResult.setLocalUser(this.saml2Principal.getName());
        this.loginResult.setLoginStatus((byte)5);
    }

    private void sessionProlongationChallenge() throws LoginException {
        LOCATION.debugT("Service Provider performs Session Prolongation Challenge.");
        this.loginResult.throwCredentialNotFoundException("Session Prolongation required.");
    }

    private void sessionProlongationAuthentication() throws LoginException {
        LOCATION.debugT("Service Provider performs Session Prolongation Authentication.");
        try {
            try {
                this.reauthentication();
            }
            catch (LoginException e) {
                try {
                    UserSession.getInstance().setAttribute("sap.com/idp_session_expiration", null);
                }
                catch (Exception e1) {
                    LOCATION.traceThrowableT(500, "Error clearing session prolongation attribute from client context.", (Throwable)e1);
                }
                AuditLogUtil.auditLogMessage((String)"Session Prolongation Authentication has failed.", SAML2LoginModule.class);
                this.loginResult.throwLoginFailedException("Session Prolongation Authentication has failed.", e);
                try {
                    SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/session_prolongation", null);
                }
                catch (Exception e2) {
                    LOCATION.traceThrowableT(500, "Error clearing session prolongation required attribute from HTTP request.", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "sap.com/session_prolongation", null);
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Error clearing session prolongation required attribute from HTTP request.", (Throwable)e);
            }
        }
    }

    private void reauthentication() throws LoginException {
        LOCATION.debugT("Service Provider performs Re-authentication.");
        if (this.saml2Artifact != null) {
            this.resolveIdPIssuedArtifact();
        }
        this.processSAML2Response();
        if (!this.loginResult.getPrincipalNameId().equals(this.saml2Principal.getNameId())) {
            String issuerIdP = this.saml2Response.getIssuer().getName();
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000026", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] containing Subject Name ID [{1}] that does not match the already authenticated subject [{2}].", (Object[])new Object[]{issuerIdP, this.loginResult.getPrincipalNameId(), this.saml2Principal.getNameId()});
            this.loginResult.throwBadCredentialException("Re-authentication with different Subject Name ID is not allowed.");
        }
        String loginResultNameIdFormat = this.loginResult.getPrincipalNameIdFormat();
        String principalNameIdFormat = this.saml2Principal.getNameIdFormat();
        if (loginResultNameIdFormat == null || loginResultNameIdFormat.length() < 1) {
            loginResultNameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            LOCATION.debugT("NameIdFormat is not specified.  NameIdFormat [unspecified] is used in login result for reauthentication.");
        }
        if (principalNameIdFormat == null || principalNameIdFormat.length() < 1) {
            principalNameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            LOCATION.debugT("NameIdFormat is not specified.  NameIdFormat [unspecified] is used in principal for reauthentication.");
        }
        if (!loginResultNameIdFormat.equals(principalNameIdFormat)) {
            String issuerIdP = this.saml2Response.getIssuer().getName();
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000027", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] containing Subject Name ID Format [{1}] that does not match the already authenticated Subject Name ID Format [{2}].", (Object[])new Object[]{issuerIdP, this.loginResult.getPrincipalNameIdFormat(), this.saml2Principal.getNameIdFormat()});
            this.loginResult.throwBadCredentialException("Re-authentication with different Subject Name ID Format is not allowed.");
        }
        this.loginResult.setLocalUser(this.saml2Principal.getName());
        this.loginResult.setLoginStatus((byte)3);
    }

    private void reauthenticationChallenge() throws LoginException {
        LOCATION.debugT("Service Provider performs Reauthentication Challenge.");
        this.loginResult.throwCredentialNotFoundException("Re-authentication required.");
    }

    private void setAuthRequestResponseBindings(SAML2AuthRequest samlRequest) throws Exception {
        if (LOCATION.bePath()) {
            LOCATION.entering("setAuthRequestResponseBindings");
        }
        ResponseRequirementType responseRequirementType = this.configManager.getACSResponseRequirement();
        if (this.configManager.getProxyingData().isProxying()) {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("As the Service Provider will proxying the AuthnRequest, the Response Requirement will be enforced to: [{0}] instead of the configured: [{1}]", new Object[]{ResponseRequirementType.IDP_DEFAULT, responseRequirementType});
            }
            responseRequirementType = ResponseRequirementType.IDP_DEFAULT;
        }
        if (ResponseRequirementType.ASSERTION_CONSUMER_INDEX.equals((Object)responseRequirementType)) {
            int acsIndex = this.configManager.getACSIndex();
            samlRequest.setAssertionConsumerServiceIndex(Integer.valueOf(acsIndex));
            if (LOCATION.beDebug()) {
                LOCATION.debugT("AssertionConsumerService Index set in the Authentication Request: [{0}]", new Object[]{acsIndex});
            }
        } else if (ResponseRequirementType.IDP_DEFAULT.equals((Object)responseRequirementType) || responseRequirementType == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("AssertionConsumerService response requrement type set to IDP default");
            }
        } else {
            String acsUrl = null;
            if (ResponseRequirementType.ASSERTION_CONSUMER_URL.equals((Object)responseRequirementType)) {
                acsUrl = SAML2LoginModuleUtil.getApplicationURL(this.callbackHandler, this.options, this.configManager.getProxyingData().isProxying());
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("AssertionConsumerService URL is not configured for the service provider. Application relative URL set as ACS URL.");
                }
            } else if (ResponseRequirementType.CUSTOM_VALUE.equals((Object)responseRequirementType)) {
                acsUrl = this.configManager.getACSUrl();
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Custom value for AssertionConsumerService response requirement type is set.");
                }
            }
            SAML2Binding responseBinding = this.configManager.getResponseBinding();
            if (SAML2LoginModuleUtil.isOriginalRequestPost(this.callbackHandler)) {
                if (SAML2Binding.HTTP_ARTIFACT_BINDING.equals((Object)responseBinding)) {
                    samlRequest.setAssertionConsumerServiceIndex(Integer.valueOf(1));
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("AssertionConsumerService Index set in the Authentication Request [1] because request is POST and response binding is Artifact.");
                    }
                    return;
                }
                acsUrl = SAML2LoginModuleUtil.addSAML2PostParameter(acsUrl);
            }
            if (responseBinding != null) {
                samlRequest.setProtocolBinding(responseBinding.getName());
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("SSO response binding set in the request: {0}", new Object[]{responseBinding.getName()});
                }
            } else {
                LOCATION.debugT("No response binding configured for the trusted Identity Provider.");
            }
            samlRequest.setAssertionConsumerServiceURL(acsUrl);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("AssertionConsumerService URL set in the authentication request: {0}", new Object[]{acsUrl});
            }
        }
    }

    private SAML2AuthRequest createAuthnRequest(String idpSSOUrl) throws LoginException {
        String affiliation;
        SAML2NameIdFormat nameIdFormat;
        SAML2LocalSP localSP = this.configManager.getLocalSP();
        SAML2AuthRequest samlRequest = null;
        try {
            Date now = Calendar.getInstance().getTime();
            String requestId = SAML2Utils.generateUUID();
            samlRequest = SAML2ProtocolFactory.getInstance().createAuthnRequest(requestId, now);
            SAML2NameID nameID = SAML2DataFactory.getInstance().createSAML2NameID(localSP.getName());
            samlRequest.setIssuer(nameID);
            samlRequest.setDestination(idpSSOUrl);
            this.setAuthRequestResponseBindings(samlRequest);
        }
        catch (Exception e) {
            AuditLogUtil.auditLogMessage((String)("Service Provider could not create AuthnRequest. Reason: " + e.getMessage()), SAML2LoginModule.class);
            LOCATION.traceThrowableT(500, "Could not create authentication request.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000008", (String)"Service Provider could not create AuthnRequest. Reason: {0}", (Object[])new Object[]{e.getMessage()});
            this.loginResult.throwLoginFailedException("Service Provider could not create authentication request.", e);
        }
        AuthnContextList configuredAuthnContexts = this.configManager.getAuthenticationContexts();
        if (configuredAuthnContexts.isEmpty()) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication Contexts are not configured for the Service Provider application.");
            }
        } else {
            ComparisonMethod comparisonMethod;
            samlRequest.setRequestedAuthnContextClassRefs(configuredAuthnContexts.getNames());
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication Contexts set in the authentication request: {0}", new Object[]{configuredAuthnContexts.getNames()});
            }
            if ((comparisonMethod = this.configManager.getRequestedAuthnContextComparisonMethod()) != null) {
                samlRequest.setRequestedAuthnContextComparison(comparisonMethod.getName());
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Authentication contexts comparison method added to the authentication request: {0}", new Object[]{comparisonMethod.getName()});
                }
            }
        }
        if ((nameIdFormat = this.configManager.getNameIDFormat()) != null) {
            samlRequest.setNameIDPolicyFormat(nameIdFormat.getName());
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Name ID Format [{0}] set in authentication request.", new Object[]{nameIdFormat.getName()});
            }
        }
        if (nameIdFormat == null || nameIdFormat == SAML2NameIdFormat.PERSISTENT || nameIdFormat == SAML2NameIdFormat.UNSPECIFIED) {
            samlRequest.setNameIDPolicyAllowCreate(this.configManager.getAllowCreate(nameIdFormat));
        }
        if (this.configManager.getForceAuthentication()) {
            samlRequest.setForceAuthn(true);
        }
        if (this.configManager.isPassive()) {
            samlRequest.setPassive(true);
        }
        if (nameIdFormat == SAML2NameIdFormat.PERSISTENT && (affiliation = localSP.getAffiliation()) != null && affiliation.length() != 0) {
            samlRequest.setNameIDPolicySPNameQualifier(affiliation);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Service Provider affiliation [{0}] set in authentication request.", new Object[]{affiliation});
            }
        }
        if (this.configManager.getProxyingData().isProxying()) {
            SAML2Scoping originalRequestScoping = this.configManager.getProxyingData().getOriginalRequestScoping();
            if (originalRequestScoping != null) {
                Integer proxyCount = originalRequestScoping.getProxyCount();
                if (proxyCount == null) {
                    proxyCount = this.configManager.getLocalSP().getProxyCount();
                } else if (proxyCount > 0) {
                    proxyCount = proxyCount - 1;
                }
                originalRequestScoping.setProxyCount(proxyCount);
                samlRequest.setScoping(originalRequestScoping);
            }
        } else {
            List<String> scopingIdPList = this.configManager.getScopingIdPList();
            if (scopingIdPList != null && scopingIdPList.size() > 0) {
                SAML2Scoping scoping = SAML2DataFactory.getInstance().createSAML2Scoping();
                scoping.setProxyCount(localSP.getProxyCount());
                SAML2IDPList saml2IdPList = SAML2DataFactory.getInstance().createSAML2IDPList();
                saml2IdPList.setIdPEntries(SAML2Utils.convertIdPNamesToIdPEntries(scopingIdPList));
                scoping.setIDPList(saml2IdPList);
                samlRequest.setScoping(scoping);
            }
        }
        this.loginResult.getAuditData().setSaml2AuthnRequest(samlRequest);
        return samlRequest;
    }

    private void sendAuthnRequest() throws LoginException {
        SAML2LocalSP localSP = this.configManager.getLocalSP();
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2Endpoint ssoEndpoint = this.configManager.getSSOEndpoint();
        String location = ssoEndpoint.getLocation();
        SAML2AuthRequest authnRequest = this.createAuthnRequest(location);
        try {
            String applicationUrl = SAML2LoginModuleUtil.getApplicationURL(this.callbackHandler, this.options, this.configManager.getProxyingData().isProxying());
            String cookieName = this.setOriginalApplicationURLCookie(localSP, authnRequest.getID(), applicationUrl);
            boolean shouldSign = trustedIdP.isToSignAuthnRequests() == SignatureOption.ALWAYS || trustedIdP.isToSignAuthnRequests() == SignatureOption.FRONT_CHANNEL_ONLY;
            SAML2GetterCallbacksPAOSHeaders paosHeaders = new SAML2GetterCallbacksPAOSHeaders();
            paosHeaders.handle(this.callbackHandler);
            if (PAOSHTTPBinding.isUserAgentSupportECP((SAML2GetterCallbacksPAOSHeaders)paosHeaders)) {
                this.paosSendAuthnRequest(authnRequest, cookieName, location, shouldSign);
            } else if (SAML2Binding.HTTP_REDIRECT_BINDING.getName().equals(ssoEndpoint.getBinding().getName())) {
                this.redirectSendAuthnRequest(authnRequest, cookieName, location, shouldSign);
            } else if (SAML2Binding.HTTP_POST_BINDING.getName().equals(ssoEndpoint.getBinding().getName())) {
                this.postSendAuthnRequest(authnRequest, cookieName, shouldSign);
            } else if (SAML2Binding.HTTP_ARTIFACT_BINDING.getName().equals(ssoEndpoint.getBinding().getName())) {
                this.artifactSendAuthnRequest(authnRequest, location, cookieName);
            } else {
                this.loginResult.throwLoginFailedException("Unsupported SSO request binding configured in service provider.");
            }
            this.loginResult.getAuditData().setSigned(shouldSign);
            String auditMessage = CommonSAML2Utils.getIssuedAuthenticationRequestString((AuditData)this.loginResult.getAuditData());
            CommonSAML2Utils.getAuthenticationCategory().infoT(LOCATION, auditMessage);
            if (LOCATION.beInfo()) {
                String signed = shouldSign ? "signed" : "unsigned";
                LOCATION.infoT("Sending {0} AuthnRequest to Identity Provider (name: {1}, location: {2}) with binding: {3}\nSAML2 message:\n {4}", new Object[]{signed, trustedIdP.getName(), location, ssoEndpoint.getBinding().getName(), authnRequest.getXMLRepresentation()});
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not send AuthnRequest.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000007", (String)"Service Provider could not send AuthnRequest to Identity Provider [{0}]. Reason: {1}", (Object[])new Object[]{trustedIdP.getName(), e.getMessage()});
            AuditLogUtil.auditLogMessage((String)("Service Provider could not send AuthnRequest to Identity Provider " + trustedIdP.getName() + ". Reason: " + e.getMessage()), SAML2LoginModule.class);
            this.loginResult.throwLoginFailedException("Could not send AuthnRequest to Identity Provider: " + trustedIdP.getName(), e);
        }
    }

    private void removeOldCookies() throws Exception {
        ExtractCookiesCallback cookiesCallback = new ExtractCookiesCallback();
        this.callbackHandler.handle(new Callback[]{cookiesCallback});
        Cookie[] cookies = (Cookie[])cookiesCallback.getCookies();
        OriginalUrlCookie orgCookie = new OriginalUrlCookie(this.callbackHandler, this.configManager.getLocalSP());
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                String name = cookie.getName();
                if (OriginalUrlCookie.isOriginalUrlCookieName(name)) {
                    long maxLifeTime;
                    try {
                        orgCookie.parseCookie(name);
                    }
                    catch (Exception e) {
                        AuditLogUtil.auditLogMessage((String)"Could not parse the original url cookie.", SAML2LoginModule.class);
                        LOCATION.traceThrowableT(400, "Could not parse the original url cookie.", (Throwable)e);
                    }
                    long timestamp = orgCookie.getTimestampOfCreation();
                    if (timestamp != 0L && (maxLifeTime = timestamp + 60000L) < System.currentTimeMillis()) {
                        orgCookie.removeCookie(name);
                    }
                }
                ++n2;
            }
        }
    }

    private String setOriginalApplicationURLCookie(SAML2LocalSP localSP, String requestId, String applicationUrl) throws Exception {
        OriginalUrlCookie ouc = new OriginalUrlCookie(this.callbackHandler, localSP);
        String cookieName = ouc.addCookie(applicationUrl, requestId, this.configManager.getProxyingData().isProxying());
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Application URL set in OUC cookie: {0}", new Object[]{applicationUrl});
        }
        return cookieName;
    }

    private void artifactSendAuthnRequest(SAML2AuthRequest samlRequest, String idpSSOUrl, String cookieName) throws Exception {
        SAML2LocalSP localSP = this.configManager.getLocalSP();
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        PrivateKey privateKey = this.configManager.getPrivateKeyForSignature();
        if (trustedIdP.isToSignAuthnRequests() == SignatureOption.ALWAYS) {
            if (localSP.isToIncludeCertInSignature()) {
                samlRequest.sign(privateKey, this.configManager.getCertificateForSignature());
            } else {
                samlRequest.sign(privateKey, null);
            }
            LOCATION.debugT("AuthnRequest was successfully signed.");
        }
        String xmlRequest = samlRequest.generate();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("AuthnRequest created: {0}", new Object[]{xmlRequest});
        }
        this.sendArtifact(xmlRequest, idpSSOUrl, cookieName);
    }

    private void postSendAuthnRequest(SAML2AuthRequest samlRequest, String cookieName, boolean shouldSign) throws Exception {
        SAML2LocalSP localSP = this.configManager.getLocalSP();
        PrivateKey privateKey = this.configManager.getPrivateKeyForSignature();
        if (shouldSign) {
            if (localSP.isToIncludeCertInSignature()) {
                samlRequest.sign(privateKey, this.configManager.getCertificateForSignature());
            } else {
                samlRequest.sign(privateKey, null);
            }
            LOCATION.debugT("AuthnRequest was successfully signed.");
        }
        SAML2LoginModuleUtil.sendAuthnRequestPOST(this.callbackHandler, samlRequest, cookieName);
    }

    private void redirectSendAuthnRequest(SAML2AuthRequest samlRequest, String cookieName, String idpSSOUrl, boolean shouldSign) throws Exception {
        PrivateKey privateKey = this.configManager.getPrivateKeyForSignature();
        SAML2DataFactory dataFactory = SAML2DataFactory.getInstance();
        RedirectPayloadDeflate redirectPayload = dataFactory.createRedirectPayloadDeflate((SAML2ProtocolToken)samlRequest, cookieName);
        if (shouldSign) {
            redirectPayload.sign(privateKey);
            LOCATION.debugT("RedirectPayload was successfully signed.");
        }
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)idpSSOUrl, (RedirectPayloadDeflate)redirectPayload);
        SAML2LoginModuleUtil.redirect(this.callbackHandler, redirectUrl);
    }

    private void paosSendAuthnRequest(SAML2AuthRequest samlRequest, String cookieName, String idpSSOUrl, boolean shouldSign) throws Exception {
        SAML2LocalSP localSP = this.configManager.getLocalSP();
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        PrivateKey privateKey = this.configManager.getPrivateKeyForSignature();
        if (samlRequest.getAssertionConsumerServiceURL() != null) {
            samlRequest.setProtocolBinding(SAML2Binding.PAOS_BINDING.getName());
        }
        if (shouldSign) {
            Certificate cert = localSP.isToIncludeCertInSignature() ? this.configManager.getCertificateForSignature() : null;
            samlRequest.sign(privateKey, cert);
            LOCATION.debugT("AuthnRequest was successfully signed.");
        }
        String requestUrl = SAML2LoginModuleUtil.getRequestUrl(this.callbackHandler, this.options);
        SOAPHeaderPAOSRequest paosRequest = PAOSDataFactory.getInstance().createPAOSRequest(requestUrl);
        SOAPHeaderECPRequest ecpRequest = PAOSDataFactory.getInstance().createECPRequest();
        SAML2IDPEntry idpEntry = SAML2DataFactory.getInstance().createSAML2IDPEntry(trustedIdP.getName());
        idpEntry.setName(trustedIdP.getName());
        idpEntry.setLocation(idpSSOUrl);
        ArrayList<SAML2IDPEntry> idpEntries = new ArrayList<SAML2IDPEntry>();
        idpEntries.add(idpEntry);
        ecpRequest.setIDPList(idpEntries);
        SAML2SetterCallbacksPAOSMessage paosMessage = PAOSHTTPBinding.sendSAML2AuthnRequest((SOAPHeaderPAOSRequest)paosRequest, (SOAPHeaderECPRequest)ecpRequest, (String)cookieName, (SAML2AuthRequest)samlRequest);
        paosMessage.handle(this.callbackHandler);
    }

    private void redirectLogout(SAML2LogoutRequest logoutRequest, PrivateKey privateKey, SAML2Endpoint endpoint, String cookieName) throws Exception {
        boolean shouldSign;
        SAML2DataFactory dataFactory = SAML2DataFactory.getInstance();
        RedirectPayloadDeflate redirectPayload = dataFactory.createRedirectPayloadDeflate((SAML2ProtocolToken)logoutRequest, cookieName);
        boolean bl = shouldSign = this.configManager.getTrustedIdP().isToSignSingleLogoutMessages() == SignatureOption.ALWAYS || this.configManager.getTrustedIdP().isToSignSingleLogoutMessages() == SignatureOption.FRONT_CHANNEL_ONLY;
        if (shouldSign) {
            redirectPayload.sign(privateKey);
            LOCATION.debugT("Redirect Payload successfully signed.");
            this.loginResult.getAuditData().setSignedOnBindingLevel(shouldSign);
        }
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)logoutRequest.getDestination(), (RedirectPayloadDeflate)redirectPayload);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("RedirectPayloadDeflate redirect URL: {0}", new Object[]{redirectUrl});
        }
        if (LOCATION.beInfo()) {
            String signed = shouldSign ? "signed" : "unsigned";
            LOCATION.infoT("Sending {0} LogoutRequest to Identity Provider (name: {1}, location: {2}) with binding: {3}\nSAML2 message:\n {4}", new Object[]{signed, this.configManager.getTrustedIdP().getName(), endpoint.getLocation(), SAML2Binding.HTTP_REDIRECT_BINDING, logoutRequest.getXMLRepresentation()});
        }
        SAML2LoginModuleUtil.redirect(this.callbackHandler, redirectUrl);
    }

    private void postLogout(SAML2LogoutRequest logoutRequest, PrivateKey privateKey, SAML2Endpoint endpoint, String cookieName) throws Exception {
        boolean shouldSign;
        boolean bl = shouldSign = this.configManager.getTrustedIdP().isToSignSingleLogoutMessages() == SignatureOption.ALWAYS || this.configManager.getTrustedIdP().isToSignSingleLogoutMessages() == SignatureOption.FRONT_CHANNEL_ONLY;
        if (shouldSign) {
            if (this.configManager.getLocalSP().isToIncludeCertInSignature()) {
                logoutRequest.sign(privateKey, this.configManager.getCertificateForSignature());
            } else {
                logoutRequest.sign(privateKey, null);
            }
            LOCATION.debugT("LogoutRequest successfully signed.");
            this.loginResult.getAuditData().setSigned(shouldSign);
        }
        String xmlRequest = logoutRequest.generate();
        if (LOCATION.beInfo()) {
            String signed = shouldSign ? "signed" : "unsigned";
            LOCATION.infoT("Sending {0} LogoutRequest to Identity Provider (name: {1}, location: {2}) with binding: {3}\nSAML2 message:\n {4}", new Object[]{signed, this.configManager.getTrustedIdP().getName(), endpoint.getLocation(), SAML2Binding.HTTP_POST_BINDING, logoutRequest.getXMLRepresentation()});
        }
        Locale locale = SAML2LoginModuleUtil.getRequestLocale(this.callbackHandler);
        String postForm = HTTPPostBinding.generateRequestForm((String)xmlRequest, (String)cookieName, (String)logoutRequest.getDestination(), (Locale)locale);
        SAML2LoginModuleUtil.setContentTypeHeader(this.callbackHandler, "text/html; charset=utf-8");
        SAML2LoginModuleUtil.setCacheControlHeaders(this.callbackHandler);
        SAMLSetterCallback ssc = new SAMLSetterCallback();
        ssc.setType((byte)9);
        ssc.setValue((Object)postForm);
        this.callbackHandler.handle(new Callback[]{ssc});
    }

    private void loadSAML2Principal() {
        this.saml2Principal = SAML2LoginModuleUtil.getSAML2Principal();
    }

    private boolean globalLogout() throws LoginException {
        SAML2LocalSP localSP = this.configManager.getLocalSP();
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2Endpoint endpoint = this.configManager.getSLOEndpoint();
        if (endpoint == null) {
            return false;
        }
        if (!localSP.isSPInitiatedSLOEnabled()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000135", (String)"Service Provider could not initiate global logout because SP-Initiated SLO has been disabled in the configuration. Local session will be logged out.");
            return true;
        }
        if (this.saml2Principal.isMNITerminated()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000097", (String)"Service Provider could not perform global logout because the name-id is terminated. Local logout is performed.");
            return true;
        }
        List sessionIndexes = this.saml2Principal.getSessionIndexes();
        if (sessionIndexes.isEmpty()) {
            LOCATION.infoT("SAML2 context does not contain any session indexes and only Local Logout is executed.");
            return false;
        }
        if (LOCATION.beInfo()) {
            LOCATION.infoT("Service Provider triggers global logout to trusted Identity Provider [{0}].", new Object[]{trustedIdP.getName()});
        }
        this.sendLogoutRequest(localSP, trustedIdP, endpoint);
        return true;
    }

    private void sendLogoutRequest(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, SAML2Endpoint endpoint) throws LoginException {
        SAML2LogoutRequest logoutRequest = this.createLogoutRequest();
        PrivateKey privateKey = this.configManager.getPrivateKeyForSignature();
        SAML2Binding sloBinding = endpoint.getBinding();
        String bindingName = sloBinding.getName();
        try {
            if (SAML2Binding.SOAP_BINDING.getName().equals(bindingName)) {
                this.loginResult.throwLoginFailedException("Unsupported SLO binding [" + bindingName + "] configured for Service Provider.");
            } else {
                String applicationUrl = SAML2LoginModuleUtil.getRequestUrl(this.callbackHandler, this.options);
                String cookieName = this.setOriginalApplicationURLCookie(localSP, logoutRequest.getID(), applicationUrl);
                if (SAML2Binding.HTTP_REDIRECT_BINDING.getName().equals(bindingName)) {
                    this.redirectLogout(logoutRequest, privateKey, endpoint, cookieName);
                } else if (SAML2Binding.HTTP_POST_BINDING.getName().equals(bindingName)) {
                    this.postLogout(logoutRequest, privateKey, endpoint, cookieName);
                } else if (SAML2Binding.HTTP_ARTIFACT_BINDING.getName().equals(bindingName)) {
                    this.artifactLogout(logoutRequest, privateKey, endpoint, cookieName);
                } else {
                    this.loginResult.throwLoginFailedException("Unsupported SLO binding [" + bindingName + "] configured for Service Provider.");
                }
            }
            this.loginResult.getAuditData().setLogoutRequest(logoutRequest);
            SAML2LoginModuleUtil.logLogoutInfo(this.loginResult.getAuditData(), this.saml2Principal.getName(), this.sharedState);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "LogoutRequest could not be sent.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000006", (String)"Service Provider could not perform global logout because LogoutRequest could not be sent to Identity Provider [{0}]. Reason: {1}", (Object[])new Object[]{trustedIdP.getName(), e.getMessage()});
            AuditLogUtil.auditLogMessage((String)("Service Provider could not perform global logout because LogoutRequest could not be sent to Identity Provider " + trustedIdP.getName() + ". Reason: " + e.getMessage()), SAML2LoginModule.class);
            LoginException le = new LoginException("Service Provider could not perform global logout because LogoutRequest could not be sent.");
            le.initCause(e);
            throw le;
        }
    }

    private SAML2LogoutRequest createLogoutRequest() throws LoginException {
        SAML2LogoutRequest logoutRequest;
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2LocalSP localSP = this.configManager.getLocalSP();
        String nameId = this.saml2Principal.getNameId();
        String nameIdFormat = this.saml2Principal.getNameIdFormat();
        String nameIdSPProvidedID = this.saml2Principal.getSPProvidedID();
        String nameIdSPNameQualifier = this.saml2Principal.getNameIdSPNameQualifier();
        String nameIdNameQualifier = this.saml2Principal.getNameIdNameQualifier();
        List sessionIndexes = this.saml2Principal.getSessionIndexes();
        SAML2NameID userNameId = SAML2DataFactory.getInstance().createSAML2NameID(nameId);
        userNameId.setFormat(nameIdFormat);
        userNameId.setSPProvidedID(nameIdSPProvidedID);
        userNameId.setSPNameQualifier(nameIdSPNameQualifier);
        userNameId.setNameQualifier(nameIdNameQualifier);
        this.loginResult.getAuditData().setNameID(userNameId);
        try {
            Date now = Calendar.getInstance().getTime();
            String requestId = SAML2Utils.generateUUID();
            if (trustedIdP.isToEncryptSingleLogoutSubject()) {
                EncryptionAlgorithm encryptAlgorithm = trustedIdP.getEncryptionAlgorithm();
                if (encryptAlgorithm == null) {
                    SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000116", (String)"Service Provider cannot read trusted Identity Provider [{0}] algorithm for encryption from configuration.", (Object[])new Object[]{trustedIdP.getName()});
                    this.loginResult.throwLoginFailedException("Encryption algorithm cannot be read from trusted IdP configuration.");
                }
                PublicKey idpEncPublicKey = this.configManager.getTrustedIdPPublicKeyForEncryption();
                SAML2EncryptedNameID encNameId = userNameId.encrypt((Key)idpEncPublicKey, encryptAlgorithm.getName());
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("LogoutRequest Name ID successfully encrypted using algorithm: {0}", encryptAlgorithm.getName());
                }
                this.loginResult.getAuditData().setSAML2NameIDEncrypted(true);
                logoutRequest = SAML2ProtocolFactory.getInstance().createLogoutRequest(requestId, now, encNameId);
            } else {
                this.loginResult.getAuditData().setSAML2NameIDEncrypted(false);
                logoutRequest = SAML2ProtocolFactory.getInstance().createLogoutRequest(requestId, now, userNameId);
            }
            logoutRequest.setSessionIndex(sessionIndexes);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SesionIndex set in the LogoutRequest: {0}", new Object[]{sessionIndexes});
            }
            SAML2NameID issuerNameId = SAML2DataFactory.getInstance().createSAML2NameID(localSP.getName());
            logoutRequest.setIssuer(issuerNameId);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Issuer set in the LogoutRequest: {0}", new Object[]{localSP.getName()});
            }
            this.setLogoutRequestDestination(logoutRequest);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "LogoutRequest could not be created.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000005", (String)"Service Provider could not perform global logout because LogoutRequest could not be created. Reason: {0}", (Object[])new Object[]{e.getMessage()});
            AuditLogUtil.auditLogMessage((String)("Service Provider could not perform global logout because LogoutRequest could not be created. Reason: " + e.getMessage()), SAML2LoginModule.class);
            LoginException le = new LoginException("Service Provider could not perform global logout because LogoutRequest could not be created.");
            le.initCause(e);
            throw le;
        }
        return logoutRequest;
    }

    private void setLogoutRequestDestination(SAML2LogoutRequest logoutRequest) throws SAML2ConfigurationException, LoginException {
        SAML2Endpoint endpoint = this.configManager.getSLOEndpoint();
        if (endpoint != null) {
            String location = endpoint.getLocation();
            logoutRequest.setDestination(location);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Destination set in the LogoutRequest: {0}", new Object[]{location});
            }
        }
    }

    private void federateLocalUserAccount() throws Exception {
        String subjectNameId = this.loginResult.getPrincipalNameId();
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        String localUsername = (String)this.sharedState.get("javax.security.auth.login.name");
        if (localUsername == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000060", (String)"Service Provider could not federate the Subject Name ID [{0}] received from Identity Provider [{1}] with local user account because local authentication was not successful.", (Object[])new Object[]{subjectNameId, trustedIdP.getName()});
            this.loginResult.throwLoginFailedException("Login name not found in shared state to be federated.");
        }
        UserMaintenanceService.setPersistentAttribute(trustedIdP, localUsername, subjectNameId);
        if (LOCATION.beInfo()) {
            LOCATION.infoT("Service Provider has successfully federated local user account [{0}] with persistent opaque-id [{1}] received from Identity Provider [{2}].", new Object[]{localUsername, this.loginResult.getPrincipalNameId(), trustedIdP.getName()});
        }
        this.loginResult.setLocalUser(localUsername);
        this.loginResult.setFederationRequired(true);
        trustedIdP.getNameIdFormatPersistent().isToUpdateUserAttributesAtLogin();
        String spName = this.configManager.isLocalIdP() ? null : this.configManager.getLocalSP().getName();
        AuthnContext newContext = Utils.getAuthenticationContext(this.configManager, this.loginResult);
        this.saml2Principal = Utils.createSAML2Principal(this.saml2Principal, newContext, this.loginResult, spName);
    }

    private void sendArtifact(String saml2Message, String location, String cookieName) throws Exception {
        int artifactValidity = this.configManager.getLocalSP().getArtifactValidityPeriodInSeconds();
        int endpointIndex = 0;
        SAML2Artifact artifact = SAML2CommonServicesManager.getInstance().getArtifactServiceInstance().issueArtifact(endpointIndex, artifactValidity, this.configManager.getLocalSP().getName(), this.configManager.getTrustedIdP().getName(), saml2Message);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SP-Issued artifact string: [{0}]", new Object[]{artifact.getValue()});
        }
        RedirectPayloadDeflate payloadDeflate = SAML2DataFactory.getInstance().createRedirectPayloadDeflate(artifact, cookieName);
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)location, (RedirectPayloadDeflate)payloadDeflate);
        SAML2LoginModuleUtil.redirect(this.callbackHandler, redirectUrl);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Artifact sent using redirect url: {0}", new Object[]{redirectUrl});
        }
    }

    private void artifactLogout(SAML2LogoutRequest logoutRequest, PrivateKey privateKey, SAML2Endpoint endpoint, String cookieName) throws Exception {
        boolean shouldSign;
        boolean bl = shouldSign = this.configManager.getTrustedIdP().isToSignSingleLogoutMessages() == SignatureOption.ALWAYS;
        if (shouldSign) {
            if (this.configManager.getLocalSP().isToIncludeCertInSignature()) {
                logoutRequest.sign(privateKey, this.configManager.getCertificateForSignature());
            } else {
                logoutRequest.sign(privateKey, null);
            }
            LOCATION.debugT("Logout request successfully signed.");
            this.loginResult.getAuditData().setSigned(shouldSign);
        }
        String xmlRequest = logoutRequest.generate();
        if (LOCATION.beInfo()) {
            String signed = shouldSign ? "signed" : "unsigned";
            LOCATION.infoT("Sending {0} LogoutRequest to Identity Provider (name: {1}, location: {2}) with binding: {3}\nSAML2 message:\n {4}", new Object[]{signed, this.configManager.getTrustedIdP().getName(), endpoint.getLocation(), SAML2Binding.HTTP_ARTIFACT_BINDING, logoutRequest.getXMLRepresentation()});
        }
        this.sendArtifact(xmlRequest, logoutRequest.getDestination(), cookieName);
    }

    private void remoteLogin() throws LoginException {
        if (this.saml2Principal == null) {
            if (this.isToResumeAuthentication()) {
                this.resumeAuthentication();
            } else if (this.isTokenInRequest()) {
                this.initialAuthentication();
            } else {
                this.authenticationChallenge();
            }
        } else if (SAML2LoginModuleUtil.isSessionProlongation(this.callbackHandler)) {
            if (this.isTokenInRequest()) {
                this.sessionProlongationAuthentication();
            } else {
                this.sessionProlongationChallenge();
            }
        } else if (this.isRequiredAuthentication()) {
            if (this.isToResumeAuthentication()) {
                this.resumeAuthentication();
            } else if (this.isTokenInRequest()) {
                this.reauthentication();
            } else {
                this.reauthenticationChallenge();
            }
        } else {
            this.ssoBetweenApplications();
        }
    }

    private boolean determineExecutionMode() {
        try {
            if (SAML2LoginModuleUtil.isDisabledByUrlParameter(this.callbackHandler)) {
                if (this.configManager.getProviderSelectionService().isManualIdPSelectionMode() && !CommonSAML2Utils.checkSalt((CallbackHandler)this.callbackHandler)) {
                    LOCATION.warningT("Salt check failed. IdP selection cannot be canceled. See SAP Note 1441999 for more details.");
                    return true;
                }
                this.execMode = (byte)2;
                LOCATION.debugT("SAML2LoginModule is running in execution mode: DISABLED");
                LOCATION.infoT("SAML2 functionality is disabled by URL parameter.");
                return false;
            }
            String modeOptionValue = this.options.get("mode");
            boolean disabledByOption = "disabled".equalsIgnoreCase(modeOptionValue);
            boolean disabledByConfig = !this.configManager.isSAML2FunctionalityEnabled();
            boolean bl = this.isDisabledByOptionOrConfig = disabledByConfig || disabledByOption;
            if (this.isDisabledByOptionOrConfig) {
                this.execMode = (byte)2;
                if (LOCATION.beDebug()) {
                    if (disabledByConfig) {
                        LOCATION.infoT("SAML2 functionality is disabled by configuration.");
                    } else if (disabledByOption) {
                        LOCATION.infoT("SAML2 functionality is disabled by login module option.");
                    }
                    LOCATION.debugT("SAML2LoginModule is running in execution mode: DISABLED");
                }
                return false;
            }
            if ("test".equalsIgnoreCase(modeOptionValue)) {
                this.execMode = 1;
                LOCATION.debugT("SAML2LoginModule is running in execution mode: TEST");
            } else {
                this.execMode = 0;
                LOCATION.debugT("SAML2LoginModule is running in execution mode DEFAULT.");
            }
            return true;
        }
        finally {
            this.configManager.setProviderExecutionMode(this.execMode);
        }
    }

    private void resolveIdPIssuedArtifact() throws LoginFailedException {
        block8: {
            try {
                SAML2ProtocolToken token = null;
                if (this.execMode == 1) {
                    HashMap testMap = new HashMap();
                    token = SAML2CommonServicesManager.getInstance().getArtifactServiceInstance().resolveArtifact(this.configManager.getSAML2Config(), this.saml2Artifact, testMap);
                    if (testMap.size() != 0) {
                        for (Map.Entry e : testMap.entrySet()) {
                            this.testOutput.setReceivedEntry((String)e.getKey(), (String)e.getValue());
                        }
                    }
                } else {
                    token = SAML2CommonServicesManager.getInstance().getArtifactServiceInstance().resolveArtifact(this.configManager.getSAML2Config(), this.saml2Artifact);
                }
                if (token instanceof SAML2Response) {
                    this.saml2Response = (SAML2Response)token;
                    this.loginResult.getAuditData().setSaml2ResponseBase((SAML2ResponseBase)this.saml2Response);
                    if (LOCATION.beInfo()) {
                        LOCATION.infoT("Service Provider has successfully resolved SAML2Artifact [{0}] received from Identity Provider [{1}] to [{2}].", new Object[]{this.saml2Artifact.getValue(), this.configManager.getTrustedIdP().getName(), this.saml2Response});
                    }
                    break block8;
                }
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000019", (String)"Service Provider received unsupported SAML2 message in ArtifactResponse. Message: {0}", (Object[])new Object[]{token});
                throw new Exception("Service Provider received unsupported SAML2 message in ArtifactResponse.");
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Service Provider could not resolve SAML2Artifact.", (Throwable)e);
                AuditLogUtil.auditLogMessage((String)"Service Provider could not resolve SAML2Artifact.", SAML2LoginModule.class);
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000013", (String)"Service Provider could not resolve SAML2Artifact. Reason: {0}", (Object[])new Object[]{e.getMessage()});
                this.loginResult.throwLoginFailedException("Service Provider could not resolve SAML2Artifact.", e);
            }
        }
    }

    private void setFederationRequiredAttributes() {
        try {
            SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
            String idpName = trustedIdP.getName();
            String idpDescription = trustedIdP.getDescription();
            if (idpDescription != null && idpDescription.length() != 0) {
                idpName = idpDescription;
            }
            SAML2NameIdFormatPersistentTrustedIdP persistentNameIdFormat = trustedIdP.getNameIdFormatPersistent();
            boolean isInteractiveFederationAllowed = persistentNameIdFormat.isInteractiveAccountLinking();
            boolean isAutomaticAccountCreationAllowed = persistentNameIdFormat.isAutomaticAccountCreation();
            if (isInteractiveFederationAllowed) {
                SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "federationRequired", "true");
                SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "federationIdP", idpName);
                SAML2LoginModuleUtil.setSessionAttribute(this.callbackHandler, "proxyFederationRequired", "true");
                if (LOCATION.beInfo()) {
                    LOCATION.infoT("Service Provider allowing interactive account linking");
                }
            }
            if (isAutomaticAccountCreationAllowed) {
                SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "automaticAccountCreation", "true");
                SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, "federationIdP", idpName);
                if (LOCATION.beInfo()) {
                    LOCATION.infoT("Service Provider allowing automatic account creation");
                }
            }
        }
        catch (Exception e) {
            AuditLogUtil.auditLogMessage((String)"Could not set request attributes required for federation.", SAML2LoginModule.class);
            LOCATION.traceThrowableT(500, "Could not set request attributes required for federation.", (Throwable)e);
        }
    }

    private void onSAML2AuthenticationFailed() {
        SAML2LoginModuleUtil.requestReSubmitPostParams(this.callbackHandler);
        OriginalUrlCookie orgCookie = new OriginalUrlCookie(this.callbackHandler, this.configManager.getLocalSP());
        orgCookie.removeCookie(this.relayState);
    }

    private void onOverallAuthenticationFailed() {
        Utils.removePrincipal(this.subject);
        SAML2LoginModuleUtil.requestReSubmitPostParams(this.callbackHandler);
        try {
            SAML2LoginModuleUtil.setSessionAttribute(this.callbackHandler, "com.sap.security.saml2.sp.LoginResult", this.loginResult);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("LoginResult saved in HTTP session: {0}", new Object[]{this.loginResult});
            }
        }
        catch (Exception e) {
            AuditLogUtil.auditLogMessage((String)"Could not set LoginResult as application session attribute.", SAML2LoginModule.class);
            LOCATION.traceThrowableT(500, "Could not set LoginResult as application session attribute.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000012", (String)"Service Provider could not save SAML2 context in application session. Reason: {0}", (Object[])new Object[]{e.getMessage()});
        }
    }

    private void interactivePersistentFederation() throws LoginException {
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2NameIdFormatPersistentTrustedIdP persistentConfig = trustedIdP.getNameIdFormatPersistent();
        if (persistentConfig.isInteractiveAccountLinking()) {
            String federationRequiredParam = null;
            try {
                federationRequiredParam = SAML2LoginModuleUtil.getRequestParameterAsString(this.callbackHandler, "federationRequired");
            }
            catch (Exception e) {
                AuditLogUtil.auditLogMessage((String)"Could not get request attribute for federation.", SAML2LoginModule.class);
                LOCATION.traceThrowableT(500, "Could not get request attribute for federation.", (Throwable)e);
            }
            if (federationRequiredParam != null) {
                boolean federationRequired = "on".equalsIgnoreCase(federationRequiredParam);
                if (federationRequired) {
                    try {
                        this.federateLocalUserAccount();
                    }
                    catch (Exception e) {
                        AuditLogUtil.auditLogMessage((String)"Error federating local user account.", SAML2LoginModule.class);
                        LOCATION.traceThrowableT(500, "Error federating local user account.", (Throwable)e);
                        SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000080", (String)"Service Provider could not federate the Subject Name ID [{0}] received from Identity Provider [{1}]. Reason: {2}", (Object[])new Object[]{this.loginResult.getPrincipalNameId(), trustedIdP.getName(), e.getMessage()});
                        this.loginResult.throwLoginFailedException("Error federating local user account.", e);
                    }
                }
            } else if (this.loginResult.isFederationRequired()) {
                String spName = this.configManager.isLocalIdP() ? null : this.configManager.getLocalSP().getName();
                AuthnContext newContext = Utils.getAuthenticationContext(this.configManager, this.loginResult);
                this.saml2Principal = Utils.createSAML2Principal(this.saml2Principal, newContext, this.loginResult, spName);
            }
        } else if (!persistentConfig.isAutomaticAccountCreation()) {
            throw new IllegalStateException("Login status code Interactive Persistent Federation is inconsistent with persistent name-id format congifuration.");
        }
    }

    private void onSuccessfulSAML2Authentication(byte loginStatus) throws LoginException {
        OriginalUrlCookie orgCookie = new OriginalUrlCookie(this.callbackHandler, this.configManager.getLocalSP());
        orgCookie.removeCookie(this.relayState);
        this.subject.getPrincipals().add((Principal)this.saml2Principal);
        this.cacheUser(this.saml2Principal);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2Principal added to subject: {0}", new Object[]{this.saml2Principal});
        }
        if (!this.loginResult.isFederationRequired()) {
            this.sharedState.put("javax.security.auth.login.principal", this.saml2Principal);
        }
        if (loginStatus != 5) {
            if (this.configManager.getLocalSP().issueSAPLogonTickets() && CommonSAML2Utils.shouldIssueTokensToBackendSystems((String)this.loginResult.getLocalUser())) {
                SAML2CommonServicesManager.getInstance().getSSO2ServiceInstance().createLogonTicket(this.subject, this.callbackHandler, this.sharedState, new HashMap());
            }
            String clusterWideClientID = this.loginResult.getClusterWideClientID();
            SAML2LoginModuleUtil.setRequestAttribute(this.callbackHandler, REQUEST_ATTRIBUTE_SESSION_INDEX, clusterWideClientID);
            this.handleSessionProlongation();
        }
        SAML2LoginModuleUtil.restoreOriginalRequest(this.configManager, this.callbackHandler, this.options, this.relayState);
    }

    private void cacheUser(SAML2Principal saml2Principal) {
        String userName = saml2Principal.getName();
        ModifiableUser user = null;
        try {
            ModifiableUserProvider userProvider;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("User {0} will be created from SAML2 pricipal.", new Object[]{userName});
            }
            if ((userProvider = ModifiableUserManagementAccessor.getModifiableUserProvider()) != null) {
                user = userProvider.getModifiableUser(userName);
                if (user == null) {
                    user = userProvider.createUser(userName);
                }
                this.updateUserAttributes(saml2Principal, user);
                userProvider.persistUser(user);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("User {0} was created and saved.", new Object[]{userName});
                }
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("No ModifiableUserProvider found. Cannot cache user.");
            }
        }
        catch (PersistenceException e) {
            AuditLogUtil.auditLogMessage((String)("User provider failed to access user " + userName), SAML2LoginModule.class);
            LOCATION.traceThrowableT(400, "User provider failed to access user {0}.", new Object[]{userName}, (Throwable)e);
        }
        catch (UnsupportedUserNameException e) {
            AuditLogUtil.auditLogMessage((String)("Failed to create user because the provided name " + userName + " is not supported."), SAML2LoginModule.class);
            LOCATION.traceThrowableT(400, "Failed to create user because the provided name [{0}] is not supported.", new Object[]{userName}, (Throwable)e);
        }
        catch (UserAlreadyExistsException e) {
            AuditLogUtil.auditLogMessage((String)("User " + userName + " already exists. Failed to persist."), SAML2LoginModule.class);
            LOCATION.traceThrowableT(400, "User {0} already exists. Failed to persist.", new Object[]{userName}, (Throwable)e);
        }
    }

    private void updateUserAttributes(SAML2Principal saml2Principal, ModifiableUser user) {
        Set attributes = saml2Principal.getAttributes();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                List values = attribute.getValues();
                if (values == null || values.isEmpty()) continue;
                try {
                    user.setAttribute(attribute.getName(), (String)attribute.getValues().get(0));
                }
                catch (ReadonlyAttributeException e) {
                    AuditLogUtil.auditLogMessage((String)("Cound not add read-only attribute " + attribute.getName()), SAML2LoginModule.class);
                    LOCATION.traceThrowableT(400, "Cound not add read-only attribute [{0}].", new Object[]{attribute.getName()}, (Throwable)e);
                }
                catch (UnsupportedUserAttributeException e) {
                    AuditLogUtil.auditLogMessage((String)("The attribute " + attribute.getName() + " is not supported and cannot be added to user."), SAML2LoginModule.class);
                    LOCATION.traceThrowableT(400, "The attribute [{0}] is not supported and cannot be added to user.", new Object[]{attribute.getName()}, (Throwable)e);
                }
                catch (UnsupportedUserAttributeValueException e) {
                    AuditLogUtil.auditLogMessage((String)("The value " + (String)values.get(0) + " is not supported for attribute " + attribute.getName()), SAML2LoginModule.class);
                    LOCATION.traceThrowableT(400, "The value [{0}] is not supported for attribute [{1}]", new Object[]{values.get(0), attribute.getName()}, (Throwable)e);
                }
            }
        }
    }

    private void handleSessionProlongation() throws LoginFailedException {
        String sessionProlongationValue = this.options.get("session.prolongation");
        if (this.execMode == 1 && sessionProlongationValue != null) {
            try {
                int idpSessionExpiration = Integer.valueOf(sessionProlongationValue);
                UserSession.getInstance().setAttribute("sap.com/idp_session_expiration", (Object)(System.currentTimeMillis() + (long)(idpSessionExpiration * 1000)));
            }
            catch (NumberFormatException e) {
                AuditLogUtil.auditLogMessage((String)"Value is not a valid integer in [session.prolongation] login module option.", SAML2LoginModule.class);
                this.loginResult.throwLoginFailedException("Value is not a valid integer in [session.prolongation] login module option.", e);
            }
            catch (Exception e) {
                AuditLogUtil.auditLogMessage((String)"Session Prolongation attribute cannot be set to the client context.", SAML2LoginModule.class);
                this.loginResult.throwLoginFailedException("Session Prolongation attribute cannot be set to the client context.", e);
            }
        } else if (this.loginResult.getSessionNotOnOrAfter() != null) {
            try {
                UserSession.getInstance().setAttribute("sap.com/idp_session_expiration", (Object)this.loginResult.getSessionNotOnOrAfter().getTime());
            }
            catch (Exception e) {
                AuditLogUtil.auditLogMessage((String)"Session Prolongation attribute cannot be set to the client context.", SAML2LoginModule.class);
                this.loginResult.throwLoginFailedException("Session Prolongation attribute cannot be set to the client context.", e);
            }
        } else {
            LOCATION.debugT("SessionNotOnOrAfter of the AuthnStatement is not set in the received authentication request.");
        }
    }

    private void setTestOutputInSession() {
        if (!this.configManager.isLocalIdP() && this.configManager.isIdPSelected()) {
            this.testOutput.setSessionAttributes(this.callbackHandler, this.configManager.getSAML2Config());
        }
        this.testOutput.setLoginResult(this.loginResult);
    }

    private void determineAccessType() {
        String option = this.options.get("access.type");
        this.isLocalAccess = "local".equalsIgnoreCase(option);
        if (this.isLocalAccess) {
            LOCATION.debugT("Access type for the Service Provider application is: [local]");
        }
    }

    private void checkHttpsRequirements() throws LoginException {
        boolean isSecure = SAML2LoginModuleUtil.isRequestSecure(this.callbackHandler);
        boolean isHttpEnabled = this.configManager.getLocalProvider().isPlainHTTPConnectionsEnabled();
        if (!isSecure && !isHttpEnabled) {
            boolean changed;
            String requestUrl = null;
            try {
                requestUrl = SAML2LoginModuleUtil.getRequestUrl(this.callbackHandler, this.options);
            }
            catch (Exception e) {
                AuditLogUtil.auditLogMessage((String)"Could not get relative URL from request.", SAML2LoginModule.class);
                LOCATION.traceThrowableT(500, "Could not get relative URL from request.", (Throwable)e);
                LoginException le = new LoginException();
                le.initCause(e);
                throw le;
            }
            if (SAML2LoginModuleUtil.isCurrentRequestPost(this.callbackHandler)) {
                SAML2LoginModuleUtil.storePostParams(this.callbackHandler);
                requestUrl = SAML2LoginModuleUtil.addSAML2PostParameter(requestUrl);
            }
            if (changed = SAML2LoginModuleUtil.changeSchema(this.callbackHandler, requestUrl)) {
                LOCATION.infoT("Service Provider has changed the current scheme to HTTPS because it is configured to accept only secure connections.");
            } else {
                LOCATION.errorT("Service Provider could not change the current scheme to HTTPS because it failed to read the server secure port.");
            }
            this.loginResult.throwLoginFailedException("HTTP access denied.");
        }
    }

    private void checkSupportedBinding() throws LoginException {
        SAML2LocalSP localSP;
        Set supportedBindings;
        if (this.saml2Binding != null && !this.configManager.isLocalIdP() && !(supportedBindings = (localSP = this.configManager.getLocalSP()).getAssertionConsumerSupportedBindings()).contains(this.saml2Binding)) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000009", (String)"Service Provider received SAML2 message over unsupported binding [{0}].", (Object[])new Object[]{this.saml2Binding.getName()});
            this.loginResult.throwLoginFailedException("Service Provider received SAML2 message over unsupported binding: " + this.saml2Binding.getName());
        }
    }

    protected void setErrorMessagesAttribute(CallbackHandler callbackHandler, String attributeName, SAML2Response saml2Response) {
        if (saml2Response != null && !"urn:oasis:names:tc:SAML:2.0:status:Success".equalsIgnoreCase(saml2Response.getTopLevelStatusCode())) {
            String idpName = this.loginResult.getIdpName();
            if (idpName != null) {
                SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
                String description = trustedIdP.getDescription();
                if (description != null && description.length() != 0) {
                    idpName = description;
                }
            } else {
                idpName = "";
            }
            HashMap<String, String> errorMessages = new HashMap<String, String>();
            errorMessages.put("topLevelStatus", saml2Response.getTopLevelStatusCode());
            errorMessages.put("secondLevelStatus", saml2Response.getSecondLevelStatusCode());
            errorMessages.put("messageStatus", saml2Response.getStatusMessage());
            errorMessages.put("idpHost", idpName);
            SAML2LoginModuleUtil.setRequestAttribute(callbackHandler, attributeName, errorMessages);
        }
    }
}

