/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.engine.lib.security.login.SubjectWrapper;
import com.sap.security.auth.service.ThreadAuthenticationContext;
import com.sap.security.auth.service.UserSession;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.commons.AuditData;
import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.lib.bindings.HTTPPostBinding;
import com.sap.security.saml2.lib.callbacks.SAMLGetterCallback;
import com.sap.security.saml2.lib.callbacks.SAMLSetterCallback;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.sp.ConfigurationManager;
import com.sap.security.saml2.sp.LoginResult;
import com.sap.security.saml2.sp.SAML2LoginModule;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.User;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class SAML2LoginModuleUtil {
    private static final Location LOCATION = Location.getLocation(SAML2LoginModule.class);
    private static final String LOGIN_MODULE_OPTION_PROXY_HEADER = "proxy_header";
    static final String ACS_URL = "/saml2/sp/acs";
    private static final String METHOD_TYPE_POST = "POST";
    private static final String HTTPS_SCHEME = "https";
    private static Integer securePort = null;

    SAML2LoginModuleUtil() {
    }

    static SAML2Principal getSAML2Principal() {
        Set<SAML2Principal> principals;
        UserSession session = UserSession.getInstance();
        SubjectWrapper subjectWrapper = (SubjectWrapper)session.getSubject();
        if (subjectWrapper != null && (principals = subjectWrapper.getSubject().getPrincipals(SAML2Principal.class)) != null && !principals.isEmpty()) {
            return principals.iterator().next();
        }
        return null;
    }

    static Object getRequestParameter(CallbackHandler callbackHandler, String requestParameterName) throws Exception {
        SAMLGetterCallback sgc = new SAMLGetterCallback();
        sgc.setType((byte)3);
        sgc.setName(requestParameterName);
        callbackHandler.handle(new Callback[]{sgc});
        Object object = sgc.getValue();
        return object;
    }

    static String getRequestHeader(CallbackHandler callbackHandler, String headerName) throws Exception {
        HttpGetterCallback sgc = new HttpGetterCallback();
        sgc.setType((byte)1);
        sgc.setName(headerName);
        callbackHandler.handle(new Callback[]{sgc});
        Object headerValue = sgc.getValue();
        return (String)headerValue;
    }

    static String getRequestParameterAsString(CallbackHandler callbackHandler, String requestParameterName) throws Exception {
        HttpGetterCallback sgc = new HttpGetterCallback();
        sgc.setType((byte)3);
        sgc.setName(requestParameterName);
        callbackHandler.handle(new Callback[]{sgc});
        Object param = sgc.getValue();
        if (param != null && param instanceof String[]) {
            String[] params = (String[])param;
            if (params.length == 1) {
                return params[0];
            }
            if (params.length > 1) {
                if (requestParameterName != null) {
                    String url = SAML2LoginModuleUtil.getRequestUrl(callbackHandler);
                    String[] stringArray = params;
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        String value = String.valueOf(URLEncoder.encode(requestParameterName, "UTF-8")) + "=" + URLEncoder.encode(s, "UTF-8");
                        if (url.indexOf(value) == -1) {
                            return s;
                        }
                        ++n2;
                    }
                }
                return params[0];
            }
        }
        return null;
    }

    static String getRequestMethodType(CallbackHandler callbackHandler) throws Exception {
        String cookie_value = SAML2LoginModuleUtil.getOriginalURLCookie(callbackHandler);
        String methodType = null;
        if (cookie_value != null && cookie_value.length() > 0) {
            char first_char = cookie_value.charAt(0);
            switch (first_char) {
                case 'G': 
                case 'g': {
                    methodType = "GET";
                    break;
                }
                case 'P': 
                case 'p': {
                    methodType = METHOD_TYPE_POST;
                    break;
                }
                default: {
                    LOCATION.debugT("Unknown method type: {0}", new Object[]{cookie_value});
                }
            }
        }
        if (methodType == null) {
            HttpGetterCallback sgc = new HttpGetterCallback();
            sgc.setType((byte)6);
            callbackHandler.handle(new Callback[]{sgc});
            methodType = (String)sgc.getValue();
        }
        return methodType;
    }

    static String getOriginalURLCookie(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        String cookie_value = null;
        return cookie_value;
    }

    static boolean isSessionProlongation(CallbackHandler callbackHandler) {
        try {
            Object sessionProlongationRequired = SAML2LoginModuleUtil.getRequestAttribute(callbackHandler, "sap.com/session_prolongation");
            return sessionProlongationRequired != null;
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error clearing session prolongation required attribute from HTTP request.", (Throwable)e);
            return false;
        }
    }

    static boolean changeSchema(CallbackHandler callbackHandler, String url) {
        block3: {
            if (SAML2LoginModuleUtil.getServerSecurePort() == null) break block3;
            URL u = new URL(url);
            URL https = new URL(HTTPS_SCHEME, u.getHost(), securePort, u.getFile());
            SAML2LoginModuleUtil.redirect(callbackHandler, https.toString());
            return true;
        }
        try {
            LOCATION.errorT("Could not switch to secure connection. Reason: could not get secure port.");
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not switch to secure connection.", (Throwable)e);
        }
        return false;
    }

    static boolean isRequestSecure(CallbackHandler callbackHandler) {
        try {
            HttpGetterCallback sgc = new HttpGetterCallback();
            sgc.setType((byte)7);
            callbackHandler.handle(new Callback[]{sgc});
            Object isSecure = sgc.getValue();
            return (Boolean)isSecure;
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error getting request isSecure value", (Throwable)e);
            return false;
        }
    }

    static boolean isOriginalRequestPost(CallbackHandler callbackHandler) {
        block3: {
            block4: {
                String orgReqMethod = SAML2LoginModuleUtil.getRequestParameterAsString(callbackHandler, "saml2post");
                if (orgReqMethod == null) break block3;
                if (!"true".equalsIgnoreCase(orgReqMethod)) break block4;
                LOCATION.debugT("Original request method is POST (based on ACS endpoint parameter).");
                return true;
            }
            try {
                LOCATION.debugT("Original request method is GET (based on ACS endpoint parameter).");
                return false;
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Could not get [saml2post] parameter from request.", (Throwable)e);
            }
        }
        return SAML2LoginModuleUtil.isCurrentRequestPost(callbackHandler);
    }

    static boolean isCurrentRequestPost(CallbackHandler callbackHandler) {
        block3: {
            try {
                String requestMethodType = SAML2LoginModuleUtil.getRequestMethodType(callbackHandler);
                if (!METHOD_TYPE_POST.equalsIgnoreCase(requestMethodType)) break block3;
                LOCATION.debugT("Original request method is POST (based on original URL cookie).");
                return true;
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Could not get original request method type.", (Throwable)e);
                return false;
            }
        }
        LOCATION.debugT("Original request method is GET (based on original URL cookie).");
        return false;
    }

    static String addSAML2PostParameter(String url) {
        return CommonSAML2Utils.addQueryStringParameter((String)"saml2post", (String)"true", (String)url);
    }

    static boolean shouldRestorePostParameters(CallbackHandler callbackHandler) {
        try {
            String saml2Post = SAML2LoginModuleUtil.getRequestParameterAsString(callbackHandler, "saml2post");
            return "true".equalsIgnoreCase(saml2Post);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error determining the initial request type.", (Throwable)e);
            return false;
        }
    }

    static Object getRequestAttribute(CallbackHandler callbackHandler, String requestAttributeName) throws IOException, UnsupportedCallbackException {
        SAMLGetterCallback sgc = new SAMLGetterCallback();
        sgc.setType((byte)13);
        sgc.setName(requestAttributeName);
        callbackHandler.handle(new Callback[]{sgc});
        Object object = sgc.getValue();
        return object;
    }

    static void setRequestAttribute(CallbackHandler callbackHandler, String attributeName, Object attributeValue) {
        try {
            HttpSetterCallback sgc = new HttpSetterCallback();
            sgc.setType((byte)13);
            sgc.setName(attributeName);
            sgc.setValue(attributeValue);
            callbackHandler.handle(new Callback[]{sgc});
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error setting request attribute: " + attributeName, (Throwable)e);
        }
    }

    static Object getSessionAttribute(CallbackHandler callbackHandler, String requestAttributeName) throws IOException, UnsupportedCallbackException {
        SAMLGetterCallback sgc = new SAMLGetterCallback();
        sgc.setType((byte)10);
        sgc.setName(requestAttributeName);
        callbackHandler.handle(new Callback[]{sgc});
        Object object = sgc.getValue();
        return object;
    }

    static void setSessionAttribute(CallbackHandler callbackHandler, String attributeName, Object attributeValue) throws IOException, UnsupportedCallbackException {
        HttpSetterCallback sgc = new HttpSetterCallback();
        sgc.setType((byte)10);
        sgc.setName(attributeName);
        sgc.setValue(attributeValue);
        callbackHandler.handle(new Callback[]{sgc});
    }

    static Object getRuntimeModelAttribute(CallbackHandler callbackHandler, String requestAttributeName) throws IOException, UnsupportedCallbackException {
        SAMLGetterCallback sgc = new SAMLGetterCallback();
        sgc.setType((byte)20);
        sgc.setName(requestAttributeName);
        callbackHandler.handle(new Callback[]{sgc});
        return sgc.getValue();
    }

    static void setRuntimeModelAttribute(CallbackHandler callbackHandler, String attributeName, Object attributeValue) throws IOException, UnsupportedCallbackException {
        HttpSetterCallback sgc = new HttpSetterCallback();
        sgc.setType((byte)20);
        sgc.setName(attributeName);
        sgc.setValue(attributeValue);
        callbackHandler.handle(new Callback[]{sgc});
    }

    static Object removeRuntimeModelAttribute(CallbackHandler callbackHandler, String attributeName) throws IOException, UnsupportedCallbackException {
        HttpSetterCallback sgc = new HttpSetterCallback();
        sgc.setType((byte)21);
        sgc.setName(attributeName);
        callbackHandler.handle(new Callback[]{sgc});
        return sgc.getValue();
    }

    static void sendAuthnRequestPOST(CallbackHandler callbackHandler, SAML2AuthRequest samlRequest, String relayState) throws SAML2Exception, IOException, UnsupportedCallbackException {
        String authRequestXml = samlRequest.generate();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Authentication request: " + authRequestXml);
        }
        Locale locale = SAML2LoginModuleUtil.getRequestLocale(callbackHandler);
        String requestForm = HTTPPostBinding.generateRequestForm((String)authRequestXml, (String)relayState, (String)samlRequest.getDestination(), (Locale)locale);
        SAML2LoginModuleUtil.setContentTypeHeader(callbackHandler, "text/html; charset=utf-8");
        SAML2LoginModuleUtil.setCacheControlHeaders(callbackHandler);
        SAMLSetterCallback ssc = new SAMLSetterCallback();
        ssc.setType((byte)9);
        ssc.setValue((Object)requestForm);
        callbackHandler.handle(new Callback[]{ssc});
    }

    static Locale getRequestLocale(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        LanguageCallback languageCallback = new LanguageCallback();
        callbackHandler.handle(new Callback[]{languageCallback});
        Locale locale = languageCallback.getLocale();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Retrieved locale from the callback handler is: [{0}]", new Object[]{locale});
        }
        return locale;
    }

    static void setContentTypeHeader(CallbackHandler callbackHandler, String contentType) throws IOException, UnsupportedCallbackException {
        SAMLSetterCallback ssc = new SAMLSetterCallback();
        ssc.setType((byte)1);
        ssc.setName("Content-Type");
        ssc.setValue((Object)contentType);
        callbackHandler.handle(new Callback[]{ssc});
    }

    static void setCacheControlHeaders(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        Map cacheControlHeaders = HTTPPostBinding.getCacheControlHeaders();
        SAMLSetterCallback[] callbacks = new SAMLSetterCallback[cacheControlHeaders.size()];
        int i = 0;
        for (String headerName : cacheControlHeaders.keySet()) {
            SAMLSetterCallback callback = new SAMLSetterCallback();
            callback.setType((byte)1);
            callback.setName(headerName);
            callback.setValue(cacheControlHeaders.get(headerName));
            callbacks[i] = callback;
            ++i;
        }
        callbackHandler.handle((Callback[])callbacks);
    }

    static void redirect(CallbackHandler callbackHandler, String url) throws IOException, UnsupportedCallbackException {
        SAMLSetterCallback ssc = new SAMLSetterCallback();
        ssc.setType((byte)19);
        ssc.setValue((Object)url);
        callbackHandler.handle(new Callback[]{ssc});
    }

    static String getRequestUrl(CallbackHandler callbackHandler, Map<String, String> options) throws Exception {
        String proxyPath;
        String requestUrl = SAML2LoginModuleUtil.getRequestUrl(callbackHandler);
        String header = options.get(LOGIN_MODULE_OPTION_PROXY_HEADER);
        if (header != null && (proxyPath = SAML2LoginModuleUtil.getRequestHeader(callbackHandler, header)) != null) {
            URL url;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Original application path extracted from proxy header: {0}", new Object[]{proxyPath});
            }
            if ((url = new URL(requestUrl)).getQuery() != null && proxyPath.indexOf(63) == -1) {
                String path = String.valueOf(proxyPath) + '?' + url.getQuery();
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
            } else {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), proxyPath);
            }
            requestUrl = url.toString();
        }
        return requestUrl;
    }

    static String getCookie(CallbackHandler callbackHandler, String cookieName) {
        try {
            SAMLGetterCallback sgc = new SAMLGetterCallback();
            sgc.setType((byte)2);
            sgc.setName(cookieName);
            callbackHandler.handle(new Callback[]{sgc});
            Object obj = sgc.getValue();
            String cookieValue = (String)obj;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Common domain cookie extracted from the http request: " + cookieValue);
            }
            return cookieValue;
        }
        catch (Exception e) {
            if (LOCATION.beDebug()) {
                LOCATION.traceThrowableT(100, "Error getting common domain cookie from http request.", (Throwable)e);
            }
            return null;
        }
    }

    static void storePostParams(CallbackHandler callbackHandler) {
        SAMLGetterCallback sgc = new SAMLGetterCallback();
        sgc.setType((byte)18);
        try {
            callbackHandler.handle(new Callback[]{sgc});
            if (LOCATION.beDebug()) {
                LOCATION.debugT("POST parameters successfully preserved.");
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error saving post parameters.", (Throwable)e);
        }
    }

    static void restorePostParams(CallbackHandler callbackHandler) {
        HttpSetterCallback sgc = new HttpSetterCallback();
        sgc.setType((byte)18);
        try {
            callbackHandler.handle(new Callback[]{sgc});
            if (LOCATION.beDebug()) {
                LOCATION.debugT("POST parameters successfully restored.");
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error restoring post parameters.", (Throwable)e);
        }
    }

    static String getOriginalUrl(CallbackHandler callbackHandler, Map<String, String> options) throws Exception {
        String orgURL = (String)SAML2LoginModuleUtil.getRequestAttribute(callbackHandler, "redirect_url");
        if (orgURL == null) {
            orgURL = (String)SAML2LoginModuleUtil.getSessionAttribute(callbackHandler, "com.sap.security.original_url");
        }
        if (orgURL == null) {
            orgURL = SAML2LoginModuleUtil.getRequestUrl(callbackHandler, options);
        }
        if (orgURL != null && orgURL.startsWith("http")) {
            return new URL(orgURL).getFile();
        }
        return orgURL;
    }

    static boolean isSessionAnonymous() {
        ThreadAuthenticationContext thread = ThreadAuthenticationContext.getInstance();
        return thread.getAuthenticatedPrincipal() == null;
    }

    static String addProviderNameToUrl(String url, String providerName) {
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + providerName;
        return url;
    }

    static boolean containsIgnoreCase(List<String> l, String s) {
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            if (!it.next().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    static boolean isDisabledByUrlParameter(CallbackHandler callbackHandler) {
        block6: {
            String disabled = SAML2LoginModuleUtil.getRequestParameterAsString(callbackHandler, "saml2");
            if (!"disabled".equalsIgnoreCase(disabled)) break block6;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SAML2LoginModule is disabled by an HTTP request parameter.");
            }
            return true;
        }
        try {
            Object o = SAML2LoginModuleUtil.getRequestAttribute(callbackHandler, "saml2");
            if (o instanceof String && "disabled".equalsIgnoreCase((String)o)) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("SAML2LoginModule is disabled by an HTTP request attribute.");
                }
                return true;
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error getting HTTP request parameter: saml2", (Throwable)e);
        }
        return false;
    }

    static void requestReSubmitPostParams(CallbackHandler callbackHandler) {
        HashSet<String> postParamsSet = new HashSet<String>();
        postParamsSet.add("SAMLResponse");
        postParamsSet.add("SAMLart");
        postParamsSet.add("RelayState");
        SAML2LoginModuleUtil.setRequestAttribute(callbackHandler, "sap.com/login_post_parameters", postParamsSet);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("POST parameters set as HTTP request attribute [{0}] to be re-submitted during login: {1}", new Object[]{"sap.com/login_post_parameters", postParamsSet});
        }
    }

    static String getRelativeUrl(CallbackHandler callbackHandler, Map<String, String> options) throws Exception {
        String requestUrl = SAML2LoginModuleUtil.getRequestUrl(callbackHandler, options);
        return new URL(requestUrl).getFile();
    }

    static boolean checkRecipientUrl(String recipientUrl, CallbackHandler callbackHandler, Map<String, String> options) {
        String requestUrl;
        block14: {
            URL urlRec;
            URL urlReq;
            block15: {
                block13: {
                    block12: {
                        if (recipientUrl == null || recipientUrl.length() == 0) {
                            LOCATION.errorT("Recipient URL [{0}] is not valid.", new Object[]{recipientUrl});
                            return false;
                        }
                        requestUrl = SAML2LoginModuleUtil.getRequestUrl(callbackHandler, options);
                        if (requestUrl != null && requestUrl.length() != 0) break block12;
                        LOCATION.errorT("Request URL [{0}] is not valid.", new Object[]{requestUrl});
                        return false;
                    }
                    urlReq = new URL(requestUrl);
                    urlRec = new URL(recipientUrl);
                    if (!urlRec.getPath().startsWith(ACS_URL)) break block13;
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Recipient URL [{0}] matches ACS endpoint URL [{1}].", new Object[]{urlRec.getPath(), ACS_URL});
                    }
                    return true;
                }
                if (!urlRec.getHost().equalsIgnoreCase(urlReq.getHost()) || CommonSAML2Utils.getPortFromUrl((URL)urlRec) != CommonSAML2Utils.getPortFromUrl((URL)urlReq)) break block14;
                if (!urlRec.getPath().equalsIgnoreCase(urlReq.getPath())) break block15;
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Recipient URL [{0}] matches Request URL [{1}].", new Object[]{recipientUrl, requestUrl});
                }
                return true;
            }
            if (LOCATION.beWarning()) {
                LOCATION.debugT("Recipient URL [{0}] does not match Request URL [{1}] or ACS endpoint URL [{2}].", new Object[]{urlRec.getPath(), urlReq.getPath(), ACS_URL});
            }
            return false;
        }
        try {
            if (LOCATION.beWarning()) {
                LOCATION.debugT("Recipient URL [{0}] does not match Request URL [{1}].", new Object[]{recipientUrl, requestUrl});
            }
            return false;
        }
        catch (MalformedURLException e) {
            LOCATION.traceThrowableT(500, "Cannot verify recipient host.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Cannot get request URL.", (Throwable)e);
            return false;
        }
    }

    static void logLogoutInfo(AuditData auditData, String user, Map<String, Object> sharedState) {
        String auditMessage = CommonSAML2Utils.getIssuedLogoutRequestAuditString((AuditData)auditData, (String)user);
        CommonSAML2Utils.getAuthenticationCategory().infoT(LOCATION, auditMessage);
    }

    static void logAssertionInfo(LoginResult loginResult, Map<String, Object> sharedState) {
        if (loginResult.hasLoginResultInSession()) {
            String loginDetails = (String)sharedState.get("com.sap.security.saml2.sp.SAML2LoginModule_LoginModuleDetails");
            String message = "Resuming SAML2 authentication based on already validated SAML2 token in previous authentication attempt.";
            if (loginDetails != null) {
                message = String.valueOf(message) + "\n\n" + loginDetails;
            }
            sharedState.put("com.sap.security.saml2.sp.SAML2LoginModule_LoginModuleDetails", message);
        } else {
            AuditData auditData = loginResult.getAuditData();
            if (auditData.getAssertion() != null) {
                String assertionAudit = CommonSAML2Utils.toAuditString((AuditData)auditData);
                String loginDetails = (String)sharedState.get("com.sap.security.saml2.sp.SAML2LoginModule_LoginModuleDetails");
                String message = null;
                message = loginDetails != null ? "Consumed " + assertionAudit + "\n\n" + loginDetails : "Consumed " + assertionAudit;
                sharedState.put("com.sap.security.saml2.sp.SAML2LoginModule_LoginModuleDetails", message);
            }
        }
    }

    static void logUserInfo(String uniqueId, Map<String, Object> sharedState) {
        String detailsMessage = SAML2LoginModuleUtil.generateUserInfoMessage(uniqueId);
        sharedState.put("com.sap.security.saml2.sp.SAML2LoginModule_LoginModuleDetails", detailsMessage);
    }

    private static String generateUserInfoMessage(String uniqueId) {
        StringBuffer sb = new StringBuffer();
        try {
            User user = UserManagementAccessor.getUserProvider().getUser(uniqueId);
            if (user == null) {
                throw new Exception("User not found in the UME: " + uniqueId);
            }
            sb.append("User: ").append(user.getName()).append("\n");
            sb.append("Attributes: ");
            Set attributeNames = user.listAttributes();
            for (String attributeName : attributeNames) {
                String attributeValue = user.getAttribute(attributeName);
                if (attributeValue == null || attributeValue.length() <= 0) continue;
                sb.append("\n  " + attributeName + " = " + attributeValue);
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error getting user information.", (Throwable)e);
        }
        return sb.toString();
    }

    static void redirectToIdPDiscoveryService(CallbackHandler callbackHandler, Map<String, String> options, SAML2LocalSP localSP) throws Exception {
        String url = localSP.getExternalIdPDiscoveryReadServiceUrl();
        if (url == null || url.length() == 0) {
            throw new Exception("External IdP Discovery Read Service Url cannot be read from configuration.");
        }
        String spUrl = SAML2LoginModuleUtil.getRequestUrl(callbackHandler, options);
        url = CommonSAML2Utils.addQueryStringParameter((String)"saml2spurl", (String)spUrl, (String)url);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Service Provider redirects to IdP Discovery Service using URL: {0}", new Object[]{url});
        }
        SAML2LoginModuleUtil.redirect(callbackHandler, url);
    }

    static String getApplicationURL(CallbackHandler callbackHandler, Map<String, String> options, boolean isProxying) throws Exception {
        String applicationUrl = SAML2LoginModuleUtil.getRequestUrl(callbackHandler, options);
        if (SAML2LoginModuleUtil.isCurrentRequestPost(callbackHandler)) {
            applicationUrl = SAML2LoginModuleUtil.addSAML2PostParameter(applicationUrl);
        } else if (!isProxying) {
            applicationUrl = SAML2LoginModuleUtil.removeAuthenticationRelatedRequestParameters(applicationUrl);
        }
        return applicationUrl;
    }

    static String removeAuthenticationRelatedRequestParameters(String url) {
        url = CommonSAML2Utils.removeQueryStringParameter((String)url, (String)"SAMLart");
        url = CommonSAML2Utils.removeQueryStringParameter((String)url, (String)"RelayState");
        return url;
    }

    private static String getRequestUrl(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        SAMLGetterCallback sgc = new SAMLGetterCallback();
        sgc.setType((byte)17);
        callbackHandler.handle(new Callback[]{sgc});
        Object obj = sgc.getValue();
        String requestUrl = (String)obj;
        return requestUrl;
    }

    static void restoreOriginalRequest(ConfigurationManager configManager, CallbackHandler callbackHandler, Map<String, String> options, String relayState) {
        String originalUrl = null;
        try {
            originalUrl = SAML2LoginModuleUtil.getOriginalUrl(callbackHandler, options);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not get original URL.", (Throwable)e);
        }
        if (originalUrl != null) {
            if (SAML2LoginModuleUtil.shouldRestorePostParameters(callbackHandler)) {
                SAML2LoginModuleUtil.restorePostParams(callbackHandler);
            } else {
                SAML2LoginModuleUtil.restoreOriginalGetRequest(callbackHandler, originalUrl);
            }
        }
    }

    private static void restoreOriginalGetRequest(CallbackHandler callbackHandler, String originalURL) {
        try {
            SAML2LoginModuleUtil.redirect(callbackHandler, originalURL);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Original GET request successfully restored.");
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not restore original GET request.", (Throwable)e);
        }
    }

    private static Integer getServerSecurePort() throws Exception {
        if (securePort == null) {
            ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
            if (mbeanServers == null || mbeanServers.size() == 0) {
                throw new Exception("There are no MBean servers. Server ports cannot be determined.");
            }
            ObjectName connectorsOName = new ObjectName("Catalina:type=ProtocolHandler,*");
            for (MBeanServer mbeanServer : mbeanServers) {
                try {
                    Set<ObjectInstance> connectors = mbeanServer.queryMBeans(connectorsOName, null);
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Connectors: {0}", new Object[]{connectors});
                    }
                    for (ObjectInstance oi : connectors) {
                        Integer port = null;
                        boolean secure = false;
                        try {
                            block20: {
                                String portStr;
                                block19: {
                                    String name = (String)mbeanServer.getAttribute(oi.getObjectName(), "name");
                                    if (!name.toUpperCase(Locale.ENGLISH).startsWith("HTTP")) continue;
                                    try {
                                        port = (Integer)mbeanServer.getAttribute(oi.getObjectName(), "proxyPort");
                                    }
                                    catch (AttributeNotFoundException attributeNotFoundException) {
                                        if (!LOCATION.beDebug()) break block19;
                                        LOCATION.debugT("Attribute not found: proxyPort");
                                    }
                                }
                                if (port == null || port == 0) {
                                    port = (Integer)mbeanServer.getAttribute(oi.getObjectName(), "port");
                                }
                                if ((port == null || port == 0) && (portStr = oi.getObjectName().getKeyProperty("port")) != null) {
                                    try {
                                        port = Integer.valueOf(portStr);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        if (!LOCATION.beDebug()) break block20;
                                        LOCATION.debugT("NumberFormatException thrown for Port: " + portStr);
                                    }
                                }
                            }
                            try {
                                secure = (Boolean)mbeanServer.getAttribute(oi.getObjectName(), "secure");
                            }
                            catch (AttributeNotFoundException attributeNotFoundException) {
                                secure = false;
                            }
                            if (!secure || port == null || port == 0) continue;
                            securePort = port;
                            return securePort;
                        }
                        catch (AttributeNotFoundException attributeNotFoundException) {
                            throw new Exception("Expected attribute not found in " + oi.getObjectName());
                        }
                        catch (MBeanException mBeanException) {
                            throw new Exception("Could not introspect " + oi.getObjectName());
                        }
                        catch (ReflectionException reflectionException) {
                            throw new Exception("Could not introspect " + oi.getObjectName());
                        }
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!LOCATION.beDebug()) continue;
                    LOCATION.traceThrowableT(100, "InstanceNotFoundException in getServerSecurePort()", (Throwable)instanceNotFoundException);
                }
            }
            throw new Exception("Could not determine HTTPS port");
        }
        return securePort;
    }
}

