/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;

public class ServiceProviderUtil {
    private static final String CLIENT_CONTEXT_ALIAS_PREFIX = "S-";
    private static final String CLIENT_CONTEXT_ALIAS_DELIMITER = "@";

    public static String composeClientContextAlias(String sessionIndex, String spName, String idpName) {
        byte[] sha1Bytes;
        if (sessionIndex == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(spName);
        sb.append(CLIENT_CONTEXT_ALIAS_DELIMITER);
        sb.append(idpName);
        sb.append(CLIENT_CONTEXT_ALIAS_DELIMITER);
        sb.append(sessionIndex);
        String rawAlias = sb.toString();
        try {
            sha1Bytes = SAML2Utils.calculateSha1Hash((String)rawAlias);
        }
        catch (SAML2Exception sAML2Exception) {
            return CLIENT_CONTEXT_ALIAS_PREFIX + rawAlias;
        }
        String alias = CLIENT_CONTEXT_ALIAS_PREFIX + SAML2Utils.byteArrayToHEXString((byte[])sha1Bytes);
        return alias;
    }
}

