/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.sp.LoginResult;
import com.sap.security.saml2.sp.SAML2LoginModule;
import com.sap.security.saml2.sp.SAML2LoginModuleUtil;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class TestOutputFormatter {
    private static final Location LOCATION = Location.getLocation(SAML2LoginModule.class);
    private static final String HTTP_REQUEST_HEADER_REFERER = "referer";
    private static final String ACS_ENDPOINT_SHORT_NAME = "ACS";
    private Map<String, String> receivedData = new HashMap<String, String>();
    private Map<String, String[]> assertionAttributes = new HashMap<String, String[]>();
    private boolean isTestMode = true;

    TestOutputFormatter() {
    }

    TestOutputFormatter(byte execMode) {
        this.isTestMode = execMode == 1;
    }

    void setSessionAttributes(CallbackHandler callbackHandler, SAML2Config saml2Config) {
        if (this.isTestMode) {
            this.setAcsEndpointReferer(callbackHandler);
            try {
                SAML2LoginModuleUtil.setSessionAttribute(callbackHandler, "com.sap.security.saml2.sp.SAML2Config", saml2Config);
                SAML2LoginModuleUtil.setSessionAttribute(callbackHandler, "com.sap.security.saml2.sp.ReceivedData", this.receivedData);
                SAML2LoginModuleUtil.setSessionAttribute(callbackHandler, "com.sap.security.saml2.sp.AssertionAttributes", this.assertionAttributes);
            }
            catch (IOException e) {
                LOCATION.traceThrowableT(500, "IO exception during setting session attribute for test applications.", (Throwable)e);
            }
            catch (UnsupportedCallbackException e) {
                LOCATION.traceThrowableT(500, "Unsupported callback exception during setting session attribute for test applications.", (Throwable)e);
            }
        }
    }

    void setAcsEndpointReferer(CallbackHandler callbackHandler) {
        String referer;
        try {
            referer = SAML2LoginModuleUtil.getRequestHeader(callbackHandler, HTTP_REQUEST_HEADER_REFERER);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not get request header.", (Throwable)e);
            return;
        }
        if (referer != null && referer.indexOf("/saml2/sp/acs") != -1) {
            this.receivedData.put(ACS_ENDPOINT_SHORT_NAME, "true");
        } else {
            this.receivedData.put(ACS_ENDPOINT_SHORT_NAME, "false");
        }
    }

    void setLoginResult(LoginResult loginResult) {
        if (this.isTestMode) {
            this.receivedData.put("SubjectNameId", loginResult.getPrincipalNameId());
            this.receivedData.put("SubjectNameIdFormat", loginResult.getPrincipalNameIdFormat());
            if (loginResult.getSessionIndex() != null) {
                this.receivedData.put("SessionIndex", loginResult.getSessionIndex());
            }
            if (loginResult.getSessionNotOnOrAfter() != null) {
                this.receivedData.put("SessionNotOnOrAfter", loginResult.getSessionNotOnOrAfter().toString());
            }
            this.receivedData.put("ResponseSigned", loginResult.isSAML2ResponseSigned() ? "true" : "false");
            this.receivedData.put("LocalUser", loginResult.getLocalUser());
        }
    }

    void setReceivedEntry(String name, String value) {
        if (this.isTestMode && value != null) {
            this.receivedData.put(name, value);
        }
    }

    void setAssertionAttribute(String name, String format, String value) {
        if (this.isTestMode) {
            this.assertionAttributes.put(name, new String[]{format, value});
        }
    }
}

