/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedIdP;
import com.sap.security.saml2.sp.exception.NameIdMappingFailedException;
import com.sap.security.um.service.api.ModifiableUserManagementAccessor;
import com.sap.security.um.user.modify.ModifiableUser;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;

public class UserMaintenanceService {
    private static final Location LOCATION = Location.getLocation(UserMaintenanceService.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");

    static void setPersistentAttribute(SAML2TrustedIdP trustedIdP, String localUser, String NameId) throws NameIdMappingFailedException {
        SAML2NameIdFormatPersistentTrustedIdP persistentNameIdFormat = trustedIdP.getNameIdFormatPersistent();
        String umeAttributeName = persistentNameIdFormat.getUMEAttributeName();
        if (umeAttributeName == null || umeAttributeName.length() == 0) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000076", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it does not have UME attribute configured for persistent federation.", (Object[])new Object[]{NameId, trustedIdP.getName()});
            throw new NameIdMappingFailedException("UME attribute is not configured in the Name ID Format Persistent configuration for trusted IdP: " + trustedIdP.getName());
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Configured UME attribute name for persistent Name ID Format is: {0}", new Object[]{umeAttributeName});
        }
        try {
            ModifiableUser modifiableUser = ModifiableUserManagementAccessor.getModifiableUserProvider().getModifiableUser(localUser);
            if (modifiableUser == null) {
                modifiableUser = ModifiableUserManagementAccessor.getModifiableUserProvider().createUser(localUser);
            }
            modifiableUser.setAttribute(umeAttributeName, NameId);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Subject Name ID [{0}] successfully persisted in the UME as attribute of user [{1}].", new Object[]{NameId, localUser});
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not set user persistent attribute.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000075", (String)"Service Provider could not federate the Subject Name ID [{0}] received from Identity Provider [{1}] with local user account because it could not set persistent attribute [{2}] for user account [{3}].", (Object[])new Object[]{NameId, trustedIdP.getName(), umeAttributeName, localUser});
            throw new NameIdMappingFailedException("Could not set user persistent attribute.", e);
        }
    }

    static boolean shouldCopyUserMappingInformation(SAML2NameIdFormatPersistentTrustedIdP persistentConfig) {
        return persistentConfig.getDefaultTemplateUser() != null || persistentConfig.getTemplateUsers() != null && !persistentConfig.getTemplateUsers().isEmpty();
    }

    static boolean shouldCopyUserMappingInformation(SAML2NameIdFormatTransientTrustedIdP transientConfig) {
        return transientConfig.getDefaultTemplateUser() != null || transientConfig.getTemplateUsers() != null && !transientConfig.getTemplateUsers().isEmpty();
    }
}

