/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.cfg.enums.NameIdFormatKerberosTrustedIdPOption;
import com.sap.security.saml2.cfg.enums.NameIdFormatUnspecifiedOption;
import com.sap.security.saml2.cfg.enums.NameIdFormatWindowsOption;
import com.sap.security.saml2.cfg.enums.NameIdFormatX509TrustedIdPOption;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatEmail;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatKerberosTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecified;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatWindows;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatX509TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedIdP;
import com.sap.security.saml2.commons.Attribute;
import com.sap.security.saml2.lib.attributes.AttributeValuePair;
import com.sap.security.saml2.lib.attributes.AttributeValues;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.sp.ConfigurationManager;
import com.sap.security.saml2.sp.LoginResult;
import com.sap.security.saml2.sp.exception.NameIdMappingFailedException;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import com.sap.security.um.user.modify.ModifiableUserProvider;
import com.sap.security.um.user.modify.UnsupportedUserNameException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;

public class UserMappingService {
    private static final String WINDOWS_DOMAIN_SEPARATOR = "\\";
    private static final String EMAIL_DOMAIN_SEPARATOR = "@";
    private static final String KERBEROS_REALM_SEPARATOR = "@";
    private static final String UME_ATTRIBUTE_KPN_PRINCIPAL = "principal";
    private static final String UME_ATTRIBUTE_KPN_REALM = "realm";
    private static final String UME_ATTRIBUTE_WDQN_PRINCIPAL = "principal";
    private static final String UME_ATTRIBUTE_WDQN_DOMAIN = "domain";
    private static final Location LOCATION = Location.getLocation(UserMappingService.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");
    private ConfigurationManager configManager;
    private LoginResult loginResult;

    UserMappingService(ConfigurationManager configManager, LoginResult loginResult, Map<String, Object> sharedState) {
        this.configManager = configManager;
        this.loginResult = loginResult;
    }

    void mapNameId(SAML2Assertion saml2Assertion) throws LoginException {
        String idpName;
        User iUser;
        String subjectNameId = this.loginResult.getPrincipalNameId();
        String subjectNameIDFormat = this.loginResult.getPrincipalNameIdFormat();
        String localUser = null;
        if (subjectNameIDFormat == null || subjectNameIDFormat.length() < 1) {
            subjectNameIDFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Mapping Subject NameID [{0}] to a local user account using Name ID Format [{1}]", new Object[]{subjectNameId, subjectNameIDFormat});
        }
        if ("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equalsIgnoreCase(subjectNameIDFormat)) {
            throw new LoginException("Name ID format - persistent - not supported!");
        }
        if ("urn:oasis:names:tc:SAML:2.0:nameid-format:transient".equalsIgnoreCase(subjectNameIDFormat)) {
            iUser = this.resolveNameIdTransient(subjectNameId);
            localUser = iUser.getName();
        } else if ("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress".equalsIgnoreCase(subjectNameIDFormat)) {
            iUser = this.resolveNameIdEmail(subjectNameId);
            localUser = iUser.getName();
        } else if ("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName".equalsIgnoreCase(subjectNameIDFormat)) {
            iUser = this.resolveNameIdWinDomainQualified(subjectNameId);
            localUser = iUser.getName();
        } else if ("urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos".equalsIgnoreCase(subjectNameIDFormat)) {
            iUser = this.resolveNameIdKerberosPrincipal(subjectNameId);
            localUser = iUser.getName();
        } else if ("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equalsIgnoreCase(subjectNameIDFormat)) {
            iUser = this.resolveNameIdX509Subject(subjectNameId);
            localUser = iUser.getName();
        } else if ("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equalsIgnoreCase(subjectNameIDFormat)) {
            iUser = this.resolveNameIdUnspecified(subjectNameId);
            localUser = iUser.getName();
        } else {
            idpName = this.configManager.getTrustedIdP().getName();
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000059", (String)"Service Provider has received unsupported Subject Name ID Format [{0}] from Identity Provider [{1}].", (Object[])new Object[]{subjectNameIDFormat, idpName});
            this.loginResult.throwNameIDMappingFailedException("Subject NameID Format [" + subjectNameIDFormat + "] is not supported.");
        }
        if (LOCATION.beInfo()) {
            idpName = this.configManager.getTrustedIdP().getName();
            LOCATION.infoT("Service Provider has successfully mapped the Subject Name ID [{0}] received from Identity Provider [{1}] to user [{2}].", new Object[]{subjectNameId, idpName, localUser});
        }
        this.loginResult.setLocalUser(localUser);
    }

    void mapProfileAttributes(String subjectNameId, List<SAML2ProfileAttributeTrustedIdP> profileAttributes, AttributeValues assertionAttributes, Set<Attribute> profile) throws NameIdMappingFailedException {
        if (profileAttributes != null && !profileAttributes.isEmpty()) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Profile attributes configured: {0}", new Object[]{profileAttributes});
            }
            for (SAML2ProfileAttributeTrustedIdP profileAttribute : profileAttributes) {
                String attributeName = profileAttribute.getSAML2AttributeName();
                if (attributeName == null) continue;
                AttributeValuePair assertionProfileAttribute = assertionAttributes.get(attributeName);
                if (profileAttribute.isMandatory() && this.hasMissingAttributeOrValue(assertionProfileAttribute)) {
                    LOCATION.logT(500, "Service Provider could not update user account attributes for Subject Name ID [{0}] received from Identity Provider [{1}] because mandatory profile attribute [{2}] is not found in SAML2Assertion attributes [{3}].", new Object[]{subjectNameId, this.configManager.getTrustedIdP().getName(), profileAttribute, assertionAttributes});
                    this.loginResult.throwNameIDMappingFailedException("Mandatory profile attribute [" + profileAttribute + "] not found in assertion attributes.");
                    continue;
                }
                if (assertionProfileAttribute == null) continue;
                Attribute attr = new Attribute(profileAttribute.getUMEAttributeNamespace(), profileAttribute.getUMEAttributeName(), assertionProfileAttribute.getValuesAsStrings());
                profile.add(attr);
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SAML2Assertion attributes [{0}] successfully mapped to local user account attributes [{1}].", new Object[]{assertionAttributes, profile});
            }
        } else {
            LOCATION.debugT("Profile attributes mappings are not specified in the configuration.");
        }
    }

    private boolean hasMissingAttributeOrValue(AttributeValuePair profileAttribute) {
        if (profileAttribute == null || profileAttribute.getValuesAsStrings() == null || profileAttribute.getValuesAsStrings().isEmpty()) {
            return true;
        }
        List values = profileAttribute.getValuesAsStrings();
        for (String value : values) {
            if (value != null && value.length() != 0) continue;
            return true;
        }
        return false;
    }

    private User resolveNameIdTransient(String subjectNameId) throws LoginException {
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2NameIdFormatTransientTrustedIdP nameIdFormatTransient = trustedIdP.getNameIdFormatTransient();
        if (!nameIdFormatTransient.isSupported()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000111", (String)"Service Provider does not support Name ID Format [{0}] for trusted Identity Provider [{1}]. ", (Object[])new Object[]{nameIdFormatTransient.getNameIdFormat().getName(), trustedIdP.getName()});
            this.loginResult.throwNameIDMappingFailedException("Service Provider does not support Name ID Format [" + nameIdFormatTransient.getNameIdFormat().getName() + "] for trusted Identity Provider [" + trustedIdP.getName() + "].");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Transient Name ID Format is configured to process subject nameid [{0}] as user transient id.", new Object[]{subjectNameId});
        }
        User user = null;
        try {
            user = UserManagementAccessor.getUserProvider().getUser(subjectNameId);
        }
        catch (PersistenceException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000070", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot find user by alias [{2}].", (Object[])new Object[]{subjectNameId, trustedIdP.getName(), subjectNameId});
            this.loginResult.throwNameIDMappingFailedException("Could not find user by alias: " + subjectNameId, e);
        }
        return user;
    }

    private User resolveNameIdUnspecified(String saml2SubjectNameId) throws LoginException {
        NameIdFormatUnspecifiedOption type;
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2NameIdFormatUnspecified nameIdFormatUnspecified = trustedIdP.getNameIdFormatUnspecified();
        if (!nameIdFormatUnspecified.isSupported()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000111", (String)"Service Provider does not support Name ID Format [{0}] for trusted Identity Provider [{1}]. ", (Object[])new Object[]{nameIdFormatUnspecified.getNameIdFormat().getName(), trustedIdP.getName()});
            this.loginResult.throwNameIDMappingFailedException("Service Provider does not support Name ID Format [" + nameIdFormatUnspecified.getNameIdFormat().getName() + "] for trusted Identity Provider [" + trustedIdP.getName() + "].");
        }
        if ((type = nameIdFormatUnspecified.getType()) == NameIdFormatUnspecifiedOption.LOGON_ID) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Unspecified Name ID Format is configured to process subject nameid [{0}] as user logon id.", new Object[]{saml2SubjectNameId});
            }
            User user = this.resolveUserByUserId(saml2SubjectNameId);
            return user;
        }
        if (type == NameIdFormatUnspecifiedOption.LOGON_ALIAS) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Unspecified NameID Format is configured to process subject nameid [{0}] as user alias.", new Object[]{saml2SubjectNameId});
            }
            User user = this.resolveUserByAlias(saml2SubjectNameId);
            return user;
        }
        if (type == NameIdFormatUnspecifiedOption.USER_ATTRIBUTE) {
            String umeAttributeName = nameIdFormatUnspecified.getUMEAttributeName();
            String umeAttributeNS = nameIdFormatUnspecified.getUMEAttributeNamespace();
            if (umeAttributeName == null || umeAttributeName.length() == 0) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000076", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it does not have UME attribute configured for Name ID Format [{2}].", (Object[])new Object[]{saml2SubjectNameId, this.configManager.getTrustedIdP().getName(), nameIdFormatUnspecified.getNameIdFormat().getName()});
                this.loginResult.throwNameIDMappingFailedException("UME attribute is not configured for Name ID Format [Unspecified].");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Unspecified NameID Format is configured to process subject nameid [{0}] as an attribute value of the UME user attribute [name: {1}, namespace: {2}]", new Object[]{saml2SubjectNameId, umeAttributeName, umeAttributeNS});
            }
            User user = this.resolveUserByUmeAttribute(umeAttributeName, umeAttributeNS, saml2SubjectNameId, false);
            return user;
        }
        this.loginResult.throwNameIDMappingFailedException("Unknown configuration type for unspecified NameID Format: " + type);
        return null;
    }

    private User resolveNameIdEmail(String saml2SubjectNameId) throws LoginException {
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2NameIdFormatEmail nameIdFormatEmail = trustedIdP.getNameIdFormatEmail();
        if (!nameIdFormatEmail.isSupported()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000111", (String)"Service Provider does not support Name ID Format [{0}] for trusted Identity Provider [{1}]. ", (Object[])new Object[]{nameIdFormatEmail.getNameIdFormat().getName(), trustedIdP.getName()});
            this.loginResult.throwNameIDMappingFailedException("Service Provider does not support Name ID Format [" + nameIdFormatEmail.getNameIdFormat().getName() + "] for trusted Identity Provider [" + trustedIdP.getName() + "].");
        }
        if (!nameIdFormatEmail.areAllDomainsAccepted()) {
            int index = saml2SubjectNameId.indexOf("@");
            if (index == -1 || saml2SubjectNameId.length() == index + 1 || index == 0) {
                this.loginResult.throwBadCredentialException("Domain cannot be resolved from Name ID: " + saml2SubjectNameId);
            }
            String domain = saml2SubjectNameId.substring(index + 1);
            Set acceptedDomains = nameIdFormatEmail.getAcceptedDomains();
            if (!acceptedDomains.contains(domain.toUpperCase(Locale.ENGLISH))) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000139", (String)"Domain [{0}] for trusted Identity Provider [{1}] and Name ID Format [{2}] is rejected by the Service Provider. Currently accepted domains are: {3}", (Object[])new Object[]{domain, trustedIdP.getName(), nameIdFormatEmail.getNameIdFormat().getName(), acceptedDomains});
                this.loginResult.throwNameIDMappingFailedException("Service provider has rejected domain [" + domain + "]." + " Currently supported domains are: " + acceptedDomains);
            }
        }
        String umeAttributeName = nameIdFormatEmail.getUMEAttributeName();
        String umeAttributeNS = nameIdFormatEmail.getUMEAttributeNamespace();
        User user = this.resolveUserByUmeAttribute(umeAttributeName, umeAttributeNS, saml2SubjectNameId, false);
        return user;
    }

    private User resolveNameIdWinDomainQualified(String saml2SubjectNameId) throws LoginException {
        NameIdFormatWindowsOption type;
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2NameIdFormatWindows nameIdFormatWindows = trustedIdP.getNameIdFormatWindows();
        if (!nameIdFormatWindows.isSupported()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000111", (String)"Service Provider does not support Name ID Format [{0}] for trusted Identity Provider [{1}]. ", (Object[])new Object[]{nameIdFormatWindows.getNameIdFormat().getName(), trustedIdP.getName()});
            this.loginResult.throwNameIDMappingFailedException("Service Provider does not support Name ID Format [" + nameIdFormatWindows.getNameIdFormat().getName() + "] for trusted Identity Provider [" + trustedIdP.getName() + "].");
        }
        if (!nameIdFormatWindows.areAllDomainsAccepted()) {
            int index = saml2SubjectNameId.indexOf(WINDOWS_DOMAIN_SEPARATOR);
            if (index == -1) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000067", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it is invalid Windows Domain Qualified Name.", (Object[])new Object[]{saml2SubjectNameId, this.configManager.getTrustedIdP().getName()});
                this.loginResult.throwNameIDMappingFailedException("Invalid Windows Domain Qualified Name received: " + saml2SubjectNameId);
            }
            String domain = saml2SubjectNameId.substring(0, index);
            Set acceptedDomains = nameIdFormatWindows.getAcceptedDomains();
            if (!acceptedDomains.contains(domain.toUpperCase(Locale.ENGLISH))) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000139", (String)"Domain [{0}] for trusted Identity Provider [{1}] and Name ID Format [{2}] is rejected by the Service Provider. Currently accepted domains are: {3}", (Object[])new Object[]{domain, trustedIdP.getName(), nameIdFormatWindows.getNameIdFormat().getName(), acceptedDomains});
                this.loginResult.throwNameIDMappingFailedException("Service provider has rejected domain [" + domain + "]." + " Currently supported domains are: " + acceptedDomains);
            }
        }
        if ((type = nameIdFormatWindows.getType()) == NameIdFormatWindowsOption.ADS_DATA_SOURCE) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Windows Domain Name ID Format is configured to process subject nameid [{0}] as domain and principal values of the user account.", new Object[]{saml2SubjectNameId});
            }
            User user = this.resolveUserByWDQN(saml2SubjectNameId);
            return user;
        }
        if (type == NameIdFormatWindowsOption.USER_ATTRIBUTE) {
            String umeAttributeName = nameIdFormatWindows.getUMEAttributeName();
            String umeAttributeNS = nameIdFormatWindows.getUMEAttributeNamespace();
            if (umeAttributeName == null || umeAttributeName.length() == 0) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000076", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it does not have UME attribute configured for Name ID Format [{2}].", (Object[])new Object[]{saml2SubjectNameId, this.configManager.getTrustedIdP().getName(), nameIdFormatWindows.getNameIdFormat().getName()});
                this.loginResult.throwNameIDMappingFailedException("UME attribute name is not configured for Windows Domain NameID Format");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Windows Domain Name ID Format is configured to process subject nameid [{0}] as an attribute value of the user attribute [name: {1}, namespace: {2}]", new Object[]{saml2SubjectNameId, umeAttributeName, umeAttributeNS});
            }
            User user = this.resolveUserByUmeAttribute(umeAttributeName, umeAttributeNS, saml2SubjectNameId, false);
            return user;
        }
        this.loginResult.throwNameIDMappingFailedException("Unknown configuration type for Windows Domain NameID Format: " + type);
        return null;
    }

    private User resolveNameIdKerberosPrincipal(String saml2SubjectNameId) throws LoginException {
        NameIdFormatKerberosTrustedIdPOption type;
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2NameIdFormatKerberosTrustedIdP nameIdFormatKerberos = trustedIdP.getNameIdFormatKerberos();
        if (!nameIdFormatKerberos.isSupported()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000111", (String)"Service Provider does not support Name ID Format [{0}] for trusted Identity Provider [{1}]. ", (Object[])new Object[]{nameIdFormatKerberos.getNameIdFormat().getName(), trustedIdP.getName()});
            this.loginResult.throwNameIDMappingFailedException("Service Provider does not support Name ID Format [" + nameIdFormatKerberos.getNameIdFormat().getName() + "] for trusted Identity Provider [" + trustedIdP.getName() + "].");
        }
        if (!nameIdFormatKerberos.areAllRealmsAccepted()) {
            int index = saml2SubjectNameId.indexOf("@");
            if (index == -1) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000066", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it is invalid Kerberos Principal Name.", (Object[])new Object[]{saml2SubjectNameId, this.configManager.getTrustedIdP().getName()});
                this.loginResult.throwNameIDMappingFailedException("Invalid Kerberos Principal Name received: " + saml2SubjectNameId);
            }
            String realm = saml2SubjectNameId.substring(index + 1);
            Set acceptedRealms = nameIdFormatKerberos.getAcceptedRealms();
            if (!acceptedRealms.contains(realm.toUpperCase(Locale.ENGLISH))) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000140", (String)"Realm [{0}] for trusted Identity Provider [{1}] and Name ID Format [{2}] is rejected by the Service Provider. Currently accepted realms are: {3}", (Object[])new Object[]{realm, trustedIdP.getName(), nameIdFormatKerberos.getNameIdFormat().getName(), acceptedRealms});
                this.loginResult.throwNameIDMappingFailedException("Service provider has rejected realm [" + realm + "]." + " Currently supported realms are: " + acceptedRealms);
            }
        }
        if ((type = nameIdFormatKerberos.getType()) == NameIdFormatKerberosTrustedIdPOption.ADS_DATA_SOURCE) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Kerberos nameid-format is configured to process subject nameid [{0}] as principal and realm values of the user account", new Object[]{saml2SubjectNameId});
            }
            User user = this.resolveUserByKPN(saml2SubjectNameId);
            return user;
        }
        if (type == NameIdFormatKerberosTrustedIdPOption.USER_ATTRIBUTE) {
            String umeAttributeName = nameIdFormatKerberos.getUMEAttributeName();
            String umeAttributeNS = nameIdFormatKerberos.getUMEAttributeNamespace();
            if (umeAttributeName == null || umeAttributeName.length() == 0) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000076", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it does not have UME attribute configured for Name ID Format [{2}].", (Object[])new Object[]{saml2SubjectNameId, this.configManager.getTrustedIdP().getName(), nameIdFormatKerberos.getNameIdFormat().getName()});
                this.loginResult.throwNameIDMappingFailedException("UME attribute name is not configured for Kerberos NameID Format");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Kerberos Name ID Format is configured to process subject nameid [{0}] as an attribute value of the user attribute [name: {1}, namespace: {2}]", new Object[]{saml2SubjectNameId, umeAttributeName, umeAttributeNS});
            }
            User user = this.resolveUserByUmeAttribute(umeAttributeName, umeAttributeNS, saml2SubjectNameId, false);
            return user;
        }
        this.loginResult.throwNameIDMappingFailedException("Unknown configuration type for Kerberos NameID Format: " + type);
        return null;
    }

    private User resolveNameIdX509Subject(String saml2SubjectNameId) throws LoginException {
        NameIdFormatX509TrustedIdPOption type;
        SAML2TrustedIdP trustedIdP = this.configManager.getTrustedIdP();
        SAML2NameIdFormatX509TrustedIdP nameIdFormatX509 = trustedIdP.getNameIdFormatX509();
        if (!nameIdFormatX509.isSupported()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000111", (String)"Service Provider does not support Name ID Format [{0}] for trusted Identity Provider [{1}]. ", (Object[])new Object[]{nameIdFormatX509.getNameIdFormat().getName(), trustedIdP.getName()});
            this.loginResult.throwNameIDMappingFailedException("Service Provider does not support Name ID Format [" + nameIdFormatX509.getNameIdFormat().getName() + "] for trusted Identity Provider [" + trustedIdP.getName() + "].");
        }
        if ((type = nameIdFormatX509.getType()) == NameIdFormatX509TrustedIdPOption.USER_ATTRIBUTE) {
            String umeAttributeName = nameIdFormatX509.getUMEAttributeName();
            String umeAttributeNS = nameIdFormatX509.getUMEAttributeNamespace();
            if (umeAttributeName == null || umeAttributeName.length() == 0) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000076", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it does not have UME attribute configured for Name ID Format [{2}].", (Object[])new Object[]{saml2SubjectNameId, this.configManager.getTrustedIdP().getName(), nameIdFormatX509.getNameIdFormat().getName()});
                this.loginResult.throwNameIDMappingFailedException("UME attribute name for X509Subject NameID Format is not configured.");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("X509Subject Name ID Format is configured to process subject nameid [{0}] as an attribute value of the user attribute [name: {1}, namespace: {2}]", new Object[]{saml2SubjectNameId, umeAttributeName, umeAttributeNS});
            }
            User user = this.resolveUserByUmeAttribute(umeAttributeName, umeAttributeNS, saml2SubjectNameId, false);
            return user;
        }
        this.loginResult.throwNameIDMappingFailedException("Unknown configuration type for X509 subject format: " + type);
        return null;
    }

    private User resolveUserByUmeAttribute(String umeAttributeName, String umeAttributeNS, String attributeValue, boolean caseSensitive) throws NameIdMappingFailedException {
        if (umeAttributeNS == null || umeAttributeNS.length() == 0) {
            umeAttributeNS = "com.sap.security.core.usermanagement";
            if (LOCATION.beDebug()) {
                LOCATION.debugT("There is no configured attribute namespace.The search will execute using the default one: {0}", new Object[]{umeAttributeNS});
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Searching for user by UME attribute [name: {0}, namespace: {1}] and attribute value: {2}", new Object[]{umeAttributeName, umeAttributeNS, attributeValue});
        }
        UserProvider userProvider = null;
        try {
            userProvider = UserManagementAccessor.getUserProvider();
        }
        catch (PersistenceException e) {
            LOCATION.traceThrowableT(500, "Could not obtain user provider: ", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000072", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot obtain user provider.", (Object[])new Object[]{attributeValue, this.configManager.getTrustedIdP().getName()});
            this.loginResult.throwNameIDMappingFailedException("Could not obtain user provider. ", e);
        }
        Set users = userProvider.searchUser(umeAttributeName, attributeValue, UserProvider.SearchOperator.EQUALS, caseSensitive ? UserProvider.CaseSensitive.YES : UserProvider.CaseSensitive.NO);
        if (users.size() < 1) {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to local user account because local user account is not found by UME attribute: namespace = [{2}], name = [{3}].", new Object[]{attributeValue, this.configManager.getTrustedIdP().getName(), umeAttributeNS, umeAttributeName});
            }
            this.loginResult.throwNameIDMappingNoSuchUserException("Could not find user by UME attribute [name: " + umeAttributeName + ", namespace: " + umeAttributeNS + "] and attribute value: " + attributeValue);
        } else if (users.size() > 1) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000061", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to local user account because more than one local users are found by UME attribute: namespace = [{2}], name = [{3}].", (Object[])new Object[]{attributeValue, this.configManager.getTrustedIdP().getName(), umeAttributeNS, umeAttributeName});
            this.loginResult.throwNameIDMappingFailedException("Found too many users by UME attribute [name: " + umeAttributeName + ", namespace: " + umeAttributeNS + "] and attribute value: " + attributeValue);
        } else {
            for (String uniqueid : users) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("User found by the attribute search is: {0}", new Object[]{uniqueid});
                }
                try {
                    return userProvider.getUser(uniqueid);
                }
                catch (PersistenceException e) {
                    LOCATION.traceThrowableT(500, "Could not obtain user by uniqueId: " + uniqueid, (Throwable)e);
                    SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000072", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot obtain user account by unique id [{2}].", (Object[])new Object[]{attributeValue, this.configManager.getTrustedIdP().getName(), uniqueid});
                    this.loginResult.throwNameIDMappingFailedException("Could not obtain user by uniqueId: " + uniqueid, e);
                }
            }
        }
        return null;
    }

    private User resolveUserByUserId(String userId) throws NameIdMappingFailedException {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Searching for user by Logon ID: {0}", new Object[]{userId});
        }
        try {
            User user = UserManagementAccessor.getUserProvider().getUser(userId);
            if (user == null && ModifiableUserProvider.class.isAssignableFrom(UserManagementAccessor.getUserProvider().getClass())) {
                user = ((ModifiableUserProvider)UserManagementAccessor.getUserProvider()).createUser(userId);
            }
            if (user == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000071", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot find user by logon id [{2}].", (Object[])new Object[]{userId, this.configManager.getTrustedIdP().getName(), userId});
                this.loginResult.throwNameIDMappingFailedException("Could not find user by logon id: " + userId);
            }
            return user;
        }
        catch (PersistenceException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000071", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot find user by logon id [{2}].", (Object[])new Object[]{userId, this.configManager.getTrustedIdP().getName(), userId});
            this.loginResult.throwNameIDMappingFailedException("Could not find user by logon id: " + userId, e);
            return null;
        }
        catch (UnsupportedUserNameException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000071", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot find user by logon id [{2}].", (Object[])new Object[]{userId, this.configManager.getTrustedIdP().getName(), userId});
            this.loginResult.throwNameIDMappingFailedException("Could not find user by logon id: " + userId, e);
            return null;
        }
    }

    private User resolveUserByAlias(String alias) throws NameIdMappingFailedException {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Searching for user by Alias: {0}", new Object[]{alias});
        }
        try {
            User user = UserManagementAccessor.getUserProvider().getUser(alias);
            if (user == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000070", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot find user by alias [{2}].", (Object[])new Object[]{alias, this.configManager.getTrustedIdP().getName(), alias});
                this.loginResult.throwNameIDMappingFailedException("Could not find user by alias: " + alias);
            }
            return user;
        }
        catch (PersistenceException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000070", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot find user by alias [{2}].", (Object[])new Object[]{alias, this.configManager.getTrustedIdP().getName(), alias});
            this.loginResult.throwNameIDMappingFailedException("Could not find user by alias: " + alias, e);
            return null;
        }
    }

    private User resolveUserByWDQN(String wdqn) throws NameIdMappingFailedException {
        int index;
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Searching for user account by Windows Domain Qualified Name: " + wdqn);
        }
        if ((index = wdqn.indexOf(WINDOWS_DOMAIN_SEPARATOR)) == -1) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000067", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it is invalid Windows Domain Qualified Name.", (Object[])new Object[]{wdqn, this.configManager.getTrustedIdP().getName()});
            this.loginResult.throwNameIDMappingFailedException("Invalid Windows Domain Qualified Name received: " + wdqn);
        }
        String domain = wdqn.substring(0, index);
        String principal = wdqn.substring(index + 1);
        ArrayList<User> matchedUsers = new ArrayList<User>();
        try {
            Set usersByincipal = UserManagementAccessor.getUserProvider().searchUser("principal", principal, UserProvider.SearchOperator.EQUALS, UserProvider.CaseSensitive.NO);
            if (usersByincipal != null) {
                for (String userId : usersByincipal) {
                    User user = UserManagementAccessor.getUserProvider().getUser(userId);
                    if (!domain.equalsIgnoreCase(user.getAttribute(UME_ATTRIBUTE_WDQN_DOMAIN))) continue;
                    matchedUsers.add(user);
                }
            }
        }
        catch (Exception e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000079", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot execute UME search. Reason: {2}", (Object[])new Object[]{wdqn, this.configManager.getTrustedIdP().getName(), e.getMessage()});
            this.loginResult.throwNameIDMappingFailedException("Could not search user acount by UME attribute. " + e.getMessage(), e);
        }
        if (matchedUsers.size() < 1) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000062", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to local user account because local user account is not found by Windows Domain Qualified Name [principal: {2}, domain: {3}]", (Object[])new Object[]{wdqn, this.configManager.getTrustedIdP().getName(), principal, domain});
            this.loginResult.throwNameIDMappingFailedException("Could not find user account by Windows Domain Qualified Name: " + wdqn);
        } else if (matchedUsers.size() > 1) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000063", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to local user account because more than one local user account is found by Windows Domain Qualified Name [principal: {2}, domain: {3}]", (Object[])new Object[]{wdqn, this.configManager.getTrustedIdP().getName(), principal, domain});
            this.loginResult.throwNameIDMappingFailedException("Found too many user accounts by Windows Domain Qualified Name: " + wdqn);
        } else {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("User account found by the Windows Domain Qualified Name search is: {0}", new Object[]{((User)matchedUsers.get(0)).getName()});
            }
            return (User)matchedUsers.get(0);
        }
        return null;
    }

    private User resolveUserByKPN(String kpn) throws NameIdMappingFailedException {
        int index;
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Searching for user account by Kerberos Principal Name: [{0}]", new Object[]{kpn});
        }
        if ((index = kpn.indexOf("@")) == -1) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000066", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it is invalid Kerberos Principal Name.", (Object[])new Object[]{kpn, this.configManager.getTrustedIdP().getName()});
            this.loginResult.throwNameIDMappingFailedException("Invalid Kerberos Principal Name received: " + kpn);
        }
        String principal = kpn.substring(0, index);
        String realm = kpn.substring(index + 1);
        ArrayList<User> matchedUsers = new ArrayList<User>();
        try {
            Set usersByincipal = UserManagementAccessor.getUserProvider().searchUser("principal", principal, UserProvider.SearchOperator.EQUALS, UserProvider.CaseSensitive.NO);
            if (usersByincipal != null) {
                for (String userId : usersByincipal) {
                    User user = UserManagementAccessor.getUserProvider().getUser(userId);
                    if (!realm.equalsIgnoreCase(user.getAttribute(UME_ATTRIBUTE_KPN_REALM))) continue;
                    matchedUsers.add(user);
                }
            }
        }
        catch (Exception e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000079", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to a local user account because it cannot execute UME search. Reason: {2}", (Object[])new Object[]{kpn, this.configManager.getTrustedIdP().getName(), e.getMessage()});
            this.loginResult.throwNameIDMappingFailedException("Could not search user acount by UME attribute. " + e.getMessage(), e);
        }
        if (matchedUsers.size() < 1) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000064", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to local user account because local user account is not found by Kerberos Principal Name [principal: {2}, domain: {3}]", (Object[])new Object[]{kpn, this.configManager.getTrustedIdP().getName(), principal, realm});
            this.loginResult.throwNameIDMappingFailedException("Could not find user account by Kerberos Principal Name: " + kpn);
        } else if (matchedUsers.size() > 1) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000065", (String)"Service Provider could not map the Subject Name ID [{0}] received from Identity Provider [{1}] to local user account because more than one local user account is found by Kerberos Principal Name [principal: {2}, domain: {3}]", (Object[])new Object[]{kpn, this.configManager.getTrustedIdP().getName(), principal, realm});
            this.loginResult.throwNameIDMappingFailedException("Found too many user accounts by Kerberos Principal Name: " + kpn);
        } else {
            User result = (User)matchedUsers.get(0);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("User account found by the KPN search is: {0}", new Object[]{result.getName()});
            }
            return result;
        }
        return null;
    }
}

