/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp;

import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.commons.Attribute;
import com.sap.security.saml2.commons.AuthnContext;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.sp.ConfigurationManager;
import com.sap.security.saml2.sp.LoginResult;
import com.sap.tc.logging.Location;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class Utils {
    private static final Location LOCATION = Location.getLocation(Utils.class);

    public static ConfigurationManager loadConfigurationManager(Map<String, String> options, CallbackHandler ch, LoginResult lr) {
        String providerName = options.get("provider");
        if (providerName == null) {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Default SAML2 configuration is selected because login module option [{0}] is not configured.", new Object[]{"provider"});
            }
            return new ConfigurationManager(ch, options, lr);
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Local Provider configured as a login module option: [{0}]", new Object[]{providerName});
        }
        return new ConfigurationManager(providerName, ch, options, lr);
    }

    public static SAML2Principal createSAML2Principal(SAML2Principal saml2Principal, Set<Attribute> attributes, AuthnContext newContext, LoginResult loginResult, String spName) {
        SAML2Principal newPrincipal = null;
        newPrincipal = saml2Principal != null ? new SAML2Principal(saml2Principal, loginResult.getSessionIndex(), newContext, attributes) : new SAML2Principal(loginResult.getLocalUser(), loginResult.getIdpName(), spName, loginResult.getPrincipalNameId(), loginResult.getPrincipalNameIdFormat(), loginResult.getNameIdSPProvidedId(), loginResult.getSubjectNameIdSPNameQualifier(), loginResult.getSubjectNameIdNameQualifier(), loginResult.getSessionIndex(), newContext, loginResult.getIdpProxyContext(), false, attributes);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2Principal successfully created: {0}", new Object[]{newPrincipal});
        }
        return newPrincipal;
    }

    public static SAML2Principal createSAML2Principal(SAML2Principal saml2Principal, AuthnContext newContext, LoginResult loginResult, String spName) {
        SAML2Principal newPrincipal = null;
        newPrincipal = saml2Principal != null ? new SAML2Principal(saml2Principal, loginResult.getSessionIndex(), newContext) : new SAML2Principal(loginResult.getLocalUser(), loginResult.getIdpName(), spName, loginResult.getPrincipalNameId(), loginResult.getPrincipalNameIdFormat(), loginResult.getNameIdSPProvidedId(), loginResult.getSubjectNameIdSPNameQualifier(), loginResult.getSubjectNameIdNameQualifier(), loginResult.getSessionIndex(), newContext, loginResult.getIdpProxyContext(), false);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2Principal successfully created: {0}", new Object[]{newPrincipal});
        }
        return newPrincipal;
    }

    public static AuthnContext getAuthenticationContext(ConfigurationManager configManager, LoginResult loginResult) {
        AuthnContext authnContext;
        String authnContextName;
        SAML2LocalSP localSP = configManager.getLocalSP();
        SAML2CfgAuthenticationContext ac = localSP.getAuthenticationContextByName(authnContextName = loginResult.getAuthenticationContext());
        if (ac == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Service Provider has received SAML2Assertion from Identity Provider [{0}] that contains authentication context [{1}] which could not be found in the configuration.", new Object[]{configManager.getTrustedIdP().getName(), authnContextName});
            }
            authnContext = new AuthnContext(authnContextName, authnContextName, false, false, false, true);
        } else {
            authnContext = new AuthnContext(ac.getName(), ac.getAlias(), ac.isInteractive(), ac.isHTTPS(), ac.isHTTP(), ac.isCustom());
        }
        return authnContext;
    }

    public static void removePrincipal(Subject subject) {
        for (SAML2Principal principal : subject.getPrincipals(SAML2Principal.class)) {
            subject.getPrincipals().remove(principal);
            if (!LOCATION.beDebug()) continue;
            LOCATION.debugT("SAML2Principal [{0}] removed from subject.", new Object[]{principal.getName()});
        }
    }
}

