/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.log.corrid.impl;

import com.sap.cloud.runtime.tomcat.log.corrid.impl.ThreadLocalCorrelationContext;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.applog.CorrelationIdLogFieldProvider;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.MutableCorrelationContext;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.wrapper.WrapperFactoryProvider;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.extension.wrapper.WrapperFactoryRegistry;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.idgen.CorrelationIdGenerator;
import com.sap.cloud.runtime.tomcat.log.corrid.impl.idgen.SequentialIdGenerator;
import com.sap.cloud.runtime.tomcat.log.corrid.internal.RequestProcessorChain;
import com.sap.cloud.runtime.tomcat.log.corrid.internal.RequestProcessorChainInterceptor;
import java.io.IOException;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public final class CorrelationIdInterceptor
implements RequestProcessorChainInterceptor {
    private static final Logger logger = Logger.getLogger(CorrelationIdInterceptor.class.getName());
    private static final String NOTE_CORRELATION_ID = "x-correlation-id";
    private static final String HEADER_RESPONSE_CORRELATION_ID_DEFAULT = "x-request-id";
    private static final String HEADER_RESPONSE_CORRELATION_ID_ALTERNATIVE = "x-correlation-id";
    private static final String CONF_CORRID_ID_IN_RESPONSE_HEADER = "com.sap.cloud.runtime.tomcat.log.corrid.id_in_response";
    private final CorrelationIdGenerator correlationIdGenerator;
    private final MutableCorrelationContext correlationContext;
    private final WrapperFactoryRegistry wrapperFactoryRegistry;
    private final CorridResponseHeaderStrategy responseHeaderStrategy;
    private ConfigurationProvider configurationProvider;

    public CorrelationIdInterceptor() {
        this(new ConfigurationProvider(){

            @Override
            public String getProperty(String key) {
                return System.getProperty(key);
            }
        });
    }

    protected CorrelationIdInterceptor(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        this.wrapperFactoryRegistry = new WrapperFactoryRegistry();
        this.correlationContext = new ThreadLocalCorrelationContext(this.wrapperFactoryRegistry);
        this.correlationIdGenerator = new SequentialIdGenerator();
        this.responseHeaderStrategy = this.selectResponseHeaderStrategy();
        this.registerWrapperFactories();
        CorrelationIdLogFieldProvider.setThreadLocalCorrelationContext(this.correlationContext);
    }

    private CorridResponseHeaderStrategy selectResponseHeaderStrategy() {
        String corridConfig = this.configurationProvider.getProperty(CONF_CORRID_ID_IN_RESPONSE_HEADER);
        CorridResponseHeaderStrategy responseHeaderStrategy = CorridResponseHeaderStrategy.STANDARD_HEADER;
        if (null != corridConfig) {
            switch (corridConfig = corridConfig.trim().toLowerCase(Locale.ENGLISH)) {
                case "default_header": {
                    return CorridResponseHeaderStrategy.STANDARD_HEADER;
                }
                case "alternative_header": {
                    return CorridResponseHeaderStrategy.ALTERNATIVE_HEADER;
                }
                case "disabled": {
                    return CorridResponseHeaderStrategy.NO_RESPONSE_HEADER;
                }
            }
            responseHeaderStrategy = CorridResponseHeaderStrategy.STANDARD_HEADER;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("Correlation id configuration: [%s]", corridConfig));
            logger.log(Level.FINE, String.format("Selected response header strategy: [%s]", new Object[]{responseHeaderStrategy}));
        }
        return responseHeaderStrategy;
    }

    private void registerWrapperFactories() {
        ClassLoader classLoader = CorrelationIdInterceptor.class.getClassLoader();
        ServiceLoader<WrapperFactoryProvider> wrapperFactoryProviders = ServiceLoader.load(WrapperFactoryProvider.class, classLoader);
        for (WrapperFactoryProvider wrapperFactoryProvider : wrapperFactoryProviders) {
            wrapperFactoryProvider.registerWrapperFactories(this.wrapperFactoryRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundRequest(RequestProcessorChain requestProcessorChain, Request request, Response response) throws IOException, ServletException {
        this.initCorrelationContext(request, response);
        try {
            requestProcessorChain.process(request, response);
        }
        finally {
            this.clearCorrelationContext();
        }
    }

    private void initCorrelationContext(Request request, Response response) {
        try {
            String correlationId = this.correlationIdGenerator.createCorrelationIdFor(request);
            this.correlationContext.setCorrelationId(correlationId);
            request.setNote("x-correlation-id", (Object)correlationId);
            this.responseHeaderStrategy.setResponseHeader(response, correlationId);
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, "Failed to initialize the correlation context.", ex);
        }
    }

    private void clearCorrelationContext() {
        this.correlationContext.clearCorrelationId();
    }

    private static enum CorridResponseHeaderStrategy {
        NO_RESPONSE_HEADER(null){

            @Override
            void setResponseHeader(Response response, String corrid) {
            }
        }
        ,
        STANDARD_HEADER("x-request-id"),
        ALTERNATIVE_HEADER("x-correlation-id");

        private String headerName;

        private CorridResponseHeaderStrategy(String headerName) {
            this.headerName = headerName;
        }

        void setResponseHeader(Response response, String corrid) {
            response.setHeader(this.headerName, corrid);
        }
    }

    public static interface ConfigurationProvider {
        public String getProperty(String var1);
    }
}

